#!/usr/local/bin/php
<?php
// upgrades your current berylium2 installation
//

// to be run at beyliumroot
$beryliumroot= ".";
$version= '$Id: upgrade.php,v 1.2 2003/05/27 05:29:47 csnyder Exp $';
print "\nBerylium Upgrade $version\n\n";

// check for db upgradeability
$dodb= 1;
if (!$argv[1] || !$argv[2]) {
	print "
WARNING: this script will not be updating the database, 
which is potentially a Bad Idea(tm). Consider calling it 
again as:
   $argv[0] <db adminusername> <db adminpasswd>

";
	$dodb= 0;
	}

// check beryliumroot
if(!is_readable("$beryliumroot/code")) {
	print "
Cannot read $beryliumroot/code. Make sure you are running
this from your berylium root.\n";
	exit();
	}
	
// check for berylium.conf
if(!is_readable("$beryliumroot/code/berylium.conf") || !is_readable("$beryliumroot/http/be2")) {
	print "
Cannot read $beryliumroot/code/berylium.conf and/or
$beryliumroot/http/be2... this appears to be a fresh
install.

You need to run the install script, not upgrade.\n";
	exit();
	}
include_once("$beryliumroot/code/berylium.conf");
//include_once("$beryliumroot/code/berylium-functions.php");
//include_once("$beryliumroot/code/berylium-classes.php");

// set $beryliumroot in cron scripts
$changefiles= array("cron/daily.php", "cron/site-daily.php");
$be2file= file_get_contents("$beryliumroot/http/be2");
$lines= explode("\n",$be2file);
foreach ($lines AS $line) {
	if (substr($line,0,13)== '$beryliumroot') break;
	}
$firstquotepos= strpos($line, '"');
$lastquotepos= strrpos($line, '"');
$replace= substr($line, $firstquotepos+1, ($lastquotepos - ( $firstquotepos + 1 ) ) );
print "Changing cron scripts to match current beryliumroot: $replace\n";
$search= "/home/csnyder/files/berylium2";
foreach ($changefiles AS $file) {
	$path= $beryliumroot."/".$file;
	$contents= file_get_contents($path);
	$contents= str_replace($search, $replace, $contents);
	$fp= fopen($path, "w");
	fwrite($fp, $contents);
	fclose($fp);
	print "Done with $path\n";
	}

// set ownerships -- don't touch /files directory
$adminfiles= "cron reference upgrade.php dbupgrade.php";
$webfiles= "code external http ";
$commands[0]= "chown -R $be_beryliumuser $adminfiles";
$commands[1]= "chown -R $be_beryliumuser:$be_webgroup $webfiles";
$commands[2]= "chmod -R 700 $adminfiles";
$commands[3]= "chmod -R 750 $webfiles";
foreach($commands AS $command) {
	print "$command\n";
	passthru($command);
	}

// do database upgrade?
if ($dodb) {
	$command= "./dbupgrade.php '$argv[1]' '$argv[2]' ";
	print "\nRunning $command \n";
	passthru($command);
	}

print "Upgraded!!!\n";
?>
