<?php
// Berylium2 functions
// $Date: 2003/06/09 18:50:42 $

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

//
// ----------------------------------------------------- Operations Functions -------
//

// Replace the username and password of the database server, and all will be right with the world here.
// Database user should have permission to INSERT, UPDATE, and SELECT -- ONLY

function berror($message, $errorLevel=0) {
	// puts a new message onto ${$object}->error for debuging and logging
	// errorLevel in from 0 to n with 0 being general messages, n being most detailed, default=1
	global $session;

	if ($GLOBALS['profile']==1) {
		$timenow= bgetmicrotime() - $GLOBALS[timerStart];
		$timenow= "($timenow):";
		}

	if ($errorLevel==-1) {
		$output= "There has been an administrative error in ".$_SERVER['SCRIPT_FILENAME'].":\n\r$message\n\r";
		$subject= "[".$session->request->sitename."] admin error";
		mail($GLOBALS['be_adminemail'], $subject, $output);
		exit();
		}

	if ($errorLevel==0) {
		print "There has been an error in ".$_SERVER['SCRIPT_FILENAME'].":\n\r<hr />$message<hr />\n\r";
		if ($session->p_debug>=1) {
			print "<table bgcolor='#ffffff'><tr><td>";
			print "<hr /><b>\$session->error</b><br />";
			print nl2br($session->error);
			print "<hr />Session complete at ".date("Y-M-D H:i:s").".<br /><a href='$session->refreshURL'>Refresh</a> ($session->refreshURL)";
			print "</tr></td></table>";
			}
		exit();
		}
		
	if ($session->errorLevel>=$errorLevel) {
		$session->error.= "\n\r".$timenow.$message." [$session->errorLevel/$errorLevel]";
		return 1;
		}
	return 0;
	}


function boutput($message,&$outobject) {
	// puts a new chunk onto $outobject->output for later output to the client and/or a file
	berror("adding this to $outobject->objtype id#$outobject->id ($outobject->name)",2);

	// boutput separates its chunks by 10 steps-- in theory, some other function could leven them with other content. So sort the output array before outputting!!!
	if (is_array($outobject->output)) {
		ksort($outobject->output);
		end($outobject->output);
		$n= key($outobject->output);
		$n= $n+10;
		$outobject->output[$n]= $message;
		}
	else {
		$n= 20;
		$outobject->output[$n]= $message;
		}
	berror(" inserted chunk $n into $outobject->objtype id#$outobject->id ($outobject->name)",1);
	return 1;
	}

function dbconnect() {
	$dbuser= $GLOBALS['be_dbuser'];
	$dbpassword= $GLOBALS['be_dbpassword'];
	$dbname= $GLOBALS['be_dbname'];
	
	$db= mysql_connect("localhost", "$dbuser", "$dbpassword");
	if (!$db) {
		berror("Error on database connect: ".mysql_error(),0);
		return 0;
		}
	else berror("Connected to mySQL.",1);

	if (!$database= mysql_select_db("$dbname")) {
		berror("Error selecting database $dbname: ".mysql_error(),0);
		return 0;
		}

	else berror("Database selected.",1);
	return $db;
	}
	
function ftpconnect() {
	global $site, $session;
	
	// check for existing connection and reuse
	if (isset($session->ftpconn)) {
		return $session->ftpconn;
		}

	// check for site configuration
	if ($site->p_ftphost=="" || $site->p_ftpusername=="" || $site->p_ftppassword=="" || $site->p_ftproot=="") {
		berror("ftpconnect: site is not configured for static publishing.",1);
		return 0;
		}

	// FTP login
	// initiate ftp connection
	$ftpconn= @ftp_connect($site->p_ftphost);
	if (!$ftpconn) {
		berror("ftpconnect: Cannot connect to $site->p_ftphost.",1);
		return 0;
		}

	// login with username and password
	$ftppassword= bgetword($site->p_ftppassword);
	$ftplogin = @ftp_login($ftpconn, $site->p_ftpusername, $ftppassword);
	if (!$ftplogin) {
		berror("ftpconnect: Cannot login to $site->p_ftphost with username $site->p_ftpusername.",1);
		return 0;
		}
	else berror("ftpconnect: Logged into $site->p_ftphost (connection: $ftpconn)",1);
	
	// save it in session for reuse...
	$session->ftpconn= $ftpconn;

	return $ftpconn;
	}

function bloadfile($filename) {
	$contents=0;

	// get contents of a file into a string
	if ($fd = @fopen ($filename, "r")) {
		$contents = fread ($fd, filesize ($filename));
		fclose ($fd);
		}

	return $contents;
	}


function brandom($max=32000) {
	srand((double)microtime()*1000000); 
	$random = rand(0,$max);
	return $random;
	}


function bmail($email, $subject, $message) {
	$site= $GLOBALS['site'];

	//$email= addslashes($email);
	//$message= addslashes($message);
	//$subject= addslashes($subject);

	$headers= "From: berylium@$site->name\nReply-To: $site->admin\nX-Mailer: Berylium2/".'$Date: 2003/06/09 18:50:42 $';

	$sent= mail($email, $subject, $message, $headers);
      	return $sent;
	}


function blookup($query) {
	$result= mysql_query($query);
	if ($result) {
		$array= mysql_fetch_array($result);
		if (is_array($array)) return $array;
		}
	return 0;
	}

function bgetmicrotime() { 
	list($usec, $sec)= explode(" ",microtime()); 
	return ((float)$usec + (float)$sec); 
	}
	
function bredirect($location,$message="All done here") {
	global $session;
	$timenow= bgetmicrotime() - $GLOBALS['timerStart'];
	$session->cpu+= $timenow;
	$session->updateObject();
	if ($GLOBALS['debug']) berror("$message, redirecting to <a href='$location'>$location</a>.",0);
	header("Location: $location");
	exit;
	}

//
// ----------------------------------------------------- String Functions -------
//

function bunpack($list) {
	// Unpacks a ^-delimited list of $key=$value pairs into $array[$key]=$value
	berror("bunpack() called with list: $list",2);
	$pairlist= explode("^", $list);
	while (list($key,$val)= each($pairlist)) {
		$firstequal= strpos($val, "=");
		if ($firstequal === false) {
			berror("bunpack(): no equals sign found in $val",2);
			$array["$val"]= "";
			}
		else {
			$thiskey= substr($val,0,$firstequal);
			$thisval= substr($val,$firstequal+1);
			berror("bunpack(): setting array[$thiskey]=$thisval",2);
			$array["$thiskey"]= $thisval;
			}
		}
	return $array;
	}

function bpack($array) {
	if (is_array($array)) {
		foreach($array as $key=>$value) {
			if (!$list) $list="$key=$value";
			else $list= $list."^$key=$value";
			}
		return $list;
		}
	else return "";
	}

function mysql_timestamp($datetime) {
	$year= substr($datetime,0,4);
	$month= substr($datetime,5,2);
	$day= substr($datetime,8,2);
	$time= substr($datetime,11,8);
	$hour= substr($time,0,2);
	$minute= substr($time,3,2);
	$second= substr($time,6,2);
	$timestamp= mktime($hour,$minute,$second,$month,$day,$year);
	return $timestamp;
	}
        
function bHtml($value) {
	// theory: removes all html tags, curly brackets "{}" and doublequotes from user input, converts newlines to <br />, and parses bml
        // should also replace single quotes with some entity
	// warning: only works with text in ISO-Latin-1 charset!!!
        $value= htmlentities($value, ENT_QUOTES);
        $value= preg_replace("/[{]/","&#123;",$value);
        $value= preg_replace("/[}]/","&#125;",$value);
        $value= nl2br($value);
        $value= bparsebml($value);
        $value= bpostbml($value);
        return $value;
        }

function bparsebml($text){
	$beryliumroot= $GLOBALS['beryliumroot'];
	global $session;

	if ($_GET['nobml']==1) return $text;
	if ($session->request->format=="popup") $format= "html";
	else $format= $session->request->format;
	$bmlfile= "$beryliumroot/code/bml/".$format.".php";
	if ($session->request->format=="rss") $bmlfile= "$beryliumroot/code/bml/html.php";
	if (!file_exists($bmlfile)) return $text;

	// assume markup will be found
	$found=1;
	$end=0;

	//begin parsing loop
	while ($found) {
		// sanity time
		if ($end>=strlen($text)) {
			$found=0;
			continue;
			}

		// find command start
		$start= strpos($text, "[", $end);
		if ($start===false) {
			$found=0;
			continue;
			}
		
		// look for at least one right bracket, otherwise this is madness!
		$endmost= strrpos($text, "]");
		if ($endmost===false) {
			$found=0;
			continue;
			}

		// check for command
		$commandend= strpos($text, ":", $start);
		if ($commandend===false) {
			$end= $start+1;
			continue;
			}

		// if the alleged "command" ends after the last right bracket, it isn't one.
		if ($commandend>$endmost) {
			$found=0;
			continue;
			}

		// find a likely endpoint for this tag
		$anend= strpos($text, "]", $start);
		// debug: print "(A ] at $anend)";

		// is there lunacy here? something like "[bold=boldme] blah blah [ital:italic]"???
		if ($commandend>$anend) {
			$end= $start+1;
			continue;
			}


		// check for nested markup!
		$next= strpos($text, "[", $start+1);
		//debug: print "(Next [ at $next)";

		if ($next<$anend AND !($next===false)) {
			$nestlen= $endmost-$start;
			$nest= substr($text, $start+1, $nestlen);
			$text= substr($text, 0, $start+1).bparsebml($nest).substr($text, $endmost+1);
			}


		// okay, now we can find the one living and true end
		$end= strpos($text, "]", $start);
		if ($end===false) {
			$found=0;
			continue;
			}

		// check for command again
		$commandend= strpos($text, ":", $start);
		if ($commandend===false) continue;

		// and again, if the : is outside the end bracket, forget it.
		if ($commandend>$end) continue;
		
		// get command
		$commandlen= $commandend-$start-1;
		$command= substr($text, $start+1, $commandlen);
		if ($command=="") continue;
		if (strpos($command, " ")) continue;

		// define tag
		$taglen= $end-$commandend-1;
		$tag= substr($text, $commandend+1, $taglen);

		// with $command and $tag in hand, run the bmlengine
		include($bmlfile);
		
		// if $truncatenl, look for nl as next character and adjust end to clip it
		if ($truncatebreak==1) {
			if (substr($text, $end+1, 4)=="<br />") {
				$end= $end+4;
				}
			elseif (substr($text, $end+1, 6)=="<br />") {
				$end= $end+6;
				}
			}

		// make the substitution
		$text= substr($text, 0, $start).$tag.substr($text, $end+1);
		} 
		//end while
	return $text;
	}
		
function bpostbml ($text) {
	// run a substitution on &obrack; and &cbrack;
	$text= str_replace("&obrack;", "[", $text);
	$text= str_replace("&cbrack;", "]", $text);
	return $text;
	}
	
function escapebml ($text) {
	// run a substitution on [ and ]
	$text= str_replace("[","&obrack;", $text);
	$text= str_replace("]","&cbrack;", $text);
	return $text;
	}

function bisemail ($email) {
	// match against regex
	//see http://www.php.net/manual/en/function.eregi.php for discussion about how to do this
	$emailmatch= '^[a-z\'0-9]+([._-][a-z\'0-9]+)*@([a-z0-9]+([._-][a-z0-9]+))+$';
	if (eregi($emailmatch, $email)) {
		return 1;
		}
	else return 0;
	}
	
function bescapeTemplate ($template) {
	$template= str_replace('"', '%%', $template);
	return $template;
	}
	
function bunescapeTemplate ($template) {
	$template= str_replace('%%', '"', $template);
	return $template;
	}

function bgetArticle($word,$uppercase=0) {
	// setup
	$word= strtolower($word);
	$article= "a";
	$vowels= array("a","e","i","o","u");
	$firstletter= substr($word, 0, 1);
	// test for vowel
	if (in_array($firstletter, $vowels)) {
		$article= "an";
		// now test for sounds -- u like union or o like one
		if ($firstletter=="o") {
			if ($word=="one") $article= "a";
			}
		elseif ($firstletter=="u") {
			// in three letters
			$union= array("uni", "use", "ura","ufo", "usp", "upc");
			if (in_array(substr($word,0,3),$union)) $article= "a";
			else {
				// u as an initial
				$secondletter= substr($word,1,1);
				if ($secondletter=="." || !$secondletter) $article="a";
				}
			}
		}
	// now test for silent h like hour or honor
	elseif ($firstletter=="h") {
		// in 4 letters...
		$silenth= array("hono","hone","hour","heir");
		if (in_array(substr($word,0,4),$silenth)) $article= "an";
		}
	elseif ($firstletter=="x") {
		// in 2 letters...
		$xlikeex= array("xo");
		if (in_array(substr($word,0,2),$xlikeex)) $article= "an";
		}
	if ($uppercase) $article= ucfirst($article);
	return $article;
	}

//
// ----------------------------------------------------- Password and Cookie Functions -------
//

//password suite inspired by lexzeus@mifinca.com via php.net
function keyED($txt,$encrypt_key) { 
	$encrypt_key = md5($encrypt_key); 
	$ctr=0; 
	$tmp = ""; 
	for ($i=0;$i<strlen($txt);$i++) { 
		if ($ctr==strlen($encrypt_key)) $ctr=0; 
		$tmp.= substr($txt,$i,1) ^ substr($encrypt_key,$ctr,1); 
		$ctr++; 
		} 
	return $tmp; 
	} 

function hex2bin($data) { 
	// by josh@superfork.com via php.net
	$len = strlen($data); 
	for($i=0;$i<$len;$i+=2) { 
		$newdata .= pack("C",hexdec(substr($data,$i,2))); 
		} 
	return $newdata; 
	} 

function bgetword($text, $key="") {
	$bin= hex2bin($text);
	if (!$key) $key = $GLOBALS['be_wordkey'];
	$txt = keyED($bin,$key); 
	$tmp = ""; 
	for ($i=0;$i<strlen($txt);$i++) { 
		$md5 = substr($txt,$i,1); 
		$i++; 
		$tmp.= (substr($txt,$i,1) ^ $md5); 
		} 
	return $tmp; 
	} 

function bpassword($txt, $key="") {
	if (!$key) $key = $GLOBALS['be_wordkey'];
	srand((double)microtime()*1000000); 
	$encrypt_key = md5(rand(0,32000)); 
	$ctr=0; 
	$tmp = ""; 
	for ($i=0;$i<strlen($txt);$i++) { 
		if ($ctr==strlen($encrypt_key)) $ctr=0; 
		$tmp.= substr($encrypt_key,$ctr,1) . (substr($txt,$i,1) ^ substr($encrypt_key,$ctr,1)); 
		$ctr++; 
		} 
	return bin2hex(keyED($tmp,$key)); 
	} 

function bpasswordcompare($password, $enc_text) {
	$dec_text= bgetword($enc_text);
	if ($password==$dec_text) $comp=1;
	else $comp=0;
	return $comp;
	}

function bsetcookie($key, $val, $sitename) {
	$cookie= "Set-Cookie: $key=$val; path=/;";
	header("$cookie");
	$success= "bsetcookie tried the following: $cookie";
	return $success;
	}

function bclearcookie($key) {
	header("Set-Cookie: $key=; path=/; ");
	}

	
//
// ------------------------------------------- SQL Manipulation Functions ----------
//
function bmakeSqlSafe($query) {
	global $session;

	if ($alreadydone= stristr($query, $session->sqlSafe)) {
		// it's already there
		berror("bmakeSqlSafe: found $session->sqlSafe in query -- <em>sqlSafe!</em>",1);
		return $query;
		}
	elseif ($orderby= stristr($query, "order by")) {
		// place before ORDER BY
		$orderbypos = strlen($query)-strlen($orderby);
		berror("bmakeSqlSafe: found ORDER BY clause at end of WHERE ($orderbypos).",3);
		$query= substr($query,0,$orderbypos).$session->sqlSafe.substr($query,$orderbypos);
		}
	elseif ($limit= stristr($query, "limit")) {
		// no ORDER BY, so place before LIMIT
		$limitpos = strlen($query)-strlen($limit);
		berror("bmakeSqlSafe: found LIMIT clause at end of WHERE ($limitpos).",3);
		$query= substr($query,0,$limitpos).$session->sqlSafe.substr($query,$limitpos);
		}
	else {
		// no ORDER BY or LIMIT, assume WHERE clause extends to end of $query
		berror("bmakeSqlSafe: found no ORDER BY or LIMIT clause at end of WHERE.",3);
		$query .= $session->sqlSafe;
		}

	berror("bmakeSqlSafe: returning: $query",1);
	return $query;
	}

function bfindSqlObjtype($query) {
	// take apart query to find objtype
	$frompos= strpos($query, "FROM")+4;
	$commapos= strpos($query, "AS", $frompos);
	$wherepos= strpos($query, "WHERE");
	if ($commapos!==FALSE AND $commapos<$wherepos) {
		$objtype= trim(substr($query, $frompos, ($commapos-$frompos)));
		}
	else $objtype= trim(substr($query, $frompos, ($wherepos-$frompos)));

	berror("extracted $objtype from $query",1);
	return $objtype;
	}

//
// --------------------------------------------------------- Utilities --------------------------
//
function bhumansize($size) {
        // Setup some common file size measurements.
	$kb = 1024;         // Kilobyte
	$mb = 1024 * $kb;   // Megabyte
	$gb = 1024 * $mb;   // Gigabyte
	$tb = 1024 * $gb;   // Terabyte

        if($size < $kb) return $size."B";
	else if($size < $mb) return round($size/$kb,0)."KB";
	else if($size < $gb) return round($size/$mb,0)."MB";
	else if($size < $tb) return round($size/$gb,0)."GB";
	else return round($size/$tb,2)."TB";
        }

function bstrip_attributes ($html, $attrs) {
	if (!is_array($attrs)) {
		$array= array( "$attrs" );
		unset($attrs);
		$attrs= $array;
		}

	foreach ($attrs AS $attribute) {
		// once for ", once for ', s makes the dot match linebreaks, too.
		$search[]= "/".$attribute.'\s*=\s*".+"/Uis';
		$search[]= "/".$attribute."\s*=\s*'.+'/Uis";
		// and once more for unquoted attributes
		$search[]= "/".$attribute."\s*=\s*\S+/i";
		}
	$html= preg_replace($search, "", $html);

	// check for additional matches and strip all tags if found
	foreach ($search AS $pattern) {
		if (preg_match($pattern, $html)) {
			$html= strip_tags($html);
			break;
			}
		}

	return $html;
	}

function bsafe_html ($html, $allowedtags="") {
	$version= 'berylium safe_html()/$Id: berylium-functions.php,v 1.6 2003/06/09 18:50:42 csnyder Exp $';

	// anything with ="javascript: is right out -- strip all tags and return if found
	$pattern= "/=\s*\S+script:\S+/Ui";
	if (preg_match($pattern, $html)) {
		$html= strip_tags($html);
		return $html;
		}

	// setup -- $allowedtags is an array of $tag=>$closeit pairs, where $tag is an HTML tag to allow and $closeit is 1 if the tag requires a matching, closing tag
	if ($allowedtags=="") {
		$allowedtags= array ( "p"=>1, "br"=>0, "a"=>1, "img"=>0, "li"=>1, "ol"=>1, "ul"=>1, "b"=>1, "i"=>1, "em"=>1, "strong"=>1, "del"=>1, "ins"=>1, "u"=>1, "blockquote"=>1, "pre"=>1, "hr"=>0);
		}
	elseif (!is_array($allowedtags)) {
		$array= array( "$allowedtags" );
		unset($allowedtags);
		$allowedtags= $array;
		}

	// there's some debate about this.. is strip_tags() better than rolling your own regex?
	// note: a bug in PHP 4.3.1 caused improper handling of ! in tag attributes when using strip_tags()
	$stripallowed= "";
	foreach ($allowedtags AS $tag=>$closeit) {
		$stripallowed.= "<$tag>";
		}

	//print "Stripallowed: $stripallowed -- ".print_r($allowedtags,1);
	$html= strip_tags($html, $stripallowed);

	// also, lets get rid of some pesky attributes that may be set on the remaining tags...
	$badattrs= array("on\w+", "style");
	$html= bstrip_attributes($html, $badattrs);

	// close html tags if necessary -- note that this WON'T be graceful formatting-wise, it just has to fix any maliciousness
	foreach ($allowedtags AS $tag=>$closeit) {
		if (!$closeit) continue;
		$patternopen= "/<$tag\b[^>]*>/Ui";
		$patternclose= "/<\/$tag\b[^>]*>/Ui";
		$totalopen= preg_match_all ( $patternopen, $html, $matches );
		$totalclose= preg_match_all ( $patternclose, $html, $matches2 );
		if ($totalopen>$totalclose) {
			$html.= str_repeat("</$tag>", ($totalopen - $totalclose));
			}
		}

	// close any open <!--'s and identify version just in case
	$html.= "<!-- $version -->";

	return $html;
	}

// EOF
