<?php
// Berylium Markup Language engine
// bml -> html conversion
// $Date: 2003/06/09 19:58:08 $

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// passed a command and (optionally) a tag. Builds a processed tag according to the command.
// please keep commands alphabetical.

berror("BML Engine executing '$command' with tag=$tag",2);
$site= $GLOBALS['site'];
$session= $GLOBALS['session'];
$siteUrl= $session->request->connection."://$site->name";
$truncatebreak= 0;

switch ($command) {

// ---------------------------------------------------- SIMPLE OBJECTS and HTML IMPLEMENTATION -------------------

	case "#":
		$tag= "<a id='$tag' name='$tag'> </a>";
		break;
		
	case "----":
		$tag= "<hr noshade=1 />";
		$truncatebreak= 1;
		break;
		
	case "bold":
		$tag= "<b>$tag</b>";
		break;
		
	case "b":
		$tag= bparsebml("[bold:$tag]");
		break;
		
	case "bracket":
		$tag= "&obrack;$tag&cbrack;";
		break;

	case "bullet":
		if (trim($tag)) $tag= "<ul><li>$tag</li></ul>";
		else $tag= "<li>";
		$truncatebreak= 1;
		break;

	case "cc":
		// creative commons. format [cc:year;licenseUrl;licenseName]
		// make name and url available to contexts...
		global $licenseUrl, $licenseName, $object;

		// split tag by ;
		$tag= html_entity_decode($tag, ENT_QUOTES);
		$arguments= explode(";",$tag);
		$year= htmlentities($arguments[0], ENT_QUOTES);
		$licenseUrl= $arguments[1];
		$licenseName= $arguments[2];
		if ($licenseName=="Public Domain") {
			$licenseTag= "This content has been dedicated to the public domain.";
			$tag= "<a href='$licenseUrl' title='Creative Commons Public Domain Dedication'>Dedicated to the public domain</a> in $year.<br /><a href='$licenseUrl'><img alt='no rights reserved' title='$licenseTag'  src='http://creativecommons.org/images/public/norights.gif' /></a>";
			}
		else {
			if ($licenseName=="") {
				$licenseTag= "Click for license details.";
				}
			else $licenseTag= "This content is subject to the Creative Commons $licenseName License. Click for details.";
			$tag= " &copy;$year<br />This work is subject to <a href='$licenseUrl' title='Creative Commons $licenseName License'>this license</a>.<br /><a href='$licenseUrl'><img alt='some rights reserved' title='$licenseTag'  src='http://creativecommons.org/images/public/somerights.gif' /></a>";
			}
		break;

	case "code":
		$tag= "<pre>";
		break;

	case "/code":
		$tag= "</pre>";
		$truncatebreak= 1;
		break;
		
	case "color":
		// look for a semicolon delimiting font color from link text
		$semicolon= strpos($tag, ";");

		if ($semicolon!==false) {
			$color= substr($tag,0,$semicolon);
			$tag= substr($tag, $semicolon+1);

			$tag= "<font color='$color'>$tag</font>";
			}
		break;

	case "copy":
		$tag= "&copy;$tag";
		break;

	case "date":
		$tag= date("M n, Y, \a\\t g:ia");
		break;
		
	case "del":
		// strikethrough
		$tag= "<del>$tag</del>";
		break;

	case "e2":
		// everything2.com lookup
		$tag= "<span style='border-bottom-style: dashed; border-bottom-width: 1px;'>$tag</span><sup><a href='http://everything2.com/?node=".urlencode(strtolower($tag))."' title='What does $tag mean?'>&obrack;?&cbrack;</a></sup>";
		break;
		
	case "entity":
		$tag= "&$tag;";
		break;
		
	case "&amp;":
	    	$tag= bparsebml("[entity:$tag]");
		break;

	case "&":
	    	$tag= bparsebml("[entity:$tag]");
		break;
		
	case "em":
		$tag= "<em>$tag</em>";
		break;
		
	case "ins":
		$tag= "<ins>$tag</ins>";
		break;

	case "italic":
		$tag= "<i>$tag</i>";
		break;

	case "i":
		$tag= bparsebml("[italic:$tag]");
		break;
		
	case "kbd":
		$tag= "<kbd>$tag</kbd>";
		break;
		
	case "mono":
		$tag= "<pre>$tag</pre>";
		$truncatebreak= 1;
		break;

	case "para":
		$tag= "<br />\n";
		break;

	case "pre":
		$tag= "<pre>$tag</pre>";
		$truncatebreak= 1;
		break;

	case "point":
		$tag= "<li>$tag</li>";
		$truncatebreak= 1;
		break;

	case "quote":
		$tag= "<blockquote >$tag</blockquote>";
		$truncatebreak= 1;
		break;
		
	case "q":
		$tag= html_entity_decode($tag, ENT_QUOTES);
		$args= explode(";", $tag, 2);
		if ($args[1]!="") {
			$quote= htmlentities($args[1], ENT_QUOTES);
			$attrib= "<div style='float: right;'><cite>-- $args[0]<cite>&nbsp;</div><br />&nbsp;";
			}
		else {
			$quote= htmlentities($args[0], ENT_QUOTES);
			$attrib= "";
			}
		$tag= "<blockquote >$quote $attrib</blockquote>";
		$truncatebreak= 1;
		break;

	case "strong":
		$tag= "<strong>$tag</strong>";
		break;
		
	case "space":
		$tag= str_replace(" ", "&nbsp;", $tag);
		break;

	case " ":
		$tag= bparsebml("[space:$tag]");
		break;

	case "tt":
		$tag= "<tt>";
		break;

	case "/tt":
		$tag= "</tt>";
		$truncatebreak= 1;
		break;
		
	case "ulist":
		$tag= "<ul>$tag</ul>";
		$truncatebreak= 1;
		break;


// ------------------------------------- LINK FLAVORS --------------------------------
	case "link":
		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting url from link text
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$tag= "<a href='$tag'>$tag</a>";
			}
		else {
			$url= substr($tag,0,$semicolon);
			$link= substr($tag, $semicolon+1);
			$tag= "<a href='$url'>$link</a>";
			}
		break;
		
	case "http":
		// shortcut to link
		$tag= bparsebml("[link:http:$tag]");
		break;
		
	case "https":
		// shortcut to link
		$tag= bparsebml("[link:https:$tag]");
		break;
		
	case "ftp":
		// shortcut to link
		$tag= bparsebml("[link:ftp:$tag]");
		break;
		
	case "mailto":
		// shortcut to mailto
		$tag= bparsebml("[link:mailto:$tag;$tag]");
		break;

// --------------------------------- BULLETED LISTS --------------------------

	// bulleted/numbered lists based on WikiWikiWeb syntax
	case "*list":
		$tag= "<ul>$tag</ul>";
		$truncatebreak= 1;
		break;
		
	case "1.list":
		$tag= "<ol>$tag</ol>";
		$truncatebreak= 1;
		break;

	case "1list":
		$tag= bparsebml("[1.list:$tag]");
		break;
	
	case "*":
		$tag= "<li>$tag</li>";
		$truncatebreak= 1;
		break;
		
	case "1.":
		$tag= "<li>$tag</li>";
		$truncatebreak= 1;
		break;
	// end WikiWikiWeb lists


// --------------------------------------- ADVANCED OBJECTS ------------------------------

	case "cell":
		// look for a semicolon
		$semicolon= strpos($tag, ";");

		if ($semicolon!==false) {
			$insert= substr($tag,0,$semicolon);
			$tag= substr($tag, $semicolon+1);
			if ($GLOBALS['cellturn']=="" || $GLOBALS['cellturn']=="odd") {
				berror("BML->cell <b>cellturn=$GLOBALS[cellturn]</b> so insert is on right.",1);
				$GLOBALS['cellturn']= "even";
				$tag= "<table class=celltable><tr class=cellodd><td class=cell>$tag</td><td class=cellinsert>$insert</td></tr></table>";
				}
			else {
				berror("BML->cell <b>cellturn=$GLOBALS[cellturn]</b> so insert is on left.",1);
				$GLOBALS['cellturn']= "odd";
				$tag= "<table class=celltable><tr class=celleven><td class=cellinsert>$insert</td><td class=cell>$tag</td></tr></table>";
				}
			}
		break;

	case "midi":
		$width= 144;
		$height= 16;
		$autoplay= "FALSE";
		$controller= "TRUE";
		$loop= "TRUE";
		$volume= 90;
		$tag= "<!-- [midi:tag] -->
			<OBJECT CLASSID='clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B' WIDTH='$width' HEIGHT='$height' CODEBASE='http://www.apple.com/qtactivex/qtplugin.cab'>
				<PARAM name='SRC' VALUE='$tag'>
				<PARAM name='AUTOPLAY' VALUE='$autoplay'>
				<PARAM name='CONTROLLER' VALUE='$controller'>
				<PARAM name='LOOP' VALUE='$loop'>
				<PARAM name='VOLUME' VALUE='$volume'>
				<EMBED SRC='$tag' WIDTH='$width' HEIGHT='$height' AUTOPLAY='$autoplay' CONTROLLER='$controller' LOOP='$loop' VOLUME='$volume' PLUGINSPAGE='http://www.apple.com/quicktime/download/'></EMBED>
				</OBJECT>
			</OBJECT>";
		break;

	case "image":
		/* usage:
			image:[id|url][;alignment][;widthxheight]
			[image:4] -- same as [image:4;320x240]
			[image:4;label] -- link to image as label
			[image:4;icon] -- link to image as inline icon (24x18 proportional)
			[image:4;left] -- image 500x500 to left of text
			[image:4;right] -- image 500x500 to right of text
			[image:4;center] -- image 500x500, centered on its own line
			[image:4;center;320x240] -- image scaled propotionally to fit 320x240, centered on its own line
			[image:4;thumbnail] -- same as [image:4;160x120]
			[image:http://foo.com/bar.jpg;left] -- external image full size to left of text
			[image:http://foo.com/bar.jpg;left;320x240] -- external image at 320x240 to left of text (not proportionally scaled!)
			*/
		berror("BML->image called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// split tag by ;
		$arguments= explode(";",$tag);
		$idurl= $arguments[0];
		if ($arguments[1]) {
			if (preg_match("/\d{1,4}[x,]\d{1,4}/i",$arguments[1]) || $arguments[1]== "thumbnail") {
				$sizex= $arguments[1];
				}
			else $label= $arguments[1];
			}
		if ($arguments[2]) {
			if (preg_match("/\d{1,4}[x,]\d{1,4}/i",$arguments[2]) || $arguments[2]== "thumbnail") {
				if (!$sizex) $sizex= $arguments[2];
				}
			elseif (!$label) $label= $arguments[2];
			}
		if ($sizex=="thumbnail") {
			$sizex= "160x120";
			$usethumbnail= 1;
			}
		else $usethumbnail= 0;
		berror("BML->image arguments: idurl($idurl) label($label) sizex($sizex).",1);

		// first switch-- is $idurl an id or a url?
		if (is_numeric($idurl)) {
			// display internal image
			if (!$label) {
				berror("BML->image no label found.",1);
				if (!$sizex) {
					berror("BML->image no size found, either, sizing to 320x240.",1);
					$sizex="320x240";
					}
				}

			berror("BML->image looking for image:$idurl.",1);
			$image= new Image;
			$image->selectObjectById($idurl);
			$image->title= bHtml($image->title);

			if ($sizex) {
				if (strstr($sizex, "x")) {
					$sizeArray= explode("x",$sizex);
					$width= $sizeArray[0];
					$height= $sizeArray[1];
					}
				else {
					$sizeArray= explode(",",$sizex);
					$width= $sizeArray[0];
					$height= $sizeArray[1];
					}
				berror("BML->image parsed $sizex to find width=$width and height=$height.",1);
				$image->proportion($width,$height);
				}
			
			// upgrade uri, please
			if ( substr($image->uri,0,9)=="/berylium" ) $image->uri= "/be2".$substr($image->uri,9);

			// use a smaller version of the file if available
			if ($GLOBALS['be_e99o']==1) {
				if ($usethumbnail) $image->uri= substr($image->uri, 0, strrpos($image->uri, "."))."@thumbnail".substr($image->uri, strrpos($image->uri, "."));
				else $image->uri= substr($image->uri, 0, strrpos($image->uri, "."))."@500x500".substr($image->uri, strrpos($image->uri, "."));
				}

			switch ($label) {
				case "left":
					$tag="<a href='$image->htmlUrl'><img src='$siteUrl$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title' align='left'  style='margin-right: 10px;' /></a>";
					break;

				case "right":
					$tag="<a href='$image->htmlUrl'><img src='$siteUrl$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title' align='right'  style='margin-left: 10px;'  /></a>";
					break;

				case "center":
					$tag="<div align='center'><a href='$image->htmlUrl'><img src='$siteUrl$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title'  /></a></div>";
					$truncatebreak= 1;
					break;
					
				case "":
					$tag="<a href='$image->htmlUrl'><img src='$siteUrl$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title'  /></a>";
					$truncatebreak= 1;
					break;

				case "icon":
					$icon= bparsebml("[icon:$image->id;image:$image->id;24,18]$image->title");
					$tag="<a href='$image->htmlUrl'>$icon</a>";
					break;

				default:
					$tag="<a href='$image->htmlUrl'>$label</a>";
					break;
				}
			}

		elseif ($idurl) {
			// display external image
			if (!$label) $label= "";
			if ($sizex) {
				if (strstr($sizex, "x")) {
					$sizeArray= explode("x",$sizex);
					$width= $sizeArray[0];
					$height= $sizeArray[1];
					}
				else {
					$sizeArray= explode(",",$sizex);
					$width= $sizeArray[0];
					$height= $sizeArray[1];
					}
				berror("BML->image parsed $sizex to find width=$width and height=$height.",1);
				$sizeTag= "width='$width' height='$height'";
				}
			switch ($label) {
				case "left":
					$tag="<img src='$idurl'  $sizeTag alt='external image' title='$idurl' align='left'  style='margin-right: 10px;'  />";
					break;

				case "right":
					$tag="<img src='$idurl'  $sizeTag alt='external image' title='$idurl' align='right'  style='margin-left: 10px;'  />";
					break;

				case "center":
					$tag="<div align='center'><img src='$idurl' $sizeTag alt='external image' title='$idurl'  /></div>";
					break;

				case "icon":
					$icon= bparsebml("[icon:$image->id;image:$image->id;24,18]$image->title");
					$tag="<a href='$image->htmlUrl'>$icon</a>";
					break;

				default:
					$tag="<img src='$idurl' $sizeTag alt='$label' title='$label'  /><br />";
					break;
				}
			}
		break;


	case "icon":
		// 2002-07-18 09:32
		// usage: [icon:imageid[;alt/titletag[;x,y-proportion]]]
		berror("BML->icon called as $tag",1);

		// split the arguments
		$arguments= explode(";", $tag);
		$imageid= $arguments[0];
		$title= $arguments[1];
		$proportion= $arguments[2];
		if ($proportion) {
			$size= explode("x", $proportion);
			$x= $size[0];
			$y=$size[1];
			}
		else {
			$x=88;
			$y=31;
			}

		if (is_numeric($imageid)) {
			$image= new Image;
			$image->selectObjectById($imageid);
			$image->proportion($x,$y);
			if ($title=="") $title= bHtml($image->title);
			$tag="<img src='$siteUrl$image->uri' width='$image->width' height='$image->height' alt='$title' title='$title'  />";
			}
		else {
			// fail gracefully... but how?
			}
		break;


	case "document":
		// usage: document:documentid[;text for link]
		berror("BML->document called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting documentid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$documentid= $tag;
			$label= "";
			}
		else {
			$documentid= substr($tag,0,$semicolon);
			$label= substr($tag, $semicolon+1);
			}

		if (is_numeric($documentid)) {
			berror("BML->document documentid=$documentid (tag=$tag)",1);
			$document= new Document;
			$document->selectObjectById($documentid);
			$document->title= bHtml($document->title);
			
			// use a label?
			if ($label=="") $label= $document->title;
			if ($session->request->format=="scene") $docurl= $document->htmlUrl;
			else $docurl= $document->baseUrl."?method=view$session->cgi";
			$tag="<a href='$docurl'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$documentid'>$label</a>";
			}
		break;
		
	case "comment":
		// usage: comment:commentid[;text for link]
		berror("BML->comment called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting commentid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$commentid= $tag;
			$label= "";
			}
		else {
			$commentid= substr($tag,0,$semicolon);
			$label= substr($tag, $semicolon+1);
			}

		if (is_numeric($commentid)) {
			$comment= new comment;
			$comment->selectObjectById($commentid);
			$comment->title= bHtml($comment->title);
			if ($label=="") $label= $comment->title;
			$tag="<a href='$comment->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$commentid'>$label</a>";
			}
		break;

	case "folder":
		// usage: folder:folderid[;text for link | icon]
		berror("BML->folder called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting folderid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$folderid= $tag;
			$label= "";
			}
		else {
			$folderid= substr($tag,0,$semicolon);
			$label= substr($tag, $semicolon+1);
			}

		$folder= new Folder;
		if (is_numeric($folderid)) {
			$folder= new Folder;
			$folder->selectObjectById($folderid);
			if ($label=="") $label= bHtml($folder->title);
			elseif ($label=="icon") {
				if ($folder->imageid!=0) {
					$label= bparsebml("[icon:$folder->imageid;folder:$folder->id;24,18]$folder->title");
					}
				else {
					if ($folder->public==0) $this->iconpvt= "-pvt";
					$label="<img src='/bicons/folder$this->iconpvt.gif' alt='folder:$folder->id' title='folder:$folder->id'  align='middle' /> $folder->title";
					}
				}
			$tag="<a href='$folder->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$folderid'>$folderid</a>";
			}
		break;
		
	case "sitemember":
		// usage: sitemember:sitememberid[;text for link]
		berror("BML->sitemember called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting sitememberid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$sitememberid= $tag;
			$label= "";
			}
		else {
			$sitememberid= substr($tag,0,$semicolon);
			$label= substr($tag, $semicolon+1);
			}

		if (is_numeric($sitememberid)) {
			$sitemember= new Sitemember;
			$sitemember->selectObjectById($sitememberid);
			if ($sitemember->name) {
				if ($label=="") {
					$label= bHtml($sitemember->name);
					$label= preg_replace("/\s/","&nbsp;",$label);
					}
				if ($label=="icon") {
					$name= bHtml($sitemember->name);
					$label= bparsebml("[icon:$sitemember->imageid;$name;24,18]");
					}
				$tag="<a href='$sitemember->idUrl?method=view$session->cgi'>$iconTag$label</a>";
				}
			else $tag="";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$sitememberid'>$sitememberid</a>";
			}
		break;


	case "context":
		// usage: context:contextid[;text for link]
		berror("BML->context called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting contextid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$contextid= $tag;
			$label= "";
			}
		else {
			$contextid= substr($tag,0,$semicolon);
			$label= substr($tag, $semicolon+1);
			}

		if (is_numeric($contextid)) {
			$context= new Context;
			$context->selectObjectById($contextid);
			$context->getBaseUrl();
			if ($label=="") $label= bHtml($context->name);
			$tag="<a href='$context->idUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$contextid'>$contextid</a>";
			}
		break;
		
	case "rdf":
		// get arguments  0 is rdf url, 1 is a ^-delimited list of key=value pairs
		// currently supported:  refresh=seconds, channel=hidden, descriptionSize=size, maxItems=count
		// [rdf:http://galactron/berylium/index.rdf;refresh=5^maxItems=5^descriptionSize=40]
		$arguments= explode(";", $tag);
		if ($arguments[1]!="") $optargs= bunpack($arguments[1]);

		berror("BML will parse rdf/rss from $arguments[0] now...",1);
		if (0 && $arguments[0]!="") {
			// load fase4 rdf class
			// See http//www.fase4.com/rdf/
			require_once("$GLOBALS[beryliumroot]/external/fase4_rdf/berylium-rdf.class.php");
			$rdf = new fase4_rdf;

			// modify settings based on optargs
			if ($optargs['channel']) $channelstate= $optargs['channel'];
			else $channelstate= "shown";
			$rdf->set_Options( array("channel"=>"$channelstate","build"=>"hidden","cache_update"=>"hidden") );
			if ($optargs['refresh']) $refresh= $optargs['refresh'];
			else $refresh= 43200;
			$rdf->set_refresh($refresh);
			if (is_numeric($optargs['maxItems'])) $rdf->set_max_item($optargs['maxItems']);
			if (is_numeric($optargs['descriptionSize'])) $rdf->set_description_size($optargs['descriptionSize']);

			// set cache and rdf file settings
			$rdf->set_CacheDir("$GLOBALS[beryliumroot]/external/fase4_rdf/cache");
			$rdf->_remote_file= $arguments[0];
			
			// generate the newsfeed
			$output= "<table class='rdfTable'>".$rdf->cache()."</table>";
			$rdf->finish();
			$tag= $output;
			}
		break;

	case "rss":
		$tag= bparsebml("[rdf:$tag]");
		break;

	case "googleimage":
		// presumes google url like:
		// http://images.google.com/imgres?imgurl=$foo&imgrefurl=http://www.bunch/of/junk&follows=this
		// which leads to an image url like: http://images.google.com/images?q=tbn:$foo

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for the start of imageurl=
		$var= "imgurl=";
		$imageurlstart= strpos($tag, $var) + strlen($var);
		$imageurlend= strpos($tag, "&img") - $imageurlstart;
		$imageurl= substr($tag, $imageurlstart, $imageurlend);
		berror("Google: imageurl= $imageurl | fullurl= $tag | imageurlstart is at $imageurlstart",1);

		// look for a semicolon delimiting sitememberid/url from other params
		$semicolon= strrpos($tag, ";");
		$parameter= substr($tag, $semicolon + 1);
		berror("Google: semicolon= $semicolon ($parameter)",1);
		if (trim($imageurl)!="") {
			switch ($parameter) {
				case "nolink":
					$tag= "<img src='http://images.google.com/images?q=tbn:$imageurl'  alt='Image from Google Cache' title=''  />";
					break;

				case "left":
					$tag= "<a href='$tag'><img src='http://images.google.com/images?q=tbn:$imageurl'  alt='Image from Google Cache' title=''  align='left' /></a>";
					break;

				case "right":
					$tag= "<a href='$tag'><img src='http://images.google.com/images?q=tbn:$imageurl'  alt='Image from Google Cache' title=''  align='right' /></a>";
					break;
					
				case "center":
					$tag= "<div style='text-align: center'><a href='$tag'><img src='http://images.google.com/images?q=tbn:$imageurl'  alt='Image from Google Cache' title=''  /></a></div>";
					break;
					
				default:
					$tag= "<a href='$tag'><img src='http://images.google.com/images?q=tbn:$imageurl'  alt='Image from Google Cache' title=''  /></a>";
				}
			}
		else {
			$tag= "<a href='$tag'>Google Image</a>";
			}
		break;
		
	case "end":
		// do nothing
		$tag= "$tag";
		break;
	}

?>
