#!/usr/local/bin/php
<?php
// daily berylium cron job
$version= '$Id: daily.php,v 1.2 2003/05/27 05:30:08 csnyder Exp $';

// CHANGE THE FOLLOWING to your beryliumroot:
// unless upgrade.php has done it already, of course...
$beryliumroot= "/home/csnyder/files/berylium2";

if (!$argv[0]) {
	print "\nThis script must be run from the command line.\n";
	exit;
	}

// setup
ob_start();
print "Output from $version\n";

// INCLUDES
include("$beryliumroot/code/berylium.conf");
include("$beryliumroot/code/berylium-functions.php");
include("$beryliumroot/code/berylium-classes.php");
$timestart= bgetmicrotime();

// for each site, generate daily report
$site= new Site;
$query= "SELECT obj.* FROM site AS obj WHERE obj.status='posted' ";
$list= $site->selectObject($query);
foreach($list->list AS $currentsite) {
	$command= "$beryliumroot/cron/site-daily.php ".escapeshellarg($currentsite->name);
	passthru($command);
	$sites++;
	sleep(5);
	}
$timenow= bgetmicrotime();
print "\nProcessed $sites daily reports in $timenow seconds.";

$command= "chown -R $be_beryliumuser:$be_webgroup $beryliumroot/files";
passthru($command);
$command= "chmod -R 770 $beryliumroot/files";
passthru($command);
print "\nNormalized files directory ownership.";

$output= ob_get_contents();
ob_end_clean();

mail($be_adminemail, "[berylium-server] Daily Run", $output);
?>
