#!/usr/local/bin/php
<?php
// sendbot message sender
$version= '$Id: sendbot.php,v 1.1 2003/06/11 21:54:37 csnyder Exp $';

// CHANGE THE FOLLOWING to your beryliumroot:
// unless upgrade.php has done it already, of course...
$beryliumroot= "/home/csnyder/files/berylium2";
$maxbots= 3;

if (!$argv[1]) {
	print "\nThis script must be run from the command line.
Usage:
   $argv[0]  <command> [ <ouput to stdout> ]

   command can be any of the following:

      start              send next message in queue
      stop               halt all sendbots
      resume=<messageid> resume halted message with id messageid\n\n";
	exit;
	}


if (isset($argv[2])) $verbose= 1;
else $verbose= 0;

// START TIMER
include("$beryliumroot/code/berylium-functions.php");
$timerStart= bgetmicrotime();

// CHECK CONTROLLER
$controller= dirname(__FILE__)."/sendbot.control";
if (!file_exists($controller)) {
	touch($controller);
	chmod($controller, 0600);
	}
if (!is_writeable($controller)) {
	print "\nSendbot must have write access to its controller file at $controller\n\n";
	exit;
	}
	
// ARE WE IN STOP MODE?
$control= file_get_contents($controller);
if ($control=="stop" && $argv[1]=="start") {
	print "\nI'm blocked from sending by $controller. Exiting. \n\n";
	exit;
	}

// PROCESS STOP
if ($argv[1]=="stop") {
	$fp= fopen($controller, "w");
	fwrite($fp,"stop");
	fclose($fp);
	print "Halting all working sendbots. \n\n";
	exit;
	}

// INCLUDES
include("$beryliumroot/code/berylium.conf");
include("$beryliumroot/code/berylium-classes.php");
$timenow= bgetmicrotime() - $timerStart;
$debug=$argv[2];

// START A SESSION
$session= new Session;
$session->buildSession();
$session->flavor= "sendbot";
$session->updateObject();
print "Sendbot $version (session:$session->id) at your service. ($timenow)";

// ARE WE RESUMING AN OLD MESSAGE?
if (substr($argv[1],0,6)=="resume") {
	print "Oh crap, I don't know how to resume, yet. Sorry.\n\n";
	exit;
	}

//HOW MUCH COMPANY HAVE WE?
$forknumber= file_get_contents($controller);
if (!is_numeric($forknumber)) $forknumber= 0;
$forknumber++;
if ($forknumber > $maxbots) {
	print "\nEek, I'm number $forknumber of only $maxbots allowed. I'm out of here.\n\n";
	exit;
	}
	
// GET NEXT 1 OR 2 MESSAGES
$message= new Message;
$query= "SELECT * FROM message WHERE sendtime <= now() AND status='new' AND locked!='1' ORDER BY sendtime ASC LIMIT 2";
$list= $message->selectObject($query);
if ($message->id!="") {
	$fork= 0;
	print "\nI will now send message:$message->id to all subscribers of $message->parentobjtype:$message->parentid.";
	if ($list->list[1]->id!="" && $forknumber < $maxbots) {
		print "\nAnd I will fork so that another bot can send message:".$list->list[1]->id;
		$fork= 1;
		}
	}
else {
	print "\nNo messages to send. Bye.\n\n";
	exit;
	}

// FIRST, UPDATE MESSAGE STATUS
$message->status= "sending";
$message->statusAllowed= "new, sending, sent";
$message->publicAllowed= 1;
$message->canSave['message']=1;
$message->updateObject($version);

// SECOND, UPDATE CONTROLLER
$fp= fopen($controller, "w");
fwrite($fp, $forknumber);
fclose($fp);

// THIRD, FORK IF ALLOWED
sleep(1);
$prefork= bgetmicrotime();
if ($fork) {
	$command= "$argv[0] start 1>&2 &";
	shell_exec($command);
	$forktime= bgetmicrotime() - $prefork;
	print "\nForked in $forktime seconds, continuing.";
	}

// GET THE PARENT MESSAGE
$mesparent= $message->getParent();

// NOW LOAD THE SUBSCRIPTION LIST
$submaster= new Subscription;
$subquery= "SELECT sub.* FROM subscription AS sub, sitemember AS sm WHERE sub.status='posted' AND ( ( sub.parentobjtype='$mesparent->objtype' AND sub.parentid='$mesparent->id' ) OR ( sub.parentobjtype='folder' AND sub.parentid='$mesparent->folderid' ) ) AND sm.id=sub.sitememberid ORDER BY sm.rank ASC, sub.created ASC ";
$sublist= $submaster->selectObject($subquery);
print "\nFound ".$sublist->size." matching subscriptions";
if ($verbose) print " using: $subquery\n";
if ($sublist->size<1) {
	print "\nNo matching subscriptions. Looks like my work here is done.";
	$message->status= "sent";
	// $message->recipients= 0;
	$message->updateObject($version);
	}

// GET THE SUBSCRIPTION PARENT
$subparent= $submaster->getParent();

// LOAD THE SITE
$mastersite= new Site;
$mastersite->selectObjectById($mesparent->siteid);

// LOAD THE FOLDER
$masterfolder= new Folder;
$masterfolder->selectObjectById($mesparent->folderid);


// FOR EACH SUBSCRIPTION, RENDER AND SEND 'ER - heh
$blocked= 0;
foreach ( $sublist->list AS $subscription ) {
	if ($subscription->flavor=="") $subscription->flavor= "html";
	print "\nSending to $subscription->email in $subscription->flavor now... ";
	
	// check for blocklist
	if ($subscription->p_blocklist!="") {
		$blocklist= explode(",",$subscription->p_blocklist);
		foreach ( $blocklist AS $bobj) {
			if ($bobj=="$mesparent->objtype:$mesparent->id") {
				$blocked= 1;
				break;
				}
			}
		if ($blocked) {
			$blocked= 0;
			print "or not, location  is blocked.";
			unset($subscription, $blocklist);
			continue;
			}
		unset($blocklist);
		}
	
	// get sitemember
	$sitemember= new Sitemember;
	$sitemember->selectObjectById($subscription->sitememberid);

	// copy the site and folder so we can work with them
	$site= $mastersite;
	$folder= $masterfolder;
	$object= $mesparent;
	$parent= $subscription->getParent();
	$subscription->getBaseUrl();
	$site->subscriptionUrl= $subscription->staticUrl;

	// get the right context and render it
	$site->getContext("email", $subscription->flavor);
	$site->process();
	if ($subscription->flavor=="html") $templateRender= $message->html;
	else $templateRender= $message->ptext;
	$body= $site->render("container");
	if ($verbose) print "\n".$body."\n";
	$body= bunescapeTemplate($body);
	
	// SUBJECT AND HEADERS
	$subject= "[$parent->title] $message->subject";
	$headers= "From: $site->title <berylium@$site->name>\r\nX-List-Software: Berylium2 <http://berylium.org/>\r\nList-ID: <$parent->objtype-$parent->id.$site->name>\r\nList-Owner: <mailto:berylium@$site->name>\r\nList-Archive: <http://$site->name/$parent->objtype-$parent->id.html>\r\nList-Subscribe: <http://$site->name/$parent->objtype-$parent->id.html?method=subscribe>\r\nList-Unsubscribe: <http://$site->name/$parent->objtype-$parent->id.html?method=unsubscribe>\r\nOrganization: $site->title\r\nX-Mailer: BeryliumSendbot / $version\r\nX-Mailer-Admin: $be_adminemail (please send spam or abuse reports to this address)\r\n";
	if ($subscription->flavor=="html") $headers= $headers."MIME-Version: 1.0\r\nContent-type: text/html; charset=iso-8859-1\r\n";

	// send email
	$safename= str_replace(array("<",">"), "", $subscription->name);
	$to= "$safename <$subscription->email>";
	mail($to, $subject, $body, $headers);
	$timenow= bgetmicrotime() - $timerStart;
	print "sent! ($timenow)";
	
	// prepare to loop to next subscription record
	$message->recipients++;
	$myrecipients++;
	unset($subscription, $site, $folder, $object, $sitemember, $templateRender, $body, $to, $subject, $headers);
	}

// UPDATE THE MESSAGE AS SENT
$message->status= "sent";
$message->updateObject($version);

// UPDATE THE CONTROLLER FILE
$newforknum= file_get_contents($controller);
if (is_numeric($newforknum)) {
	$newforknum= $newforknum - 1;
	$fp= fopen($controller, "w");
	fwrite($fp, $newforknum);
	fclose($fp);
	}

$timenow= bgetmicrotime() - $timerStart;
print "\n\nSent message:$message->id to $myrecipients recipients this pass ($message->recipients total). I've done all I can  at $timenow.
Thank you for sending with Berylium Sendbot.\n";
if ($verbose) print "\n\n".$session->error;

?>
