<?php
//berylbot functions

function bbotGet($request, $sitename="") {
	// generate a GET request for $request as though it came from the current session
	global $session, $site;
	if ($sitename=="") $sitename= $site->name;
	$fp= fsockopen($sitename, 80, $errno, $errstr, 5);
	if ($fp) {
		if ($sitename==$site->name) $sendcookie= "Cookie: be2word=$session->cookie; \r\n";
		fputs ($fp, "GET $request HTTP/1.0\r\nHost: $sitename\r\nUser-Agent: berylbot\r\n$sendcookie\r\n");
		while (!feof($fp)) {
			$temp= fgets($fp, 512);
			if ($session->errorLevel>=2) $fullresponse.= $temp;
			if (!$firstblank && trim($temp)!="") {
				// haven't hit first blank line yet, so this must be an HTTP response header
				$array= explode(":",$temp,2);
				$headers["{$array[0]}"]= $array[1];
				continue;
				}
			elseif (!$firstblank) {
				$firstblank= 1;
				continue;
				}
			$response.= $temp;
			}
		fclose ($fp);
		//print print_r($headers,1);
		return $response;
		}
	else {
		berror("Couldn't open socket at port 80, no publishing here.",1);
		return 0;
		}
	}
	
function bbotGetMaterial() {
	// looks at a recent (2x/day) cache of  either http://www.technorati.com/cosmos/interestingnewcomers.html or http://www.technorati.com/cosmos/currentevents.html
	// which are copyright under an attribution/non-commercial Creative Commons license -- by Sifry Consulting
	$random= brandom(1);
	$material= array();

	if ($random==1) {
		$request= "/cosmos/interestingnewcomers.html";
		$cache= "/tmp/berylbot-newcomers.html.cache";
		$file= "/tmp/berylbot-newcomers.html";
		$material['source']= "[http://www.technorati.com/cosmos/interestingnewcomers.html;Technorati Newcomers]";
		}
	else {
		$request= "/cosmos/currentevents.html";
		$file= "/tmp/berylbot-currentevents.html";
		$cache=  "/tmp/berylbot-currentevents.html.cache";
		$material['source']= "[http://www.technorati.com/cosmos/currentevents.html;Technorati Current Events]";
		}
	
	// check cache
	$miss= 1;
	if (is_readable($cache)) {
		// reload cache twice a day
		if ( filemtime($cache) > (time() - 43200) ) $miss=0;
		}

	// reload cache if miss
	if ($miss) {
		print "\nMaterial cache miss, fetching $request.";
		$ccontents= bbotGet($request, "www.technorati.com");
		if ($ccontents) {
			$fp= fopen($cache, "w");
			fwrite($fp, $ccontents);
			fclose($fp);
			}
		}
		
	// check file
	if (!is_readable($file)) {
		$contents= file_get_contents($cache);
		if ($contents) {
			$fp= fopen($file, "w");
			fwrite($fp, $contents);
			fclose($fp);
			}
		}
	else $contents= file_get_contents($file);
		
	// search for first smallindentquote in $contents
	$target= "<span class=\"smallindentquote\">";
	$close= "</span>";
	$firsttarget= strpos($contents, $target);
	$start= $firsttarget + strlen($target);
	$end= strpos($contents, $close, $firsttarget+strlen($target));
	$material['content']= substr($contents, $start, ( $end - $start ));

	// now truncate contents for the next fella or delete the file if this is it.
	if (strpos($contents, $target, $end)) {
		$contents= substr($contents, $end);
		$fp2= fopen($file, "w");
		fwrite($fp2, $contents);
		fclose($fp2);
		}
	else unlink($file);
	
	return $material;
	}

function bbotPost($request, $object, $sitename="") {
	// generate a POST request for $request as though it came from the current session, sending $object as POSTVARS
	global $session, $site;
	if ($sitename=="") $sitename= $site->name;
	
	// generate postvars
	$postvars= "submit=submit";
	foreach(get_object_vars($object) AS $key=>$value) {
		$postvars.= "&".urlencode($key)."=".urlencode($value);
		}
	$length= strlen($postvars);

	// send the request
	$fp= fsockopen($sitename, 80, $errno, $errstr, 5);
	if ($fp) {
		if ($sitename==$site->name) $sendcookie= "Cookie: be2word=$session->cookie; \r\n";
		$postrequest= "POST $request HTTP/1.0\r\nHost: $sitename\r\nUser-Agent: berylbot\r\nContent-Length: $length\r\nContent-Type: application/x-www-form-urlencoded\r\n$sendcookie\r\n$postvars";
		fputs ($fp, $postrequest);
		while (!feof($fp)) {
			$temp= fgets($fp, 512);
			if ($session->errorLevel>=2) $fullresponse.= $temp;
			if (!$firstblank && trim($temp)!="") {
				// haven't hit first blank line yet, so this must be an HTTP response header
				$array= explode(":",$temp,2);
				$headers["{$array[0]}"]= $array[1];
				continue;
				}
			elseif (!$firstblank) {
				$firstblank= 1;
				continue;
				}
			$response.= $temp;
			}
		fclose ($fp);
		//print $postrequest;
		//print print_r($headers,1);
		return $response;
		}
	else {
		berror("Couldn't open socket at port 80, no publishing here.",1);
		return 0;
		}
	}
