<?php
//Berylium2 Classes
//$Date: 2003/07/22 19:48:29 $

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

//
// ------------------------------------------------------------------- Base Classes ----
//

require("$beryliumroot/code/berylium-object.php");

class BeryliumClass extends BeryliumObject {
	// NOT IMPLEMENTED YET (if ever?) legacy, Berylium was originally going to be dynamically extendable...

	var $columns; 	// a list of SQL column definitions to expand the basic ContentObject
					// only applies for ubiquitous BeryliumClasses (siteid=folderid=0)
	var $attributes;// additional attributes that can be present (stored in ^-delimited lists)
	var $methods;	// php function definitions to expand the basic ContentObject
	}


class PublishableObject extends BeryliumObject {
	// master class for Publishable Objects
	var $name;
	var $originalid;
	var $parentobjtype;
	var $parentid;
	var $public;
	var $locked;
	var $rank;

	// following are generated on construction
	var $objtype;
	var $path;
	var $context; // Context object
	var $columns;

	// constructor
	function PublishableObject() {
		$this->columns= "name=VARCHAR(255)^originalid=INT UNSIGNED^parentobjtype=VARCHAR(255)^INDEX index_parentobjtype=(parentobjtype(16))^parentid=INT UNSIGNED^public=CHAR(4)^locked=CHAR(4)^rank=INT";
		}
	}

class ContentObject extends PublishableObject {
	// Master class for things that have a fair amount of content associated with them, most documents
	var $title;
	var $headline;
	var $description;
	var $keywords;
	var $body;
	var $imageid;
	var $audioid;
	var $videoid;
	var $author;
	var $copyright;
	var $source;

	// constructor
	function ContentObject () {
		$this->columns= "title=varchar(255)^headline=varchar(255)^description=TEXT^keywords=varchar(255) NOT NULL^INDEX index_keywords=(keywords)^body=TEXT^imageid=INT UNSIGNED^audioid=INT UNSIGNED^videoid=INT UNSIGNED^author=varchar(255)^copyright=varchar(255)^source=varchar(255)";
                }
        }

class Container extends ContentObject {
	// A Container is an object (eg a Folder) that is rendered as containing the object being requested,
	// or contains one or more of its containers. container->index=0 is the parent
	// container of the object, and container->index=n is the site root. Folders are self-contained, by the way...

	var $index;
	}

class Child extends ContentObject {
	// A Child is an object that is rendered as being contained by the object (eg each Question is the
	// child of a Poll). Each child is indexed in the order in which it is rendered.

	var $index;
	var $containertype;
	var $containerid;
	var $containername;
	}
	
class bList {
	// runtime-only class for lists of BeryliumObjects
	var $id;
	var $objtype;
	var $size;
	var $current;
	var $list;
	var $oddeven;
	
	// autolist vars
	var $autolist;
	var $previous;
	var $next;
	var $start;
	var $end;
	var $total;
	var $pagesize;

	function bList() {
		$this->objtype= "list";
		$this->size= "0";
		$this->id= uniqid('');
		$this->list= array();
		berror("Registered $this->objtype:$this->id",1);
		}
		
	function add ($object) {
		// appends $object to the list
		berror("add: adding $object->objtype:$object->id to $this->objtype:$this->id (flavor= $object->flavor)",1);
		
		// lightrank must be added - kludge!
		switch (true) {
			case ($object->rank <= 50) :
					$object->lightrank= 50;
					break;
			case ($object->rank < 500) :
					$object->lightrank= 100;
					break;
			case ($object->rank < 1000) :
					$object->lightrank= 500;
					break;
			case ($object->rank >= 1000) :
					$object->lightrank= 1000;
					break;
			}
		$this->list[]= $object;
		
		// get size
		$this->size= count($this->list);
		return $this->size;
		}

	function remove ($object) {
		// remove object from list
		foreach ($this->list AS $index=>$item) {
			if ($item->objtype==$object->objtype && $item->id==$object->id) {
				unset ($this->list["$index"]);
				berror("remove: unset $object->objtype:$object->id in $this->objtype:$this->id"."[$index]",1);
				// find new size
				$this->size= count($this->list);
				return $this->size;
				}
			}
		return 0;
		}

	function sort ($orderby) {
		// sorts a list of objects based on the field named in $orderby
		// orderby is a ^-delimited list (up to 2) of fieldname=order pairs, where ascending order= 1 and descending order= -1
		global $session;
		$obarray= explode("^", $orderby);
		if ($obarray[0]!="") {
			$pair= explode("=",$obarray[0]);
			$session->currentSort= $pair[0];
			$session->currentDirection= $pair[1];
			}
		if ($obarray[1]!="") {
			$pair= explode("=",$obarray[1]);
			$session->currentSortDefaultt= $pair[0];
			$session->currentDirectionDefault= $pair[1];
			}
		usort($this->list, array("BeryliumObject", "sort_obj"));
		}
		
	function merge ($list) {
		if (is_array($list->list)) {
			foreach($list->list AS $item) {
				$this->add($item);
				}
			}
		return $this->size;
		}
		
	function getIndexOf ($object) {
		// find object in list
		foreach ($this->list AS $index=>$item) {
			if ($item->objtype==$object->objtype && $item->id==$object->id) {
				return $index;
				}
			}
		return 0;
		}
		
	function perRow ($mode="") {
		if ($mode=="reset") {
			$this->oddeven= "";
			$this->current= 0;
			}
		else {
			// is the current row odd or even?
			if ($this->oddeven=="odd") $this->oddeven= "even";
			else $this->oddeven= "odd";
			// what is the number of the current row?
			$this->current++;
			}
		}
	}
	// END BLIST
	
//
// ------------------------------------------------------------------- Operations Classes ----
//
class Context2 extends BeryliumObject {
	// class used to process an object and merge it with display templates
	// Contexts are children of classes and are used to build object interfaces

	var $classid;    // id of parent Berylium Class or 0 for primal classes
	
	// following are used to describe the context
	var $classname;  // default is generic
	var $method;	// default is view
	var $role;	// default is anonymous
	var $format;	// default is html
	var $name;	// classname-method-role-format
	var $xml;	// XML version of context

	// appropriate context group is populated on construction
	var $process;
	var $container;
	var $template;
	var $null;
	var $listprocess;
	var $listcontainer;
	var $listgroup;
	var $listtemplate;
	var $listnull;

	// constructor
	function Context2() {
		$this->objtype= "context2";
		$this->columns= "name=VARCHAR(255)^classid=INT UNSIGNED^INDEX index_classid=(classid)^classname=VARCHAR(255)^INDEX index_classname=(classname(16))^method=VARCHAR(255)^INDEX index_method=(method(16))^format=VARCHAR(255)^INDEX index_format=(format)^role=VARCHAR(255)^INDEX index_role=(role(16))^xml=TEXT";
		}

	function parseRequest() {
		// parses request->objectname into context values:
		// like: classname-method-role-format
		global $session;

		if ($session->request->objtype=="context") {
			$this->name= $session->request->objectname;
			if (is_int($this->name)) {
				$this->id= $this->name;
				$this->name="";
				berror("Context2->parseRequest: generated an id-based context object with id=$this->id.",1);
				}
			else {
				$namearray= explode("-", $this->name);
				$this->classname= $namearray[0];
				$this->method= $namearray[1];
				$this->role= $namearray[2];
                                $this->format= $namearray[3];
				berror("Context2->parseRequest: generated a $this->classname object $this->method context with role=$this->role.",1);
				}
			}
		}

	function insertObject() {
		berror("Context2->insertObject: called.",1);
		global $site, $sitemember, $session;

		// loads in data from form
		foreach($_POST as $key=>$value) {
			$this->{$key}= $value;
			berror("insertObject: Set this->$key= $value.",2);
			}

		if ($this->sitememberid=="") $this->sitememberid= $sitemember->id;
		if ($this->siteid=="") $this->siteid= $site->id;
		if ($this->status=="") $this->status= "posted";

                // generate this->name from classname-method-role
                if ($this->role=="") $this->role= "anonymous";
                $this->name= "$this->classname-$this->method-$this->role-$this->format";
                berror("insertObject: Changing context name to $this->name. Format is $this->format",2);
                
                // load a file if provided
                $postvars= $_POST;
                $filevars= $_FILES[contextfile];
                $tempfile= $filevars[tmp_name];
                if ($tempfile!="none" AND $tempfile!="") {
                    // a file has been uploaded
                    $destination= $GLOBALS[beryliumroot]."/files/$site->name/tempcontext";
                
                    // save a temp version
                    berror("insertObject: saving $tempfile at $destination.",2);
                    $success= @move_uploaded_file("$tempfile", "$destination");
                    if (!$success) {
                            $blah= move_uploaded_file($tempfile, $destination);
                            berror("Couldn't move uploaded context from $tempfile to $destination.",0);
                            return 0;
                            }
                    $this->uploadContext("$destination");
                    }
                    
		// calls appropriate base method on context
		if ($this->id=="") parent::insertObject();
		else parent::updateObject();
		}

	function updateObject() {
		// this is, like, a hardcoded preprocess
		berror("Context2->updateObject: called",1);

		// loads in data from form
		foreach($_POST as $key=>$value) {
			$this->{$key}= $value;
			berror("updateObject: Set this->$key= $value.",2);
			}

		if ($this->sitememberid=="") $this->sitememberid= $GLOBALS['sitemember']->id;
		if ($this->site=="") $this->siteid= $GLOBALS['site']->id;
		if ($this->status=="") $this->status= "posted";
                
                // generate this->name from classname-method-role
                if ($this->role=="") $this->role= "anonymous";
                $this->name= "$this->classname-$this->method-$this->role-$this->format";
                berror("updateObject:  Changing context name to $this->name. Format is $this->format",2);
                
                // load a file if provided
                $postvars= $_POST;
                $filevars= $_FILES[contextfile];
                $tempfile= $filevars[tmp_name];
                if ($tempfile!="none" AND $tempfile!="") {
                    // a file has been uploaded
                    $destination= $GLOBALS['beryliumroot']."/files/$site->name/tempcontext";
                
                    // save a temp version
                    berror("updateObject:  saving $tempfile at $destination.",2);
                    $success= @move_uploaded_file("$tempfile", "$destination");
                    if (!$success) {
                            $blah= move_uploaded_file($tempfile, $destination);
                            berror("Couldn't move uploaded context from ($tempfile) to $destination. Check permissions on the affected direcotries. ($success)",0);
                            return 0;
                            }
                    $this->uploadContext("$destination");
                    }
                    
		// calls appropriate base method on context
		if ($this->id=="") BeryliumObject::insertObject();
		else BeryliumObject::updateObject();
		}
                
	function upload($path="") {
		if ($path=="") $path=$GLOBALS['beryliumroot']."/files/$site->name/tempcontext";
		$this->xml= bloadfile($path);
		return 1;
		}
		
	 function parseFilename($path) {
		$filename= substr(basename($path), 0, strpos(basename($path),"."));
		$namearray= explode("-",$filename);
		$this->classname= $namearray[0];
		$this->method= $namearray[1];
		$this->role= $namearray[2];
		$this->format= $namearray[3];
		return 1;
		}
		
	function parseXml() {
		// parses this->xml into one or more of:
		// 	$process; $container; $template; $null; $listprocess; $listcontainer; $listgroup; $listtemplate; $listnull;
		// note that this is kind of a dump parser, it doesn't really care whether the xml is well-formed or anything, cause it's probably not...
		berror("Context2->parseXml: called",1);
		if ($this->xml=="") berror("parseXml: called with empty xml field.",1);
		$data= $this->xml;
		global $session;

		// set up translation from xml namespace
		$found= 0;
		$properties= array("process"=>"beProcess",
						"template"=>"beTemplate",
						"null"=>"beNull",
						"container"=>"beContainer",
						"listprocess"=>"beListProcess",
						"listtemplate"=>"beListTemplate",
						"listnull"=>"beListNull",
						"listgroup"=>"beListGroup",
						"listcontainer"=>"beListContainer");

		foreach ($properties AS $key=>$entity) {;
			$entlength= strlen($entity) + 2;
			if ($parsestart= strpos( $data, "<$entity>") + $entlength) {
				if ($commandout= strpos( $data, "</$entity>", $parsestart)) {
					$parselength= $commandout - $parsestart;
					$this->{$key}= substr( $data, $parsestart, $parselength);
					$found= 1;
					berror("parseXml: parsed entity $entity into context->$key.",2);
					if ($session->errorLevel >= 3) {
						berror("parseXml: context->$key=<blockquote>".htmlentities($this->{$key})."</blockquote>",3);
						}
					switch($key) {
						case "process":
						case "listprocess":
							$data= substr($data, 0, ( $parsestart - strlen("<$entity>") ) ).substr($data, ( $parsestart + $parselength + strlen("</$entity>") ) );
							break;
						case "template":
						case "null":
						case "listtemplate":
						case "listnull":
							$data= substr($data, 0, ( $parsestart - strlen("<$entity>") ) ).'$'.$key.'Render'.substr($data, ( $parsestart + $parselength + strlen("</$entity>") ) );
							break;
						case "listgroup":
							$data= substr($data, 0, ( $parsestart - strlen("<$entity>") ) ).'$listtemplateRender'.substr($data, ( $parsestart + $parselength + strlen("</$entity>") ) );
							break;
						}
					}
				}
			}
		return $found;
		}
	}
	// END CONTEXT


class Policy extends BeryliumObject {
	// constructor:
	function Policy() {
		$this->objtype= "policy";
		$this->columns= "name=VARCHAR(255)^prequery=TEXT^addons=TEXT";
		}
		
	function loadPolicy() {
		global $sitemember, $site, $folder, $containers;
		berror("loadPolicy: called with role=$sitemember->role",1);
		
		$dbpolicies= 0;
		$success= 0;

		$this->flavor= $sitemember->role;
		if ($this->flavor=="admin") $this->flavor="editor";
		if ($this->flavor=="") $this->flavor= "none";

		berror("loadPolicy: Looking up policies now.",2);
		if ($dbpolicies) {
			// lookup policy in this folder first
			$query= "SELECT * FROM policy WHERE flavor='$this->flavor' AND folderid='$folder->id' AND siteid='$site->id' AND status='posted' ORDER BY created ASC LIMIT 1";
			$this->selectObject($query);

			if ($this->id=="") {
				foreach ($containers AS $parent) {
					if ($success) continue;
					$query= "SELECT * FROM policy WHERE flavor='$this->flavor' AND folderid='$parent[id]' AND siteid='$site->id' AND status='posted' ORDER BY created ASC LIMIT 1";
					$this->selectObject($query);
					if ($this->id!="") {
						$success= 1;
						$this->policy= $this->prequery;
						}
					}
				}
			}
		else {
			// lookup and load hard policy file
			$this->name= $this->flavor.".php";
			if (!$success) {
				// site policy
				$policypath= $GLOBALS['beryliumroot']."/files/".$site->name."/policies/";
				berror("loadPolicy: Going to look for site-based policy file at $policypath$this->name.",2);
				$path= $policypath.$this->name;
				if (file_exists($path)) {
					$this->policy= bloadfile($path);
					$success=1;
					}
				}
			if (!$success) {
				// root policy
				$policypath= $GLOBALS['beryliumroot']."/code/policies/";
				berror("loadPolicy: going to look for root policy file at $policypath$this->name.",2);
				$path= $policypath.$this->name;
				if (file_exists($path)) {
					$this->policy= bloadfile($path);
					$success=1;
					}
				else {
					// turn errorLevel back up
					berror("No policy found to match your role ($this->flavor) in this area. Server can not continue.",0);
					exit();
					}
				}
			}

		// turn errorLevel back up
		berror("loadPolicy: Found policy $this->flavor.",1);
		return $success;
		}
	}
	 // END POLICY

class Session extends BeryliumObject {
	// Class holding info about the client request and the Berylium response
	// Processes request, authentication, and response
	var $memberid;
	var $clientip;
	var $cpusecs;	// tracks total processing time of session
	var $transfer;	// tracks total file transfer (not page transfer) of session
	var $request;	  // Request object
	var $counter;	// counter object
	var $output;	  // Output array
	var $error;	  // Error array

	// constructor:
	function Session() {
		$this->objtype= "session";
		$this->columns= "memberid=INT UNSIGNED^clientip=VARCHAR(255)^cpusecs=DECIMAL(10,4)^xfer=INT UNSIGNED";

		$this->clientip= $_SERVER["REMOTE_ADDR"];
		$this->startDate= date("Y-M-d H:i:s");
		$this->error="Berylium2 Session starting for $this->clientip on $this->startDate at ".$GLOBALS['beryliumroot'];

		$this->setErrorLevel(1);
		$this->berror("This should be the next message.",1);
		}
		
	function buildSession() {
		$this->request= new Request;
		$this->refreshURL= $this->getRefreshURL();
		$this->refreshUrl= $this->refreshURL;
		$this->cgi= $this->getCgi();
                $this->getUserAgent();
		$this->counter= new Counter;

		// set-up new or load existing session...
		$this->cookie= $_COOKIE['be2word'];
		if ($this->cookie=="") {
			// create a new, anonymous session
			$this->id="";
			$this->sitememberid= 0;
			$this->flavor="anonymous";
			$this->status="0";

			// put it into the session table
			$this->insert= 1;
			$this->insertObject();
			$this->berror("Inserted session into db, session->id is now $this->id.",1);

			// use the id to make a new cookie
			$this->cookie= $this->getNewCookie();
			}
		else {
			// load session from the database
			$this->id= $this->getSessionId();
			$this->berror("This is an existing session, #$this->id.",1);
			$this->selectObjectById($this->id);
			}

		//Kludge against connection unmapping:
		if ($_SERVER['HTTPS']=="on") {
			$this->request->connection=="https";
			$this->berror("<b>Globals HTTPS is on</b>",3);
			}
		else $this->berror("<b>Globals HTTPS is off</b>",3);
		$this->berror("Finished Session Construction: a \"$this->flavor\" session for sitemember #$this->sitememberid at: <br> &nbsp; <b>".$this->request->connection."://".$this->request->sitename."<font color='#0033ff'>".$this->request->foldername."</font>/<font color='#ff0000'>".$this->request->objtype."-</font>".$this->request->objectname.".<font color='#006633'>".$this->request->format."</font>?".$this->request->cgistring."</b>",1);
		$this->berror(" &nbsp; method=".$this->request->method." role=".$this->sitemember->role." counter=".$this->request->counter,1);
		}

	function setErrorLevel($errorLevel=0) {
		global $debug;
		if ($debug && !$this->errorLevel) $errorLevel=$debug;
		$this->errorLevel= $errorLevel;
		$this->berror("Error level changed to $errorLevel.",1);
		}

	function getRefreshURL() {
		$scriptname= $_SERVER['SCRIPT_NAME'];
		$slash= "";
		if (dirname($this->request->path)!="/") $slash= "/";
		$url= $scriptname.dirname($this->request->path).$slash.urlencode(basename(stripslashes($this->request->path)))."?";
		while (list($key,$val)= each($this->request->cgiarray)) {
			if ($key=="counter") continue;
			$url= $url.$key."=".$val."&";
			}
		$url= $url."counter=".($this->request->counter+1);
		$this->scriptname= $scriptname;
		$this->berror("url=".$url,2);
		return $url;
		}

	function getCgi() {
		// returns cgi values without method and with counter+1
		$cgisep= "&amp;";
		$cgi= $cgisep;
		foreach($this->request->cgiarray as $key=>$val) {
			if ($key=="counter") continue;
			if ($key=="method") continue;
			if ($key=="key") continue;
                        if ($key=="debug") continue;
                        if ($key=="role") continue;
			if ($key=="return") $val= urlencode($val);
			$cgi= $cgi.$key."=".$val.$cgisep;
			}
		$cgi= $cgi."counter=".($this->request->counter+1);
		$this->berror("getCgi(): cgi=".$cgi,2);
		return $cgi;
		}

	function getListQuery() {
		$getvars= array_merge($_GET,$_POST);
		berror("getListQuery: called by $this->objtype id#$this->id ($this->name)... wherestatus=$this->wherestatus.",1);

                global $sitemember, $session, $site, $object;

		// flavor
		if ($getvars[listflavor]) $this->listflavor= $getvars[listflavor];
		else $this->listflavor= "%";
		if ($getvars[listflavorby]) $this->listflavorby= $getvars[listflavorby];
		else $this->listflavorby= 0;
		if ($getvars[listflavordir]) $this->listflavordir= $getvars[listflavordir];
		else $this->listflavordir= "ASC";
		if ($getvars[listflavorsign]) $this->listflavorsign= $getvars[listflavorsign];
		else $this->listflavorsign= "LIKE";

		$this->flavorwhere= " AND obj.flavor $this->listflavorsign '$this->listflavor' ";
		if ($this->listflavorby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.flavor $this->listflavordir ";
			else $this->orderby= $this->orderby.", flavor $this->listflavordir ";
			}

		// this folder
		if ($getvars[listthisfolder]) $this->listthisfolder= $getvars[listthisfolder]; 
		else $this->listthisfolder= 0;
		if ($this->listthisfolder) {
			$this->folderidwhere= "AND obj.folderid='$this->listthisfolder' ";
			}

		// status
		if ($getvars[liststatus]) $this->liststatus= $getvars[liststatus];
		else $this->liststatus= "posted";

		if ($getvars[liststatusby]) $this->liststatusby= $getvars[liststatusby];
		else $this->liststatusby= 0;
		if ($getvars[liststatusdir]) $this->liststatusdir= $getvars[liststatusdir];
		else $this->liststatusdir= "ASC";
		if ($getvars[liststatussign]) $this->liststatussign= $getvars[liststatussign];
		else $this->liststatussign= "LIKE";

		// special for writer-- show all new or posted objects and hidden objects belonging to me
		if ($sitemember->role=="writer" && $getvars[liststatus]=="") {
			$this->liststatus= "%' AND ( obj.status='posted' OR obj.status='new' OR ( obj.status='hidden' AND obj.sitememberid='$sitemember->id' ) ) AND obj.status!='deleted";
			$this->liststatussign= "LIKE";
			}
		
		// spcial for editor/admin -- all? or all but deleted?
		elseif ( ($sitemember->role=="editor" || $sitemember->role=="admin") && $getvars[liststatus]=="" ) {
			$this->liststatus= "%";
			}

		$this->statuswhereAlt= " AND obj.status $this->liststatussign '$this->liststatus' ";

		if ($this->liststatusby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.status $this->liststatusdir ";
			else $this->orderby= $this->orderby.", obj.status $this->liststatusdir ";
			}

		// rank
		if ($getvars[listrank]!="") $this->listrank= $getvars[listrank];
		else $this->listrank= "1";
		berror("I got $this->listrank ($_GET[listrank])",2);
		if ($getvars[listrankby]) $this->listrankby= $getvars[listrankby];
		else $this->listrankby= 0;
		if ($getvars[listrankdir]) $this->listrankdir= $getvars[listrankdir];
		else $this->listrankdir= "DESC";
		if ($getvars[listranksign]) $this->listranksign= $getvars[listranksign];
		else $this->listranksign= ">=";

		$this->rankwhere= " AND obj.rank $this->listranksign '$this->listrank' ";
		if ($this->listrankby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.rank $this->listrankdir ";
			else $this->orderby= $this->orderby.", obj.rank $this->listrankdir ";
			}

		// public
		if ($getvars[listpublic]!="") $this->listpublic= $getvars[listpublic];
		elseif ($sitemember->role!="anonymous") $this->listpublic="%";
		else $this->listpublic= "1";
		if ($getvars[listpublicby]) $this->listpublicby= $getvars[listpublicby];
		else $this->listpublicby= 0;
		if ($getvars[listpublicdir]) $this->listpublicdir= $getvars[listpublicdir];
		else $this->listpublicdir= "DESC";
		if ($getvars[listpublicsign]) $this->listpublicsign= $getvars[listpublicsign];
		else $this->listpublicsign= "LIKE";

		$this->publicwhereAlt= " AND obj.public $this->listpublicsign '$this->listpublic' ";
		if ($this->listpublicby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.public $this->listpublicdir ";
			else $this->orderby= $this->orderby.", obj.public $this->listpublicdir ";
			}

		// author
		if ($getvars[listauthor]) $this->listauthor= $getvars[listauthor];
		else $this->listauthor= "%";
		if ($getvars[listauthorby]) $this->listauthorby= $getvars[listauthorby];
		else $this->listauthorby= 0;
		if ($getvars[listauthordir]) $this->listauthordir= $getvars[listauthordir];
		else $this->listauthordir= "ASC";
		if ($getvars[listauthorsign]) $this->listauthorsign= $getvars[listauthorsign];
		else $this->listauthorsign= "LIKE";

		$this->authorwhere= " AND obj.sitememberid $this->listauthorsign '$this->listauthor' ";
		if ($this->listauthorby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.author $this->listauthordir ";
			else $this->orderby= $this->orderby.", obj.author $this->listauthordir ";
			}

		// created
		if ($getvars[listcreated]) $this->listcreated= $getvars[listcreated];
		else $this->listcreated= 0;
		if ($getvars[listcreatedby]) $this->listcreatedby= $getvars[listcreatedby];
		else $this->listcreatedby= 0;
		if ($getvars[listcreateddir]) $this->listcreateddir= $getvars[listcreateddir];
		else $this->listcreateddir= "ASC";
		if ($getvars[listcreatedsign]) $this->listcreatedsign= $getvars[listcreatedsign];
		else $this->listcreatedsign= ">";

		$this->createdwhere= " AND obj.created $this->listcreatedsign '$this->listcreated' ";
		if ($this->listcreatedby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.created $this->listcreateddir ";
			else $this->orderby= $this->orderby.", obj.created $this->listcreateddir ";
			}

		// updated
		if ($getvars[listupdated]) $this->listupdated= $getvars[listupdated];
		else $this->listupdated= 0;
		if ($getvars[listupdatedby]) $this->listupdatedby= $getvars[listupdatedby];
		else $this->listupdatedby= 0;
		if ($getvars[listupdateddir]) $this->listupdateddir= $getvars[listupdateddir];
		else $this->listupdateddir= "ASC";
		if ($getvars[listupdatedsign]) $this->listupdatedsign= $getvars[listupdatedsign];
		else $this->listupdatedsign= ">";

		$this->updatedwhere= " AND obj.updated $this->listupdatedsign '$this->listupdated' ";
		if ($this->listupdatedby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.updated $this->listupdateddir ";
			else $this->orderby= $this->orderby.", obj.updated $this->listupdateddir ";
			}

		// folderwhere
		if ($getvars[listfolderby]) $this->listfolderby= $getvars[listfolderby];
		else $this->listfolderby= 0;
		if ($getvars[listfolderdir]) $this->listfolderdir= $getvars[listfolderdir];
		else $this->listfolderdir= "ASC";

		$this->folderwhere= " AND folder.id= obj.folderid AND folder.name LIKE '".$GLOBALS[folder]->name."%' ";
		if ($this->listfolderby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY folder.name $this->listfolderdir ";
			else $this->orderby= $this->orderby.", folder.name $this->listfolderdir ";
			}
                        
                // if restrict parent folders according to publishing status
                if ($sitemember->role=="anonymous") {
                        $this->folderwhere.= "AND folder.status='posted' AND folder.public='1' ";
                        }
                elseif ($sitemember->role=="member") {
                        $this->folderwhere.= "AND folder.status='posted' ";
                        }
			
		// keyword search
		if (trim($getvars['keyword']!="")) {
			// simple search
			$searchkey= addslashes($getvars['keyword']);
			$this->keyword= $getvars['keyword'];
			$this->keywordwhere= " AND ( obj.title LIKE '%$searchkey%' OR obj.headline LIKE '%$searchkey%' OR obj.keywords LIKE '%$searchkey%' ) ";
			}
		else $this->keywordwhere= "";

		// build the query
		$this->listquery= "SELECT obj.* FROM $object->objtype AS obj, folder WHERE obj.siteid='$site->id' $this->keywordwhere $this->flavorwhere $this->folderidwhere $this->statuswhereAlt $this->rankwhere $this->publicwhereAlt $this->authorwhere $this->createdwhere $this->updatedwhere $this->folderwhere $this->sqlSafe $this->orderby ";
		$this->totalquery= "SELECT COUNT(obj.id) FROM $object->objtype AS obj, folder WHERE obj.siteid='$site->id' $this->keywordwhere $this->flavorwhere $this->folderidwhere $this->statuswhereAlt $this->rankwhere $this->publicwhereAlt $this->authorwhere $this->createdwhere $this->updatedwhere $this->folderwhere $this->sqlSafe ";

		// get total number of objects eligible for this list:
		$result= @mysql_query("$this->totalquery");
		if ($result) {
			$totalarray= mysql_fetch_row($result);
			$this->listtotal= $totalarray[0];
			}
		else {
			$this->listtotal= 0;
			}
			
		// limit and offset
		if ($getvars[listlimit]) $this->listlimit= $getvars[listlimit];
		else $this->listlimit= 10;
		if ($getvars[listoffset]) $this->listoffset= $getvars[listoffset]; 
		else $this->listoffset= 0;
		
		// what about the jump fields?
		if ($getvars[listoffset1]) $this->listoffset= $getvars[listoffset1] - 1;
		if ($getvars[listoffset2]) $this->listoffset= $getvars[listoffset2] - 1; 
		
		// start and end items
		$this->liststart= $this->listoffset + 1;
		$this->listend= $this->listoffset + $this->listlimit;
		
		// have any navigation buttons been pressed?
		if ($getvars['listprev']) {
			$this->listoffset= $this->listoffset - $this->listlimit;
			if ($this->listoffset < 0 ) $this->listoffset= 0;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery: detected prev button (value=$getvars[listprev]). New listoffset will be $this->listoffset.",1);
			}
			
		if ($getvars['listfirst']) {
			$this->listoffset= 0;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery: detected first button (value=$getvars[listprev]). New listoffset will be 0.",1);
			}

		if ($getvars['listnext']) {
			$this->listoffset= $this->listoffset + $this->listlimit;
			if ($this->listoffset > $this->listtotal ) $this->listoffset= $this->listtotal - $this->listlimit;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery: detected next button (value=$getvars[listprev]). New listoffset will be $this->listoffset.",1);
			}
			
		if ($getvars['listlast']) {
			$this->listoffset= $this->listtotal - $this->listlimit;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery: detected last button (value=$getvars[listprev]). New listoffset will be $this->listoffset.",1);
			}
			
		// make sure offset, start and end are sane values...
		if ($this->listend > $this->listtotal) $this->listend= $this->listtotal;
		if ($this->listoffset > $this->listtotal) $this->listoffset= $this->listtotal - $this->listlimit;
		if ($this->listoffset < 0 ) $this->listoffset= 0;
		if ($this->liststart > $this->listend || $this->liststart < 0 ) $this->liststart= $this->listoffset + 1;
			
		// tack limit and offset onto end of listquery
		$this->limit= " LIMIT $this->listoffset, $this->listlimit ";
		$this->listquery.= $this->limit;
		
		// reset statuswhere if it was changed temporarily...
		if ($resetstatuswhere==1) {
			$this->statuswhere= $this->oldstatuswhere;
			}
			
		berror("getListQuery: found $this->listtotal objects eligible for $this->listquery",1);
		return $this->listtotal;
		}

	function getNewCookie() {
		// creates a session cookie word based on the current session

		// take the memberid, sessionid, and a random value and encrypt them to make a session cookie
		if ($this->id!="") {
			$random= brandom();
			$random2= brandom();
			$word= "$random2^$this->sitememberid^$this->id^$random";
			$word= bpassword($word);
			$success= bsetcookie("be2word", $word, $this->request->sitename);

			$this->berror("getNewCookie() called by $this->objtype:$this->id on site='".$this->request->sitename."' set ($success) word=$word.",1);
			return $word;
			}
		else {
			$this->berror("getNewCookie() called by $this->objtype with no id.",0);
			return 0;
			}
		}

	function getSessionID() {
		// decrypts cookie word and returns the session id

		// Decode and expand $word ($random2^$sitememberid^$sessionid^$random)
		$wordarray= explode("^", bgetword($_COOKIE['be2word']));
		$sitememberid= $wordarray[1];
		$sessionid= $wordarray[2];
		$this->berror("wordarray is: ".print_r($wordarray,1),2);

		$this->berror("getSessionID() called by $this->objtype:$this->id. Found session #$sessionid and sitemember #$sitememberid.",1);
		return $sessionid;
		}
                
        function getUserAgent() {
		$this->userAgent= $_SERVER['HTTP_USER_AGENT'];
		berror("getUserAgent: found $this->userAgent",1);
		// look for Mozilla/x where x<5 -- that's Netscape4.x, can't deal with padding
		if (substr($this->userAgent,0,8)=="Mozilla/" && (strpos($this->userAgent,"MSIE")===false)) {
			if (substr($this->userAgent,8,1)=="4") {
				$this->netscape= substr($this->userAgent,8,1);
				berror("getUserAgent() declares this to be a Netscape4 user agent. :-(",2);
				}
			else $this->mozilla= substr($this->userAgent,8,1);
			}
		}
                
	function berror($message, $errorLevel=0) {
		// puts a new message onto $this->error for debuging and logging
		// errorLevel in from 0 to n with 0 being general messages, n being most detailed, default=0
		if ($this->errorLevel>($errorLevel-1)) {
			$this->error= $this->error."\n\r".$message;
			return 1;
			}
		else {
			return 0;
			}
		}

	function updateObject() {
		// Session->updateObject
		$this->berror("Session->update: called by $this->objtype:$this->id ",1);
		$success=0;
		$postvars= $_POST;

		// connect to database
		if (!$this->dbconnection) $this->dbconnection= dbconnect();
                                            
		// addslashes to all fields, merge p_keys into $this->properties
		$this->beryliumToMySQL();

		// get columns from table description so we know what bits of this object we can save
		$query= "DESCRIBE $this->objtype ";
		$this->berror("inspecting table with query=$query; ",3);
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			$this->berror("extracting column ".$columnarray['Field'],3);
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through columns to build the update query
		$queryvalues= "updated= now()";
		foreach ($tablecolumn AS $key=>$val) {
			if ($key=="id" OR $key=="created" OR $key=="updated") {
				$this->berror("continuing because of $key being created or updated.",3);
				continue;
				}

			if ( $this->{$key}=="" ) {
				$this->berror("continuing for this->$key='' (".$this->{$key}.") and postvars[$key] is '' also. (<b>".$postvars[$key]."</b>)",3);
				continue;
				}
			else {
				$this->berror("setting newobject[$key]=".$this->{$key}.".",3);
				$newobject[$key]= $this->{$key};
				$queryvalues= $queryvalues.", $key= '$newobject[$key]'";
				}
			}		

		// process the update query
		$query= "UPDATE $this->objtype SET $queryvalues WHERE id='$this->id' ";
		$result= mysql_query($query);
		if (!$result) {
			$this->berror("update query failed to get a result. $query; (".mysql_error().")",1);
			}
		else $success=1;

		// unencode object
		$this->mySQLToBerylium();
                
                // get the date and time in case we need it.
                $this->updated= date("Y-m-d H:i:s");

		$this->berror("<b>update successful:</b> $query;",1);
		return $success;
		}

	function loginprocess($email="", $password="") {
		global $site, $folder;

		$postvars= $_POST;
		if (!$email) $email= $postvars['email'];
		if (!$password) $password= $postvars['password'];
		$email= addslashes($email);
		$this->berror("session->loginprocess() called with email=$email and password=$password at folder $folder->name.",1);

		if (!$_REQUEST['Clue'] AND ($email=="" OR $password=="")) {
			$this->message= "Please enter your email address AND password to login.";
			return 0;
			}

		// create a temporary sitemember object for comparison
		$temp= new Member;

		// lookup email in member table
		$query= "SELECT * FROM member WHERE siteid='$site->id' AND email='$email' AND status!='deleted' ";
		$temp->selectObject($query);

		if ($temp->id=="") {
			// LEGACY -- you used to be able to spread a single member record across multiple sites.
			$query= "SELECT * FROM member WHERE email='$email' AND status!='deleted' ";
			$temp->selectObject($query);
			if ($temp->id=="") {
				$this->message= "<span style='color: red'>No membership was found with that email address.</span><br /><a href='$object->baseUrl?method=createmember$this->cgi'>Click here</a> to create one.";
				return 0;
				}
			}
                        
		// PASSWORD HINT / PASSWORD
		if ($_REQUEST['Clue']!="") {
			// send hint if available...
			if (trim($temp->hint)!="") {
				$message="You requested ".$temp->email."'s password hint for $site->name.\r\n\r\nIt is: ".$temp->hint."\r\n\r\nEnd of transmission.";
				bmail($email, "Your password hint", $message);
				$this->message= "Your hint has been sent.";
				}

			// else send password (plaintext, ick!)
			else {
				$plainpass= bgetword($temp->password);
				$message="You requested ".$temp->email."'s password for $site->name.\r\n\r\nIt is: ".$plainpass."\r\n\r\nEnd of transmission.";
				bmail($email, "Your password", $message);
				$this->message= "Your password has been sent.";
				}
			return 0;
			}

		// compare passwords
		$passcompare=0;
		$passcompare= bpasswordcompare($password, $temp->password);
		if (!$passcompare) {
			$this->message= "<span style='color: red'>That password doesn't match that email address.</span>";
			return 0;
			}

		// matches. find sitemember
		$sitemember = new Sitemember;
		$query= "SELECT * FROM sitemember WHERE memberid='$temp->id' AND siteid='$site->id' AND status!='deleted' ";
		$sitemember->selectObject($query);
		if (!$sitemember->id) {
			$this->message= "You are not a member of this site. Click &quot;Create a new membership&quot; to create a member record here.";
			return 0;
			}
			
		// check for pending/suspended membership
		if ($sitemember->status!="posted") {
			if ($sitemember->status=="new") {
				// pending membership...
				$this->p_confirmation= "New Membership";
				$this->p_message= "Your membership to this site is pending. You will be contacted via email ($temp->email) when it is activated.";
				$redirect= "$object->baseUrl?method=confirm";
				bredirect($redirect);
				return 0;
				}
			else {
				// suspended or otherwise not posted...
				$this->p_confirmation= "Membership Error";
				$this->p_message= "Sorry, you do not have membership priveledges on this site.";
				$redirect= "$object->baseUrl?method=confirm";
				bredirect($redirect);
				return 0;
				}
			}
		// update session, get new cookie
		elseif($passcompare==1) {
			$GLOBALS['sitemember']= $sitemember;
			$this->memberid= $temp->id;
			$this->sitememberid= $sitemember->id;
			$this->cookie= $this->getNewCookie();
			
			if ($_REQUEST['remember']==1) {
				// set permanent login cookie
				$key= $site->name;
				$cookiebuild= time()."^".$_REQUEST['email']."^".$_REQUEST['password'];
				$cookievalue= bpassword($cookiebuild, $key);
				$expire= time()+$GLOBALS['be_logintime'];
				setcookie ( "be2session", $cookievalue, $expire, "/" );
				}

			// update the session itself in the db
			$this->siteid= $site->id;
			$this->folderid= $folder->id;
			$this->flavor= "login";
			$this->updateObject();
			return 1;
			}
		}

	function logout () {
		// update the current session
		$this->flavor= "logout";
		$this->updateObject();

		// set cookie word to ""
		bclearcookie("be2word");

		if ($_COOKIE['be2session']) {
			// unset the permalogin cookie, too.
			// decode cookie for time
			$key= $site->name;
			$cookietext= bgetword($_COOKIE['be2session'], $key);
			$array= explode("^", $cookietext, 3);
			$settime= $array[0];

			$expire= $settime+$GLOBALS['be_logintime'];
			setcookie ( "be2session", "", $expire, "/" );
			}

		// refresh page after this.
		$this->berror("session->logout() called on session id#$this->id.",1);
		return 1;
		}

	function membercreate() {
		global $site;

		$postvars= $_POST;
		$email= $postvars['email'];
		$this->berror("session->membercreate() called with email=$email.",1);

		if (!bisemail($email)) {
			$this->message= "<span style='color: red'>That doesn't seem to be a valid email address. ($email)</span>";
			return 0;
			}

		if ($email=="" OR $postvars['password']=="" OR $postvars['name']=="") {
			$this->message= "<span style='color: red'>Please fill out ALL fields to create a new Membership.</span>";
			return 0;
			}

		// check for username
		$tempsm= new Sitemember;
		$query= "SELECT * FROM sitemember WHERE name='$postvars[name]' AND siteid='$site->id' AND status!='deleted'  ";
		$tempsm->selectObject($query);
		if ($tempsm->id!="") {
			$this->message= "<span style='color: red'>There is already a member named $postvars[name] at this site. Please choose a different name.</span>";
			return 0;
			}

		// create a temporary member object for comparison
		$temp= new Member;

		// lookup email in member table
		$email= addslashes($email);
		$query= "SELECT * FROM member WHERE email='$email' AND siteid='$site->id' AND status!='deleted' ";
		$temp->selectObject($query);

		if ($temp->id!="") {
			$this->message= "<span style='color: red'>There is already a membership at this site for $temp->email. <br /><br />Use the <kbd>send my hint</kbd> button on the login page to get your password hint if you need to.</span>";
			return 0;
			}
                else {
                        // no duplicate so create new Member
                        $temp->email= $postvars['email'];
                        $temp->name= $postvars['name'];
                        $temp->password= bpassword($postvars[password]);
                        $temp->hint= $postvars['hint'];
                        $temp->flavor= "standard";
                        $temp->status= "posted";
			$temp->siteid= $site->id;
        
                        $temp->insertObject();
                        }

		// create the sitemember now
		$tempsm->memberid= $temp->id;
		$tempsm->siteid= $site->id;
		$tempsm->folderid= $site->folderid;
		$tempsm->rank= 50;
		$tempsm->public= $postvars['public'];;
		if ($site->public) {
			$tempsm->flavor= "standard";
			$tempsm->status= "posted";
			}
		else {
			$tempsm->flavor= "request";
			$tempsm->status= "new";
			}
		$tempsm->name= $temp->name;
		$tempsm->role= "member";
		$tempsm->insertObject();
		
		//update memeber with sitememberid
		$temp->sitememberid= $tempsm->id;
		berror("session->membercreate: updating member:$temp->id to link it with sitemember:$temp->sitememberid.",1);
		$query= "UPDATE member SET sitememberid='$temp->sitememberid' WHERE id='$temp->id' ";
		$result= mysql_query($query);
		return 1;
		}

	function membersave() {
		global $site, $sitemember;

		$postvars= $_POST;
		$email= addslashes($postvars['email']);
		$id= addslashes($postvars['id']);
		$this->berror("session->membersave() called on member #$id with email=$email.",1);

		if ($email=="" OR $postvars['password']=="") {
			$this->message= "Please fill out email *and* current password to edit your record.";
			return 0;
			}

		// create a temporary member object for comparison
		$temp= new Member;

		// lookup email in member table
		$query= "SELECT * FROM member WHERE email='$email' AND id!='$id' AND siteid='$site->id' AND status!='deleted' ";
		$temp->selectObject($query);

		if ($temp->id!="") {
			$this->message= "<span style='color: red'>Another membership already exists with that email address ($temp->email).</span>";
			return 0;
			}

		$current= new Member;
		$query= "SELECT * FROM member WHERE id='$id' ";
		$current->selectObject($query);

		// make sure oldpassword matches password on file
		$passcompare=0;
		$passcompare= bpasswordcompare($postvars['password'], $current->password);
		if (!$passcompare) {
			$this->message= "<span style='color: red'>You didn't supply the correct current password, update canceled.</span>";
			return 0;
			}

		// no duplicate, password okay, so update the member
		$temp->id= $postvars['id'];
		$temp->email= $postvars['email'];
		if ($postvars['newpassword']!="") $temp->password= bpassword($postvars['newpassword']);
		else $temp->password= $current->password;
		if ($postvars['hint']!="") $temp->hint= $postvars['hint'];
		elseif ($postvars['newpassword']=="") $temp->hint= $current->hint;
		$temp->flavor= $current->flavor;
		$temp->status= $current->status;
		$temp->applyPolicy();
		$temp->updateObject("membersave");
		return 1;
		}

	function permalogin() {
		// login via be2session cookie...
		global $site, $object;

		// decode cookie
		$key= $site->name;
		$cookietext= bgetword($_COOKIE['be2session'], $key);
		$array= explode("^", $cookietext, 3);
		$settime= $array[0];
		$email= $array[1];
		$password= $array[2];
		berror("Permanent-login found: settime= $settime | email= $email | password= ".str_repeat("*", strlen($password)),1);

		// attempt a login
		if ($this->loginprocess($email, $password) ) {
			// set permanent login cookie
			$cookiebuild= time()."^$email^$password";
			$cookievalue= bpassword($cookiebuild, $key);
			$expire= time()+$GLOBALS['be_logintime'];
			setcookie ( "be2session", $cookievalue, $expire, "/" );

			$newlocation= "$object->baseUrl?method=view$session->cgi";
			bredirect($newlocation);
			}
		else {
			// uh-oh, permalogin cookie found, but login has changed... clear cookie
			$expire= $settime+$GLOBALS['be_logintime'];
			setcookie ( "be2session", "", $expire, "/" );

			$object->getBaseUrl();
			$newlocation= "$object->baseUrl?method=view$session->cgi";
			bredirect($newlocation);
			}
		}
	}
	// END SESSION

class Request {
	// Object to parse HTTP Request into useful values

	var $request_uri;
	var $connection;  // protocol, really, but we only know http so far...
	var $scriptname; // if called via $be_scriptname
	var $sitename; // minus www and port

	var $path;
	var $folderpath;
	var $objectstring;
	var $objtype;
	var $objectname;
	var $format;
	var $containers; // array of containing folders
	var $cgistring;
	var $cgiarray;
	var $counter;
	var $method;

	// constructor
	function Request() {
		/* allowed request syntax:
			static request, not found -- failover to berylium:
				http://sitename/folderpath[/[objtype-]objectname.format]
			dynamic request by name:
				http://sitename$be_scriptname/folderpath[/[objtype-]objectname.format][?method=method]
			static/dynamic request by id (the "permanent url" recommended by W3C):
				http://ex.com/classname/id[.format][?method=method]

			Notes:
				default format is html
				default objtype is document
				index is a "magic" objectname that refers to the folder
		*/
		global $be_scriptname;

		// get the request
		$this->request_uri= urldecode($_SERVER['REQUEST_URI']);
		
		// strip $be_scriptname if found
		if (substr($this->request_uri, 0, strlen($be_scriptname))==$be_scriptname) {
			$this->request_uri= substr($this->request_uri, strlen($be_scriptname));
			$this->scriptname= $be_scriptname;
			}

		// set connection type
		if ($_SERVER['HTTPS']=="on") {
			$this->connection= "https";
			}
		else {
			$this->connection= "http";
			}

		// sitename
		$this->sitename= $_SERVER['HTTP_HOST'];
		// strip www
		if (substr($this->sitename,0,4)=="www.") $this->sitename= substr($this->sitename,4);
		// strip port
		if ($portstart=strrpos($this->sitename,":")) {
			$this->sitename= substr($this->sitename,0,$portstart);
			}
			
		// catch our breath
		berror("New Request for $this->connection://$this->sitename$this->request_uri (scriptname=$this->scriptname)",1);

		// split off cgistring and path
		if ($cgipos= strpos($this->request_uri, "?")) {
			$this->cgistring= substr($this->request_uri, $cgipos+1);
			$this->path= substr($this->request_uri, 0, $cgipos);
			}
		elseif ($cgipos === FALSE) {
			$this->path= $this->request_uri;
			if ($this->path=="") $this->path= "/";
			}
		else {
			// cgipost=0 and request looks like http://sitename?method=blah
			$this->path= "/";
			$this->cgistring= substr($this->request_uri, 1);
			}
		berror("Request found path:$this->path and cgistring:$this->cgistring.",2);

		// kludge against multiple leading slashes in path, which sometimes happens
		while(substr($this->path,0,2)=="//") {
			$this->path= substr($this->path, 1);
			berror("-- removing leading // from path, now $this->path",3);
			}

		// path is now folderpath[/[objtype-]objectname.format]
		// separate folderpath from objectstring
		if ($this->path=="/") {
			$this->folderpath= "/";
			$this->objtype= "folder";
			$this->objectname= "/";
			$this->format= "html";
			}
		elseif (substr($this->path, -1)=="/") {
			// like: /folderpath/objectname/
			$this->folderpath= substr($this->path,0,-1);
			if ($lastslash=strrpos($this->folderpath,"/")) {
				//$this->objectname= substr($this->folderpath, $lastslash+1);
				$this->objectname= $this->folderpath;
				$this->folderpath= substr($this->folderpath, 0, $lastslash);
				}
			else {
				//$this->objectname= substr($this->folderpath,1);
				$this->objectname= $this->folderpath;
				$this->folderpath= "/";
				}
			$this->objtype= "folder";
			$this->format= "html";
			}
		elseif ($lastslash=strrpos($this->path, "/")) {
			// like: /folderpath/objtype-objectname.html
			$this->folderpath= substr($this->path,0,$lastslash);
			$this->objectstring= substr($this->path,$lastslash+1);
			}
		else {
			// like: /objtype-objectname.html
			$this->folderpath= "/";
			$this->objectstring= substr($this->path,1);
			}
		// parse objectstring if found...
		if ($this->objectstring!="") {
			// get objtype if found...
			if ($hyphenpos= strpos($this->objectstring, "-")) {
				$this->objtype= substr($this->objectstring, 0, $hyphenpos);
				$name= substr($this->objectstring, $hyphenpos+1);
				}
			else $name= $this->objectstring;
			// get format if found...
			if ($dotpos= strrpos($name,".")) {
				$this->format= substr($name, $dotpos+1);
				$this->objectname= substr($name,0,$dotpos);
				}
			elseif ($dotpos!==FALSE) {
				$this->objectname= "";
				$this->format= substr($name, 1);
				}
			else $this->objectname= $name;
			// if no objtype and no format, this is a folder...
			if ($this->objtype=="" && $this->format=="") {
				$this->objtype= "folder";
				$this->format= "html";
				if ($this->folderpath!="/") $slash= "/";
				$this->objectname= $this->folderpath.$slash.$this->objectname;
				}
			elseif ($this->objtype=="") {
				$this->objtype= "document";
				}
			// default format
			if ( $this->format=="" && ($this->connection=="http" || $this->connection=="https")) {
				$this->format= "html";
				}
			// objectname index trumps all
			if ($this->objectname=="index") {
				$this->objtype= "folder";
				if ($lastslash=strrpos($this->folderpath,"/")) {
					//$this->objectname= substr($this->folderpath, $lastslash+1);
					$this->objectname= $this->folderpath;
					$this->folderpath= substr($this->folderpath, 0, $lastslash);
					}
				else $this->objectname= $this->folderpath;
				}
				
			// check to make sure it's a valid objtype
			// for backwards compatibility, also to keep things from breaking on bad requests
			if ( !class_exists(ucfirst($this->objtype)) ) {
				$this->objectname= $this->objtype."-".$this->objectname;
				$this->objtype= "document";
				}
			}
		berror("Request is folderpath=$this->folderpath objtype=$this->objtype and objectname=$this->objectname in $this->format ",1);
		
		// create containers array from folderpath
		if ($this->folderpath!="/") {
			$this->containers= explode("/",$this->folderpath);
			}
		$this->containers[0]= "/";
		// berror("Request->containers=".print_r($this->containers,1)." from $this->folderpath",1);

		// parse cgistring
		parse_str($this->cgistring, $this->cgiarray);

		// find method
		if (is_array($this->cgiarray)) {
			$this->method= $this->cgiarray['method'];
			if ($this->method=="" && $_GET['keyword']!="") $this->method= "listall";
			elseif ($this->method=="") $this->method= "view";
			}
		else $this->method= "view";

		// find counter
		if (is_array($this->cgiarray)) {
			$this->counter= $this->cgiarray['counter'];
			if ($this->counter=="") $this->counter=1;
			}
		else $this->counter= 1;
		
		// SANITIZE IT
		foreach ( get_object_vars($this) AS $key=>$value) {
			if (!is_array($this->{$key}) ) $this->{$key}= addslashes($value);
			}

		berror("Request for $this->objtype: $this->connection:// $this->sitename $this->folderpath / $this->objtype - $this->objectname . $this->format ? $this->cgistring<br>
				&nbsp; method=$this->method  counter=$this->counter",2);
		}

	}
	// END REQUEST

class Member extends BeryliumObject {
	// member object class
	var $email;
	var $password;
	var $hint;
	var $role;

	// constructor
	function member() {
		$this->objtype= "member";
		$this->columns= "email=VARCHAR(255) NOT NULL^password=VARCHAR(255)^hint=VARCHAR(255)^role=VARCHAR(255)^INDEX index_email=(email)";
		}
		
	function loadMember() {
		global $session, $site, $sitemember;
		berror("loadMember: called by session:$session->id for sitemember:$sitemember->id with memberid:$sitemember->memberid",1);
		$this->selectObjectById($sitemember->memberid);
		}
	}

//
// ----------------------------------------------------------- Hardcoded Content Classes ----
//

class Sitemember extends ContentObject {
	// unlike member, sitemember is a content object

	// constructor
	function sitemember () {
		$this->objtype="sitemember";
		$this->publishable= 0;
		$this->columns= "memberid=int(10) unsigned^INDEX memberid=(memberid)^role=varchar(255)^INDEX role=(role(16))";
		}

	function loadSitemember () {
		// needs to be called after session and containers
		global $session, $site;
		berror("search starting, looking for sitemember #$session->sitememberid in $site->name.",1);

		// if truly anonymous, give up
		$this->id= $session->sitememberid;
		if ($this->id=="0" || $this->id=="") {
			berror(" didn't find member->id, [bold:role=anonymous].",1);
			$this->role= "anonymous";
			$this->rank= 50;
			}
		else {
			// look up sitemembership.
			$this->selectObjectById($this->id);
			if ($this->role=="") {
				 $this->role= "anonymous";
				 $this->siteid= $site->id;
				 $this->id= 0;
				 $this->memberid= 0;
				 $this->name= "Anonymous";
				 berror("didn't find one so role is role=$this->role unless member is found.",1);
				 }
			else berror("found local sitemembership ($this->name) with role=$this->role.",1);
			}
		berror("Sitemember $this->name has been constructed with <b>role='$this->role'</b>, sitemember:$this->id in folder ($this->folderid)",1);
		return 1;
		}
	}
	// END SITEMEMBER

class Site extends ContentObject {
	// constructor
	function Site () {
		$this->objtype="site";
		}

	function loadSite() {
		global $session;
		$this->name= $session->request->sitename;
		$this->folderid= 1;
		
		$query= "SELECT * FROM site WHERE name='$this->name' ";
		$this->selectObject($query);
                if ($this->id=="") berror("Sorry, there is no site by that name ($this->name). session->request: ".$session->request->sitename,0);
		berror("$this->name has been constructed, site:$this->id",1,"site");

		$this->getBaseURL();
		}
		
	function insertObject() {
		berror("called by $this->objtype id#$this->id ($this->name).",1);

		// insert the object...
		$success= BeryliumObject::insertObject();
		berror("successfully inserted object? ($success)",1);

		// create the folder
		if ($success) {
			$newdir= $GLOBALS['beryliumroot']."/files/$this->name";
			berror("site->insertObject(): new directory is $newdir",1);

			umask(000);
			$success= @mkdir($newdir,0770);
			if (!$success) {
				$blah= mkdir($newdir,0770);
				berror("site->insertObject(): mkdir() failed to create a directory at $newdir. (But the site has been inserted in the db, so you'll need to do it manually.)",1);
				return 0;
				}
			}

		return $success;
		}
		
	function getContents($classname) {
		// finds the number of objects of type $classname in this site
		$query= "SELECT count(obj.id) FROM $classname AS obj WHERE obj.siteid='$this->id' AND obj.status='posted' ";
		if ($result= mysql_query($query)) {
			$array= mysql_fetch_row($result);
			$total= $array[0];
			}
		else $total= 0;
		
		return $total;
		}
	}
	// END SITE

class Folder extends ContentObject {
	// constructor
	function Folder() {
		$this->objtype="folder";
		$this->columns= "INDEX index_name=(name)";
		$this->publishable= 1;
		}

	function save() {
		berror("Folder->save() called by $this->objtype:$this->id.",1);
		global $site;

		if (isset($_POST['name']) && $this->name!="/") {
			// cleanup folder name (or get it from cleaned up title)
			$this->name= $_POST['name'];
			if ($this->name!="") $this->name= preg_replace ("/[^A-Za-z0-9]/","",$this->name);
			else {
				$this->name= preg_replace ("/[^A-Za-z0-9]/","",$_POST['title']);
				if (strlen($this->name)>16) $this->name= substr($this->name,0,16);
				}

			// do not allow empty name, or very bad things will happen
			if ($this->name=="") $this->name= substr(uniqid(""),6);

			// preface with / if necessary
			if (substr($this->name,0,1)!="/") $this->name= "/".$this->name;
			berror("Folder->save: name cleanup produced ($this->name).",1);
			}

		// if this is a new folder, append folder->name to this->name and make this->folderid=folder->id
		if ($this->id=="") {
			// new folder in the current folder, eh?
			global $folder;

			// check the name again
			if ($this->name=="") {
				// it must not have been sent as POST[name]
				$this->name= preg_replace ("/[^A-Za-z0-9]/","",$_POST['title']);
				if (strlen($this->name)>16) $this->name= substr($this->name,0,16);
				if ($this->name=="") $this->name= substr(uniqid(""),6);
				$this->name= "/".$this->name;
				berror("Folder->save: name generation produced ($this->name).",1);
				}

			if ($folder->name=="/") $currentfolder= "";
			else $currentfolder= $folder->name;
			$this->name= "$currentfolder$this->name";
			$this->folderid= $GLOBALS['folder']->id;
			berror("Folder->save: new folder will be named $this->name and have folderid=$this->folderid.",1);
			}
		// if this is an existing folder, append containers[1]->name to this->name and leave this->folderid alone.
		else {
			$parentfoldername= $GLOBALS['containers'][1]->name;
			if ($parentfoldername=="/") $parentfoldername= "";
			$this->name= "$parentfoldername$this->name";
			berror("Folder->save: existing folder will be named $this->name and have folderid=$this->folderid.",1);
			
			// better find out if the name has changed, you'll need to change it in subfolders
			// this would be a great place for transaction start
			}
		$success= BeryliumObject::save();

		berror("Folder->save() comin' back atcha, with this->nameChanged=$this->nameChanged and $success",1);
		if ($success && $this->nameChanged!="") {
			// name has, in fact, changed. look for and update subfolders. there is implied permission for user to do this since they're subfolders
			$nclen= strlen($this->nameChanged);
			if ($nclen<1) berror("Woe has befallen you: the folder name has been changed, but the old name has been lost. All subfolders have now been rendered unusable until you change the name back.",0);
			$selectquery= "SELECT id,name FROM folder WHERE siteid='$site->id' AND name LIKE '$this->nameChanged/%' ";
			if ($result= mysql_query($selectquery)) {
				while ($update= mysql_fetch_assoc($result)) {
					$newname= $this->name.substr($update['name'],$nclen);
					$repairquery= "UPDATE folder SET name='$newname' WHERE id='$update[id]' ";
					if (!$repairresult= mysql_query($repairquery)) {
						berror("Subfolder name update failed on $repairquery. ".mysql_error(),1);
						}
					else berror("Subfolder name update succeeded: $update[name] is now $newname.",1);
					}
				berror("Subfolder name update done.",1);
				}
			else berror("Subfolder name update didn't find any subfolders with $selectquery.",1);
			
			// also, if there is ftp, move the static folder to the new location
			if ($ftpconn= ftpconnect()) {
				$oldpath= $site->p_ftproot.$this->nameChanged;
				$newpath= $site->p_ftproot.$this->name;
				berror("move: attempting to move $oldpath to $newpath via FTP now.",1);
				ftp_rename($ftpconn, $oldpath, $newpath);
				}
			}

		// and here's where you'd end the transaction, rolling back the update if the subfolder names couldn't be changed.
		return $success;
		}
		
	function publish_recursive($mode="list", $format, $recipe="") {
		// get all documents, images, and subfolders of the current folder, and if mode=publish, then republish
		// if mode=list, return the number of objects to be republished.
		global $site;
		berror("publish_recursive called on folder:$this->id ($this->name)",1);

		// if trying to republish whole site, panic (for now)
		if ($this->name=="/") {
			berror("Sorry, you may not republish the entire site.",1);
			}

		// which objtypes to look for?
		$classarray= array("folder","document","image");
		$list= new bList;

		foreach ($classarray AS $class) {
			berror("<blockquote>",1);
			// query looks for all posted/public item rank>=100 in the current folder, as well as subfolders.
			if ($class=="folder") $sameclass= " AND obj.id!='$this->id'  ";
			else $sameclass= "";
			$query= "SELECT obj.* FROM $class AS obj, folder WHERE obj.siteid='$site->id' $sameclass AND ((folder.id=obj.folderid AND obj.folderid='$this->id' AND obj.rank>='100') OR (folder.id=obj.folderid AND folder.name LIKE '$this->name%' AND obj.rank>='100')) AND obj.status='posted' AND obj.public='1' AND folder.status='posted' AND folder.public='1' ";
			berror("publish_recursive: $class query=$query",1);
			$subclass= "sub$class";
			$command= '${$subclass}= new '.ucfirst($class).";";
			eval ($command);
			$sublist= ${$subclass}->selectObject($query);
			${$subclass}->getContext($method);
			$list->merge($sublist);
			unset ($sublist);
			berror("</blockquote>",1);
			}
		berror("publish_recursive: ultimate number of objects to republish is $list->size plus myself. ",1);
		
		if ($mode!="publish") return $list;
		
		if (is_array($list->list)) {
			foreach ($list->list AS $subobject) {
				$subobject->publish($format, $recipe="");
				}
			}
		$this->publish($format, $recipe="");
		return $list->size;
		}

	function loadFolder () {
		global $session, $site;
		if ($session->request->objtype=="folder" && $session->request->objectname!="") $this->name= $session->request->objectname;
		else $this->name= $session->request->folderpath;
		$this->siteid= $site->id;
		$query= "SELECT obj.* FROM folder AS obj WHERE obj.name='$this->name' AND obj.siteid='$this->siteid' $session->statuswhere $session->publicwhere";
		if ($this->selectObject($query)) {
			berror("$this->name has been constructed, folder:$this->id",1);
			$this->getBaseURL();
			return 1;
			}
		// if not found, defer to upstream folder
		$this->name= $session->request->folderpath;
		$query= "SELECT obj.* FROM folder AS obj WHERE obj.name='$this->name' AND obj.siteid='$this->siteid' $session->statuswhere $session->publicwhere";
		if ($this->selectObject($query)) {
			berror("$this->name has been constructed, folder:$this->id",1);
			$this->getBaseURL();
			return 1;
			}
		else return 0;
		}
		
	function getOptionDiv($mode="view") {
		global $site, $sitemember;
		$this->applyPolicy();
		
		// FLAVOR TAG
		if ($this->flavorTag=="") {
			$article= bgetArticle($this->flavor);
			$this->flavorTag= "$article ".strtolower($this->flavor);
			}

		if ($this->editor) {
			if ($this->p_staticpath_html!="") $this->publishStatus= "Static version: <a href='$this->staticUrl'>$this->staticUrl</a> (<a href='$this->baseUrl?method=publish'>republish</a>)";
			elseif ($this->status=="posted" && $this->public==1 && $this->rank>50) $this->publishStatus= "Static version: none (<a href='$this->baseUrl?method=publish'>publish it</a>)";
			$this->editorTag= " - <a href='$this->baseUrl?method=edit'><img src='/bicons/edit.gif' alt='edit' /> edit</a> - <a href='$this->baseUrl?method=pickup'><img src='/bicons/pickup.gif' alt='pick up' /> pickup</a> - <img src='/bicons/bulbsgif/$this->glow.gif' alt='bulb' />
				<blockquote>$this->flavor $this->objtype:$this->id is $this->longstatus<br />
				Created: $this->created by $this->authorName<br />
				Last updated: $this->updated<br />
				$this->publishStatus</blockquote>";
			}
		elseif ($this->owner && ( $sitemember->role=="writer" && $this->canSave['folder'])) {
			$this->editorTag= " - <a href='$this->baseUrl?method=edit'><img src='/bicons/edit.gif' alt='edit' /> edit</a>";
			$bulbtag= " - <img src='/bicons/bulbsgif/$this->glow.gif' alt='bulb' />$this->longstatus";
			}
		elseif ($sitemember->role!="anonymous") {
			$bulbtag= " - <img src='/bicons/bulbsgif/$this->glow.gif' alt='bulb'  title='$this->longstatus' />";
			}
		$this->optionDiv= "<div id='Controls'><h4><a href='$this->baseUrl'>$this->title:</a> $this->flavorTag</h4><p><a href='$this->idUrl'>permalink</a> - <a href='http://$site->name$this->staticPath/index.rss'><img src='/bicons/rss10.gif' class='inline' /> RSS Newsfeed</a> $this->editorTag $bulbtag</p></div>";
		}


	function loadParents() {
		// makes $container[1] a copy of the parent folder, then sets $containers[2 - n] to be its parent folders, where n is the root folder.
		berror("loadParents: called on folder:$this->id ($this->name)",1);
		global $site;
		$index=0;
		$containers= array();

		/*
		if ($this->name=="/") {
			berror(" -- at top-level (root) folder already!",2);
			return $containers;
			}
			*/

		// lop the end off of $this->name
		$nextslash= strrpos($this->name, "/");
		$currentfolder= substr($this->name,0,$nextslash);

		// kludge to force the root folder into the 2nd container if the first folder is something like /name
		if ($currentfolder=="" AND $this->name!="/" )  {
			$currentfolder="/";
			$atroot=1;
			}

		// create more containers
		while ($currentfolder!="") {
			$index= $index+1;
			$tempfolder= new Folder;
			$query= "SELECT obj.* FROM folder AS obj WHERE obj.name='$currentfolder' AND obj.siteid='$site->id' $this->sqlSafe ";
			$tempfolder->selectObject($query);

			//set up unique name and baseURL
			$tempfolder->getBaseUrl();
			$nextslash= strrpos($currentfolder, "/");
			$containers[$index]= $tempfolder;

			berror("loadParents: containers[$index] is named $currentfolder, and has id=".$containers[$index]->id." ($tempfolder->id).",1);

			// get name of previous folder
			$currentfolder= substr($currentfolder,0,$nextslash);

			// kludge to force the root folder into the nth container
			if ($currentfolder=="" AND !$atroot) {
				$currentfolder= "/";
				$atroot=1;
				}
			unset ($tempfolder);
			}
		// return the entire array of containers
		return $containers;
		}

	function getBackPath() {
		// v2 DEPRECATED!!!
		berror("called",0);
		global $containers;

		foreach ($containers AS $key=>$value) {
			if ($value->name=="/") continue;
			if (is_int($key)) continue;
			$backpath= "<a href='$value->baseURL'>$value->uniqueName</a>".$backpath;
			}
		$this->backpath= $backpath;
		}
		
	function getContents($classname) {
		// finds the number of objects of type $classname in this folder, including subfolders
		if ($classname=="folder") {
			$query= "SELECT count(obj.id) FROM $classname AS obj WHERE obj.folderid='$this->id' AND obj.status='posted' ";
			}
		elseif ($this->name=="/") {
			$query= "SELECT count(obj.id) FROM $classname AS obj WHERE obj.siteid='$this->siteid' AND obj.status='posted' ";
			}
		else {
			$query= "SELECT count(obj.id) FROM $classname AS obj, folder WHERE ( obj.folderid='$this->id' OR ( folder.id=obj.folderid AND folder.name LIKE '$this->name/%' ) ) AND obj.status='posted' ";
			}
		if ($result= mysql_query($query)) {
			$array= mysql_fetch_row($result);
			$total= $array[0];
			}
		else $total= 0;
		return $total;
		}
	}
// END FOLDER

class Document extends ContentObject {
	function Document () {
		$this->objtype= "document";
		$this->columns= "";
		$this->publishable= 1;
		}
	}
        
class Comment extends ContentObject {
	function Comment () {
		$this->objtype= "comment";
		$this->columns= "";
		}
	}

class Image extends ContentObject {
	// image object
	// 2003-01-19: can set $this->maxsize (bytes) on an image to keep a cap on what people can upload.

	// constructor
	function Image () {
		$this->objtype= "image";
		$this->columns= "format=varchar(255)^path=varchar(255)^uri=varchar(255)^width=INT^height=INT";
		$this->publishable= 1;
		}

	function upload ($filevars, $maxsize=0) {
		BeryliumObject::upload($filevars, $maxsize);

		// make sure this is an image
		$imagesize= getimagesize($this->path);
		$this->width= $imagesize[0];
		$this->height= $imagesize[1];

		// build filename extension
		switch ($imagesize[2]) {
			case 1: $extension="gif"; break;
			case 2: $extension="jpg"; break;
			case 3: $extension="png"; break;
			case 4: $extension="swf"; break;
			}

		// build path, uri, and format
		if ($extension!="") {
			$this->p_attachformat= $extension;
			$this->format= ".$extension";
			}
		$success= $this->updateObject();
		return $success;
		}

	function import ($url, $maxsize=0) {
		BeryliumObject::import($url, $maxsize);

		// make sure this is an image
		$imagesize= getimagesize($this->path);
		$this->width= $imagesize[0];
		$this->height= $imagesize[1];

		// build filename extension
		switch ($imagesize[2]) {
			case 1: $extension="gif"; break;
			case 2: $extension="jpg"; break;
			case 3: $extension="png"; break;
			case 4: $extension="swf"; break;
			}

		// build path, uri, and format
		if ($extension!="") {
			$this->p_attachformat= $extension;
			$this->format= ".$extension";
			}
		$success= $this->updateObject();
		return $success;
		}

	function oldsave () {
		// check for upload and determine type
		berror("Image-oldsave() called, deprecated",0);
		$posto= $_FILES['imagefile'];
		if ($posto['size']!="") $this->useupload= "[bold:Uploading file] ($posto[size] bytes).";
		else $this->useupload=0;
		
		$postp= $_POST['imageurl'];
		if ($postp) $this->useimport= "[bold:Importing file] ($postp).";
		else $this->useimport=0;
		
		$this->id= $_POST['id'];
		berror("Image->save() called by '$this->objtype' object id#$this->id ($this->name). ($useupload)",1);

		// has the name changed?
		if ($this->id!="") {
			$temp= new Image;
			$query= "SELECT * FROM image WHERE id='$this->id' ";
			$temp->selectObject($query);
			$temp->getBaseUrl();
			$newname= $_POST['name'];
			if ($temp->name != $newname) {
				// change filename (even if a new image will be uploaded on top)
				berror("Image->save(): [bold:renaming image file] on disk ($temp->path) because name has changed from $temp->name to $newname",1);
				
				if (!file_exists($temp->path)) {
					berror("Image->save(): cancelled file rename: $temp->path does not exist.",1);
					}
				else {
					$dir= dirname($temp->path);
					$base= basename($temp->path);
					$dotpos= strrpos($base, ".");
					if ($dotpos) {
						$ext= substr($base,$dotpos);
						}
					$renamepath= "$dir/$newname$ext";
					berror("Image->save(): set to rename file $temp->path to $renamepath.",1);
					if (rename($temp->path, $renamepath)) {
						berror("Image->save(): rename successful.",1);
						}
					else {
						berror("Image->save(): unable to rename image file: from $temp->path to $renamepath. Not updated.",0);
						}
					}
				
				// get new path and uri information
				if ($renamepath) {
					$this->path= $renamepath;
					$this->uri= dirname($temp->uri)."/image-$newname$ext";
					}
				else {
					$base= basename($temp->path);
					$dotpos= strrpos($base, ".");
					if ($dotpos) {
						$ext= substr($base,$dotpos);
						}
					$this->path= dirname($temp->path)."/$newname$ext";
					$this->uri= dirname($temp->uri)."/image-$newname$ext";
					}
				berror("Image->save(): rename finishing. New path is ($this->path), new uri is ($this->uri).",1);
				}
			}

		BeryliumObject::save();
		}

	function proportion($width="*", $height="*", $enlarge=0) {
		berror("Image->proportion() called by '$this->objtype' object id#$this->id ($this->name). ($this->width X $this->height) going to ($width X $height)",1);

		$this->origHeight= $this->height;
		$this->origWidth= $this->width;
		
		if ($enlarge) {
			berror("Image->proportion() will enlarge if necessary.",1);
			// enlarge first, then reduce if necessary to fit box
			if ($width != "*" && $this->width < $width) {
				$proportion= $width/$this->width;
				$this->width= round($this->width*$proportion);
				$this->height= round($this->height*$proportion);
				$this->isProportioned= 1;
				berror("Image->proportion() enlarge width: new size is $this->width x $this->height. ($proportion)",2);
				}

			if ($height != "*" && $this->height < $height) {
				$proportion= $height/$this->height;
				$this->width= round($this->width*$proportion);
				$this->height= round($this->height*$proportion);
				$this->isProportioned= 1;
				berror("Image->proportion() enlarge height: new size is $this->width x $this->height. ($proportion)",2);
				}
			}

		if ($width != "*" && $this->width > $width) {
			$proportion= $width/$this->width;
			$this->width= round($this->width*$proportion);
			$this->height= round($this->height*$proportion);
			$this->isProportioned= 1;
			berror("Image->proportion() reduce width: new size is $this->width x $this->height. ($proportion)",2);
			}

		if ($height != "*" && $this->height > $height) {
			$proportion= $height/$this->height;
			$this->width= round($this->width*$proportion);
			$this->height= round($this->height*$proportion);
			$this->isProportioned= 1;
			berror("Image->proportion() reduce height: new size is $this->width x $this->height. ($proportion)",2);
			}

		berror("Image->proportion() new size is $this->width x $this->height.",1);
		return 1;
		}

	function getFileSize () {
		if ($this->path=="") $this->getBaseUrl();
		if (file_exists($this->path)) {
			$size= filesize($this->path);
			$this->bytesize= $size;
			if ($size<1024) {
				$this->filesize= "$size Bytes";
				}
			elseif ($size < 1048576) {
				$size= $size/1024;
				$size= round($size,2);
				$this->filesize= "$size KB";
				}
			else	{
				$size= $size/1048576;
				$size= round($size,2);
				$this->filesize= "$size MB";
				}
			}
		else {
			$this->bytesize= 0;
			$this->filesize= "file not found!";
			}
		return $this->filesize;
		}
	}


class Uplink extends PublishableObject {
	// uplink (weblog republishing settings) object
	var $publishurl;		// xml-rpc url
	var $remoteuser;		// username
	var $remotepass;	// password - stored encrypted
	var $remotename;	// blogname
	var $remoteid;		// blogid
	var $remoteurl;		// url of the published weblog
	var $template;		// template for entries (bml and/or html)
	var $remotepublish;	// should remote weblog publish on post? (boolean)
	var $autopublish;	// should public entries automatically be published to this uplink? (boolean) (unimplemented...?)

	// constructor
	function Uplink () {
		$this->objtype= "uplink";
		$this->columns= "publishurl=varchar(255)^remoteuser=varchar(255)^remotepass=varchar(255)^remotename=varchar(255)^remoteid=int^remoteurl=varchar(255)^template=text^remotepublish=char(4)^autopublish=char(4)";
		}
	}
	
class Subscription extends PublishableObject {
	// subscription object
	var $email;		// email address for delivery -- may be different than member->email

	// constructor
	function Subscription () {
		$this->objtype= "subscription";
		$this->columns= "email=varchar(255)";
		}
	}

class Message extends PublishableObject {
	// message object
	var $ptext;		// plain text version of the message
	var $html;		// html version of the message
	var $sendtime;	// time to start sending the message
	var $recipients;	// number of subscribers the message has been sent to (not real time, necessarily...)

	// constructor
	function Message () {
		$this->objtype= "message";
		$this->columns= "subject=varchar(255)^ptext=TEXT^html=TEXT^sendtime=DATETIME^recipients=INT";
		}
		
	function createMessage ($object, $method, $sendtime="" ) {
		// creates a new meesage, based on object, using the context hinted at in $method
		berror("message create: called for $object->objtype:$object->id with method=$method",1);
		
		// sendtime
		if ($sendtime=="") $sendtime= date("Y-m-d H:i:s");

		// set up the properties
		$this->status= "new";
		$this->flavor= "$method";
		$this->name= uniqid("");
		
		// create against the parent of object...
		if ($object->parentid!=0) {
			$parent= $object->getParent();
			$this->parentobjtype= $parent->objtype;
			$this->parentid= $parent->id;
			}
		// ..or against parent folder
		else {
			$this->parentobjtype= "folder";
			$this->parentid= $object->folderid;
			}
		
		// finish building
		$this->public= $object->public;
		$this->rank= $object->rank;
		$this->sendtime= $sendtime;
		$this->recipients= 0;
		$this->subject= $object->title;

		// find the context to use for html
		$htmlobject= $object;
		$htmlobject->getContext($method, "html");
		$htmlobject->process();
		$this->html= $htmlobject->render();
		
		// do the same for text
		$object->getContext($method, "txt");
		$object->process();
		$this->ptext= $object->render();
		
		// save the new message record
		$success= $this->insertObject();
		return $success;
		}
	}

class Sequence extends ContentObject {
	function Sequence () {
		$this->objtype= "sequence";
		$this->columns= "";
		}
	}

class Event extends PublishableObject {
	// event object (for sequences / server events)
	var $sequenceid;
	var $starttime;
	var $duration;

	// constructor
	function Event () {
		$this->objtype= "event";
		$this->columns= "sequenceid=INT UNSIGNED^starttime=VARCHAR(255)^duration=VARCHAR(255)^INDEX index_sequenceid=(sequenceid)";
		}
		
	}

class Counter extends BeryliumObject {
	//  counter class for keeping track of hits, links, etc
	// NOTE counter maxes-out up to 9,999,999,999.99 , avgcount maxes at 999,999.99
	//		counter may be incremented by 0.01 at a time

	 // these are declared in BeryliumObject
	 // var $id;
	 // var $flavor;
	 // var $created;
	 // var $updated;
	 // var $sitememberid;
	 // var $siteid;
	 // var $folderid;
	 // var $status;
	 // var $properties;
	var $parentobjtype;
	var $parentid;
	var $count;
	var $avgcount;
	var $avgperiod;
	var $avgmax;
	var $avgmaxdate;

	var $columns;

	// constructor
	function Counter() {
		$this->objtype= "counter";
		$this->columns= "parentobjtype=VARCHAR(255)^INDEX index_parentobjtype=(parentobjtype(16))^parentid=INT UNSIGNED^count=DECIMAL(12,2) UNSIGNED^avgcount=DECIMAL(8,2) UNSIGNED^avgperiod=INT UNSIGNED^avgupdated=DATETIME^avgmax=DECIMAL(8,2) UNSIGNED^avgmaxdate=DATETIME";
		}

	function ping($objtype, $id, $flavor="views", $increment=1, $avgperiod=86400) {
		berror("ping: will increment $flavor counter for $objtype:$id by $increment.",1);

		//  get/create local counter object
		$lc= new Counter;
		if (!$lc->selectCounter($objtype, $id, $flavor)) {
			// counter not found, create one:
			berror("ping: counter not found, creating new.",1);
			$lc->createCounter($objtype, $id, $flavor, $avgperiod);
			}

		// return error to app if not found and unable to create
		if ($lc->id=="") {
			berror("unable to increment $flavor counter for $objtype:$id-- database error.",1);
			return 0;
			}
			
		// if updated was more than $lc->avgperiod seconds ago, update avgs
		$updated= mysql_timestamp($lc->avgupdated);
		$created= mysql_timestamp($lc->created);
		$now= time();
		$elapsed= $now - $updated;
		berror("ping: $elapsed seconds have elapsed since $lc->avgupdated ($now - $updated). ",1);
		if ($elapsed > $lc->avgperiod) {
			berror("That's greater than $lc->avgperiod, so computing new avgs values.",1);

			// how many avgperiods have passed since created?
			$created= mysql_timestamp($lc->created);
			$elapsed= $now - $created;
			$periods= $elapsed/$lc->avgperiod;
			
			// new average
			$lc->avgcount= round($lc->count/$periods,2);
			$lc->avgupdated= date("Y-m-d H:i:s");
			berror("new average after $periods periods is $lc->avgcount. $elapsed seconds have passed since counter created at $lc->created, and count is at $lc->count.",1);

			// does this qualify as a new avgmax?
			if ($lc->avgcount > $lc->avgmax) {
				$lc->avgmax= $lc->avgcount;
				$lc->avgmaxdate= date("Y-m-d H:i:s");
				berror(".... a new record! ($lc->avgmax on $lc->avgmaxdate)",1);
				}
			}
		elseif (($now - $created)<$lc->avgperiod) {
			// first period hasn't come due yet, update avg with count
			$lc->avgcount= $lc->count + $increment;
			$lc->avgupdated= date("Y-m-d H:i:s");
			$lc->avgmax= $lc->avgcount;
			$lc->avgmaxdate= date("Y-m-d H:i:s");
			}
		
		// increment the counter and update
		$lc->count= $lc->count + $increment;
		
		// addslashes to all fields, merge p_keys into $this->properties
		$lc->beryliumToMySQL();

		// get columns from table description so we know what bits of this object we can save
		$query= "DESCRIBE $lc->objtype ";
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			berror("updateObject() extracting column ".$columnarray['Field'],3);
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through columns to build the update query
		$queryvalues= "updated= now()";
		foreach ($tablecolumn AS $key=>$val) {
			if ($key=="id" OR $key=="created" OR $key=="updated") {
				berror("updateObject() continuing because of $key being id, or created or updated.",3);
				continue;
				}
			if ($lc->objtype!="session" AND ($key=="siteid" OR ($key=="sitememberid" && $sitemember->role!="admin") )) {
				berror("updateObject() continuing on siteid or sitememberid (objtype!=session). ($key)",3);
				continue;
				}
			if ($lc->objtype=="sitemember" AND ($key=="folderid" OR ( $key=="role" && $lc->id==$sitemember->id ))) {
				berror("updateObject() continuing on sitemember.folderid or sitemember.role (sitemembers cannot change their own role). ($key)",3);
				continue;
				}
			if ( $lc->{$key}=="" ) {
				berror("updateObject() continuing for this->$key='' (".$lc->{$key}.") and postvars[$key] is '' also. (<b>".$postvars[$key]."</b>)",3);
				continue;
				}
			else {
				berror("updateObject() setting newobject[$key]=".$lc->{$key}.".",3);
				$newobject[$key]= $lc->{$key};
				$queryvalues= $queryvalues.", $key= '$newobject[$key]'";
				}
			}

		// process the update query
		$query= "UPDATE $lc->objtype SET $queryvalues WHERE is='$lc->id' ";
		$result= mysql_query($query);
		if (!$result) {
			berror("updateObject(): update query failed to get a result. $query; (".mysql_error().")",1);
			$success= 0;
			}
		else {
			berror("updateObject: <b>update successful:</b> $query;",1);
			$success=1;
			}

		// unencode object
		$lc->mySQLToBerylium();

                // get the date and time in case we need it.
                $lc->updated= date("Y-m-d H:i:s");
		return $lc->count;
		}

	function selectCounter($objtype, $id, $flavor="views") {
		berror("looking for $flavor counter for $objtype:$id ",1);
		global $site;
		$query= "SELECT obj.* FROM counter AS obj WHERE obj.siteid='$site->id' AND obj.flavor='$flavor' AND obj.parentobjtype='$objtype' AND obj.parentid='$id' AND obj.status='posted' ";
		$this->selectObject($query);
		if ($this->listsize==1) {
			berror("found counter:$this->id.",1);
			return 1;
			}
		else {
			berror("found $this->listsize items, unsuccessful lookup.",1);
			if ($this->listsize>1) berror("<b>Error: counter table corruption</b>, found more than one $flavor counter for $objtype:$id.",1);
			$this->selectmiss= 1;
			return 0;
			}
		}

	function createCounter($objtype, $id, $flavor="views", $avgperiod=86400) {
		berror("will attempt to create a $flavor counter for $objtype:$id with avgperiod=$avgperiod. ",1);
		// check for existing counter
		if ($this->selectmiss!=1) {
			$this->selectCounter($objtype, $id, $flavor);
			if ($this->id!="") {
				berror("found existing counter #$this->id: a $this->flavor counter for $this->parentobjtype:$this->parentid.",1);
				return 0;
				}
			}

		// starting values
		$this->parentobjtype= $objtype;
		$this->parentid= $id;
		$this->flavor= $flavor;
		$this->count= 0;
		$this->avgcount= 0;
		$this->avgperiod= $avgperiod;
		$this->avgupdated= date("Y-m-d H:i:s");
		$this->avgmax= 0;
		$this->avgmaxdate= date("Y-m-d H:i:s");
		$this->status= "posted";

		// insert
		$this->insertObject("counter-override");

		berror("inserted new $this->flavor counter: counter:$this->id ",1);
		return $this->id;
		}

	// end Counter class
	}

// EOF

