<?php
// Berylium2 main object class
//$Date: 2003/07/24 21:29:27 $

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// master class for all objects
class BeryliumObject {

	// all database objects have these attributes
	var $id;		// unique id
	var $flavor;		// subtype of the object; indexed
	var $created;		// creation timestamp
	var $updated;		// last update timestamp
	var $sessionid;		// last session to modify this object
	var $sitememberid;	// Sitemember id of owner/creator or 0 for Anonymous; indexed
	var $siteid;		// id of containing Site or 0 for Ubiquitous; indexed
	var $folderid;		// id of containing Folder or 0 for root (/); indexed
	var $status;		// new | posted | hidden | deleted; indexed
	var $properties;		// ^-delimited list of key=value pairs for extra properties (become $this->p_key=value)

	// operational attributes not stored in db
	var $columns;		// mySQL column_definition for this object, to be inherited by user objects
	var $queryExtras;	// extra WHERE clauses (beginning with AND) and/or OFFSET, LIMIT, and ORDERBY clauses
	var $listsize;		// number of objects returned by selectObject() (number of objects in $objectarray[])

	// constructor method
	function BeryliumObject() {
		$this->columns= "id=INT UNSIGNED AUTO_INCREMENT PRIMARY KEY^flavor=VARCHAR (255)^INDEX index_flavor=(flavor(32))^created=DATETIME^updated=DATETIME^sessionid=INT UNSIGNED^sitememberid=INT UNSIGNED^INDEX index_sitememberid=(sitememberid)^siteid=INT UNSIGNED^INDEX index_siteid=(siteid)^folderid=INT UNSIGNED^INDEX index_folderid=(folderid)^status=VARCHAR(255)^INDEX index_status=(status(16))^properties=TEXT";
		}

	// policies
	function applyPolicy($override=0) {
		berror("applyPolicy: called on $this->objtype:$this->id ($this->name).",1);

		// only call once per object, k?
		if ($this->policyId!="" && $override==0) {
			berror(" -- already has a policy: $this->policyId",1);
			return 1;
			}
		$dbpolicies=0;

		global $session, $site, $sitemember, $member, $folder, $policy;
		$postvars= $_POST;
		$getvars= $_GET;
		
		// evaluate the policy
		if ($policy->policy=="") {
			berror("-- called with no global policy loaded. Error.",1);
			return 0;
			}
		eval($policy->policy);
		berror("applyPolicy:  Policy eval()ed, this->policyId=$this->policyId",2);

		// is owner?
		if (( $this->objtype!="sitemember" && $this->sitememberid==$sitemember->id && $sitemember->id!=0 ) || ( $this->objtype=="sitemember" && $this->memberid==$member->id )) {
			$this->owner= 1;
			berror("applyPolicy:  this->owner= $this->owner because you are sitemember:$sitemember->id and this is owned by sitemember:$this->sitememberid.",3);
			}
		elseif ($this->sitememberid=="" && $sitemember->id!=0) {
			$this->owner= 1;
			berror("applyPolicy: this->owner= $this->owner because this item seems to be unowned. (this->sitememberid= $this->sitememberid)",3);
			}
		else {
			$this->owner= 0;
			berror("applyPolicy: this->owner=0 because you are sitemember:$sitemember->id and this is owned by sitemember:$this->sitememberid.",3);
			}

		// anonymouses can't really own anything...
		if ($sitemember->role=="anonymous") {
			$this->owner= 0;
			$this->itemOwner= 0;
			$this->goAwayAndRegisterYouPerson= "1"; // heh
			berror("applyPolicy: you are anonymous so you don't own it. ",2);
			}

		// is editor?
		if (( $sitemember->role=="editor" && $this->rank <= $sitemember->rank ) || $sitemember->role=="admin") {
			$this->editor= 1;
			berror("applyPolicy: this->editor $this->editor",2);
			}
		else {
			$this->editor= 0;
			}

		// determine whether this kind of object can be saved by policy
		if ( $this->canSave[$this->objtype]==1 || $this->canSave['all'] ) {
			berror("applyPolicy: you can save these. this->canSave[$this->objtype]=".$this->canSave[$this->objtype]." OR this->canSave[all]=".$this->canSave[all],2);
			$cansave= 1;
			}
		else $cansave= 0;

		// is insert (can create like objects?)
		if ($cansave) {
			$this->insert= 1;
			berror("applyPolicy: this->insert $this->insert",2);
			}
		else $this->insert= "";

		// is update (can create like objects?)
		// update is possible if canSave[objtype] and either: 1) admin, 2) owner with rank greater than the object's, or 3) editor with rank greater than the object's
		berror("applyPolicy: Update checking: this->p_sessionid= $this->p_sessionid...",2);
		if ( $cansave && ( $this->owner || $this->editor ) && ( $this->rank <= $sitemember->rank || $sitemember->role=="admin" )) {
			$this->update= 1;
			berror(" applyPolicy: this->update $this->update",2);
			}
		// kludge for anonymous updating of, eg, comments.
		elseif ( $cansave && $this->rank <= $sitemember->rank && $sitemember->id==0 && $this->sitememberid==0 && $this->p_sessionid==$session->id) {
			$this->update= 1;
			berror("applyPolicy: this->update=$this->update because this anonymous session ($session->id) is the same as this->p_sessionid ($this->p_sessionid).",2);
			}
		else $this->update= 0;

		// generate policyReport
		$this->policyReport= "Policy report for $this->objtype:$this->id: ";
		if ( $this->owner ) $this->policyReport.= " <font color='purple'>owner</font>  ";
		else $this->policyReport.= " <font color='purple'>not owner</font>  ";
		if ( $this->editor ) $this->policyReport.= " <font color='blue'>editor</font>  ";
		if ( $this->insert ) {
			$this->policyReport.= " <font color='green'>insert</font>  ";
			if ( $this->update ) $this->policyReport.= " <font color='red'>update</font> ";
			else $this->policyReport.= " <font color='red'>no update (not enough rank)</font> ";
			}
		else $this->policyReport.= " <font color='green'>no insert (no canSave)</font>  ";
		$this->policyReport.= " ($this->policyId)";

		berror("applyPolicy: report: $this->policyReport",1);
		return 1;
		}

// callable methods from context to translate webform into object -- save, upload, and import: 

	function save($maxsize=0) {
		// gets new values from $_POST and inserts/updates them in the db
		// note that contexts are responsible for giving new objects decent, upstanding names.
		// all policy checking is done at the insertObject / updateObject level
		berror("save() called by '$this->objtype' object:$this->id ($this->name) (path=$this->path).",1);

		// load new object vars from $_POST -- ignore id, contextOverride, folderid, and siteid (and name on folders-- see Folder->save()
		foreach ($_POST as $key=>$value) {
			if ($key=="id" || $key=="contextOverride" || $key=="folderid" || $key=="siteid") {
				berror("save() ignored _POST[$key].",2);
				continue;
				}
			if ($this->objtype=="folder" && $key=="name") continue;
			$this->{$key}= $value;
			berror("save() set this->$key=$value",1);
			}

		// generate automagic keywords for searching later...
		// v2 -- this should disappear once we switch to MySQL FULLTEXT indexes -- let them deal with i18n on this, heh.
		$ignorewords= " the , of , and , a , to , in , is , you , that , it , he , she , for , was , on , are , as , with , his , her , they , at , be , this , from , i , have , or , by , one , had , not , but , all , were , there , can , an , your , which , their , said , if , do , so , these , has , than , did , those , 1 , 2 , 3 , 4 , 5 , 6 ";
		$igwordsarray= explode(",", $ignorewords);
		$ignorepunctuation= ".,?,!,:,;,[,]";
		$igpuncarray= explode(",", $ignorepunctuation);
		$igpuncarray[]= ",";
		$this->keywords= str_replace($igwordsarray, " ", str_replace($igpuncarray, " ", strtolower($this->description)));
		$this->keywords= str_replace("  ", " ", $this->keywords);

		// has the "Create New" button been pressed?
		if ($this->submit=="create new") {
			$this->id= "";
			}

		// name check - must be free of special chars for most objects...
		if ($this->objtype!="folder" && $this->objtype!="sitemember") {
			$this->name= str_replace("%","",urlencode(str_replace(" ","",$this->name)));
			berror("save() has determined name will be $this->name",1);
			}
		// no hyphens allowed, except in site names
		if ($this->objtype!="site") $this->name= str_replace("-","_",$this->name);

		// update or insert here
		if ($this->id!="" && $this->contextOverride!="") $success= $this->updateObject($this->contextOverride);
		elseif ($this->id!="") $success= $this->updateObject();
		else $success= $this->insertObject();
		if (!$success) return 0;

		// was there a new attachment?
		if ($_FILES['filefile']['name']!="") {
			berror("save(): Will attempt to upload attached file into $this->path.",1);
			if ($this->upload($_FILES['filefile'], $maxsize)) {
				berror("File uploaded.",1);
				}
			}
		elseif ($this->fileurl!="") {
			berror("save(): Will attempt to import $this->fileurl into $this->path.",1);
			if ($this->import($this->fileurl, $maxsize)) {
				berror("File imported.",1);
				}
			}

		return $success;
		}

	function upload($filevars, $maxsize=0) {
		$tempfile= $filevars[tmp_name];
		$type= $filevars[type];
		$size= $filevars[size];
		$sentname= $filevars[name];

		// is_uploaded_file check
		if (!is_uploaded_file($tempfile)) {
			berror("upload: $tempfile failed the is_uploaded_file() test. Sorry.",1);
			berror("That file ($tempfile) failed an important security checkpoint. <br><br>Please note this message and contact the server administrator ($GLOBALS[be_adminemail]).",0);
			}
		
		// set up maximum filesize restriction (1MB default)
		if (!$maxsize && isset($GLOBALS['be_maxuploadsize'])) $maxsize= $GLOBALS['be_maxuploadsize'];
		else $maxsize=1048576;

		// check filesize against maximum
		if ($size>$maxsize && $maxsize!=0) {
		berror("File size of $size Bytes exceeds maximum allowed: $maxsize Bytes (".($maxsize/1024)."KB).<br\>
			Please use your browser's back button and upload a smaller file instead.",0);
			}
			
		// path check
		$this->getBaseUrl(1);
		if ($this->path=="" || substr($this->path, -1)=="-") {
			berror("upload: invalid or missing path ($this->path), file will not be uploaded.",1);
			return 0;
			}

		// directory check
		$modir= dirname($this->path);
		if (!is_dir($modir)) {
			// we may need to make month dir.. check yeardir first
			$yeardir= dirname($modir);
			if (!is_dir($yeardir)) {
				// we need to make yeardir
				$filesdir= dirname($yeardir);
				if ($filesdir!= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name) {
					berror("File upload error. Invalid path ($this->path) parsed to $filesdir, $yeardir, and $modir.",0);
					}
				if (!mkdir($yeardir,0770)) berror("File upload error. Couldn't create directory $yeardir.",0);
				}
			if (!mkdir($modir,0770)) berror("File upload error. Couldn't create directory $modir.",0);
			}

		// save it where it needs to go
		berror("upload: saving file at $this->path",1);
		$success= @move_uploaded_file($tempfile, $this->path);
		if (!$success) {
			$blah= move_uploaded_file($tempfile, $this->path);
			berror("Oh boy. Couldn't move uploaded file from $tempfile to $this->path.",0);
			return 0;
			}
			
		// get the md5 hash of the file for validating it later
		$this->p_attachment= md5_file($this->path);

		// get the declared file format for use later
		$dotpos= strrpos($sentname, ".");
		if ($dotpos) {
			$this->p_attachformat= strtolower(substr($sentname, $dotpos+1));

			// limit format to known three-letter extensions
			switch($this->p_attachformat) {
				case "html": $this->p_attachformat= "htm"; break;
				case "text": $this->p_attachformat= "txt"; break;
				case "jpeg": $this->p_attachformat= "jpg"; break;
				}
			}
		else {
			// unknown filetype based on extension
			$this->p_attachformat= "file";
			}
		$this->updateObject();

		// make sure ya can't execute it
		chmod("$this->path", 0660);
		return $success;
		}

	function import($url, $maxsize=0) {
		// set up maximum filesize restriction (1MB default)
		if (!$maxsize && isset($GLOBALS['be_maxuploadsize'])) $maxsize= $GLOBALS['be_maxuploadsize'];
		elseif (!$maxsize) $maxsize=1048576;

		// path check
		$this->getBaseUrl(1);
		if ($this->path=="" || substr($this->path, -1)=="-") {
			berror("upload: invalid or missing path ($this->path), file will not be uploaded.",1);
			return 0;
			}

		// directory check
		$modir= dirname($this->path);
		if (!is_dir($modir)) {
			// we may need to make month dir.. check yeardir first
			$yeardir= dirname($modir);
			if (!is_dir($yeardir)) {
				// we need to make yeardir
				$filesdir= dirname($yeardir);
				if ($filesdir!= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name) {
					berror("File upload error. Invalid path ($this->path) parsed to $filesdir, $yeardir, and $modir.",0);
					}
				if (!mkdir($yeardir,0770)) berror("File upload error. Couldn't create directory $yeardir.",0);
				}
			if (!mkdir($modir,0770)) berror("File upload error. Couldn't create directory $modir.",0);
			}

		// get the contents of the remote file...
		$tempfile= file_get_contents($url);

		// save it where it needs to go
		$fp= fopen($this->path, "w");
		$success= fwrite($fp, $tempfile, $maxsize);
		if (!$success) {
			berror("Sorry, unable to write contents of $url to $this->path.",0);
			}
			
		// get the md5 hash of the file for validating it later
		$this->p_attachment= md5_file($this->path);

		// get the declared file format for use later
		$dotpos= strrpos($url, ".");
		if ($dotpos) {
			$this->p_attachformat= strtolower(substr($sentname, $dotpos+1));

			// limit format to known three-letter extensions
			switch($this->p_attachformat) {
				case "html": $this->p_attachformat= "htm"; break;
				case "text": $this->p_attachformat= "txt"; break;
				case "jpeg": $this->p_attachformat= "jpg"; break;
				}
			}
		else {
			// unknown filetype based on extension
			$this->p_attachformat= "file";
			}
		
		// set the source
		if ($this->source=="") $this->source= "$url";
		$this->updateObject();

		// make sure ya can't execute it
		chmod("$this->path", 0660);
		return $success;
		}

	function publish($format, $recipe="") {
		// publishes to static site if site is configured for it
		// call just after this->save() for best results
		berror("publish: called by $this->objtype:$this->id with format=$format and recipe=$recipe ",1);
		global $session, $site, $folder, $containers;
		$this->applyPolicy();

		if (!$ftpconn= ftpconnect()) {
			berror("Error connecting to FTP, cannot publish.",1);
			return 0;
			}
			
		// setup dynamic vars
		$staticpathformat= "p_staticpath_$format$recipe";
		$staticmd5format= "p_staticmd5_$format$recipe";

		// check for existing static file at this->p_staticfile
		if ($this->{$staticpathformat}!="") {
			$existingpath= $this->{$staticpathformat};
			$tmp = tempnam ("/tmp", "be2publish");
			if ( @ftp_get ( $ftpconn, $tmp, $existingpath, FTP_BINARY ) ) {
				// is it OUR static file?
				if (md5_file($tmp)!=$this->{$staticmd5format}) {
					berror("File at $existingpath does not match the file we put there.",1);
					
					// all is not lost, but only if the name has changed!
					if ($this->nameChanged=="") {
						berror("Tried to republish this $this->objtype, but the file at ".$this->{$staticpathformat}." is not the one I put there.",1);
						$this->{$staticpathformat}= "0";
						$this->{$staticmd5format}= "0";
						$this->updateObject("publish");
						return 0;
						}
					}
				// it's ours, so feel free to remove it
				elseif (!@ftp_delete($ftpconn, $existingpath)) {
					berror("Umm, tried to delete $existingpath and couldn't.",0);
					return 0;
					}
				}
			else {
				berror("No existing file found at $existingpath. ($tmp)",1);
				$this->{$staticpathformat}= "0";
				// remember md5 in case the folder was moved and the object is in the new location already
				$oldmd5= $this->{$staticmd5format};
				$this->{$staticmd5format}= "0";
				}
			
			// destroy $tmp
			unlink($tmp);
			}
			
		// check against this->status and this->public, as well as folder->status and folder->public
		// only public-posted objects with rank>99 get published, thanks
		if ($this->status!="posted" || $this->public!=1 || $this->rank<=50) {
			berror("publish: this object is not eligible for publishing, as it is $this->public-$this->status-$this->rank.",1);
			$this->{$staticpathformat}= "0";
			$this->{$staticmd5format}= "0";
			$this->updateObject("publish");
			return 0;
			}
		// folder check
		if ($this->objtype!="folder" && ( $folder->status!="posted" || $folder->public!=1 || $folder->rank<=50 )) {
			berror("publish: this object is not eligible for publishing, because its containing folder ($folder->name) is $folder->public-$folder->status-$folder->rank.",1);
			$this->{$staticpathformat}= "0";
			$this->{$staticmd5format}= "0";
			$this->updateObject("publish");
			return 0;
			}
		elseif ($this->objtype=="folder" && $this->name!="/" && ( $containers[1]->status!="posted" || $containers[1]->public!=1 || $containers[1]->rank<=50 )) {
			berror("publish: this folder is not eligible for publishing,  because its containing folder (".$containers[1]->name.") is ".$containers[1]->public."-".$containers[1]->status."-".$containers[1]->rank,1);
			$this->{$staticpathformat}= "0";
			$this->{$staticmd5format}= "0";
			$this->updateObject("publish");
			return 0;
			}

		// generate HTTP request for this object in $format -- and recipe if given and save to tmp
		if ($recipe!="") $recipetag= "@$recipe";
		if ($this->objtype=="folder") {
			// folders are really indexes...
			$uri= $this->name."/index$recipetag.".$format;
			}
		else {
			$this->getBaseUrl(1);
			berror("publish: this->staticPath is ".$this->staticPath,1);
			//$noformat= substr($this->staticPath,0,strrpos($this->staticPath, "."));
			$uri= $this->staticPath.$recipetag.".".$format;
			}
		$referer= "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
		$fp= fsockopen($site->name, 80, $errno, $errstr, 5);
		if ($fp) {
			fputs ($fp, "GET $uri HTTP/1.0\r\nHost: $site->name\r\nReferer: $referer\r\nUser-Agent: be2-publish\r\n\r\n");
			while (!feof($fp)) {
				$temp= fgets($fp, 512);
				if ($session->errorLevel>=2) $fullresponse.= $temp;
				if (!$firstblank && trim($temp)!="") {
					// haven't hit first blank line yet, so this must be an HTTP response header
					$array= explode(":",$temp,2);
					$headers["{$array[0]}"]= $array[1];
					continue;
					}
				elseif (!$firstblank) {
					$firstblank= 1;
					continue;
					}
				$response.= $temp;
				}
			fclose ($fp);
			if ($session->errorLevel>=2) berror("Response: <blockquote>".nl2br(htmlentities($fullresponse))."</blockquote>",2);
			}
		else {
			berror("Couldn't open socket at port 80, no publishing here.",1);
			return 0;
			}

  		// check response headers to make sure it came from Berylium -- otherwise we'd be overwriting an existing file
		//berror(print_r($headers,1),0);
		if (strpos(key($headers), "404")) {
			berror("Received a 404 not found. Couldn't publish.",1);
			$this->{$staticpathformat}= "0";
			$this->{$staticmd5format}= "0";
			$this->updateObject("publish");
			return 0;
			}
		if ($headers["X-Berylium-2"]=="") {
			// this could be a static version of the same page because we moved it from one folder to another...
			if ($oldmd5== md5($response)) {
				berror("Found our page in new location, will publish over it.",1);
				}
			else {
				berror("Received a non-berylium response. File at $uri, couldn't publish.",1);
				$this->{$staticpathformat}= "0";
				$this->{$staticmd5format}= "0";
				$this->updateObject("publish");
				return 0;
				}
			}

		// get md5 of response
		$staticmd5= md5($response);
		
		// check that put path exists... create it if not... this should be recusive calls to $folder->publish()...
		$staticpath= $site->p_ftproot.$uri;
		$staticdir= dirname($staticpath);
		if (!@ftp_chdir($ftpconn, $staticdir)) {
			berror("Need to create directory $staticdir.",2);
			$create[]= $staticdir;
			$parentdir= dirname($staticdir);
			while ($parentdir!= $site->p_ftproot) {
				if (@ftp_chdir($ftpconn, $parentdir)) break;
				berror("Need to create directory $parentdir.",2);
				$create[]= $parentdir;
				$parentdir= dirname($parentdir);
				}
			$create= array_reverse($create);
			foreach ($create AS $directory) {
				if ( !@ftp_mkdir($ftpconn, $directory) ) {
					berror("Unable to make directory $directory, giving up on publish.",1);
					return 0;
					}
				}
			}

		// drop $response into a file resource...
		$tmp = tempnam ("/tmp", "be2publish");
		$fp2 = fopen($tmp, "w");
		fwrite($fp2, $response);
		fclose($fp2);

		// ftp-put tmp into static site
		if (!@ftp_put($ftpconn, $staticpath, $tmp, FTP_BINARY)) {
			berror("Unable to put file $staticpath.",1);
			unlink($tmp);
			$this->{$staticpathformat}= "0";
			$this->{$staticmd5format}= "0";
			$this->updateObject("publish");
			return 0;
			}
		unlink($tmp);
		berror("Successfully published file to $staticpath, updating object with publishing info now.",1);

		// update object
		$this->{$staticpathformat}= $staticpath;
		$this->{$staticmd5format}= $staticmd5;
		$success= $this->updateObject("publish");

		return $success;
		}

// database interface - insert, update, select, etc.

	function insertObject($override=0) {
		// insertObject inserts $this as a new database record
		global $session, $site, $folder, $sitemember;

		berror("insertObject: called by $this->objtype:$this->id ($this->name). ",1);
		$success=0;

		if ($override) berror("<b>override policy mode</b>: $override.",1);

		$this->applyPolicy();
		if (!$this->insert && !$override) {
			berror("-- called without insert policy in $this->policyId and override=$override",1);
			berror("Sorry, you cannot create $this->objtype"."s. Policy report: $this->policyReport.",0);
			return 0;
			}

		// connect to database
		if (!$session->dbconnection) $session->dbconnection= dbconnect();

		// apply policy on insert
		if ($this->objtype!="session" AND !$session->setup AND !$override) {
			// checked against allowed publishing settings...
			if (!($this->canSave[$this->objtype] OR $this->canSave[all])) {
				berror("Failed to find a policy that allows you to save $this->objtype objects. Server must halt.",0);
				exit;
				}
			berror("insertObject: applying policy. statusAllowed=$this->statusAllowed | publicAllowed=$this->publicAllowed | rankAllowed=$this->rankAllowed",2);
			
			// status check
			if (strpos($this->statusAllowed, $this->status)===false) {
				berror("You are trying to set $this->objtype:$this->id's status to $this->status, which is not allowed. Allowed status: $this->statusAllowed.",0);
				exit;
				}
			// rank reduction; EXCEPTION FOR NEW SITEMEMBERS
			if ($this->rank > $this->rankAllowed && $this->objtype!="sitemember") {
				berror("You are trying to set $this->objtype:$this->id's rank to $this->rank, which is not allowed. Maximum allowed rank: $this->rankAllowed.",0);
				exit;
				}
			// public check
			if ($this->public && !$this->publicAllowed) {
				berror("You are trying to make $this->objtype:$this->id public, which is not allowed.",0);
				exit;
				}
			}

		// make sure some important fields are set
		if ($this->siteid=="") $this->siteid=$site->id;
		if ($this->folderid=="") $this->folderid=$folder->id;
		if ($this->sitememberid=="") $this->sitememberid=$sitemember->id;
		$this->sessionid= $session->id;
		
		// check for existence of site
		if ($this->siteid!="") {
			$tempsite= new Site;
			$tempsite->selectObjectById($this->siteid);
			if ($this->siteid!="" && $tempsite->id=="") {
				berror("Site $this->siteid doesn't exist.",0);
				exit();
				}
			}

		// check for existence of folder
		if ($this->folderid!="") {
			$tempfolder= new Folder;
			$tempfolder->selectObjectById($this->folderid);
			if ($this->folderid!="" && $tempfolder->id=="") {
				berror("Folder $this->folderid doesn't exist.",0);
				exit();
				}
			}

		// check for duplicate name in this folder
		if ($this->name!="") {
			$found= $this->checkDuplicate("name");
			if ($found) {
				berror("A $this->objtype with the same $field already exists here. It is $this->objtype:$found[id] with status=$found[status]. Please use the back button to change the name of the object you are trying to create or edit.",0);
				exit();
				}
			}

		// addslashes to all fields
		$this->beryliumToMySQL();

		// get columns from table description so we know what bits of this object to save
		$query= "DESCRIBE $this->objtype ";
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through the columns to build the insert query... id, created and updated are exceptions
		$queryvalues= "''";
		while (list($key,$val)= each($tablecolumn)) {
			if ($key=="id") {
				continue;
				}
			elseif ($key=="created" OR $key=="updated") {
				$queryvalues= $queryvalues.", now()";
				continue;
				}
			else {
				$newobject[$key]= $this->{$key};
				$queryvalues= $queryvalues.", '$newobject[$key]'";
				}
			}		

		// process insert query
		$query= "INSERT INTO $this->objtype VALUES ($queryvalues) ";
		$result= mysql_query($query);
		if (!$result) {
			berror("insertObject: insert query failed to get a result. $query",1);
			$success= 0;
			}
		else {
			berror("insertObject: <b>Insert successful:</b> $query",1);
			$success= 1;
			}

		// update object with new id and unencode
		$this->id= mysql_insert_id();
		$this->mySQLToBerylium();

		// return a valid-looking created date
		$this->created= date("Y-m-d h:i:s");

		return $success;
		}

	function updateObject($override=0) {
		// updateObject updates the database record for $this
		berror("updateObject($override) called by $this->objtype:$this->id ($this->name)",1);
		
		$success=0;
		$overridden=0;
		$postvars= $_POST;
		global $session, $site, $folder, $sitemember;
		
		if (!$this->update && !$override) {
			berror("-- called without update policy in $this->policyId",1);
			berror("Sorry, you cannot update $this->objtype:$this->id. Policy report: $this->policyReport.",0);
			return 0;
			}

		// connect to database
		if (!$session->dbconnection) $session->dbconnection= dbconnect();
		$this->sessionid= $session->id;

		// check for duplicate name in this folder
		if ($this->siteid=="") $this->siteid=$site->id;
		if ($this->name!="") {
			$found= $this->checkDuplicate("name");
			if ($found) {
				berror("A $this->objtype with the same name already exists here. It is $this->objtype:$found[id] with status=$found[status]. Please use the back button to change the name of the object you are trying to create or edit.",0);
				exit();
				}
			}
                        
		// load comparison object to check for lock, ownership and unpassed p_keys
		$command= "\$temp= new ".ucfirst($this->objtype).";";
		eval($command);
		$temp->selectObjectById($this->id);
		berror("updateObject:  loaded temp $this->objtype with id=$temp->id (owned by sitemember:$temp->sitememberid).",2);
		if ($temp->locked) {
			berror("$temp->objtype:$temp->id ($temp->name) is locked by the database administrator. Cannot continue at this time.",0);
			exit();
			}

		// can't change ownship unless admin, can't make rank higher than self
		if ($sitemember->role!="admin" && $this->objtype!="member") {
			$this->sitememberid= $temp->sitememberid;
			// don't update the rank if sitemember is overreaching
			if ($this->rank > $sitemember->rank) $this->rank= "";
			berror("updateObject: After pre-policy adjustments, rank= $this->rank and sitemember= $this->sitememberid. ",2);
			}
		elseif ($sitemember->role!="admin") {
			// don't update the rank if sitemember is overreaching
			if ($this->rank > $sitemember->rank) $this->rank= "";
			berror("updateObject: After pre-policy adjustments, rank= $this->rank and sitemember= $this->sitememberid. ",2);
			}

		// get a policy for temp unless $override
		$temp->applyPolicy();
		$this->owner= $temp->owner;
		$this->editor= $temp->editor;
		$this->insert= $temp->insert;
		$this->canSave= $temp->canSave;
		if ($this->update && $this->update!=$temp->update) {
			berror("updateObject: <font color='red'>ERROR: Policy mismatch. You may not have permission to update.</font>",1);
			}
		$this->update= $temp->update;
		$this->policyId= $temp->policyID;
		$this->policyReport= $temp->policyReport;
		berror("updateObject: After policy filtering, Policy Report is $this->policyReport. ",1);
		berror("-- This->owner= $this->owner because sitemember:$this->sitememberid owns this object and you are $sitemember->id",2);
  		berror("-- This->update= $this->update because sitemember:$this->sitememberid owns this object and you are $sitemember->id (Or session:$this->p_sessionid owns this object and you are session:$session->id)",2);
		berror("-- This->canSave[all]=".$this->canSave['all'].", from policy. This->canSave[$this->objtype]=".$this->canSave[$this->objtype].", also from policy.",2);

		// final check for update permission
		if (!$this->update && !$override) {
			berror("updateObject: called without update policy in $this->policyId and override=$override",1);
			berror("Sorry, you cannot update $this->objtype:$this->id. Policy report: $this->policyReport.",0);
			exit();
			}
		elseif (!$this->update && $override) {
			berror("updateObject: <b>Policy Override</b> by context: $override",1);
			$this->update= 1;
			$overridden= 1;
			}

		// apply policy on update
		if ($this->objtype!="session") {
			if ($overridden!=1 && ( $this->canSave[$this->objtype]=="" && $this->canSave['all']=="")) {
				berror("Sorry, failed to find a policy that allows you to save $this->objtype objects. (".$this->canSave['all'].") Server must halt.",0);
				exit();
				}
			berror("updateObject: applying policy. statusAllowed=$this->statusAllowed | publicAllowed=$this->publicAllowed | rankAllowed=$this->rankAllowed",2);
			// status check
			if (strpos($this->statusAllowed, $this->status)===false && $this->status!="") {
				berror("You are trying to set $this->objtype:$this->id's status to $this->status, which is not allowed. Allowed status: $this->statusAllowed.",0);
				exit();
				}
			// rank reduction
			if ($this->rank > $this->rankAllowed) {
				berror("You are trying to set $this->objtype:$this->id's rank to $this->rank, which is not allowed. Maximum allowed rank: $this->rankAllowed.",0);
				exit();
				}
			// public check
			if ($this->public && !$this->publicAllowed) {
				berror("You are trying to make $this->objtype:$this->id public, which is not allowed.",0);
				exit();
				}
			}
			
		// check for name change
		if ($temp->name!=$this->name) $this->nameChanged= $temp->name;
		berror("temp->name=$temp->name and this->name=$this->name, this->nameChanged=$this->nameChanged.",1);

		// check for unpassed p_keys that we shouldn't overwrite...
		if (is_array($temp->propertiesarray)) {
			foreach ($temp->propertiesarray AS $pkey=>$pvalue) {
				if (trim($pkey)=="") {
					berror("updateObject(): empty pkey.",3);
					continue;
					}
				$p_pkey= "p_$pkey";
				if ($this->{$p_pkey}=="" AND !isset($postvars[$p_pkey]) ) {
					$this->{$p_pkey}= stripslashes($pvalue);
					berror("updateObject(): From db, this->$p_pkey=".$this->{$p_pkey},3);
					}
				else berror("updateObject(): this->$p_pkey is being updated, skipping.",3);
				}
			}
		
		// addslashes to all fields, merge p_keys into $this->properties
		$this->beryliumToMySQL();

		// get columns from table description so we know what bits of this object we can save
		$query= "DESCRIBE $this->objtype ";
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			berror("updateObject() extracting column ".$columnarray['Field'],3);
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through columns to build the update query
		$queryvalues= "updated= now()";
		foreach ($tablecolumn AS $key=>$val) {
			if ($key=="id" OR $key=="created" OR $key=="updated") {
				berror("updateObject() continuing because of $key being id, or created or updated.",3);
				continue;
				}
			if ($this->objtype!="session" AND ($key=="siteid" OR ($key=="sitememberid" && $sitemember->role!="admin") )) {
				berror("updateObject() continuing on siteid or sitememberid (objtype!=session). ($key)",3);
				continue;
				}
			if ($this->objtype=="sitemember" AND ($key=="folderid" OR ( $key=="role" && $this->id==$sitemember->id ))) {
				berror("updateObject() continuing on sitemember.folderid or sitemember.role (sitemembers cannot change their own role). ($key)",3);
				continue;
				}
			if ( $this->{$key}=="" && !isset($postvars["$key"]) ) {
				berror("updateObject() continuing for this->$key=NULL (".$this->{$key}.") because postvars[$key]  is not set.)",3);
				continue;
				}
			else {
				berror("updateObject() setting newobject[$key]=".$this->{$key}.".",2);
				$newobject[$key]= $this->{$key};
				$queryvalues= $queryvalues.", $key= '$newobject[$key]'";
				}
			}

		// process the update query
		$query= "UPDATE $this->objtype SET $queryvalues WHERE id='$this->id' ";
		$result= mysql_query($query);
		if (!$result) {
			berror("updateObject(): update query failed to get a result. $query; (".mysql_error().")",1);
			$success= 0;
			}
		else {
			if ($session->errorLevel>1) berror("updateObject: <b>update successful:</b> $query;",2);
			else berror("updateObject: <b>update successful:</b>",1);
			$success=1;
			}

		// unencode object
		$this->mySQLToBerylium();

                // get the date and time in case we need it.
                $this->updated= date("Y-m-d H:i:s");
		
		// reset $this->update to 0 if an override was used to set it to 1 for the update
		if ($override && $overridden) $this->update= 0;
		return $success;
		}

	function selectObject($query) {
		// selectObject runs a query on the database and returns an $objectarray of results
		//    as well as loading the first object into $this
		berror("selectObject: called by $this->objtype:$this->id ($this->name) with query=$query;",1);
		$success=0;

		global $objecttree, $session;

		// connect to database
		if (!$session->dbconnection) $session->dbconnection= dbconnect();

		// get the result set
		$result= mysql_query($query);
		if (!$result) {
			berror("selectObject(): query failed to get a result: (".mysql_error().")",1);
			return 0;
			}

		if ($objectarray= mysql_fetch_array($result)) {
			$this->arrayToObject($objectarray);
			$list= new bList;
			$list->add($this);
			
			// put this into objecttree with a baseUrl
			if (is_subclass_of($this, "PublishableObject")) $this->getBaseUrl();
			berror("selectObject: <em> $this->objtype:$this->id registered in objecttree.</em>",1);
			$objecttree["$this->objtype:$this->id"]= $this;

			// load the rest of the result set
			while ($listarray= mysql_fetch_array($result)) {
				$command= "\$item= new ".ucfirst($this->objtype).";";
				eval($command);
				$item->arrayToObject($listarray);
				$list->add($item);
				
				if (is_subclass_of($item, "PublishableObject") && $item->id) $item->getBaseUrl();
				if ($item->id) {
					berror("selectObject: <em> $item->objtype:$item->id registered in objecttree.</em>",1);
					$objecttree["$item->objtype:$item->id"]= $item;
					}
				}
			}
		else {
			berror("selectObject(): Empty result found at $result. ",1);
			return 0;
			}

		// add listsize to object and return array of additional results
		$this->listsize= $list->size;
		return $list;
		}

	function selectObjectById($id=0, $register=1) {
		// selectObjectById loads a single object from the database into $this
		// also preemptively calls getBaseUrl() and drops the object into $objecttree
		berror("selectObjectById: called with id=$id by $this->objtype:$this->id ($this->name)",1);
		$success=0;
		global $objecttree, $session, $site;
		
		// just in case
		if ($id==0) $id= $this->id;

		if ($objecttree["$this->objtype:$id"]->id=="") {
			berror("selectObjectById: <em> $this->objtype:$id not found in objecttree, going to db.</em>",1);
			// connect to database
			if (!$session->dbconnection) $session->dbconnection= dbconnect();

			// build the query based on session policy
			if ($this->objtype!="site") $sitetag= "obj.siteid='$site->id' AND ";
			$safeid= addslashes($id);
			$query= "SELECT obj.* FROM $this->objtype AS obj WHERE obj.id='$safeid' $session->sqlSafe ";
			berror("selectObjectById: using query= $query",2);

			// get the result set
			$result= mysql_query($query);
			if (!$result) {
				berror("-- query failed to get a result: (".mysql_error().")",2);
				return 0;
				}

			// take first result and load it into $this object
			$objectarray[0]= mysql_fetch_array($result);
			if (is_array($objectarray[0])) {
				foreach($objectarray[0] as $key=>$value) {
					if (is_int($key)) continue;
					if ($key=="properties" AND trim($value)!="") {
						berror("selectObjectById: found properties ($value), unpacking...",3);
						// unpack properties into propertiesarray
						$this->propertiesarray= bunpack($value);

						// unpack properties array into p_keys
						if (is_array($this->propertiesarray)) {
							foreach ($this->propertiesarray AS $pkey=>$pvalue) {
								if (trim($pkey)=="") {
								berror("-- empty pkey.",3);
								continue;
								}
								$p_pkey= "p_$pkey";
								$this->{$p_pkey}= $pvalue;
								berror("-- this->$p_pkey=".$this->{$p_pkey},3);
								}
							}
						continue;
						}
					$this->{$key}= $value;
					}
				$success= 1;

				if ($register) {
					// also call getBaseUrl()
					$this->getBaseUrl();
					berror("selectObjectById: <em> $this->objtype:$id registered in objecttree now.</em>",1);
					$objecttree["$this->objtype:$id"]= $this;
					}
				}
			else {
				berror("selectObjectById($id): Empty result found in $result. ",1);
				$success= 0;
				}
			}
		else {
			berror("selectObjectById: <em> $this->objtype:$id found in objecttree!</em>",1);
			$this= $objecttree["$this->objtype:$id"];
			$success= 1;
			}
		return $success;
		}

	function getMySQLColumns($objtype="BeryliumObject") {
		// gets the mySQL column_definition from a BeryliumObject of type $objtype for makeTable()
		//   allows objects to define their own SQL tables
		berror("getMySQLColumns: called by $this->objtype:$this->id ($this->name).",1);

		//create a temporary object
		$command= "\$temp= new $objtype;";
		eval("$command");

		//unpack the ^ delimited columns, then use that array to build the column_definition 
		$columns= bunpack($temp->columns);
		foreach ($columns AS $key=>$val) {
			$column_definition= $column_definition.", $key $val";
			}
		$column_definition= substr($column_definition,2);

		// recurse back through parent classes
		if ($parentclass= get_parent_class($temp)) {
			$prepend= $temp->getMySQLColumns($parentclass);
			if ($prepend!="" AND $column_definition!=" ") $column_definition= $prepend.", ".$column_definition;
			elseif ($prepend!="") $column_definition= $prepend;
			}

		// return the column definition
		berror("getMySQLColumns(): Returning column definition: $column_definition",3);
		return $column_definition;
		}

	function makeTable() {
		// initializes a table to hold this type of object
		berror("makeTable called by $this->objtype:$this->id ($this->name).",1);

		if (!$this->classname= get_class($this)) {
			berror("makeTable can't figure out classname of this '$this->objtype' object. Sad face.",0);
			exit();
			}

		// connect to database
		global $session;
		if (!$session->dbconnection) $session->dbconnection= dbconnect();

		// use getMySQLColumns() to build the Create Table query		
		$query="CREATE TABLE ".$this->objtype." (".$this->getMySQLColumns($this->classname).") ";
		$result= mysql_query($query);

		if (!$result) {
			berror("makeTable(): Error on Create Table query= '$query'; (".mysql_error().")",1);
			$success=0;
			}
		else $success=1;
		return $success;
		}

	function checkDuplicate($field="name") {
		// checks the database for a similar object with the same name (or some other field)
		berror("checkDuplicate called on '$field' by $this->objtype:$this->id ($this->name) in site=$this->siteid and folder=$this->folderid.",1);

		// sites must have unique names, period
		if ($this->objtype=="site" and $field=="name") $nonfolder="";

		// folders, must be named uniquely sitewide
		if ($this->objtype=="folder" AND $field=="name") $nonfolder= "AND siteid='$this->siteid' ";

		// otherwise name must be unique to containing folder only
		else $nonfolder= "AND folderid='$this->folderid' ";
		
		// its okay for some things to have duplicate names as long as the older ones are deleted first...
		if ($this->objtype=="event") $deletedokay= "AND status!='deleted' ";

		// build query -- it's okay if $this->id=="" because then it won't be equal to any other ids, will it?
		$query= "SELECT id,name,status FROM $this->objtype WHERE id!='$this->id' AND $field='".$this->{$field}."' $nonfolder $deletedokay";
		$result= mysql_query($query);

		berror("checkDuplicate checking for duplicate $this->objtype using query=$query",2);
		if ($duplicate= @mysql_fetch_array($result)) {
			berror("checkDuplicate Found one: $duplicate[objtype]:$duplicate[id] ($duplicate[name]) with status=$duplicate[status].",1);
			$found=$duplicate;
			}
		else $found=0;
		return $found;
		}

// encode/decode, translation, etc.

	function beryliumToHtml($mode="") {
		// processes text fields for html display with bml parsed -- not reversible!
		// theory: removes all html tags, curly brackets "{}" and doublequotes from user input, converts newlines to <br>, and parses bml
		// should also replace single quotes with some entity
		// warning: currently only works with text in ISO-Latin-1 charset!!!
		berror("beryliumToHtml called by $this->objtype:$this->id ($this->name).",1);

		if ($this->currentFormat!="text/html") {
			$objectproperties= get_object_vars($this);
			foreach ($objectproperties as $key=>$value) {
				if (!is_string($value)) continue;
				if ($key=="sqlSafe" || $key=="sqlSafeFolder") continue;
				if ($mode=="list" && $key=="body") continue;
				switch ($key) {
					// allow HTML in some fields
					case "body":
					case "description": $this->{$key}= bHtml($value,1); break;
					// disallow by default
					default: $this->{$key}= bHtml($value,0);
					}
				}
			$this->currentFormat= "text/html";
			}
		else berror("-- redundant call, format is already $this->currentFormat.",2);
		return 1;
		}

	function beryliumToForm() {
		// processes text fields for html display -- reversible
		// theory: removes all html tags and doublequotes from user input (" becomes &quot;)
		// warning: currently only works with text in ISO-Latin-1 charset!!!
		berror("beryliumToForm called by $this->objtype:$this->id ($this->name).",1);

		if ($this->currentFormat!="text/bml" && $this->currentFormat!="text/html") {
			$objectproperties= get_object_vars($this);
			foreach ($objectproperties as $key=>$value) {
				if (!is_string($value)) continue;
				$this->{$key}= htmlentities($value, ENT_QUOTES, "UTF-8");
				}
			$this->currentFormat= "text/bml";
			}
		elseif ($this->currentFormat!="text/html") {
			berror("beryliumToForm can't process, format is already $this->currentFormat.",1);
			}
		else berror("-- redundant call, format is already $this->currentFormat.",2);
		return 1;
		}

	function formToBerylium() {
		// reverts html-encoded text back to regular chars (&quot; becomes ")
		// warning: only works with text in ISO-Latin-1 charset!!!	
		berror("formToBerylium called by $this->objtype:$this->id ($this->name).",1);

		// reverse the htmlentities translation table...
		$trans = get_html_translation_table(HTMLENTITIES);
		$trans = array_flip ($trans);

		$objectproperties= get_object_vars($this);
		foreach ($objectproperties as $key=>$value) {
			if (!is_string($value)) continue;
			$this->{$key}= html_entity_decode($value, ENT_QUOTES, "UTF-8");
			}
                $this->currentFormat= "text/plain";
		return 1;
		}

	function beryliumToMySQL() {
		// processes all fields for insertion into database -- reversible, except for the initial stripping of slashes
		// theory: escapes quotes and doublequotes in user input so they don't break query strings (" becomes \")
		berror("beryliumToMySQL called by $this->objtype:$this->id ($this->name) (path=$this->path).",1);

		$objectproperties= get_object_vars($this);
		unset($this->propertiesarray);
		foreach ($objectproperties as $key=>$value) {
			// protect against escaped values...
			if (!(strpos($value, '\$')===FALSE)) {
				berror("Cleaning up $key=>$value",1);
				$value= str_replace('\$','\ ',$value);
				}
			if (!is_string($value) && !is_numeric($value)) continue;
			if (substr($key,0,2)=="p_" && trim($value)!="") {
				// create properties array
				$propname= substr($key,2);
				if ($value=="0") $value= "";
				$this->propertiesarray[$propname]= addslashes($value);
				berror("beryliumToMySQL adding $propname to the properties array.",2);
				continue;
				}
			$this->{$key}= addslashes($value);
			}
		if (is_array($this->propertiesarray)) {
			// packup properties
			$this->properties= bpack($this->propertiesarray);
			berror("beryliumToMySQL() properties array packed as: $this->properties",2);
			}
		else $this->properties= " ";
                $this->currentFormat= "text/php";
		return 1;
		}

	function mySQLToBerylium() {
		// removes quoting
		// theory: unescapes quotes and doublequotes in user input (\" becomes ")
		berror("mySQLToBerylium called by $this->objtype:$this->id ($this->name).",1);

		$objectproperties= get_object_vars($this);
		foreach ($objectproperties as $key=>$value) {
			if (!is_string($value)) continue;
			if ($key=="properties" AND trim($value)!="") {
				berror("mySQLToBerylium found properties, unpacking...",2);
				// unpack properties into propertiesarray
				$this->propertiesarray= bunpack($value);
				
				// unpack properties array into p_keys
				if (is_array($this->propertiesarray)) {
					foreach ($this->propertiesarray AS $pkey=>$pvalue) {
						$p_pkey= "p_$pkey";
						$this->{$p_pkey}= stripslashes($pvalue);
						berror("-- this->$p_pkey=".$this->{$p_pkey},2);
						}
					}
				continue;
				}
			$this->{$key}= stripslashes($value);
			}
                $this->currentFormat= "text/plain";
		return 1;
		}
		
	function allowHTML($property) {
		// allow HTML tags in $this->{$property}
		berror("allowHTML called on $this->objtype:$this->id -> $property",1);
		$field= $this->{$property};
		$field= @html_entity_decode ($field, ENT_QUOTES, "UTF-8");
		$this->{$property}= bsafe_html($field);
		}

	function timeFormat($format='D M j, Y, \a\t H:i:s') {
		// mysqltimestamp()s $this->created and $this->modified to UNIX timestamps
		//     $this->createdStamp $this->modifiedStamp, then translates 
		//      by $format, replacing $this->created and $this->modified
		//      with nice dates
		berror("timeFormat() called with '$format' by $this->objtype:$this->id ($this->name).",1);

		if ($this->timeFormatted=="") {
			$this->updatedSql= $this->updated;
			$this->updatedStamp= mysql_timestamp($this->updatedSql);
			$this->createdSql= $this->created;
			$this->createdStamp= mysql_timestamp($this->createdSql);
			}

		$this->created= date($format, $this->createdStamp);
		berror("timeFormat(): $this->createdSql was translated as $this->created.",3);

		$this->updated= date($format, $this->updatedStamp);
		berror("timeFormat(): $this->upatedSql was translated as $this->updated.",3);

		$this->timeFormatted= $format;
		return 1;
		}

        function getRuntimeVars($recache=0) {
		// call this *after* $this->beryliumToHtml in preprocess to enable runtimevars
		// see docs/runtimevars.txt for a list of them
		// if you add something here, update that document. Thanks.
		if ($this->runtimecalled!=1 || $recache) {
			berror("getRuntimeVars processing $this->objtype:$this->id.",1);

			// format time and get path info
			$this->timeFormat("F j, Y \a\\t g:ia");
			$this->getBaseUrl();

			// dateTag: created or p_originaldate
			if ($this->p_originaldate) {
					$origdate= mysql_timestamp($this->p_originaldate);
					$this->originaldate= date("l, F j, Y", $origdate);
					$this->dateTag= $this->originaldate;
					}
			else $this->dateTag= $this->created;

			// publishStatus, glow, iconpvt: compile publishStatus ( like: public-posted-100 ), iconpvt, and glow
			switch (true) {
					case ($this->rank <= 50) :
							$this->lightrank= 50;
							break;
					case ($this->rank < 500) :
							$this->lightrank= 100;
							break;
					case ($this->rank < 1000) :
							$this->lightrank= 500;
							break;
					case ($this->rank >= 1000) :
							$this->lightrank= 1000;
							break;
					}
			if ($this->public) {
					$this->longstatus= "public-$this->status-$this->rank";
					$this->glow= "public-$this->status-$this->lightrank";
					}
			else {
					$this->longstatus= "private-$this->status-$this->rank";
					$this->glow= "private-$this->status-$this->lightrank";
					$this->iconpvt= "-pvt";
					}
			//if ($this->status=="deleted") $this->glow= "deleted";

			// iconTag: show default icon or alt icon from imageid
			if ($this->imageid!="0") {
					$this->iconTag= bparsebml("[icon:$this->imageid;$this->flavor $this->objtype;16x16]");
					}
			else $this->iconTag= "<a href='$this->baseUrl'><img src='/bicons/$this->objtype$this->iconpvt.gif' alt='icon' title='$this->flavor $this->objtype' class='inline' /></a>";

			// authorTag: show sitemember if no author defined
			$this->authorObj= new Sitemember;
			$this->authorObj->selectObjectById($this->sitememberid);
			$this->authorObj->getBaseUrl();
			$this->authorName= "<a href='".$this->authorObj->staticUrl."'>".$this->authorObj->name."</a>";
			$this->authorPlain= $this->authorObj->name;
			if (trim($this->author)== "") {
				$this->authorTag= $this->authorName;
				}
			else $this->authorTag= $this->author;

			// author location
			$this->authorLocation= $this->authorObj->p_location;

			// safetitle
			$this->safetitle= strip_tags($this->title);

			// SOURCE
			if ($this->source!="") {
				if (substr($this->source,0,4)=="http") {
					$sourcearray= parse_url($this->source);
					$this->sourceTag= "<span class='label'>Source:</span> ".bparsebml("[$this->source;$sourcearray[host]]")."<br />";
					}
				else $this->sourceTag= "<span class='label'>Source:</span> $this->source<br />";
				}

			// COPYRIGHT
			if ($this->copyright!="") $this->copyrightTag= "<span class='label'>Rights:</span> $this->copyright";

			$this->runtimecalled= 1;
			}
		else berror("getRuntimeVars already called on $this->objtype:$this->id, <em>SKIPPING</em>",2);
		}
		
	function getOptionDiv ($mode="view") {
		global $sitemember, $site;
		$this->applyPolicy();
		if ($this->editor || ( $this->owner && $this->rank <= $sitemember->rank) ) {
			if ($this->publishable==1) {
				$found= 0;
				foreach ( get_object_vars($this) AS $key=>$value ) {
					if (substr($key,0, 13)!="p_staticpath_") continue;
					if ($value=="") continue;
					$staticUrl= "http://$site->name".substr($value, strlen($site->p_ftproot));
					if (!$found) {
						$this->publishStatus= "Static files: (<a href='$this->baseUrl?method=publish'>republish</a>)<li><a href='$staticUrl'>$staticUrl</a></li>";
						$found= 1;
						}
					else $this->publishStatus.= "<li><a href='$staticUrl'>$staticUrl</a></li>";
					}
				if (!$found && $this->status=="posted" && $this->public==1 && $this->rank>50) {
					$this->publishStatus= "Static files: none (<a href='$this->baseUrl?method=publish'>publish it</a>)";
					}
				}
			if ($this->p_announced!="") $announceTag= $this->p_announced;
			else $announceTag= "not yet - <a href='$this->baseUrl?method=announce'><strong>Announce it!</strong></a>";
			$this->editorTag= " - <a href='$this->baseUrl?method=edit'><img src='/bicons/edit.gif' alt='edit' /> edit</a> - <a href='$this->baseUrl?method=pickup'><img src='/bicons/pickup.gif' alt='pick up' /> pickup</a> - <img src='/bicons/bulbsgif/$this->glow.gif' alt='bulb' /></p>
				<blockquote>$this->flavor $this->objtype:$this->id is $this->longstatus<br />
				Created: $this->created by $this->authorName<br />
				Last updated: $this->updated<br />
				Announced to subscribers: $announceTag<br />
				$this->publishStatus</blockquote>";
			}
		elseif ($this->owner && $sitemember->role=="writer") {
			$this->editorTag= " - <a href='$this->baseUrl?method=edit'><img src='/bicons/edit.gif' alt='edit' /> edit</a>  - <img src='/bicons/bulbsgif/$this->glow.gif' alt='bulb' />$this->longstatus</p>";
			}
		else {
			$this->editorTag= " - <img src='/bicons/bulbsgif/$this->glow.gif' alt='bulb' title='$this->longstatus' /></p>";
			}

		// not anonymous...
		if ($sitemember->role!="anonymous") {
			$this->optionDiv= "<div id='Controls'><p><a href='$this->idUrl'>permalink</a> - <a href='javascript:republish(\"$this->baseUrl\")'>uplink/email</a> $this->editorTag</div>";
			}
		// anonymous
		else {
			$this->optionDiv= "<div id='Controls'><p><a href='$this->idUrl'>permalink</a> - <a href='javascript:republish(\"$this->baseUrl\")'>uplink/email</a></p></div>";
			}
		}
		
	function getNeighbors($objtype="",$flavor="%") {
		// looks up surrounding objects, possibly of similar flavor; returns 0, previous, next, or both
		berror("getNeighbors(): called on $this->objtype:$this->id with flavor=$flavor",1);
		global $session;
		
		// convert objtype to array
		if (!is_array($objtype)) {
			$temp= $objtype;
			unset($objtype);
			$objtype= array( $temp );
			}
		// search on documents and images by default
		if ($objtype[0]=="") {
			$objtype= array("document","image");
			}

		// load all peers
		$list= new bList;
		foreach ($objtype AS $thistype) {
			$command= "\$subclass= new ".ucfirst($thistype).";";
			eval($command);
			$query= "SELECT obj.id, obj.name, obj.title, obj.flavor, obj.created,obj.folderid FROM $thistype AS obj WHERE obj.flavor LIKE '$flavor' AND obj.folderid='$this->folderid' $session->sqlSafe ";
			$sublist= $subclass->selectObject($query);
			$list->merge($sublist);
			unset ($sublist);
			unset($subclass);
			}
		$list->sort("created=1");

		// find this object in peer list, and determine previous and next peer
		$previous= -1;
		$next= -1;
		if (is_array($list->list)) {
			foreach ($list->list AS $key=>$peer) {
				if ($peer->id!=$this->id) continue;
				if ($peer->objtype!=$this->objtype) continue;
				$previous= $key-1;
				$next= $key+1;
				break;
				}
			}

		// aggregate the previous and next objects into this object
		$return= 0;
		if ($previous>=0) {
			$this->previous= $list->list[$previous];
			$this->previous->getBaseUrl();
			$this->previous->safetitle= strip_tags(bHtml($this->previous->title));
			if (trim($this->previous->safetitle)=="") $this->previous->safetitle= "Unititled ".$this->previous->flavor;
			$return= "previous";
			}
		if ($next>0 && $next<$list->size) {
			$this->next= $list->list[$next];
			$this->next->getBaseUrl();
			$this->next->safetitle= strip_tags(bHtml($this->next->title));
			if (trim($this->next->safetitle)=="") $this->next->safetitle= "Unititled ".$this->next->flavor;
			if ($return=="") $return= "next";
			else $return= "both";
			}
		return $return;
		}

	function getParent () {
		berror("getParent called on $this->objtype:$this->id with parentobjtype=$this->parentobjtype",1);
		if ($this->parentobjtype=="") return 0;
		$command= "\$parentobject= new ".ucfirst($this->parentobjtype).";";
		eval($command);
		$parentobject->id= $this->parentid;
		$parentobject->selectObjectById($this->parentid);
		berror("getParent $parentobject->objtype:$parentobject->id ($parentobject->name) has been constructed as the parent of $this->objtype:$this->id.",2);
		return $parentobject;
		}
		
	function getContents($classname, $flavor="%") {
		// finds the number of objects of type $classname in this site
		global $session;
		$query= "SELECT count(obj.id) FROM $classname AS obj WHERE obj.parentobjtype='$this->objtype' AND obj.parentid='$this->id' AND obj.flavor LIKE '$flavor' $session->sqlSafe ";
		if ($result= mysql_query($query)) {
			$array= mysql_fetch_row($result);
			$total= $array[0];
			}
		else $total= 0;
		return $total;
		}

	function bparseCBML($string) {
		berror("bparseCBML called with string=$string",1);
		$this->context->parseTemp= $string;
		$this->parseCBML("parseTemp");
		return $this->context->parseTemp;
		}

	function parseCBML($field){
		// finds and translates commands written in curly-bracket markup language {cbml} within contexts
		// see cbml-engine.php
		// note that field is $this->context->field, not $this->field -- why? not quite sure yet.
		berror("parseCBML called with '$field' by $this->objtype:$this->id ($this->name).",1);
		global $session, $site, $folder, $containers, $object, $sitemember;

		// load code
		$code= $this->context->{$field};

		// assume markup will be found
		$found=1;
		$end=0;
	
		//begin parsing loop
		while ($found) {
			// sanity time
			if ($end>=strlen($code)) {
				berror("-- end ($end) is greater than the string length of code, exiting loop.",3);
				$found=0;
				continue;
				}

			// find command start
			$start= strpos($code, "{", $end);
			if ($start===false) {
				berror("-- No more { found after $end. ",3);
				$found=0;
				continue;
				}
			else berror("-- First { after $end is at $start.",3);
			
			// look for at least one right bracket, otherwise this is madness!
			$endmost= strrpos($code, "}");
			if ($endmost===false) {
				berror("-- no endmost }, unclosed brackets, aborting.",3);
				$found=0;
				continue;
				}
			else berror("-- The last }  is at $endmost.",3);
	
			// check for command
			$commandend= strpos($code, ":", $start);
			if ($commandend===false) {
				$end= $start+1;
				berror("-- No command found after $start. end=$end now. strlen(code)=".strlen($code),3);
				continue;
				}
			else berror("-- A : was found at $commandend.",3);
	
			// if the alleged "command" ends after the last right bracket, it isn't one.
			if ($commandend>$endmost) {
				berror("-- But that : at $commandend is further out than the endmost } at $endmost, aborting.",3);
				$found=0;
				continue;
				}
	
			// find a likely endpoint for this tag
			$anend= strpos($code, "}", $start);
			berror("-- Next } after $start found at $anend.",3);

			// is there lunacy here? something like "[bold=boldme] blah blah [ital:italic]"???
			if ($commandend>$anend) {
				berror("-- Lunacy here, command end (:) at $commandend is greater than } found at $anend, so trying another loop.",3);
				$end= $start+1;
				continue;
				}

			// okay, now we can find the one living and true end
			$end= strpos($code, "}", $start);
			if ($end===false) {
				$found=0;
				continue;
				}
			berror("-- The } found $end is declared to be the true end of this statement.",3);

			// check for command again
			$commandend= strpos($code, ":", $start);
			if ($commandend===false) continue;
			berror("-- The : found at $commandend is declared to be the true end of this command.",3);

			// and again, if the : is outside the end bracket, forget it.
			if ($commandend>$end) {
				berror("-- The : at $commandend is outside of the } at $end, so forget it.",3);
				continue;
				}
			
			// get command
			$commandlen= $commandend-$start-1;
			$command= substr($code, $start+1, $commandlen);
			if (trim($command)=="") {
				berror("parseCBML No command found!",3);
				continue;
				}
			if (strpos($command," ")) {
				berror("parseCBML Command-like structure found, but not a command (has spaces) ",3);
				continue;
				}
	
			// define tag
			$taglen= $end-$commandend-1;
			$tag= substr($code, $commandend+1, $taglen);

		//parse the tag for variables.
		$this->applyPolicy();
		$commandv= "\$tag= \"$tag\";";
		berror("parseCBML parsing $tag for variables: $commandv. ",2);
		eval($commandv);
	
			// with $command and $tag in hand, run the bmlengine
			$tag= str_replace("&#039;","'",$tag);
			include("$GLOBALS[beryliumroot]/code/cbml-engine.php");
	
			// make the substitution
			$code= substr($code, 0, $start).$tag.substr($code, $end+1);
			berror("parseCBML Substitution made, continuing...",2);
			
			// adjust the endpoint-- $start + strlen($tag)
			$taglength= strlen($tag);
			berror("-- Cleaning up, the end is really at $start+$taglength, or ".($start+$taglength).", but we'll go ahead and start looking at ".($start+1)."...",3);
			//$end= $start+$taglength;
			$end= $start+1;
			} //end while

		$this->context->{$field}= $code;
		}

// context processing and rendering

	function process($mode="") {
		// evals $this->context->process
		global $session, $site, $member, $sitemember, $folder, $containers, $object, $parent;
		if ($this->originalid!="" && $this->originalid!="0") $this->getOriginal();
		berror("process() called on $this->objtype:$this->id ($this->name)",1);
		if ($this->context->process!="") {
			if ($session->errorLevel>=2) {
				$this->context->processhtml= htmlentities($this->context->process);
				berror("process() processing <blockquote><tt>".$this->context->processhtml."</tt></blockquote>",2);
				}
			eval($this->context->process);
			}
		return 1;
		}

	function render($mode="") {
		// renders object via context container/template to $templateRender
		// if mode="container" doesn't render template / null
		// if mode="child" only renders template / null
		// note: $session and $member are not passed to render's scope for security reasons 
		//     -- if you need to get member or session fields into a template, you must pass them explicitly through $sitemember
		global $site, $sitemember, $folder, $object, $parent, $templateRender;

		berror("render() called by $this->objtype:$this->id ($this->name) with mode=$mode",1);

		// render template or null (or neither!)
		if ($this->context->template!="" && $mode!="container" && $this->id!="" && $this->showNull!=1) {
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("template");
			$template= bescapeTemplate($this->context->template);
			$command= "\$templateRender= \"$template\";";
			eval($command);
			}
		elseif ($this->context->null!="" && $mode!="container") {
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("null");
			$null= bescapeTemplate($this->context->null);
			$command= "\$nullRender= \"$null\";";
			eval($command);
			}

		// render container (or not)
		if ($this->context->container!="" && $mode!="child" && ( strpos($this->context->container,'$nullRender') || ( $this->showNull!=1 && $this->id!="") ) ) {
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("container");
			$container= bescapeTemplate($this->context->container);
			$command= "\$templateRender= \"$container\";";
			eval($command);
			}
		else {
			$templateRender= $templateRender.$nullRender;
			}

		//boutput($output,$session);
		return $templateRender;
		}
		
	function listprocess(&$list) {
		// evals $this->context->process
		global $session, $site, $member, $sitemember, $folder, $containers, $object;
		berror("listprocess() called on $this->objtype:$this->id ($this->name)",1);
		if ($this->context->listprocess!="") {
			if ($session->errorLevel>=2) {
				$this->context->processhtml= htmlentities($this->context->listprocess);
				berror("listprocess() processing <blockquote><tt>".$this->context->processhtml."</tt></blockquote>",2);
				}
			eval($this->context->listprocess);
			}
		return 1;
		}

	function listRender($mode="", $listtemplateRender="") {
		// renders object via context container/template to $listRender
		// if mode="container" doesn't render template / null
		// if mode="item" only renders template / null
		// see note on render() about not passing $session and $member into local scope
		global $site, $sitemember, $folder, $object;

		berror("listRender() called by $this->objtype:$this->id ($this->name) with mode=$mode",1);

		// render listtemplate or listnull (or neither!)
		if ($this->context->listtemplate!="" && $mode=="item" && $this->id!="" && $this->showNull!=1) {
			berror("listRender: rendering listtemplate.",2);
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("listtemplate");
			$listtemplate= bescapeTemplate($this->context->listtemplate);
			$command= "\$listtemplateRender= \"$listtemplate\";";
			eval($command);
			}
		elseif ($this->context->listnull!="" && $mode=="item") {
			berror("listRender: rendering listnull.",2);
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("listnull");
			$listnull= bescapeTemplate($this->context->listnull);
			$command= "\$listnullRender= \"$listnull\";";
			eval($command);
			}
			
		// render listgroup (or not)
		if ($this->context->listgroup!="" && $mode=="group") {
			berror("listRender: rendering listgroup.",2);
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("listgroup");
			$listgroup= bescapeTemplate($this->context->listgroup);
			$command= "\$listtemplateRender= \"$listgroup\";";
			eval($command);
			}

		// render container (or not)
		if ($this->context->listcontainer!="" && $mode=="container" && ( strpos($this->context->listcontainer,'$listnullRender') || ( $this->showNull!=1 && $this->id!="") ) ) {
			berror("listRender: rendering listcontainer.",2);
			if ($GLOBALS['session']->request->format!="css") $this->parseCBML("listcontainer");
			$listcontainer= bescapeTemplate($this->context->listcontainer);
			$command= "\$listRender= \"$listcontainer\";";
			eval($command);
			}
		else {
			$listRender= $listtemplateRender.$listnullRender;
			}

		if ($GLOBALS['session']->errorLevel>=2) {
			$htmlListRender= htmlentities($listRender);
			berror("listrender: returning <blockquote><tt>$htmlListRender</tt></blockquote>",2);
			}
		return $listRender;
		}


// object-fu: makeAlias, copy, move

	function move($newfolder, $newparent="") {
		global $site;
		berror("move(): called by $this->objtype $this->name (#$this->id), moving into $newfolder->name.",1);

		// do not allow a folder to be moved into one of its subfolders
		if ($this->objtype=="folder" && !(strpos($newfolder->name, $this->name)===FALSE)) {
			if (strpos($newfolder->name, $this->name)==0) {
				berror("Sorry, you may not move a folder into one of its subfolders.",0);
				}
			}

		// must be called with at least object $newfolder
		if (!is_object($newfolder) || $newfolder->id=="") {
			berror("move(): called with missing or unloaded newfolder object.",1);
			return 0;
			}
		if (is_object($newparent) && $newparent->id=="") {
			berror("move(): called with newparent ($newparent->objtype $newparent->name) but it has no id.",1);
			return 0;
			}
		elseif (is_object($newparent)) {
			$withparent= 1;
			}
			
		// change folderid (and parentid and parentobjtype)
		$this->oldfolderid= $this->folderid;
		$this->folderid= $newfolder->id;
		if ($withparent) {
			$this->parentid= $newparent->id;
			$this->parentobjtype= $newparent->objtype;
			}
		berror("move(): updating the folderid ($this->oldfolderid becomes $this->folderid) ",2);
		if ($withparent) berror("move():  and parentid (to $this->parentobjtype:$this->parentid)",2);
		
		// if this is a folder, change the name
		if ($this->objtype=="folder") {
			$this->nameChanged= $this->name;
			$basename= basename($this->name);
			$this->name= $newfolder->name."/".$basename;
			$nclen= strlen($this->nameChanged);
			if ($nclen<1) berror("Something is very wrong, could not determine new name for folder.",0);
			if ($this->updateObject()) {
				$selectquery= "SELECT id,name FROM folder WHERE siteid='$site->id' AND name LIKE '$this->nameChanged/%' ";
				if ($result= mysql_query($selectquery)) {
					while ($update= mysql_fetch_assoc($result)) {
						$newname= $this->name.substr($update['name'],$nclen);
						$repairquery= "UPDATE folder SET name='$newname' WHERE id='$update[id]' ";
						if (!$repairresult= mysql_query($repairquery)) {
							berror("Subfolder name update failed on $repairquery. ".mysql_error(),1);
							}
						else berror("Subfolder name update succeeded: $update[name] is now $newname.",1);
						}
					berror("Subfolder name update done.",1);
					}
				else berror("Subfolder name update didn't find any subfolders with $selectquery.",1);
				}

			// also, if this is a folder and there is ftp, move the static folder to the new location
			if ($ftpconn= ftpconnect()) {
				$oldpath= $site->p_ftproot.$this->nameChanged;
				$newpath= $site->p_ftproot.$this->name;
				berror("move: attempting to move $oldpath to $newpath via FTP now.",1);
				@ftp_rename($ftpconn, $oldpath, $newpath);
				}
			
			return 1;
			}
		
		// should it be save called?
		elseif ($this->updateObject()) {
			return 1;
			}
		else {
			berror("move(): tried to move but could not update the db.",1);
			return 0;
			}
		}
		
	function getOriginal() {
		// merges original object with current
		if ($this->originalid!="" && $this->originalid!="0") {
			berror("getOriginal will now load the original object at $this->objtype:$this->originalid.",1);
			global $session;
			
			// instantiate object
			$command= "\$original= new ".ucfirst($this->objtype).";";
			$void= eval($command);

			//load original
			if (!$original->selectObjectById($this->originalid)) {
				berror("getOriginal original object is not available!",1);
				return 0;
				}
				
			// set up alias vars on this object
			$this->aliasid= $this->id;

			// break it out into bits
			foreach(get_object_vars($original) as $key=>$value) {
					if ($key=="id" || $key=="originalid") continue;
					if ($key=="properties") $key= "inherited";
					berror("getOriginal() found $key.",3);
					if ($this->{$key}!="") {
						berror("getOriginal() but child object aleady has $key=".$this->{$key}.".",3);
						continue;
						}
					$this->{$key}= $value;
					}
			$this->originalObject= $original;
			return 1;
			}
		else {
			berror("getOriginal called on $this->objtype:$this->id but no originalid.",2);
			return 0;
			}
		}


// context-related methods

	function getContext($method="", $format="") {
		// use the following to turn db lookup of contexts on(1)/off(0)
		berror("getContext called on $this->objtype:$this->id ($this->name) flavor=$this->flavor.",1);
		$dbcontexts=0;
		$success= 0;
		global $session, $sitemember, $containers, $folder, $site, $beryliumroot;
		$this->context= new Context2;

		// set up values/arrays to search against
		if ($method=="") $method= $session->request->method;
		if ($format=="") $format= $session->request->format;
		$classnamearray= array($this->objtype, "generic");
		switch($sitemember->role) {
			case "admin": $rolearray= array("admin","editor","writer","member","anonymous"); break;
			case "editor": $rolearray= array("editor","writer","member","anonymous"); break;
			case "writer": $rolearray= array("writer","member","anonymous"); break;
			case "member": $rolearray= array("member","anonymous"); break;
			default: $rolearray= array($sitemember->role);
			}
		
		// setup patharray in which to search
		if ($session->p_standardContext==1 && $site->p_localcontextsonly!=1) {
			$patharray= array("$beryliumroot/code/contexts/$folder->flavor/$this->flavor",
							"$beryliumroot/code/contexts/$folder->flavor",
							"$beryliumroot/code/contexts");
			}
		elseif ($site->p_localcontextsonly==1) {
			$patharray= array("$beryliumroot/code/contexts/$folder->flavor/$this->flavor",
							"$beryliumroot/code/contexts/$folder->flavor",
							"$beryliumroot/code/contexts");
			}
		else {
			$patharray= array("$beryliumroot/files/$site->name/contexts/$folder->flavor/$this->flavor",
							"$beryliumroot/files/$site->name/contexts/$folder->flavor",
							"$beryliumroot/files/$site->name/contexts",
							"$beryliumroot/code/contexts/$folder->flavor/$this->flavor",
							"$beryliumroot/code/contexts/$folder->flavor",
							"$beryliumroot/code/contexts");
			}

		// drill down through path array, matching most-to-least specific by role, then by classname. first context found is the winner!
		foreach ( $patharray AS $path ) {
			if (!is_dir($path)) {
				berror("getContext no directory: $path",2);
				continue;
				}
			if ($success) continue;
			foreach ( $classnamearray AS $classname ) {
				if ($success) continue;
				foreach ( $rolearray AS $role ) {
					if ($success) continue;
					$filename= "$classname-$method-$role-$format.be2";
					berror("getContext looking for $path/$filename.",2);
					if ( file_exists("$path/$filename") ) {
						$this->context->upload("$path/$filename");
						$this->context->parseFilename("$filename");
						$this->context->parseXml();
						$success= 1;
						berror("getContext found <em>".$this->context->classname."-".$this->context->method."-".$this->context->role."-".$this->context->format."</em>.",1);
						}
					}
				}
			}
		return $success;
		}

// utilities methods

	function getPropertiesList() {
		// generates an html properties list for the object
		berror("getPropertiesList called by $this->objtype:$this->id ($this->name).",1);

		$array= get_object_vars($this);
		$list= "<hr /><b>$this->objtype:$this->id values:</b><blockquote>";
		while (list($key, $val)= each($array)) {
			if (is_int($key)) continue;
			$list= $list."$key => $val<br />";
			if (is_object($val) and $key!="context") $list= $list.$val->getPropertiesList();
			}
		$list= $list."---End of $this->objtype:$this->id ---</blockquote>";
		return $list;
		}
		
	function getBaseURL($recache=0) {
		if ($this->baseUrl=="" || $recache) {
			// creates two webpaths, five URLs, and the attachment path for the current object
			global $session, $site;
			
		// PREP

			// get parent folder of object if not a folder or site
			if ($this->objtype!="folder" && $this->objtype!="site") {
				$alias= 0;
				if (is_numeric($this->originalid) && $this->originalid > 0) {
					berror("getBaseURL detected <b>alias</b>, will supply all urls and paths based on original $this->objtype at $this->originalid",1);
					$parent= new Folder;
					$parent->selectObjectById($this->originalObject->folderid);
					$alias= 1;
					}
				else {
					$parent= new Folder;
					$parent->selectObjectById($this->folderid);
					}
				if ($parent->name=="") $parent->name= "/";
				berror("getBaseUrl: parentfolder is folder:".$this->folderid." (".$parent->name.")",1);
				
				// url encode object name
				if ($alias) $this->urlname= urlencode($this->originalObject->name);
				else $this->urlname= urlencode($this->name);
				}
			
			// use classname?
			if ($this->objtype!="document" && $this->objtype!="folder") $classname= $this->objtype."-";
			
			// add slash?
			if ($parent->name!="" && $parent->name!="/") $parent->name= $parent->name."/";
			
			// scriptname?
			if ($session->request->scriptname!="") $scriptname= $session->request->scriptname;
			else $scriptname= $GLOBALS['be_scriptname'];
			
			// noscriptname?
			if ($site->p_alwaysusescriptname==1) $noscriptname= $GLOBALS['be_scriptname'];
			else $noscriptname= "";
			
			// native format?
			if ($this->format!="") $nativeformat= $this->format;
			else $nativeformat= ".html";
			
			// connection + sitename
			$beUrlBase= $session->request->connection."://".$site->name;

		// BUILD

			if ($this->objtype=="site") {
				// site is an exception
				$this->staticPath= $noscriptname."/";
				$this->bePath= $scriptname."/";
				$this->staticUrl= "http://$this->name/";
				$this->htmlUrl= "http://$this->name/index.html";
				$this->idUrl= "http://".$this->name.$scriptname."/site-".$this->id.".html";
				$this->beUrl= $beUrlBase.$session->request->scriptname."/";
				$this->baseUrl= $beUrlBase.$session->request->scriptname."/index.".$session->request->format;
				}
			elseif ($this->objtype=="folder") {
				// folder is also an exception
				if ($this->name!="/") $addslash= "/";
				$this->staticPath= $noscriptname.$this->name;
				$this->bePath= $scriptname.$this->name;
				$this->staticUrl= "http://".$site->name.$noscriptname.$this->name.$addslash."index.html";
				$this->htmlUrl= $this->staticUrl;
				$this->idUrl= "http://".$site->name.$scriptname."/folder-".$this->id.".html";
				$this->beUrl= $beUrlBase.$session->request->scriptname.$this->name.$addslash."index.html";
				$this->baseUrl= $beUrlBase.$session->request->scriptname.$this->name.$addslash."index.".$session->request->format;
				}
			else {
				// staticPath == /folder/name/[class-]objectname
				$this->staticPath= $noscriptname.$parent->name.$classname.$this->urlname;

				// bePath == /be2/folder/name/[class-]objectname
				$this->bePath= $scriptname.$parent->name.$classname.$this->urlname;

				// staticUrl == http://sitename/folder/name/[class-]objectname.nativeformat
				$this->staticUrl= "http://".$site->name.$this->staticPath.$nativeformat;

				// htmlUrl == http://sitename/folder/name/[class-]objectname.html
				$this->htmlUrl= "http://".$site->name.$this->staticPath.".html";

				// idUrl == http://sitename/class-objectid.html
				$this->idUrl= "http://".$site->name.$scriptname."/".$this->objtype."-".$this->id.".html";

				// beUrl == [$scriptname]/folder/name/[class-]objectname.nativeformat
				$this->beUrl= $beUrlBase.$session->request->scriptname.$parent->name.$classname.$this->urlname.$nativeformat;

				// baseUrl == [$scriptname]/folder/name/[class-]objectname.requestformat
				$this->baseUrl= $beUrlBase.$session->request->scriptname.$parent->name.$classname.$this->urlname.".".$session->request->format;
				}

			// path == beryliumroot/files/sitename/yyyy/mm/class-objectid
			if ($this->createdStamp=="") $datepart= date("Y/m", mysql_timestamp($this->created));
			else $datepart= date("Y/m", $this->createdStamp);
			$this->path= $GLOBALS['beryliumroot']."/files/$site->name/$datepart/$this->objtype-$this->id";

			berror("getBaseUrl: finished construction, baseUrl is $this->baseUrl.",1);
			}
		else berror("getBaseURL already called on $this->objtype:$this->id, <em>SKIPPING</em>.",2);
		return 1;
		}

	function sort_obj($a, $b) {
		global $session;
		$field= $session->currentSort;
		$direction= $session->currentDirection;
		if ($field=="") $field= "rank";
		if ($direction!=1 && $direction!=-1 ) $direction= -1;
		$al = $a->{$field};
		$bl = $b->{$field};
		if ($al == $bl) {
			$defsort= $session->currentSortDefault;
			$defdirection= $session->currentDirectionDefault;
			if ($defsort=="") $defsort= "created";
			if ( $defdirection!=1 && $defdirection!=-1 ) $defdirection= 1;
			$al = $a->{$defsort};
			$bl = $b->{$defsort};
			return ($defdirection * strnatcasecmp ($al,$bl));
			}
		return ($direction * strnatcasecmp ($al,$bl));
		}

	function arrayToObject($array) {
		berror("arrayToObject building $this->objtype:$array[id]",2);
		foreach($array as $key=>$value) {
			if (is_int($key)) continue;
			if ($key=="properties" AND trim($value)!="") {
				berror("arrayToObject: found properties ($value), unpacking...",3);
				// unpack properties into propertiesarray
				$this->propertiesarray= bunpack($value);

				// unpack properties array into p_keys
				if (is_array($this->propertiesarray)) {
					foreach ($this->propertiesarray AS $pkey=>$pvalue) {
						if (trim($pkey)=="") {
							berror("empty pkey.",3);
							continue;
							}
						$p_pkey= "p_$pkey";
						$this->{$p_pkey}= $pvalue;
						berror("-- this->$p_pkey=".$this->{$p_pkey},3);
						}
					}
				continue;
				}
			$this->{$key}= $value;
			berror("arrayToObject: this->$key= $value.",4);
			}
		return 1;
		}

	function attachedFile() {
		if (is_readable($this->path)) {
			if (md5_file($this->path)==$this->p_attachment) {
				return 1;
				}
			else {
				berror("Attached file at $this->path has been corrupted.",1);
				}
			}
		return 0;
		}
		
	function subscribed($block="") {
		global $session, $sitemember;
		$subscription= new Subscription;
		$query= "SELECT obj.* FROM subscription AS obj WHERE obj.sitememberid='$sitemember->id' AND obj.parentobjtype='$this->objtype' AND obj.parentid='$this->id' AND obj.status!='deleted' $session->sqlSafe ";
		$subscription->selectObject($query);
		if ($subscription->id!="") {
			$subscription->getBaseUrl();
			$this->subscriptionUrl= $subscription->baseUrl;
			$this->subscriptionStatus= $subscription->status;
			if ($subscription->p_blocklist!="" && $block!="") {
				$blocklist= explode(",", $subscription->p_blocklist);
				foreach ($blocklist AS $bobj) {
					if ($bobj==$block) $this->subscriptionStatus= "blocked";
					}
				}
			return $subscription->id;
			}
		return 0;
		}

	// END CLASS BeryliumObject
	}

// EOF

