<?php
// Berylium Markup Language engine
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// passed a command and (optionally) a tag. Builds a processed tag according to the command.
// please keep commands alphabetical.

//berror("BML Engine executing '$command' with tag=$tag",1);


switch ($command) {
	case "bold":
		$tag= "<b>$tag</b>";
		break;

	case "code":
		$tag= "<pre>";
		break;
		
	case "/code":
		$tag= "</pre>";
		break;

	case "bracket":
		$tag= "&obrack;$tag&cbrack;";
		break;

	case "color":
		// look for a semicolon delimiting font color from link text
		$semicolon= strpos($tag, ";");

		if ($semicolon!==false) {
			$color= substr($tag,0,$semicolon);
			$tag= substr($tag, $semicolon+1);
			
			$tag= "<font color='$color'>$tag</font>";
			}
		break;
		
	case "cell":
		// look for a semicolon
		$semicolon= strpos($tag, ";");

		if ($semicolon!==false) {
			$insert= substr($tag,0,$semicolon);
			$tag= substr($tag, $semicolon+1);
			if ($GLOBALS['cellturn']=="" || $GLOBALS['cellturn']=="odd") {
				berror("BML->cell <b>cellturn=$GLOBALS[cellturn]</b> so insert is on right.",1);
				$GLOBALS['cellturn']= "even";
				$tag= "<table class=celltable><tr class=cellodd><td class=cell>$tag</td><td class=cellinsert>$insert</td></tr></table>";
				}
			else {
				berror("BML->cell <b>cellturn=$GLOBALS[cellturn]</b> so insert is on left.",1);
				$GLOBALS['cellturn']= "odd";
				$tag= "<table class=celltable><tr class=celleven><td class=cellinsert>$insert</td><td class=cell>$tag</td></tr></table>";
				}
			}
		break;

	case "date":
		$tag= date("M n, Y, \a\\t g:ia");
		break;
		
	case "italic":
		$tag= "<i>$tag</i>";
		break;

	case "quote":
		$tag= "<blockquote>$tag</blockquote>";
		break;

	case "copy":
		$tag= "&copy;$tag";
		break;
                
        case "acirc":
		$tag= "&acirc;$tag";
		break;

	case "link":
		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting url from link text
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$tag= "<a href='$tag'>$tag</a>";
			}
		else {
			$url= substr($tag,0,$semicolon);
			$link= substr($tag, $semicolon+1);
			$tag= "<a href='$url'>$link</a>";
			}
		break;

	case "list":
		$tag= "<b>List:</b> $tag";
		break;

	case "para":
		$tag= "<br>\n";
		break;

	case "image":
		// usage: image:imageid|url[;alignment[;width,height]]
		berror("BML->image called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting imageid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$tag= "<img src='$tag'>";
			}
		else {
			$url= substr($tag,0,$semicolon);
			$params= substr($tag, $semicolon+1);
			if ($semicolon= strpos($params, ";")) {
				$widthheight= substr($params,0,$semicolon);
				$alignment= substr($params, $semicolon+1);
				}
			else {
				if ($params!="left" AND $params!="right") {
					$widthheight= "$params";
					$alignment= "";
					}
				else {
					$widthheight= "";
					$alignment= "$params";
					}
				}

			$turn= $GLOBALS['turn'];
			if ($turn=="odd" AND $alignment=="") {
				$alignment= "right";
				$GLOBALS['turn']= "even";
				berror("BML->image no alignment, odd turn, <b>setting turn=$GLOBALS[turn]</b> and alignment=$alignment.",1);
				}
			elseif ($turn=="even" AND $alignment=="") {
				$alignment= "left";
				$GLOBALS['turn']= "odd";
				berror("BML->image no alignment, even turn, <b>setting turn=$GLOBALS[turn]</b> and alignment=$alignment.",1);
				}
			elseif ($alignment=="") {
				$alignment= "right";
				$GLOBALS['turn']= "even";
				berror("BML->image no alignment, no turn, <b>setting turn=$GLOBALS[turn]</b> and alignment=$alignment.",1);
				}

			$image= new Image;
			if (is_numeric($url)) {
				$query= "SELECT obj.*, folder.name AS foldername FROM image AS obj, folder WHERE obj.id='$url' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
				$image->selectObject($query);
				$command= "\$image->proportion($widthheight);";
				berror("BML->image proportion command=$command",1);
				eval($command);

				$image->beryliumToHtml();
				$tag="<a href='$session->scriptname$image->foldername/image-$image->name.html?method=view$session->cgi'><img src='$session->scriptname$image->foldername/image-$image->name$image->format' width='$image->width' height='$image->height' alt='image: $image->title' title='$image->title' align='$alignment' border='0' ></a>";
				}
			elseif (substr($url,0,7)=="http://" && 0) {
				$image->path= $url;
				//$imagesize= getimagesize($url);
				$image->width= $imagesize[0];
				$image->height= $imagesize[1];
				$command= "\$image->proportion($widthheight);";
				berror("BML->image proportion command=$command",1);
				eval($command);
								
				$tag="<a href='$image->path'><img src='$image->path' width='$image->width' height='$image->height' alt='external image' title='$image->path' align='$alignment' border='0' ></a>";
				}
			}
		break;
		
	case "document":
		// usage: document:documentid[;text for link]
		berror("BML->document called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting documentid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$documentid= $tag;
			$label= "";
			}
		else {
			$documentid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$document= new Document;
		if (is_numeric($documentid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM document AS obj, folder WHERE obj.id='$documentid' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$document->selectObject($query);
			$document->beryliumToHtml();
			$document->getBaseUrl();
			if ($label=="") $label= $document->title;
			$tag="<a href='$document->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$documentid'>$documentid</a>";
			}
		break;
		
	case "folder":
		// usage: folder:folderid[;text for link]
		berror("BML->folder called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting folderid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$folderid= $tag;
			$label= "";
			}
		else {
			$folderid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$folder= new Folder;
		if (is_numeric($folderid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM folder AS obj, folder WHERE obj.id='$folderid' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$folder->selectObject($query);
			$folder->beryliumToHtml();
			$folder->getBaseUrl();
			if ($label=="") $label= $folder->title;
			$tag="<a href='$folder->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$folderid'>$folderid</a>";
			}
		break;

	}


?>