<?php
// Code-friendly Berylium Markup Language engine
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// passed a command and (optionally) a tag. Builds a processed tag according to the command.
berror("[color:#ff6600;CBML Engine executing '$command' with tag=$tag]",1);


switch ($command) {

	case "list":
		// usage: {list:"SELECT * FROM objtype WHERE 1 ORDER BY field LIMIT 1,2"[;method]} -- list will add appropriate wherepublic and wherestatus
		$session= $GLOBALS[session];
		$sitemember= $GLOBALS[sitemember];
		
		// look for a semicolon delimiting objtype from query
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$query= $tag;
			$method= "list";
			}
		else {
			$query= substr($tag,0,$semicolon);
			$method= substr($tag, $semicolon+1);
			}
			
		// add wherestatus and wherepublic at the end of the WHERE clause...
		if ($sitemember->role!="admin") {
			if ($orderby= stristr($query, "order by")) {
				// place before ORDER BY
				$orderbypos = strlen($query)-strlen($orderby);
				berror("CBML list found ORDER BY clause at end of WHERE ($orderbypos).",1);
				$query= substr($query,0,$orderbypos).$session->statuswhere.$session->publicwhere.substr($query,$orderbypos);
				}
			elseif ($limit= stristr($query, "limit")) {
				// no ORDER BY, so place before LIMIT
				$limitpos = strlen($query)-strlen($limit);
				berror("CBML list found LIMIT clause at end of WHERE ($limitpos).",1);
				$query= substr($query,0,$limitpos).$session->statuswhere.$session->publicwhere.substr($query,$limitpos);
				}
			else {
				// no ORDER BY or LIMIT, assume WHERE clause extends to end of $query
				berror("CBML list found no ORDER BY or LIMIT clause at end of WHERE.",1);
				$query .= $session->statuswhere.$session->publicwhere;
				}
			}
		
		eval("\$query=\"$query\";");
		berror("[color:#ff6600;CBML list will use query=$query; to [bold:list] objects using $method.]",1);

		$output= blist($query,$method);

		$tag= $output;
		break;


	case "index":
		// usage: {index:objtype[;method]}

		//$GLOBALS[session]->applyPolicy();
		$session= $GLOBALS[session];
		$site= $GLOBALS[site];

		// look for a semicolon delimiting objtype from query
		$semicolon= strpos($tag, ";");
		if ($semicolon===false) {
			$objtype= $tag;
			$method= "list";
			}
		else {
			$objtype= substr($tag,0,$semicolon);
			$methodish= substr($tag, $semicolon+1);
			}
			
		// look for a semicolon delimiting method from limit
		$semicolon2= strpos($methodish, ";");
		if ($semicolon2===false) {
			$method= $methodish;
			$queryLimit= "";
			}
		else {
			$method= substr($methodish,0,$semicolon2);
			$limit= substr($methodish, $semicolon2+1);
			$queryLimit= "LIMIT $limit ";
			}
		

		// index query looks for all posted item.rank>100 in the current folder, as well as any posted item.rank>500 in subfolders, subject to $session->wherepublic,
		//   and orders them by rank and created-date
		$query= "SELECT obj.* FROM $objtype AS obj, folder WHERE obj.siteid='$site->id' AND ((folder.id=obj.folderid AND obj.folderid=$folder->id AND obj.rank>='100') OR (folder.id=obj.folderid AND folder.name LIKE '$folder->name%' AND obj.rank>='500')) AND obj.status='posted' $session->publicwhere ORDER BY obj.rank DESC, obj.created ASC $queryLimit ";
		berror("[color:#ff6600;CBML list will use query=$query; to list $objtype"."s using $method.]",1);

		$output= blist($query,$method);

		$tag= $output;
		break;


	case "image":
		$output= bparsebml("[image:$tag]");
		$tag= $output;
		break;

	// switch ends here
	}



?>