<?php
// Berylium Objects http-engine
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// $beryliumroot is set in the berylium/http/berylium script
include("$beryliumroot/code/berylium-functions.php");
include("$beryliumroot/code/berylium-classes.php");

// init timer
$timerStart= bgetmicrotime();

// start a new Session
// the session loads from the db (or creates and saves new...), creates a session->request, a session->member (authenticated if not anonymous), and starts a new error channel
$session= new Session;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Session construction complete at $timenow. Loading member next.<hr>",1);


// get the site
$site= new Site;
$site->loadSite();
$session->siteid= $site->id;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Site construction complete at $timenow. Loading sitemember next.<hr>",1);


// get the sitemember
//$member->id= 1;
$sitemember= new Sitemember;
$sitemember->getsitemember();
	//allow sitemembers to drop rank dynamically
	switch ($sitemember->role) {
		case "admin":
			if ($HTTP_GET_VARS['role']) {
				$sitemember->role= $HTTP_GET_VARS['role'];
				$sitemember->truerole= "admin";
				}
			break;
		case "editor":
			if ($HTTP_GET_VARS['role']=="writer" || $HTTP_GET_VARS['role']=="member" || $HTTP_GET_VARS['role']=="anonymous") {
				$sitemember->role= $HTTP_GET_VARS['role'];
				$sitemember->truerole= "editor";
				}
			break;
		case "writer":
			if ($HTTP_GET_VARS['role']=="member" || $HTTP_GET_VARS['role']=="anonymous") {
				$sitemember->role= $HTTP_GET_VARS['role'];
				$sitemember->truerole= "editor";
				}
			break;
		}
	if ($sitemember->truerole=="") {
		$sitemember->truerole= $sitemember->role;
		berror("Sitemember did not drop role.",1);
		}
	else {
		berror("Sitemember dropped role from $sitemember->truerole to $sitemember->role.",1);
		}
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>sitemember construction complete at $timenow. Loading member next.<hr>",1);

// load member
$member= new Member;
$query= "SELECT * FROM member WHERE id='$session->memberid' AND status!='delete' ";
$member->selectObject($query);
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>member construction complete ($member->email) at $timenow. Loading session policy next.<hr>",1);

// get session->policy here
$session->applyPolicy();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Session policy discovery complete at $timenow. Loading folder next.<hr>",1);

// get the folder with context
$folder= new Folder;
$folder->loadFolder();
$session->folderid= $folder->id;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Folder construction complete at $timenow. Loading containers next.<hr>",1);

// get the containers
$containers= $session->getContainers($folder);
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Containers construction complete at $timenow. Finding site and folder contexts next.<hr>",1);



//get site and folder contexts
$site->getContext("view",$session->request->format);
$folder->getContext("view",$session->request->format);
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Site and folder contexts found at $timenow. Loading object next.<hr>",1);

// preprocess was here, along with css and folder header, now moved below object lookup...

// deal with the primary object
// instantiate the proper class
$command= "\$object= new ".ucfirst($session->request->objtype).";";
eval($command);

// set-up the name
$object->name= $session->request->objectname;
$object->folderid= $folder->id;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr> Loading primary '$object->objtype' object #$object->id ($object->name) here, from folderid #$object->folderid. Time is $timenow.<hr>",1);


// render object view or perform object save
if ($session->request->method=="save" OR $session->request->method=="savenew") {
	$object->save();
	}
else $object->view();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Object rendering finished at $timenow. Rendering headers and footers next.<hr>",1);

// preprocess site and folder
$site->preProcess();
$folder->preProcess();

// render site css, folder css, and folder headers
$site->css($session);
$folder->css($session);
$folder->header($session);

// render folder and site footers
$folder->footer($session);
$site->footer($session);

// render site header (last so it includes all css and $object properties...)
$site->header($session);

// postprocess folder and site
$folder->postProcess();
$site->postProcess();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>All objects rendered at $timenow. Outputting.<hr>",1);

// print session->output
ksort($session->output);
foreach($session->output as $key=>$value) {
	berror("Outputting chunk $key now.",1);
	print $value;
	}
flush();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Output done at $timenow. Cleaning up.<hr>",1);

// log session
$session->updateObject();

// print session->error then exit
if ($debug) {
	print "<table bgcolor='#ffffff'><tr><td>";
	print "<hr><b>\$session->error</b> for berylium server at $SCRIPT_FILENAME";
	print "<blockquote>";
	print nl2br(bparsebml($session->error));
	
	if ($vars) {

		// session
		print "<hr>";
		$sessionarray= get_object_vars($session);
		print "<blockquote><b>session:</b>";
		foreach ($sessionarray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";

		// session->request
		print "<hr>";
		$request= $session->request;
		$sessionrequestarray= get_object_vars($request);
		print "<blockquote><b>session->request:</b>";
		foreach ($sessionrequestarray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
		
		print "<hr>";
		$preferences= $session->preferences;
		$sessionpreferencesarray= get_object_vars($preferences);
		print "<blockquote><b>session->preferences:</b>";
		foreach ($sessionpreferencesarray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
				
		print "<hr>";
		$sitearray= get_object_vars($site);
		print "<blockquote><b>site:</b>";
		foreach ($sitearray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
		
		print "<hr>";
		$memberarray= get_object_vars($member);
		print "<blockquote><b>member:</b>";
		foreach ($memberarray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
		
		print "<hr>";
		$folderarray= get_object_vars($folder);
		print "<blockquote><b>folder:</b>";
		foreach ($folderarray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
		
		print "<hr>";
		$sitememberarray= get_object_vars($sitemember);
		print "<blockquote><b>sitemember:</b>";
		foreach ($sitememberarray as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
		
		print "<hr>";
		print "<blockquote><b>containers[0]:</b>";
		foreach ($containers[0] as $key => $val) {
		if ($key=="error" || $key=="output" ) continue;
			print "<br>$key=>$val";
			}
		print "</blockquote>";
		
		print "<hr>";
		$objectarray= get_object_vars($object);
		print "<blockquote><b>Object:</b>";
		foreach ($objectarray as $key => $val) {
			//if ($key=="error" || $key=="output" ) continue;
			$val= htmlentities($val);
			print "<br>$key=>$val";
			}		
		print "</blockquote>";

		print "<hr>";
		$contextarray= get_object_vars($object->context);
		print "<blockquote><b>context:</b>";
		foreach ($contextarray as $key => $val) {
			//if ($key=="error" || $key=="output" ) continue;
			$val= htmlentities($val);
			print "<br>$key=>$val";
			}		
		print "</blockquote>";		
		}

	print "</blockquote>";
	print "<hr>Session complete at ".date("Y-M-d H:i:s").".<br><a href='$session->refreshURL'>Refresh</a> ($session->refreshURL) | <a href='#top'>Top</a>";
	print "</tr></td></table>";
	}

if ($info) {
	print "<hr><br>";
	phpinfo();
	}

// timer function
$timerEnd= bgetmicrotime();
$timer= $timerEnd - $timerStart;
if ($session->request->format=="html" && $HTTP_USER_AGENT!="berylium-wget") print "<br>That took $timer seconds.";
elseif ($session->request->format=="html") print "<br>Cached ".date("Y-M-d H:i:s").".";
?>