<?php
// 2002-06-25 17:44 by Chris Snyder
// find and list images in path (a folder) as thumbnails
// drop in replacement for fancyindexing -> save into an image directory as index.php

$thumbwidth=80;
$thumbheight=60;

function myfilesize($file) {
	// First check if the file exists.
	if(!is_file($file)) exit("File does not exist!");
	
	// Setup some common file size measurements.
	$kb = 1024;         // Kilobyte
	$mb = 1024 * $kb;   // Megabyte
	$gb = 1024 * $mb;   // Gigabyte
	$tb = 1024 * $gb;   // Terabyte
	
	// Get the file size in bytes.
	$size = filesize($file);
	
	if($size < $kb) return $size." B";
	else if($size < $mb) return round($size/$kb,2)." KB";
	else if($size < $gb) return round($size/$mb,2)." MB";
	else if($size < $tb) return round($size/$gb,2)." GB";
	else return round($size/$tb,2)." TB";
	}

if (substr($REQUEST_URI,-1)=="/") {
	$length= strlen($REQUEST_URI)-1;
	$uripath= substr($REQUEST_URI,0,$length);
	}
else {
	$uripath= dirname($REQUEST_URI);
	}
$filepath= $DOCUMENT_ROOT.$uripath;

$lastslash= strrpos($uripath,"/");
$parenturi= substr($uripath,0,$lastslash+1);
if ($parenturi=="") $parenturi= "/";

// show source code?
if ($showsource) $sourceinfo= "| Script: $SCRIPT_FILENAME ( <a href='#source'>source code</a> )";
else $sourceinfo= "| <a href='$SCRIPT_NAME?showsource=1#source'>show source code</a>";

print "<html>
<head>
<title>$uripath</title>
<style type='text/css'>
	body { font-family: Verdana, Geneva, sans-serif; font-size: 12px; background-color: #ffffee;}
	table { font-family: Verdana, Geneva, sans-serif; font-size: 12px; }
	.heading { font-size: 12px; font-weight: bold; background-color: #666677; color: #dddddd; border: 1px; border-style: solid; }
	.oddrow { background-color: #ffffff; }
	.evenrow { background-color: #eeffee; }
</style>
</head>
<body>
<h1>Image index of $uripath</h1>
<p><a href='$parenturi'><img src='/icons/back.gif' border=0 hspace=5 align=absmiddle>Up to parent folder</a> $sourceinfo</p>";

if ($handle = opendir($filepath)) {
	print "
<table cellpadding=5>
	<tr class=heading>
		<td align=center>Image</td>
		<td>Name</td>
		<td>Modified</td>
		<td align=center>Filesize</td>
		<td align=center>IPTC Info</td>
	</tr>";
				
	while ($file = readdir($handle)) {
		if (substr($file,0,1)==".") continue;
		if ($file=="index.php") continue;
		$timestamp= filemtime("$filepath/$file");
		$modified= date("r", $timestamp);
		if ($evenrow) {
			$evenrow=0;
			$rowclass= "evenrow";
			}
		else {
			$evenrow=1;
			$rowclass= "oddrow";
			}
		if (@is_dir("$filepath/$file")) {
			print"
	<tr class='$rowclass'>
		<td align=right><img src='/icons/folder.gif' alt=folder title=folder></td>
		<td><a href='$uripath/$file/'>$file/</a></td>
		<td>$modified</td>
		<td align=center>-</td>
		<td align=center>-</td>
	</tr>";
			}
		else {  
			unset($info);
			unset($extrainfo);
			unset($sizetag);
			$filesize= myfilesize("$filepath/$file");
			if ($imagesize=@getimagesize("$filepath/$file",$info)) {
				$width= $imagesize[0];
				$height= $imagesize[1];
				if ($width>$thumbwidth) {
					$ratio= $thumbwidth / $width;
					$width=$thumbwidth;
					$height= $height*$ratio;
					}
				if ($height>$thumbheight) {
					$ratio= $thumbheight / $height;
					$height=$thumbheight;
					$width= $width*$ratio;
					}
				$icontag= "<img src='$uripath/$file' width=$width height=$height alt=image title=image>";
				$sizetag= "<br>$imagesize[0]x$imagesize[1] pixels";
				
				if (isset ($info['APP13'])) {
					$iptc = iptcparse ($info['APP13']);
					if (is_array($iptc)) {
						foreach ($iptc AS $key=>$val) {
							if ($key=="2#000") continue;
							$extrainfo.="$val[0]<br>";
							}
						}
					}				
				}
			else $icontag= "<img src='/icons/text.gif' alt=file title=file>";
			print"
	<tr class='$rowclass'>
		<td valign=top align=right>$icontag</td>
		<td valign=top><a href='$uripath/$file'>$file</a>$sizetag</td>
		<td valign=top>$modified</td>
		<td valign=top align=right>$filesize</td>
		<td valign=top>$extrainfo</td>
	</tr>";
			}
		}   
	print "
	<tr class=heading>
		<td align=center>Image</td>
		<td>Name</td>
		<td>Modified</td>
		<td align=center>Filesize</td>
		<td align=center>IPTC Info</td>
	</tr>
</table>
<p><a href='$parenturi'><img src='/icons/back.gif' border=0 hspace=5 align=absmiddle>Up to parent folder</a></p>
<p>For more information about IPTC Info, see <a href='http://www.iptc.org/'>http://www.iptc.org/</a></p>";
	}								     
closedir($handle);
if ($showsource) {
	print "<hr><a name='source'> </a><h1>PHP Source:</h1>";
	$void= show_source($SCRIPT_FILENAME);
	}
print "
<p>$SERVER_SIGNATURE</p>
</body>
</html>";
?>