<?php
// Berylium Markup Language engine
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// passed a command and (optionally) a tag. Builds a processed tag according to the command.
// please keep commands alphabetical.

berror("BML Engine executing '$command' with tag=$tag",1);
$site= $GLOBALS['site'];

switch ($command) {
	case "bold":
		$tag= "<b>$tag</b>";
		break;

	case "code":
		$tag= "<pre>";
		break;

	case "/code":
		$tag= "</pre>";
		break;
		
	case "tt":
		$tag= "<tt>";
		break;

	case "/tt":
		$tag= "</tt>";
		break;
		
	case "space":
		$tag= str_replace(" ", "&nbsp;", $tag);
		break;

	case "bracket":
		$tag= "&obrack;$tag&cbrack;";
		break;
		
	case "bullet":
		if (trim($tag)) $tag= "<ul><li>$tag</li></ul>";
		else $tag= "<li>";
		break;

	case "color":
		// look for a semicolon delimiting font color from link text
		$semicolon= strpos($tag, ";");

		if ($semicolon!==false) {
			$color= substr($tag,0,$semicolon);
			$tag= substr($tag, $semicolon+1);
			
			$tag= "<font color='$color'>$tag</font>";
			}
		break;
		
	case "cell":
		// look for a semicolon
		$semicolon= strpos($tag, ";");

		if ($semicolon!==false) {
			$insert= substr($tag,0,$semicolon);
			$tag= substr($tag, $semicolon+1);
			if ($GLOBALS['cellturn']=="" || $GLOBALS['cellturn']=="odd") {
				berror("BML->cell <b>cellturn=$GLOBALS[cellturn]</b> so insert is on right.",1);
				$GLOBALS['cellturn']= "even";
				$tag= "<table class=celltable><tr class=cellodd><td class=cell>$tag</td><td class=cellinsert>$insert</td></tr></table>";
				}
			else {
				berror("BML->cell <b>cellturn=$GLOBALS[cellturn]</b> so insert is on left.",1);
				$GLOBALS['cellturn']= "odd";
				$tag= "<table class=celltable><tr class=celleven><td class=cellinsert>$insert</td><td class=cell>$tag</td></tr></table>";
				}
			}
		break;

	case "date":
		$tag= date("M n, Y, \a\\t g:ia");
		break;
		
	case "italic":
		$tag= "<i>$tag</i>";
		break;

	case "quote":
		$tag= "<blockquote>$tag</blockquote>";
		break;

	case "copy":
		$tag= "&copy;$tag";
		break;
                
        case "acirc":
		$tag= "&acirc;$tag";
		break;

	case "link":
		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting url from link text
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$tag= "<a href='$tag'>$tag</a>";
			}
		else {
			$url= substr($tag,0,$semicolon);
			$link= substr($tag, $semicolon+1);
			$tag= "<a href='$url'>$link</a>";
			}
		break;

	case "list":
		$tag= "<b>List:</b> $tag";
		break;

	case "para":
		$tag= "<br>\n";
		break;

	case "image":
		/* usage:
                image:[id|url][;alignment][;widthxheight]
                [image:4] -- same as [image:4;center;160x120]
                [image:4;label] -- link to image as label
                [image:4;icon] -- link to image as inline icon (24x18 proportional)
                [image:4;left] -- image full size to left of text
                [image:4;right] -- image full size to right of text
                [image:4;center] -- image full size, centered on its own line
                [image:4;center;320x240] -- image scaled propotionally to fit 320x240, centered on its own line
                [image:http://foo.com/bar.jpg;left] -- external image full size to left of text
                [image:http://foo.com/bar.jpg;left;320x240] -- external image at 320x240 to left of text (not proportionally scaled!)
                */
		berror("BML->image called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);
                
                // split tag by ;
                $arguments= explode(";",$tag);
                $idurl= $arguments[0];
                if ($arguments[1]) {
                        if (preg_match("/\d{1,4}[x,]\d{1,4}/i",$arguments[1])) {
                                $sizex= $arguments[1];
                                }
                        else $label= $arguments[1];
                        }
                if ($arguments[2]) {
                        if (preg_match("/\d{1,4}[x,]\d{1,4}/i",$arguments[2])) {
                                if (!$sizex) $sizex= $arguments[2];
                                }
                        elseif (!$label) $label= $arguments[2];
                        }
                berror("BML->image arguments: idurl($idurl) label($label) sizex($sizex).",1);
                
                // first switch-- is $idurl an id or a url?
                if (is_numeric($idurl)) {
                        // display internal image
                        if (!$label) {
                                berror("BML->image no label found, centering.",1);
                                $label= "center";
                                if (!$sizex) {
                                        berror("BML->image no size found, either, sizing to 160x120.",1);
                                        $sizex="160x120";
                                        }
                                }
                        
                        berror("BML->image looking for image:$idurl.",1);
                        $image= new Image;
			$query= "SELECT obj.*, folder.name AS foldername FROM image AS obj, folder WHERE obj.id='$idurl' AND obj.siteid='$site->id' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$image->selectObject($query);
			$image->title= bHtml($image->title);
			$image->getBaseUrl();
                        
                        if ($sizex) {
                                if (strstr($sizex, "x")) {
                                        $sizeArray= explode("x",$sizex);
                                        $width= $sizeArray[0];
                                        $height= $sizeArray[1];
                                        }
                                else {
                                        $sizeArray= explode(",",$sizex);
                                        $width= $sizeArray[0];
                                        $height= $sizeArray[1];
                                        }
                                berror("BML->image parsed $sizex to find width=$width and height=$height.",1);
                                $image->proportion($width,$height);
                                }
                                
			$siteUrl= $GLOBALS['session']->request->connection."://$site->name";
                        switch ($label) {
                                case "left":
                                        $tag="<a href='$image->baseUrl'><img src='$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title' align='left' border='0' ></a>";
                                        break;
                                        
                                case "right":
                                        $tag="<a href='$image->baseUrl'><img src='$siteUrl$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title' align='right' border='0' ></a>";
                                        break;
                                
                                case "center":
                                        $tag="<div align='center'><a href='$image->baseUrl'><img src='$image->uri' width='$image->width' height='$image->height' alt='$image->title' title='$image->title' border='0' ></a></div>";
                                        break;
                                        
                                case "icon":
                                        $icon= bparsebml("[icon:$image->id;image:$image->id;24,18]$image->title");
                                        $tag="<a href='$image->baseUrl'>$icon</a>";
                                        break;
                                
                                default:
                                        $tag="<a href='$image->baseUrl'>$label</a>";
                                        break;
                                }
                        }
                elseif ($idurl) {
                        // display external image
                        if (!$label) $label= "";
                        if ($sizex) {
                                if (strstr($sizex, "x")) {
                                        $sizeArray= explode("x",$sizex);
                                        $width= $sizeArray[0];
                                        $height= $sizeArray[1];
                                        }
                                else {
                                        $sizeArray= explode(",",$sizex);
                                        $width= $sizeArray[0];
                                        $height= $sizeArray[1];
                                        }
                                berror("BML->image parsed $sizex to find width=$width and height=$height.",1);
                                $sizeTag= "width='$width' height='$height'";
                                }
                        switch ($label) {
                                case "left":
                                        $tag="<img src='$idurl' $sizeTag alt='external image' title='$idurl' align='left' border='0'>";
                                        break;
                                        
                                case "right":
                                        $tag="<img src='$idurl' $sizeTag alt='external image' title='$idurl' align='right' border='0'>";
                                        break;
                                
                                case "center":
                                        $tag="<div align='center'><img src='$idurl' $sizeTag alt='external image' title='$idurl' border='0'></div>";
                                        break;
                                        
                                case "icon":
                                        $icon= bparsebml("[icon:$image->id;image:$image->id;24,18]$image->title");
                                        $tag="<a href='$image->baseUrl'>$icon</a>";
                                        break;
                                
                                default:
                                        $tag="<div><img src='$idurl' $sizeTag alt='$label' title='$label' border='0'></div>";
                                        break;
                                }
                        }


/* old code
		// look for a semicolon delimiting imageid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false && is_numeric($tag)) {
			// this is a tag like [image:56]...
			$image= new Image;
			$query= "SELECT obj.*, folder.name AS foldername FROM image AS obj, folder WHERE obj.id='$tag' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$image->selectObject($query);
			$image->title= bHtml($image->title);
			$image->getBaseUrl();
                        $label= bparsebml("[icon:$image->id;image:$image->id;24,18]$image->title");
			//$label= $image->title;
			$tag="<a href='$image->baseUrl?method=view$session->cgi'>$label</a>";
			}
		elseif ($semicolon===false) {
			$tag= "<img src='$tag'>";
			}
		else {
			$url= substr($tag,0,$semicolon);
			$params= substr($tag, $semicolon+1);
			if ($semicolon= strpos($params, ";")) {
				$widthheight= substr($params,0,$semicolon);
				$alignment= substr($params, $semicolon+1);
				}
			else {
				if ($params!="left" AND $params!="right") {
					$widthheight= "$params";
					$alignment= "";
					}
				else {
					$widthheight= "";
					$alignment= "$params";
					}
				}

			$turn= $GLOBALS['turn'];
			if ($turn=="odd" AND $alignment=="") {
				$alignment= "right";
				$GLOBALS['turn']= "even";
				berror("BML->image no alignment, odd turn, <b>setting turn=$GLOBALS[turn]</b> and alignment=$alignment.",1);
				}
			elseif ($turn=="even" AND $alignment=="") {
				$alignment= "left";
				$GLOBALS['turn']= "odd";
				berror("BML->image no alignment, even turn, <b>setting turn=$GLOBALS[turn]</b> and alignment=$alignment.",1);
				}
			elseif ($alignment=="") {
				$alignment= "right";
				$GLOBALS['turn']= "even";
				berror("BML->image no alignment, no turn, <b>setting turn=$GLOBALS[turn]</b> and alignment=$alignment.",1);
				}

			$image= new Image;
			if (is_numeric($url)) {
				$query= "SELECT obj.*, folder.name AS foldername FROM image AS obj, folder WHERE obj.id='$url' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
				$image->selectObject($query);
				$command= "\$image->proportion($widthheight);";
				berror("BML->image proportion command=$command",1);
				eval($command);

				$image->title= bHtml($image->title);
				$tag="<a href='$session->scriptname$image->foldername/image-$image->name.html?method=view$session->cgi'><img src='$session->scriptname$image->foldername/image-$image->name$image->format' width='$image->width' height='$image->height' alt='image: $image->title' title='$image->title' align='$alignment' border='0' ></a>";
				}
			elseif (substr($url,0,7)=="http://" && 0) {
				$image->path= $url;
				//$imagesize= getimagesize($url);
				$image->width= $imagesize[0];
				$image->height= $imagesize[1];
				$command= "\$image->proportion($widthheight);";
				berror("BML->image proportion command=$command",1);
				eval($command);
								
				$tag="<a href='$image->path'><img src='$image->path' width='$image->width' height='$image->height' alt='external image' title='$image->path' align='$alignment' border='0' ></a>";
				}
			}
end of old code */


		break;
		
		
	case "icon":
		// 2002-07-18 09:32
		// usage: [icon:imageid[;alt/titletag[;x,y-proportion]]]
		berror("BML->icon called as $tag",1);

		// split the arguments
		$arguments= explode(";", $tag);
		$imageid= $arguments[0];
		$title= $arguments[1];
		$proportion= $arguments[2];
		if ($proportion) {
			$size= explode(",", $proportion);
			$x= $size[0];
			$y=$size[1];
			}
		else {
			$x=48;
			$y=48;
			}

		if (is_numeric($imageid)) {
			$image= new Image;
			$query= "SELECT obj.* FROM image AS obj WHERE obj.id='$imageid'  AND obj.siteid='".$GLOBALS[site]->id."' $session->wherestatus $session->wherepublic ";
			$image->selectObject($query);
			$image->getBaseUrl();
			$image->proportion($x,$y);
			if ($title=="") $title= bHtml($image->title);
			$tag="<span class='bicon'><img src='$image->uri' width='$image->width' height='$image->height' alt='$title' title='$title' border='0' align='absmiddle'></span>";
			}
		else {
			// fail gracefully... but how?
			}
		break;


	case "document":
		// usage: document:documentid[;text for link]
		berror("BML->document called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting documentid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$documentid= $tag;
			$label= "";
			}
		else {
			$documentid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$document= new Document;
		if (is_numeric($documentid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM document AS obj, folder WHERE obj.id='$documentid' AND obj.siteid='".$GLOBALS[site]->id."' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$document->selectObject($query);
			$document->title= bHtml($document->title);
			$document->getBaseUrl();
			if ($label=="") $label= $document->title;
			$tag="<a href='$document->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$documentid'>$label</a>";
			}
		break;
		
	case "comment":
		// usage: comment:commentid[;text for link]
		berror("BML->comment called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting commentid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$commentid= $tag;
			$label= "";
			}
		else {
			$commentid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$comment= new comment;
		if (is_numeric($commentid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM comment AS obj, folder WHERE obj.id='$commentid' AND obj.siteid='".$GLOBALS[site]->id."' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$comment->selectObject($query);
			$comment->title= bHtml($comment->title);
			$comment->getBaseUrl();
			if ($label=="") $label= $comment->title;
			$tag="<a href='$comment->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$commentid'>$label</a>";
			}
		break;

	case "folder":
		// usage: folder:folderid[;text for link | icon]
		berror("BML->folder called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting folderid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$folderid= $tag;
			$label= "";
			}
		else {
			$folderid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$folder= new Folder;
		if (is_numeric($folderid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM folder AS obj, folder WHERE obj.id='$folderid' AND obj.siteid='".$GLOBALS[site]->id."' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$folder->selectObject($query);
			$folder->getBaseUrl();
			if ($label=="") $label= bHtml($folder->title);
			elseif ($label=="icon") {
				if ($folder->imageid!=0) {
					$label= bparsebml("[icon:$folder->imageid;folder:$folder->id;24,18]$folder->title");
					}
				else {
					if ($folder->public==0) $this->iconpvt= "-pvt";
					$label="<img src='/bicons/folder$this->iconpvt.png' alt='folder:$folder->id' title='folder:$folder->id' border=0 align=absmiddle> $folder->title";
					}
				}
			$tag="<a href='$folder->baseUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$folderid'>$folderid</a>";
			}
		break;
		
	case "sitemember":
		// usage: sitemember:sitememberid[;text for link]
		berror("BML->sitemember called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting sitememberid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$sitememberid= $tag;
			$label= "";
			}
		else {
			$sitememberid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$sitemember= new Sitemember;
		if (is_numeric($sitememberid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM sitemember AS obj, folder WHERE obj.id='$sitememberid' AND obj.siteid='".$GLOBALS[site]->id."' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$sitemember->selectObject($query);
			if ($sitemember->name) {
				$sitemember->getBaseUrl();
				if ($label=="") {
					$label= bHtml($sitemember->name);
					$label= preg_replace("/\s/","&nbsp;",$label);
					}
                                if ($label=="icon") {
                                        $name= bHtml($sitemember->name);
                                        $label= bparsebml("[icon:$sitemember->imageid;$name;24,18]");
                                        }
				$tag="<a href='$sitemember->idUrl?method=view$session->cgi'>$iconTag$label</a>";
				}
			else $tag="";			
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$sitememberid'>$sitememberid</a>";
			}
		break;


	case "context":
		// usage: context:contextid[;text for link]
		berror("BML->context called as $tag",1);

		// fix how htmlentities might break urls with CGI in them...
		$tag= str_replace("&amp;", "&", $tag);

		// look for a semicolon delimiting contextid/url from other params
		$semicolon= strpos($tag, ";");

		if ($semicolon===false) {
			$contextid= $tag;
			$label= "";
			}
		else {
			$contextid= substr($tag,0,$semicolon);
			$label= htmlentities(substr($tag, $semicolon+1));
			}

		$context= new Context;
		if (is_numeric($contextid)) {
			$query= "SELECT obj.*, folder.name AS foldername FROM context AS obj, folder WHERE obj.id='$contextid' AND obj.siteid='".$GLOBALS[site]->id."' $session->wherestatus $session->wherepublic AND folder.id=obj.folderid ";
			$context->selectObject($query);
			$context->getBaseUrl();
			if ($label=="") $label= bHtml($context->name);
			$tag="<a href='$context->idUrl?method=view$session->cgi'>$label</a>";
			}
		else {
			// urls aren't implemented
			$tag= "<a href='$contextid'>$contextid</a>";
			}
		break;
	}


?>
