<?php
//Berylium Objects and Supporting Classes
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

//
// ------------------------------------------------------------------- Base Classes ----
//

include("$beryliumroot/code/beryliumObject.php");


class BeryliumClass extends BeryliumObject {
	// master class for defining attributes and methods of user-created ContentObjects
	// stores class definitions in the database that extend the ContentObject Class

	 // these are declared in BeryliumObject
	 // var $id;
	 // var $flavor;
	 // var $created;
	 // var $updated;
	 // var $sitemember;
	 // var $siteid;
	 // var $folderid;
	 // var $status;
	 // var $properties;

	var $columns; 	// a list of SQL column definitions to expand the basic ContentObject
			// only applies for ubiquitous BeryliumClasses (siteid=folderid=0)

	var $attributes;// additional attributes that can be present (stored in ^-delimited lists)

	/* NOTE: while this class extends BeryliumObject so that individual BeryliumClasses can be
		stored in the database, it does not extend ContentObject. Even so, the following
		ContentObject attributes will be created by any object implementing a
		BeryliumClass, so these names are all reserved.
		var $name;
		var $originalid;
		var $parentobjtype;
		var $parentid;
		var $public;
		var $locked;
		var $rank;
		var $objtype;
		var $path;
		var $context;
		END RESERVED NAMES... */

	var $methods;	// php function definitions to expand the basic ContentObject

	function makeTable() {
		// initializes a table to hold this type of object
		berror("makeTable() called by ".get_class($this)." id $this->id.",1);

		//unpack the ^ delimited columns, then use that array to build the column_definition 
		$columns= bunpack($this->columns);
		while (list ($key, $val)= each($columns)) {
			$column_definition= $column_definition.", $key $val";
			}
		$column_definition= substr($column_definition,2);

		$query="CREATE TABLE IF NOT EXISTS ".$this->name. " (".$this->getMySQLColumns($flavor).",".$column_definition.") ";
		berror("makeTable() using query=$query",0);
                $result= mysql_query($query);

		if (!$result) {
			berror("Error in makeTable on query= $query; ( $MYSQL_ERROR )",1);
			$success=0;
			}
		else $success=1;

		return $success;
		}

	// Contexts are children BeryliumClass objects	
	}



class Context extends BeryliumObject {
	// class used to process an object and merge it with display templates
	// Contexts are children of classes and are used to build object interfaces

	var $classid;    // id of parent Berylium Class or 0 for primal classes
	var $classname;  // Classname of parent class

	// following are used to describe the context
	var $method;	// default is view
	var $format;	// default is html
	var $role;	// default is ''
	var $name;	// classname-method[-role]

	// appropriate context group is populated on construction
	var $preprocess;	// php code to evaluate before rendering object (/ contexts only!)
	var $header;		// for container objects (site and folder): html to render around contained objects
				// for listing methods: html to start list (eg table declaration and first row)
	var $css;		// object-specific css declarations
	var $template;		// cbml-coded object template
	var $listrow;		// cbml-coded row for listing methods; $template's and/or $nullobject's are inserted in this
	var $footer;		// html to close header
	var $nullobject;	// template to use when no object found in database, or for empty cells in a list
	var $postprocess;	// php code to evaluate after rendering object (/ contexts only!)

	// constructor
	function Context() {
		$this->objtype= "context";

		$this->columns= "name=VARCHAR(255)^classid=INT UNSIGNED^INDEX index_classid=(classid)^classname=VARCHAR(255)^method=VARCHAR(255)^INDEX index_method=(method(16))^format=VARCHAR(255)^INDEX index_format=(format)^role=VARCHAR(255)^INDEX index_role=(role(16))^preprocess=TEXT^header=TEXT^css=TEXT^template=TEXT^listrow=TEXT^footer=TEXT^nullobject=TEXT^postprocess=TEXT";
		}

	function parseName() {
		// parses request->objectname into context values:

		// like: classname-method-[role]
		$session= $GLOBALS['session'];
		if ($session->request->objtype=="context") {
			$this->name= $session->request->objectname;
			if (is_int($this->name)) {
				$this->id= $this->name;
				$this->name="";
				berror("context->parseName() generated an [bold:id-based] context object with id=$this->id.",1);
				}
			else {
				$namearray= explode("-", $this->name);
				$this->classname= $namearray[0];
				$this->method= $namearray[1];
				$this->role= $namearray[2];
                                $this->format= $namearray[3];
				berror("context->parseName() generated a $this->classname object $this->method context with role=$this->role.",1);
				}
			}
		}

	function selectContext($query="") {
		// loadObject refreshed $this with data from the database. Requires $this->objtype and either $this->id or ($this->name and $this->folderid)
		berror("context->selectContext() called by $this->objtype id#$this->id ($this->name, in folder #$this->folderid). query=$query;",1);
		if ($query!="") {
			BeryliumObject::selectObject($query);
			return 1;
			}

		// connect to database if not already
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();

		// pick a query scheme
		if ($this->id!="" AND $this->objtype!="") {
			$query= "SELECT * FROM $this->objtype WHERE id=$this->id $this->queryExtras";
			}
                /* Phase out        
		elseif ($this->name!="" AND $this->folderid!="" AND $this->classname!="" AND $this->method!="") {
			$query= "SELECT * FROM $this->objtype WHERE folderid='$this->folderid' AND classname='$this->classname' AND method='$this->method' AND role='$this->role' AND format='$this->format' $this->queryExtras";
			}  */
                elseif ($this->name!="" AND $this->folderid!="") {
			$query= "SELECT * FROM $this->objtype WHERE folderid='$this->folderid' AND name='$this->name' $this->queryExtras";
			}
                        
		else {
			berror("context->selectObject(): called by $this->objtype without enough details. Needs at least name and folderid ($this->folderid)",1);
			}

		BeryliumObject::selectObject($query);

		return 1;
		}

	function insertObject() {
		// this is, like, a hardcoded preprocess

		// loads in data from form
		foreach($_POST as $key=>$value) {
			$this->{$key}= $value;
			berror("Set this->$key= $value.",2);
			}

		if ($this->sitememberid=="") $this->sitememberid= $GLOBALS['sitemember']->id;
		if ($this->site=="") $this->siteid= $GLOBALS['site']->id;
		if ($this->status=="") $this->status= "posted";
                
                // generate this->name from classname-method-role
                if ($this->role=="") $this->role= anonymous;
                $this->name= "$this->classname-$this->method-$this->role-$this->format";
                berror("updateContext(): Changing context name to $this->name. Format is $this->format",1);
                
                // load a file if provided
                $postvars= $_POST;
                $filevars= $_FILES[contextfile];
                $tempfile= $filevars[tmp_name];
                if ($tempfile!="none" AND $tempfile!="") {
                    // a file has been uploaded
                    $destination= $GLOBALS[beryliumroot]."/files/$site->name/tempcontext";
                
                    // save a temp version
                    berror("context->upload: saving $tempfile at $destination.",1);
                    $success= @move_uploaded_file("$tempfile", "$destination");
                    if (!$success) {
                            $blah= move_uploaded_file($tempfile, $destination);
                            berror("context->upload(): Couldn't move uploaded context from $tempfile to $destination. ($success)",0);
                            return 0;
                            }
                    $this->uploadContext("$destination");
                    }
                    
		// calls appropriate base method on context
		if ($this->id=="") parent::insertObject();
		else parent::updateObject();
		}

	function updateObject() {
		// this is, like, a hardcoded preprocess

		// loads in data from form
		foreach($_POST as $key=>$value) {
			$this->{$key}= $value;
			berror("Set this->$key= $value.",2);
			}

		if ($this->sitememberid=="") $this->sitememberid= $GLOBALS['sitemember']->id;
		if ($this->site=="") $this->siteid= $GLOBALS['site']->id;
		if ($this->status=="") $this->status= "posted";
                
                // generate this->name from classname-method-role
                if ($this->role=="") $this->role= anonymous;
                $this->name= "$this->classname-$this->method-$this->role-$this->format";
                berror("updateContext(): Changing context name to $this->name. Format is $this->format",1);
                
                // load a file if provided
                $postvars= $_POST;
                $filevars= $_FILES[contextfile];
                $tempfile= $filevars[tmp_name];
                if ($tempfile!="none" AND $tempfile!="") {
                    // a file has been uploaded
                    $destination= $GLOBALS['beryliumroot']."/files/$site->name/tempcontext";
                
                    // save a temp version
                    berror("context->upload: saving $tempfile at $destination.",1);
                    $success= @move_uploaded_file("$tempfile", "$destination");
                    if (!$success) {
                            $blah= move_uploaded_file($tempfile, $destination);
                            berror("context->upload(): Couldn't move uploaded context from ($tempfile) to $destination. Check permissions on the affected direcotries. ($success)",0);
                            return 0;
                            }
                    $this->uploadContext("$destination");
                    }
                    
		// calls appropriate base method on context
		if ($this->id=="") parent::insertObject();
		else parent::updateObject();
		}
                
        function uploadContext($path) {
                if ($path=="") $path=$GLOBALS['beryliumroot']."/files/$site->name/tempcontext";
                $fd= @fopen("$path", "r");
                if (!$fd) {
                        berror("Could not open $destination (fd=$fd).",0);
                        }
                        
                // parse the name line: %%classname-method-role-format%%
                $nameline= fgets($fd,1024);
                while (substr($nameline,0,2)!="%%") {
                    berror("uploadContext(): Disgarding line before nameline: $nameline",1);
                    $nameline= fgets($fd,1024);
                    }
                $nameline= substr(trim($nameline),2,-2);
                $names= explode("-", $nameline);
                $this->classname= $names[0];
                $this->method= $names[1];
                $this->role= $names[2];
                $this->format= $names[3];
                $this->name= "$this->classname-$this->method-$this->role-$this->format";
                berror("uploadContext loading file for $this->name",1);
                    
                // find and load the preprocess, header, etc
                while ($line= fgets($fd,1024) AND trim($line)!="%%preprocess%%") {
                        berror("uploadContext skipping: $line",1);
                        }
                
                $this->preprocess= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%header%%") {
                            $this->preprocess= $this->preprocess.$line;
                            }
                berror("uploadContext() loaded preprocess= $this->preprocess",2);
                
                $this->header= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%css%%") {
                            $this->header= $this->header.$line;
                            }
                berror("uploadContext() loaded header= $this->header",2);
                
                $this->css= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%template%%") {
                        $this->css= $this->css.$line;
                            }
                berror("uploadContext() loaded css= $this->css",2);
                
                $this->template= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%listrow%%") {
                            $this->template= $this->template.$line;
                            }
                berror("uploadContext() loaded template= $this->template",2);
                
                $this->listrow= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%nullobject%%") {
                            $this->listrow= $this->listrow.$line;
                            }
                berror("uploadContext() loaded listrow= $this->listrow",2);
                
                
                $this->nullobject= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%footer%%") {
                            $this->nullobject= $this->nullobject.$line;
                            }
                berror("uploadContext() loaded nullobject= $this->nullobject",2);
                
                
                $this->footer= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%postprocess%%" AND trim($line)!="%% postprocess %%") {
                            $this->footer= $this->footer.$line;
                            }
                berror("uploadContext() loaded footer= $this->footer",2);
                
                
                $this->postprocess= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%end of context%%" AND trim($line)!="%% end of context %%") {
                            $this->postprocess= $this->postprocess.$line;
                            }
                berror("uploadContext() loaded postprocess= $this->postprocess",2);
                
		@fclose($fd); 
                return 1;
                }

	}


class PublishableObject extends BeryliumObject {
	// master class for Publishable Objects

	// following are persistent, stored in database:
	 // these are declared in BeryliumObject
	 // var $id;
	 // var $flavor;
	 // var $created;
	 // var $updated;
	 // var $sitememberid;
	 // var $siteid;
	 // var $folderid;
	 // var $status;
	 // var $properties;
	var $name;
	var $originalid;
	var $parentobjtype;
	var $parentid;
	var $public;
	var $locked;
	var $rank;

	// following are generated on construction
	var $objtype;
	var $path;
	var $context; // Context object
	var $columns;

	// constructor
	function PublishableObject() {
		$this->columns= "name=VARCHAR(255)^originalid=INT UNSIGNED^parentobjtype=VARCHAR(255)^INDEX index_parentobjtype=(parentobjtype(16))^parentid=INT UNSIGNED^public=CHAR(4)^locked=CHAR(4)^rank=INT";
		}
	}

class ContentObject extends PublishableObject {
	// Master class for things that have a fair amount of content associated with them, most documents

	var $title;
	var $headline;
	var $description;
	var $keywords;
	var $body;
	var $imageid;
	var $audioid;
	var $videoid;
	var $author;
	var $copyright;
	var $source;

	// constructor
	function ContentObject () {
		$this->columns= "title=varchar(255)^headline=varchar(255)^description=TEXT^keywords=varchar(255) NOT NULL^INDEX index_keywords=(keywords)^body=TEXT^imageid=INT UNSIGNED^audioid=INT UNSIGNED^videoid=INT UNSIGNED^author=varchar(255)^copyright=varchar(255)^source=varchar(255)";
                }

        }


class Container extends ContentObject {
	// A Container is an object (eg a Folder) that is rendered as containing the object being requested, 
	// or contains one or more of its containers. container->index=0 is the parent 
	// container of the object, and container->index=n is the site root. Folders are self-contained, by the way...

	var $index;
	}



class Child extends ContentObject {
	// A Child is an object that is rendered as being contained by the object (eg each Question is the
	// child of a Poll). Each child is indexed in the order in which it is rendered.

	var $index;
	var $containertype;
	var $containerid;
	var $containername;
	}


// the "enforcer"
class Policy extends BeryliumObject {
	var $prequery;	// phpcode to build the queryextras
	var $addons; 	// phpcode to build the default object

	// var $flavor; // role of policy
        // var $folderid; // matches $sitemember->folderid

	// constructor:
	function Policy() {
		$this->objtype= "policy";
		$this->columns= "name=VARCHAR(255)^prequery=TEXT^addons=TEXT";
		}

        function uploadPolicy($path) {
                if ($path=="") $path=$GLOBALS['beryliumroot']."/files/$site->name/temppolicy";
                $fd= @fopen("$path", "r");
                if (!$fd) {
                        berror("Could not open $destination (fd=$fd).",0);
                        }
                        
                // parse the name line: %%name%%
                $nameline= fgets($fd,1024);
                while (substr($nameline,0,2)!="%%") {
                    berror("uploadPolicy(): Disgarding line before nameline: $nameline",1);
                    $nameline= fgets($fd,1024);
                    }
                $nameline= substr(trim($nameline),2,-2);
                $this->name= $nameline;
                berror("uploadPolicy loading file for ($this->name)",1);
                    
                // find and load the prequery, et al
                        while ($line= fgets($fd,1024) AND trim($line)!="%%prequery%%") {
                        berror("uploadPolicy skipping: $line",1);
                        }
                
                $this->prequery= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%addons%%") {
                            $this->prequery= $this->prequery.$line;
                            }
                berror("uploadPolicy() loaded prequery= $this->prequery",2);
                
                $this->addons= "";
                while ($line= fgets($fd,1024) AND trim($line)!="%%end of policy%%") {
                            $this->addons= $this->addons.$line;
                            }
                berror("uploadPolicy() loaded addons= $this->addons",2);
		@fclose($fd);                

                return 1;
                }

	}  // end Policy








//
// ------------------------------------------------------------------- Operations Classes ----
//

class Session extends BeryliumObject {
	// Class holding info about the client request and the Berylium response
	// Processes request, authentication, and response

	 // these are declared in BeryliumObject
	 // var $id;
	 // var $flavor;
	 // var $created;
	 // var $updated;
	 // var $sitememberid;
	 // var $siteid;
	 // var $folderid;
	 // var $status;
	 // var $properties;

	var $request;	  // Request object
	var $member;	// Member object or 0 (anonymous)
	var $sitemember;  // Sitemember object or 0 (anonymous)
	var $output;	  // Output array
	var $error;	  // Error array

	// constructor:
	function Session() {
		$this->objtype= "session";
		$this->clientip= $_SERVER["REMOTE_ADDR"];
		$this->startDate= date("Y-M-d H:i:s");
		$this->error="Session starting for $this->clientip on $this->startDate at ".$GLOBALS['beryliumroot'];
		$this->setErrorLevel();
		$this->request= new Request;
		$this->refreshURL= $this->getRefreshURL();
		$this->cgi= $this->getCgi();
                $this->getUserAgent();
		$this->sitemember= new Sitemember;

		// set-up new or load existing session...
		$this->cookie= $_COOKIE['word'];
		if ($this->cookie=="") {
			// create a new, anonymous session
			$this->id="";
			$this->sitemember->id= 0;
			$this->sitememberid= 0;
			$this->flavor="anonymous";
			$this->sitemember->role= "anonymous";
			$this->status="post";

			// put it into the session table
			$this->insertObject();
                        $this->error= $this->error." Request parsed for sitename:".$this->request->sitename;

			$this->berror("Inserted session into db, session->id is now $this->id.",1);

			// use the id to make a new cookie
			$this->cookie= $this->getNewCookie();
			}
		else {
			// load session from the database
			$this->id= $this->getSessionId();
			$this->berror("Calling loadObject as a $this->objtype with id=$this->id.",1);
			$this->loadObject();
			$this->sitemember->id= $this->sitememberid;
			if ($this->sitememberid==0) {
				$this->sitemember->role= "anonymous";
				}
			}

                

		//Kludge against connection unmapping:
		if ($_SERVER['HTTPS']=="on") {
			$this->request->connection=="https";
			$this->request->scriptname=="/berylium";
			$this->berror("<b>Globals HTTPS is on</b>",1);
			}
		else $this->berror("<b>Globals HTTPS is off</b>",1);
		$this->berror("Finished Session Construction: a \"$this->flavor\" session for sitemember #$this->sitememberid at: <br> &nbsp; <b>".$this->request->connection."://".$this->request->sitename."<font color='#0033ff'>".$this->request->foldername."</font>/<font color='#ff0000'>".$this->request->objtype."-</font>".$this->request->objectname.".<font color='#006633'>".$this->request->format."</font>?".$this->request->cgistring."</b>",1);
		$this->berror(" &nbsp; method=".$this->request->method." role=".$this->sitemember->role." counter=".$this->request->counter,1);
		$this->columns= "memberid=INT(10)^clientip=VARCHAR(255)";
		}

	function getContainers($zero) {
		// makes $container[0] a copy of $zero (the current folder) then sets $container[1,2,...,n] to parent folders, where n is the root folder.
		$this->berror("getContainers() called on a ".get_class($zero)." with id $zero->id. ($zero->name)",1);
		
		$session= $GLOBALS["session"];

		$primecontainer= new Container;
		$primecontainer->id= $zero->id;
		$primecontainer->name= $zero->name;
		$primecontainer->objtype= $zero->objtype;
		$primecontainer->index= 0;
		$query= "SELECT obj.* FROM $zero->objtype AS obj WHERE obj.id='$zero->id' $session->statuswhere $session->publicwhere";
		$primecontainer->selectObject($query);
		$index=0;
		
		//set up unique name and baseURL
		$primecontainer->getBaseURL();
		$slash= strrpos($primecontainer->name, "/");
		$primecontainer->uniqueName= substr($primecontainer->name, $slash);
		$currentfolder= $primecontainer->name;
		$container[$currentfolder]= $primecontainer;
		$container[$index]= $primecontainer;
		
		// create a working foldername variable
		$this->berror("getContainers(): container[$index] is also named container[$currentfolder], and has id=".$container[$index]->id." (".$container[$currentfolder]->id.").",1);

		// lop the end off of $currentfolder
		$nextslash= strrpos($currentfolder, "/");
		$currentfolder= substr($currentfolder,0,$nextslash);

		// kludge to force the root folder into the 2nd container if the first folder is something like /name
		if ($currentfolder=="" AND $primecontainer->name!="/" )  {
			$currentfolder="/";
			$atroot=1;
			}
		
		// create more containers
		while ($currentfolder!="") {
			$index= $index+1;
			$container[$currentfolder]= new Container;
			$container[$currentfolder]->objtype= $zero->objtype;
			$container[$currentfolder]->index= $index;
			$container[$currentfolder]->name= $currentfolder;
			$query= "SELECT obj.* FROM ".$container[$currentfolder]->objtype." AS obj WHERE obj.name='$currentfolder' AND obj.siteid='".$GLOBALS['site']->id."' $session->statuswhere $session->publicwhere ";
			$container[$currentfolder]->selectObject($query);
			
			//set up unique name and baseURL
			$container[$currentfolder]->getBaseURL();
			$nextslash= strrpos($currentfolder, "/");
			$container[$currentfolder]->uniqueName= substr($currentfolder, $nextslash);
			$container[$index]= $container[$currentfolder];

			$this->berror("getContainers(): container[$index] is also named container[$currentfolder], and has id=".$container[$index]->id." (".$container[$currentfolder]->id.").",1);

			// get name of previous folder
			$currentfolder= substr($currentfolder,0,$nextslash);
	
			// kludge to force the root folder into the nth container
			if ($currentfolder=="" AND !$atroot) {
				$currentfolder= "/";
				$atroot=1;
				}
			}

		// return the entire array of containers
		return $container;
		}

	function setErrorLevel($errorLevel=0) {
		if ($GLOBALS['session']->p_debug AND !$this->errorLevel) $errorLevel=$GLOBALS['session']->p_debug;
		$this->errorLevel= $errorLevel;
		$this->berror("Error level changed to $errorLevel.",1);
		}

	function getRefreshURL() {
		if ($_SERVER['HTTPS']=="on") $scriptname= "/berylium";
		else $scriptname= "/berylium";
		$url= $scriptname."/".$this->request->path."?";
		while (list($key,$val)= each($this->request->cgiarray)) {
			if ($key=="counter") continue;
			$url= $url.$key."=".$val."&";
			}
		$url= $url."counter=".($this->request->counter+1);
		$this->scriptname= $scriptname;
		$this->berror("getRefreshURL(): url=".$url,2);
		return $url;
		}

	function getCgi() {
		// returns cgi values without method and with counter+1
		$cgi= "&";
		foreach($this->request->cgiarray as $key=>$val) {
			if ($key=="counter") continue;
			if ($key=="method") continue;
			if ($key=="key") continue;
                        if ($key=="debug") continue;
                        if ($key=="role") continue;
			$cgi= $cgi.$key."=".$val."&";
			}
		$cgi= $cgi."counter=".($this->request->counter+1);
		$this->berror("getCgi(): cgi=".$cgi,2);
		return $cgi;
		}

	function getListQuery() {
		$getvars= array_merge($_GET,$_POST);
		berror("getListQuery() called by $this->objtype id#$this->id ($this->name)... wherestatus=$this->wherestatus.",1);

                $sitemember= $GLOBALS['sitemember'];
		$session= $GLOBALS['session'];

		// flavor
		if ($getvars[listflavor]) $this->listflavor= $getvars[listflavor];
		else $this->listflavor= "%";
		if ($getvars[listflavorby]) $this->listflavorby= $getvars[listflavorby];
		else $this->listflavorby= 0;
		if ($getvars[listflavordir]) $this->listflavordir= $getvars[listflavordir];
		else $this->listflavordir= "ASC";
		if ($getvars[listflavorsign]) $this->listflavorsign= $getvars[listflavorsign];
		else $this->listflavorsign= "LIKE";

		$this->flavorwhere= " AND obj.flavor $this->listflavorsign '$this->listflavor' ";
		if ($this->listflavorby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.flavor $this->listflavordir ";
			else $this->orderby= $this->orderby.", flavor $this->listflavordir ";
			}
				

		// this folder
		if ($getvars[listthisfolder]) $this->listthisfolder= $getvars[listthisfolder]; 
		else $this->listthisfolder= 0;
		if ($this->listthisfolder) {
			$this->folderidwhere= "AND obj.folderid='$this->listthisfolder' ";
			}

		// status
		if ($getvars[liststatus]) $this->liststatus= $getvars[liststatus];
		else $this->liststatus= "posted";

		if ($getvars[liststatusby]) $this->liststatusby= $getvars[liststatusby];
		else $this->liststatusby= 0;
		if ($getvars[liststatusdir]) $this->liststatusdir= $getvars[liststatusdir];
		else $this->liststatusdir= "ASC";
		if ($getvars[liststatussign]) $this->liststatussign= $getvars[liststatussign];
		else $this->liststatussign= "LIKE";

		$this->statuswhereAlt= " AND obj.status $this->liststatussign '$this->liststatus' ";
		if ($this->liststatusby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.status $this->liststatusdir ";
			else $this->orderby= $this->orderby.", obj.status $this->liststatusdir ";
			}
			
			
		// special case for editors and admins looking for deleted objects
		berror("getListQuery(): Method is ".$session->request->method." here.",2);
		if (($GLOBALS['sitemember']->role=="editor" || $GLOBALS['sitemember']->role=="admin") && ($this->liststatus=="deleted" || $session->request->method=="listall")) {
			$resetstatuswhere= 1;
			$this->oldstatuswhere= $this->statuswhere;
			$this->statuswhere= "";
			}


		// rank
		if ($getvars[listrank]!="") $this->listrank= $getvars[listrank];
		else $this->listrank= "100";
		berror("I got $this->listrank ($_GET[listrank])",2);
		if ($getvars[listrankby]) $this->listrankby= $getvars[listrankby];
		else $this->listrankby= 0;
		if ($getvars[listrankdir]) $this->listrankdir= $getvars[listrankdir];
		else $this->listrankdir= "DESC";
		if ($getvars[listranksign]) $this->listranksign= $getvars[listranksign];
		else $this->listranksign= ">=";

		$this->rankwhere= " AND obj.rank $this->listranksign '$this->listrank' ";
		if ($this->listrankby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.rank $this->listrankdir ";
			else $this->orderby= $this->orderby.", obj.rank $this->listrankdir ";
			}

		// public
		if ($getvars[listpublic]!="") $this->listpublic= $getvars[listpublic];
		else $this->listpublic= "1";
		if ($getvars[listpublicby]) $this->listpublicby= $getvars[listpublicby];
		else $this->listpublicby= 0;
		if ($getvars[listpublicdir]) $this->listpublicdir= $getvars[listpublicdir];
		else $this->listpublicdir= "DESC";
		if ($getvars[listpublicsign]) $this->listpublicsign= $getvars[listpublicsign];
		else $this->listpublicsign= "LIKE";

		$this->publicwhereAlt= " AND obj.public $this->listpublicsign '$this->listpublic' ";
		if ($this->listpublicby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.public $this->listpublicdir ";
			else $this->orderby= $this->orderby.", obj.public $this->listpublicdir ";
			}

		// author
		if ($getvars[listauthor]) $this->listauthor= $getvars[listauthor];
		else $this->listauthor= "%";
		if ($getvars[listauthorby]) $this->listauthorby= $getvars[listauthorby];
		else $this->listauthorby= 0;
		if ($getvars[listauthordir]) $this->listauthordir= $getvars[listauthordir];
		else $this->listauthordir= "ASC";
		if ($getvars[listauthorsign]) $this->listauthorsign= $getvars[listauthorsign];
		else $this->listauthorsign= "LIKE";

		$this->authorwhere= " AND obj.sitememberid $this->listauthorsign '$this->listauthor' ";
		if ($this->listauthorby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.author $this->listauthordir ";
			else $this->orderby= $this->orderby.", obj.author $this->listauthordir ";
			}

		// created
		if ($getvars[listcreated]) $this->listcreated= $getvars[listcreated];
		else $this->listcreated= 0;
		if ($getvars[listcreatedby]) $this->listcreatedby= $getvars[listcreatedby];
		else $this->listcreatedby= 0;
		if ($getvars[listcreateddir]) $this->listcreateddir= $getvars[listcreateddir];
		else $this->listcreateddir= "ASC";
		if ($getvars[listcreatedsign]) $this->listcreatedsign= $getvars[listcreatedsign];
		else $this->listcreatedsign= ">";

		$this->createdwhere= " AND obj.created $this->listcreatedsign '$this->listcreated' ";
		if ($this->listcreatedby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.created $this->listcreateddir ";
			else $this->orderby= $this->orderby.", obj.created $this->listcreateddir ";
			}

		// updated
		if ($getvars[listupdated]) $this->listupdated= $getvars[listupdated];
		else $this->listupdated= 0;
		if ($getvars[listupdatedby]) $this->listupdatedby= $getvars[listupdatedby];
		else $this->listupdatedby= 0;
		if ($getvars[listupdateddir]) $this->listupdateddir= $getvars[listupdateddir];
		else $this->listupdateddir= "ASC";
		if ($getvars[listupdatedsign]) $this->listupdatedsign= $getvars[listupdatedsign];
		else $this->listupdatedsign= ">";



		$this->updatedwhere= " AND obj.updated $this->listupdatedsign '$this->listupdated' ";
		if ($this->listupdatedby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY obj.updated $this->listupdateddir ";
			else $this->orderby= $this->orderby.", obj.updated $this->listupdateddir ";
			}

		// folderwhere
		if ($getvars[listfolderby]) $this->listfolderby= $getvars[listfolderby];
		else $this->listfolderby= 0;
		if ($getvars[listfolderdir]) $this->listfolderdir= $getvars[listfolderdir];
		else $this->listfolderdir= "ASC";

		$this->folderwhere= " AND folder.id= obj.folderid AND folder.name LIKE '".$GLOBALS[folder]->name."%' ";
		if ($this->listfolderby) {
			if ($this->orderby=="") $this->orderby= "ORDER BY folder.name $this->listfolderdir ";
			else $this->orderby= $this->orderby.", folder.name $this->listfolderdir ";
			}
                        
                // if restrict parent folders according to publishing status
                if ($sitemember->role=="anonymous") {
                        $this->folderwhere.= "AND folder.status='posted' AND folder.public='1' ";
                        }
                elseif ($sitemember->role=="member") {
                        $this->folderwhere.= "AND folder.status='posted' ";
                        }
			
		// keyword search
		if (trim($getvars['keyword']!="")) {
			// simple search
			$searchkey= addslashes($getvars['keyword']);
			$this->keyword= $getvars['keyword'];
			$this->keywordwhere= " AND ( obj.title LIKE '%$searchkey%' OR obj.headline LIKE '%$searchkey%' OR obj.keywords LIKE '%$searchkey%' ) ";
			}
		else $this->keywordwhere= "";

		// finally, apply policy so that list is protected in terms of public and posted. (this is probably redundant...)
		//$this->applyPolicy();

		// build the query
		$this->listquery= "SELECT obj.* FROM ".$GLOBALS['object']->objtype." AS obj, folder WHERE obj.siteid='".$GLOBALS['site']->id."' $this->keywordwhere $this->flavorwhere $this->folderidwhere $this->statuswhereAlt $this->rankwhere $this->publicwhereAlt $this->authorwhere $this->createdwhere $this->updatedwhere $this->folderwhere $this->statuswhere $this->publicwhere $this->orderby ";
		$this->totalquery= "SELECT COUNT(obj.id) FROM ".$GLOBALS['object']->objtype." AS obj, folder WHERE obj.siteid='".$GLOBALS['site']->id."' $this->keywordwhere $this->flavorwhere $this->folderidwhere $this->statuswhereAlt $this->rankwhere $this->publicwhereAlt $this->authorwhere $this->createdwhere $this->updatedwhere $this->folderwhere $this->statuswhere $this->publicwhere ";

		// get total number of objects eligible for this list:
		$result= @mysql_query("$this->totalquery");
		if ($result) {
			$totalarray= mysql_fetch_row($result);
			$this->listtotal= $totalarray[0];
			}
		else {
			$this->listtotal= 0;
			}
			
		// limit and offset
		if ($getvars[listlimit]) $this->listlimit= $getvars[listlimit];
		else $this->listlimit= 10;
		if ($getvars[listoffset]) $this->listoffset= $getvars[listoffset]; 
		else $this->listoffset= 0;
		
		// what about the jump fields?
		if ($getvars[listoffset1]) $this->listoffset= $getvars[listoffset1] - 1;
		if ($getvars[listoffset2]) $this->listoffset= $getvars[listoffset2] - 1; 
		
		// start and end items
		$this->liststart= $this->listoffset + 1;
		$this->listend= $this->listoffset + $this->listlimit;
		
		// have any navigation buttons been pressed?
		if ($getvars['listprev']) {
			$this->listoffset= $this->listoffset - $this->listlimit;
			if ($this->listoffset < 0 ) $this->listoffset= 0;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery(): detected prev button (value=$getvars[listprev]). New listoffset will be $this->listoffset.",1);
			}
			
		if ($getvars['listfirst']) {
			$this->listoffset= 0;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery(): detected first button (value=$getvars[listprev]). New listoffset will be 0.",1);
			}

		if ($getvars['listnext']) {
			$this->listoffset= $this->listoffset + $this->listlimit;
			if ($this->listoffset > $this->listtotal ) $this->listoffset= $this->listtotal - $this->listlimit;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery(): detected next button (value=$getvars[listprev]). New listoffset will be $this->listoffset.",1);
			}
			
		if ($getvars['listlast']) {
			$this->listoffset= $this->listtotal - $this->listlimit;
			$this->liststart= $this->listoffset + 1;
			$this->listend= $this->listoffset + $this->listlimit;
			berror("getListQuery(): detected last button (value=$getvars[listprev]). New listoffset will be $this->listoffset.",1);
			}
			
		// make sure offset, start and end are sane values...
		if ($this->listend > $this->listtotal) $this->listend= $this->listtotal;
		if ($this->listoffset > $this->listtotal) $this->listoffset= $this->listtotal - $this->listlimit;
		if ($this->listoffset < 0 ) $this->listoffset= 0;
		if ($this->liststart > $this->listend || $this->liststart < 0 ) $this->liststart= $this->listoffset + 1;
			
		// tack limit and offset onto end of listquery
		$this->limit= " LIMIT $this->listoffset, $this->listlimit ";
		$this->listquery.= $this->limit;
		
		// reset statuswhere if it was changed temporarily...
		if ($resetstatuswhere==1) {
			$this->statuswhere= $this->oldstatuswhere;
			}
			
		berror("getListQuery() created: [quote:$this->listquery] and found $this->listtotal objects eligible for it.",1);
		return $this->listtotal;
		}

	function getNewCookie() {
		// creates a session cookie word based on the current session

		// take the memberid, sessionid, and a random value and encrypt them to make a session cookie
		$random= brandom();
		$random2= brandom();
		$word= "$random2^$this->sitememberid^$this->id^$random";
		$word= bpassword($word);
		$success= bsetcookie("word", $word, $this->request->sitename);

		$this->berror("getNewCookie() called by ".get_class($this)." id #".$this->id." on site='".$this->request->sitename."' set ($success) word=$word. (HTTP_COOKIE_VARS['word']=".$_COOKIE['word'].")",1);
		return $word;
		}

	function getSessionID() {
		// decrypts cookie word and returns the session id

		// Decode and expand $word ($random2^$sitememberid^$sessionid^$random)
		$wordarray= explode("^", bgetword($_COOKIE['word']));
		$sitememberid= $wordarray[1];
		$sessionid= $wordarray[2];

		$this->berror("getSessionID() called by ".get_class($this)." id #".$this->id.". Found session #$sessionid and sitemember #$sitememberid.",1);
		return $sessionid;
		}
                
        function getUserAgent() {
                $this->userAgent= $_SERVER["HTTP_USER_AGENT"];
                berror("getUserAgent() found: $this->userAgent",1);
                // look for Mozilla/x where x<5 -- that's Netscape4.x, can't deal with padding
                if (substr($this->userAgent,0,8)=="Mozilla/" && (strpos($this->userAgent,"MSIE")===false)) {
                    if (substr($this->userAgent,8,1)=="4") {
                        $this->netscape= substr($this->userAgent,8,1);
                        berror("getUserAgent() declares this to be a Netscape user agent.",1);
                        }
                    }
                }
                
	function berror($message, $errorLevel=0) {
		// puts a new message onto $this->error for debuging and logging
		// errorLevel in from 0 to n with 0 being general messages, n being most detailed, default=0

		if ($this->errorLevel>=$errorLevel) {
			$this->error= $this->error."\n\r".$message;
			return 1;
			}

		else {
			return 0;
			}
		}


	function updateObject() {
		// updateObject updates the database record for $this
		berror("updateSession() called by ".get_class($this)." id#$this->id ($this->name) (path=$this->path) (status=$this->status) | session->p_debug=$this->p_debug.",1);
		$success=0;
		$postvars= $_POST;

		// connect to database
		if (!$this->dbconnection) $this->dbconnection= dbconnect();
                                            
		// addslashes to all fields, merge p_keys into $this->properties
		$this->beryliumToMySQL();

		// get columns from table description so we know what bits of this object we can save
		$query= "DESCRIBE $this->objtype ";
		berror("updateSession inspecting table with query=$query; ",1);
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			berror("updateSession() extracting column ".$columnarray['Field'],2);
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through columns to build the update query
		$queryvalues= "updated= now()";
		foreach ($tablecolumn AS $key=>$val) {
			if ($key=="id" OR $key=="created" OR $key=="updated") {
				berror("updateSession() continuing because of $key being created or updated.",2);
				continue;
				}

			if ($this->objtype!="session" AND ($key=="siteid" OR $key=="sitememberid")) {
				berror("updateSession() continuing on siteid or sitememberid (objtype!=session). ($key)",2);
				continue;
				}

			if ( $this->{$key}=="" ) {
				berror("updateSession() continuing for this->$key='' (".$this->{$key}.") and postvars[$key] is '' also. (<b>".$postvars[$key]."</b>)",2);
				continue;
				}
			else {
				berror("updateSession() setting newobject[$key]=".$this->{$key}.".",2);
				$newobject[$key]= $this->{$key};
				$queryvalues= $queryvalues.", $key= '$newobject[$key]'";
				}
			}		

		// process the update query
		$query= "UPDATE $this->objtype SET $queryvalues WHERE id='$this->id' ";
		$result= mysql_query($query);
		if (!$result) {
			berror("updateSession(): update query failed to get a result. $query; (".mysql_error().")",1);
			}
		else $success=1;

		// unencode object
		$this->mySQLToBerylium();
                
                // get the date and time in case we need it.
                $this->updated= date("Y-m-d H:i:s");

		berror("updateSession(): [bold:update successful]. $query;",1);
		return $success;
		}


	function loadObject() {
		// SPECIAL FOR SESSION!
		// loadObject refreshed $this with data from the database. Requires $this->objtype and either $this->id or ($this->name and $this->folderid)
		$this->berror("session->loadObject() called by ".get_class($this)." id $this->id ($this->name).",1);

		// connect to database if not already
		if (!$this->dbconnection) $this->dbconnection= dbconnect();
		if ($this->dbconnection) $this->berror("Database connection established as $this->dbconnection.",1);

		// pick a query scheme
		$query= "SELECT * FROM session WHERE id=$this->id $this->queryExtras";

		// get the result set
		$result= mysql_query($query, $this->dbconnection);
		if (!$result) {
			$this->berror("loadObject(): query failed to get a result (with $this->dbconnection). $query",1);
			return 0;
			}

		// take first result and load it into $this object
		$objectarray= mysql_fetch_array($result);
		if (is_array($objectarray)) {
			while (list($key,$val)= each($objectarray)) {
				if (is_int($key)) continue;
				if ($key=="properties" AND trim($val)!="") {
					berror("selectObject() found properties ($val), unpacking...",1);
					// unpack properties into propertiesarray
					$this->propertiesarray= bunpack($val);
					
					// unpack properties array into p_keys
					if (is_array($this->propertiesarray)) {
						foreach ($this->propertiesarray AS $pkey=>$pvalue) {
							$p_pkey= "p_$pkey";
							$this->{$p_pkey}= $pvalue;
							berror("selectObject(): this->$p_pkey=".$this->{$p_pkey},1);
							}
						}
					continue;
					}				
				$this->{$key}= $val;
				}
			$success= 1;
			}

		else {
			$this->berror("loadObject(): result found, but array is empty. Result=$result. Objectarray=$objectarray.",1);
			$this->berror(" - continue - query=\"$query\" (".mysql_error().")",1);
			$success= 0;
			}

		return $success;
		}


	function loginprocess() {
		$site= $GLOBALS['site'];
		$folder= $GLOBALS['folder'];
		$postvars= $_POST;
		$email= addslashes($postvars['email']);
		$password= $postvars['password'];
		$this->berror("session->loginprocess() called with email=$email and password=$password at folder $folder->name.",1);

		if (!$_REQUEST['Clue'] AND ($email=="" OR $password=="")) {
			$GLOBALS['session']->alert= "Please enter your email address AND password to login.";
			return 0;
			}

		// create a temporary sitemember object for comparison
		$temp= new Member;

		// lookup email in member table
		$query= "SELECT * FROM member WHERE email='$email' AND status!='deleted' ";
		$temp->selectObject($query);

		if ($temp->id=="") {
			$GLOBALS['session']->alert= "No membership was found with that email address. <a href='$session->refreshUrl?method=createmember$session->cgi'>Click here</a> to create one.";
			return 0;
			}
                        
		if ($_REQUEST['Clue']) {
			// if send hint button was pressed...
			$message="You requested ".$temp->email."'s berylium password hint for $site->name.

It is: ".$temp->hint."

End of transmission.";
			bmail($email, "Your password hint", $message);
			$GLOBALS['session']->alert= "Your hint has been sent.";
			return 0;
			}

		// compare passwords
		$passcompare=0;
		$passcompare= bpasswordcompare($password, $temp->password);
		if (!$passcompare) {
			$GLOBALS['session']->alert= "That password doesn't match that email address.";
			return 0;
			}

		// matches. find sitemember
		$sitemember = new Sitemember;
		$query= "SELECT * FROM sitemember WHERE memberid='$temp->id' AND siteid='$site->id' AND status!='deleted' ";
		$sitemember->selectObject($query);
		if (!$sitemember->id) {
			$GLOBALS['session']->alert= "Sorry, you are not a member of this site, although you seem to be a member of another site on this server. Click &quot;Create a new membership&quot;-- you can use the same email/password combo you just used.";
			return 0;
			}
			
		// update session, get new cookie
		elseif($passcompare==1) {
			$GLOBALS['sitemember']= $sitemember;
			$GLOBALS['session']->memberid= $temp->id;
			$GLOBALS['session']->sitememberid= $sitemember->id;
			$GLOBALS['session']->getNewCookie();

			// update the session itself in the db
			$GLOBALS['session']->siteid= $site->id;
			$GLOBALS['session']->folderid= $folder->id;
			$GLOBALS['session']->flavor= "login";
			$GLOBALS['session']->updateObject();

			return 1;
			}
		}


	function logout () {
		// update the current session
		$this->flavor= "logout";
		$this->updateObject();

		// set cookie word to ""
		bclearcookie("word");

		// refresh page after this.
		$this->berror("session->logout() called on session id#$this->id.",1);

		return 1;
		}



	function membercreate() {
		$site= $GLOBALS['site'];
		$postvars= $_POST;
		$email= addslashes($postvars[email]);
		$this->berror("session->membercreate() called with email=$email.",1);

		if ($email=="" OR $postvars[password]=="" OR $postvars[hint]=="" OR $postvars['name']=="") {
			$GLOBALS['session']->alert= "Please fill out ALL fields to create a new Membership.";
			return 0;
			}

		if ($postvars[password]==$postvars[hint]) {
			$GLOBALS['session']->alert= "Please do not use your password as your password hint. Really.";
			return 0;
			}

		// create a temporary member object for comparison
		$temp= new Member;

		// lookup email in member table
		$query= "SELECT * FROM member WHERE email='$email' AND status!='deleted' ";
		$temp->selectObject($query);

		if ($temp->id!="") {
                        // check to see if password matches. If so, you may continue but without adding a member record
                        $passcompare=0;
                        $passcompare= bpasswordcompare($postvars[password], $temp->password);
                        if (!$passcompare) {
                                // if not, let the user know what has happened.
                                $GLOBALS['session']->alert= "A membership for $temp->name already exists with that email address ($temp->email).</b>
                                  If this is you, you have already registered with another site on this server. 
                                  You may register with this site also, by 1) using the same email address/password 
                                  combination or 2) using a different email address.";
                                return 0;
                                }
                        $temp->name= $postvars['name'];
			}
                else {
                        // no duplicate so create new Member
                        $temp->email= $postvars[email];
                        $temp->name= $postvars['name'];
                        $temp->password= bpassword($postvars[password]);
                        $temp->hint= $postvars[hint];
                        $temp->flavor= "standard";
                        $temp->status= "posted";
        
                        $temp->insertObject();
                        }

		// create the sitemember now
		$fmem= new Sitemember();

		$fmem->memberid= $temp->id;
		$fmem->siteid= $site->id;
		$fmem->folderid= $site->folderid;
		if ($site->public) {
			$fmem->flavor= "standard";
			$fmem->status= "posted";
			}
		else {
			$fmem->flavor= "request";
			$fmem->status= "new";
			}
		$fmem->name= $temp->name;
		$fmem->role= "member";

		$fmem->insertObject();

		return 1;
		}

	function membersave() {
		$site= $GLOBALS['site'];
		$sitemember= $GLOBALS['sitemember'];
		$postvars= $_POST;
		$email= addslashes($postvars[email]);
		$id= addslashes($postvars[id]);
		$this->berror("session->membersave() called on member #$id with email=$email.",1);

		if ($email=="" OR ($postvars[password]=="" && $sitemember->role!="admin") OR ($postvars[newpassword]!="" && $postvars[hint]=="")) {
			$GLOBALS['session']->alert= "Please fill out email and cuurent password (and hint if you are changing passwords) to edit your record.";
			return 0;
			}

		if ($postvars[newpassword]=="" AND $postvars[password]==$postvars[hint]) {
			$GLOBALS['session']->alert= "Please do not use your password as your password hint. Really.";
			return 0;
			}
		elseif ($postvars[newpassword]!="" AND $postvars[newpassword]==$postvars[hint]) {
			$GLOBALS['session']->alert= "Please do not use your new password as your password hint. Really.";
			return 0;
			}

		// create a temporary member object for comparison
		$temp= new Member;

		// lookup email in member table
		$query= "SELECT * FROM member WHERE email='$email' AND id!='$id' AND status!='deleted' ";
		$temp->selectObject($query);

		if ($temp->id!="") {
			$GLOBALS['session']->alert= "Another membership already exists with that email address ($temp->email).";
			return 0;
			}

		$current= new Member;
		$query= "SELECT * FROM member WHERE id='$id' ";
		$current->selectObject($query);

		// make sure oldpassword matches password on file
		$passcompare=0;
		$passcompare= bpasswordcompare($postvars[password], $current->password);
		if (!$passcompare && $sitemember->role!="admin") {
			$GLOBALS['session']->alert= "You didn't supply the correct old password, update canceled. ($passcompare)";
			return 0;
			}

		// no duplicate, password okay, so update the member
		$temp->id= $postvars[id];
		$temp->email= $postvars[email];
		$temp->password= bpassword($postvars[newpassword]);
		if ($postvars[hint]!="") $temp->hint= $postvars[hint];
		$temp->flavor= $current->flavor;
		$temp->status= $current->status;

		$temp->updateObject();

		return 1;
		}


	}



class Member extends BeryliumObject {
	// member object class

	var $email;
	var $password;
	var $hint;
	var $role;

	// constructor
	function member() {
		$this->objtype= "member";
		$this->columns= "email=VARCHAR(255) NOT NULL^password=VARCHAR(255)^hint=VARCHAR(255)^role=VARCHAR(255)^INDEX index_email=(email)";
		}

	}


class Log extends BeryliumObject {
	// log table logs statistics for each ContentObject

	}



class Undo extends BeryliumObject {
	// undo table allows database operations to be undone

	}



class Request {
	// Object to parse HTTP Request into useful values

	var $request_uri;
	var $path;
	var $sitename;
	var $foldername;
	var $objectstring;
	var $objtype;
	var $objectname;
	var $format;
	var $cgistring;
	var $cgiarray;
	var $counter;
	var $method;

	// constructor
	function Request() {
		// object by name: http://sitename/scriptname/name/of/folder/objtype-objectname.format?method=value&cgivar=value
		// object by id: http://sitename/scriptname/name/of/folder/objtype-id.format
		// folder as index: http://sitename/scriptname/name/of/folder/index.format
		// folder as implied index: http://sitename/scriptname/name/of/folder/
		// implied document by name: http://sitename/scriptname/name/of/folder/documentname.format
		// onject in a subsite: http://sitename/scriptname/subsitename/name/of/folder/objtype-objectname.format

		// get the request sans leading /berylium
		if ($_SERVER['HTTPS']=="on") {
			$this->request_uri= urldecode(substr($_SERVER['REQUEST_URI'],9));
			$this->connection= "https";
			}
		else {
			$this->request_uri= urldecode(substr($_SERVER['REQUEST_URI'],9));
			$this->connection= "http";
			}
		berror("Constructor Request() called on $this->connection://".$_SERVER['HTTP_HOST']."/".$this->request_uri,1);

		// sitename
		$this->sitename= $_SERVER['HTTP_HOST'];
		if (substr($this->sitename,0,4)=="www.") $this->sitename= substr($this->sitename,4);

		// split off cgistring and path
		$cgipos= strpos($this->request_uri, "?");
		if ($cgipos === FALSE) $this->path= $this->request_uri;
		elseif ($cgipos==0) {
			$this->path= "/";
			$this->cgistring= substr($this->request_uri, 1);
			}
		else {
			$this->cgistring= substr($this->request_uri, $cgipos+1);
			$this->path= substr($this->request_uri, 0, $cgipos);
			}
		berror("Request($this->request_uri) found path:$this->path and cgistring:$this->cgistring. cgipos=$cgipos",1);

                //kludge for root folder (http://site/berylium//objtype-name.format problem )... must be a better way?
                $firstpart= substr($this->path,0,1);
                if ($firstpart=="/") $this->path= substr($this->path,1);
                berror("Request() first part of path is $firstpart, path is now $this->path.",1);
                
		// split $this->path into an array based on /
		$requestarray= explode("/", $this->path);
		
		// go through each element
		while (list($key,$val)= each($requestarray)) {
			// debug: print "$key=>$val<br>";
			// if blank, do nothing
			if ($val=="") continue;

			// if there's a hyphen on the end, call it an objtype declaration. Make it and everything after it the objectstring.
			if (substr($val,-1)=="-") {
				$this->objectstring= $val;
				$objtypeDeclared=1;
				continue;
				}
			if ($objtypeDeclared) {
				$this->objectstring= $this->objectstring."/".$val;
				continue;
				}

			// if there's a dot in it, it could be a subsitename or an objectstring
			if (strpos($val,".") && $key!=0) {
				$this->objectstring= $val;
				continue;
				}
			elseif (strpos($val,".") && $key==0) {
				if (substr($val,strpos($val,".")+1)==$this->sitename) {
					// subsite of site
					$this->subsitename= $val;
					}
				else $this->objectstring= $val;
				continue;
				}

			// otherwise it's a foldername
			$this->foldername= $this->foldername."/".$val;
			}

		// set foldername and/or subsitename if blank
		if ($this->foldername=="") $this->foldername="/";
		if ($this->subsitename=="") $this->subsitename= $this->sitename;
		
		// parse objectstring for objtype
		if ($this->objectstring=="") {
			// no object, so object is folder.
			$this->objtype= "folder";
			$this->objectname= $this->foldername;
			$this->format= "html";
			}

		elseif ($hyphenpos= strpos($this->objectstring,"-")) {
			//there is an objtype declaration here
			$this->objtype= substr($this->objectstring,0,$hyphenpos);

			// break it down even further
			$this->namestring= substr($this->objectstring,$hyphenpos+1);
			}
		
		else {
			// there is no objtype declaration
			$this->objtype= "document";
			$this->namestring= $this->objectstring;
			}

		// parse namestring for name and/or format
		if ($this->namestring=="") {
			// no format
			$this->format= "html";
			}

		else {
			$dotpos= strrpos($this->namestring,".");
			if ($dotpos===false) {
				// name, but no format
				$this->objectname= $this->namestring;
				$this->format= "html";
				}

			elseif ($dotpos==0) {
				// format only, no name
				$this->objectname="";
				$this->format= substr($this->namestring,1);
				}
			else {
				// name and format!
				$this->objectname= substr($this->namestring,0,$dotpos);
				$this->format= substr($this->namestring,$dotpos+1);
				}
			}

		// if no format, or wrong format, then html
		if ($this->format=="" OR $this->format=="htm") $this->format= "html";
		
		// name is special name index-- oops, that means we're looking at a folder...
		if ($this->objectname=="index") {
			$this->objectname= $this->foldername;
			$this->objtype= "folder";
			}

		// parse cgistring
		parse_str($this->cgistring, $this->cgiarray);

		// find method
		if (is_array($this->cgiarray)) {
			$this->method= $this->cgiarray['method'];
			if ($this->method=="" && $_GET['keyword']!="") $this->method= "listall";
			elseif ($this->method=="") $this->method= "view";
			}
		else $this->method= "view";

		// find counter
		if (is_array($this->cgiarray)) {
			$this->counter= $this->cgiarray['counter'];
			if ($this->counter=="") $this->counter=1;
			}
		else $this->counter= 1;

		berror("Finished Request Construction: a $this->connection:// $this->subsitename $this->foldername | $this->objtype - $this->objectname . $this->format ? $this->cgistring<br>
				&nbsp; method=$this->method  counter=$this->counter",1);
		}

	function viewObject() {
		// default view context; to do: render to session->output...

		$array= get_object_vars($this);
		print get_class($this)." values:<br><blockquote>";
		while (list($key, $val)= each($array)) {
			if (is_int($key)) continue;
			print "$key => $val<br>";
			if (is_object($val)) $val->viewObject();
			}
		print "---End---</blockquote>";
		}
	}

//
// ----------------------------------------------------------- Hardcoded Content Classes ----
//

class Sitemember extends ContentObject {
	// unlike member, sitemember is a content object

	// constructor
	function sitemember () {
		$this->objtype="sitemember";
		$this->columns= "memberid=int(10) unsigned^INDEX memberid=(memberid)^role=varchar(255)^INDEX role=(role(16))";
		}

	function getsitemember () {
		// needs to be called after session and containers
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		berror("getsitemember() search starting, looking for sitemember #$session->sitememberid in $site->name.",1);

		// if truly anonymous, give up
		$this->id= $session->sitememberid;
		if ($this->id=="0" || $this->id=="") {
			berror("getsitemember() didn't find member->id, [bold:role=anonymous].",1);
			$this->role= "anonymous";
			}
		else {
			// look up sitemembership.
			$query= "SELECT * FROM sitemember WHERE id='$this->id' AND siteid='$site->id' ";
			$this->selectObject($query);
			if ($this->role=="") {
				 $this->role= "anonymous";
				 $this->siteid= $site->id;
				 $this->id= 0;
				 $this->memberid= 0;
				 $this->name= "Anonymous";
				 berror("getsitemember() didn't find one so role is role=$this->role unless member is found.",1);
				 }
			else berror("getsitemember() found local sitemembership ($this->name) with role=$this->role.",1);
			}
		berror("sitemember constructor: Sitemember $this->name has been constructed with <b>role='$this->role'</b>, sitemember:$this->id in folder ($this->folderid)",1);
		return 1;
		}

	}

class Site extends ContentObject {
	// site object

	// constructor
	function Site () {
		$this->objtype="site";
		}

	function loadSite() {
		$session= $GLOBALS['session'];
		$this->name= $session->request->sitename;
		$this->folderid= 1;
		
		$query= "SELECT * FROM site WHERE name='$this->name' ";
		$this->selectObject($query);
                if ($this->id=="") berror("Sorry, there is no site by that name ($this->name).",0);
		berror("loadSite(): $this->name has been constructed, site:$this->id",1,"site");

		$this->getBaseURL();
		}
		
	function save() {
		$posto= $_POST;

		$this->id= $posto['id'];
		foreach ($posto as $key=>$value) {
			$this->{$key}= $value;
			}
		berror("[bold:Site->save()] called by '$this->objtype' object id#$this->id ($this->name)(folderid: $this->folderid). ",1);
		
		$this->name= preg_replace ("/[^A-Za-z0-9\.]/","",$this->name);
		berror("Site->save() name cleanup produced ($this->name).",1);
		
		$this->folderid= $GLOBALS[folder]->id;
		berror("[bold:Site->save()] says name is '$this->name' and folderid is '$this->folderid'.",1);
		BeryliumObject::save();
		}
		
	function insertObject() {
		berror("site->insertObject() called by $this->objtype id#$this->id ($this->name).",1);

		// insert the object...
		$success= BeryliumObject::insertObject();
		berror("site->insertObject(): successfully inserted object? ($success)",1);
		
		// create the folder
		if ($success) {
			$newdir= $GLOBALS['beryliumroot']."/files/$this->name";
			berror("site->insertObject(): new directory is $newdir",1);

			umask(000);
			$success= @mkdir($newdir,0770);
			if (!$success) {
				$blah= mkdir($newdir,0770);
				berror("site->insertObject(): mkdir() failed to create a directory at $newdir. (But the site has been inserted in the db, so you'll need to do it manually.)",1);
				return 0;
				}
                        else {
                                // also make the .cache directory
                                $newcdir= $newdir."/.cache";
                                $success= @mkdir($newcdir,0770);
                                if (!$success) {
                                        $blah= mkdir($newcdir,0770);
                                        berror("site->insertObject(): mkdir() failed to create a .cache directory at $newcdir. (But the site has been inserted in the db, so you'll need to do it manually.)",1);
                                        return 0;
                                        }
                                }
			}

		return $success;
		}
		
	}

class Folder extends ContentObject {
	// folder object

	// constructor
	function Folder() {
		$this->objtype="folder";
		}

	function save() {
		$posto= $_POST;

		if ($posto['public']!="1" AND $posto[id]=="") $createmember= "[bold:Creating sitemember] ($posto[author]).";
		else $createmember=0;

		$this->id= $posto['id'];
		foreach ($posto as $key=>$value) {
			$this->{$key}= $value;
			}
		berror("[bold:Folder->save()] called by '$this->objtype' object id#$this->id ($this->name)(folderid: $this->folderid). ($createmember)",1);
		
		$this->name= preg_replace ("/[^A-Za-z0-9]/","",$this->name);
		if (substr($this->name,0,1)!="/") $this->name= "/".$this->name;
		berror("Folder->save() name cleanup produced ($this->name).",1);

		// if this is a new folder, append folder->name to this->name and make this->folderid=folder->id
		if ($this->id=="") {
			$currentfolder= $GLOBALS['folder']->name;
			if ($currentfolder=="/") $currentfolder= "";
			if ($this->name=="/") {
				// generate a title-based unique name
				if (trim($this->title)=="") $this->name= date("Ymd").".".substr(uniqid(""),-4);
				else {
					$this->name= urlencode(strtolower(str_replace(" ","_",$this->title)));
					$this->name= preg_replace("/\%\d\d/","",$this->name);
					$this->name= substr($this->name,0,12);
					}
				$this->name= "/".$this->name;
				}
			berror("<b>Folder->save()</b> name of new folder is $this->name.",1);
			$this->name= "$currentfolder$this->name";
			$this->folderid= $GLOBALS['folder']->id;
			}
		// if this is an existing folder, append containers[1]->name to this->name and leave this->folderid alone.
		else {
			$parentfoldername= $GLOBALS['containers'][1]->name;
			if ($parentfoldername=="/") $parentfoldername= "";
			$this->name= "$parentfoldername$this->name";
			$this->folderid= $GLOBALS['containers'][1]->id;
			}
		berror("[bold:Folder->save()] says name is '$this->name' and folderid is '$this->folderid'.",1);

		BeryliumObject::save();

		if ($createmember!="") {
			$this->folderid= $this->id;
			BeryliumObject::updateObject();
			berror("[bold:Folder->save():] updated folderid to match id ($this->folderid).",1);

			$newmember= new Sitemember;
			$newmember->name= $posto[author];
			$newmember->role= "editor";
			$newmember->folderid= $this->id;
			$newmember->rank= 100;

			$created= $newmember->insertObject();
			if ($created) {
				berror("Folder->save(): folder created and new Member created as editor.",1);
				return 1;
				}
			}
		else {
			berror("[bold:Folder->save()]: folder created with folderid=$this->folderid.",1);
			return 0;
			}
		}

	function loadFolder () {
		$session= $GLOBALS['session'];
		$this->name= $session->request->foldername;
		$this->siteid= $GLOBALS['site']->id;
		
		$query= "SELECT obj.* FROM folder AS obj WHERE obj.name='$this->name' AND obj.siteid='$this->siteid' $session->statuswhere $session->publicwhere";
		$this->selectObject($query);
		berror("loadFolder(): $this->name has been constructed, folder:$this->id",1);

		$this->getBaseURL();
		}

	function getBackPath() {
		$containers= $GLOBALS['containers'];

		foreach ($containers AS $key=>$value) {
			if ($value->name=="/") continue;
			if (is_int($key)) continue;
			$backpath= "<a href='$value->baseURL'>$value->uniqueName</a>".$backpath;
			}
		$this->backpath= $backpath;
		}

	function insertObject() {
		berror("folder->insertObject() called by $this->objtype id#$this->id ($this->name).",1);

		// insert the object...
		$success= BeryliumObject::insertObject();
		berror("folder->insertObject(): successfully inserted object? ($success)",1);
		$site= $GLOBALS['site'];
		
		// create the folder
		if ($success && $this->name!="/") {
			$newdir= $GLOBALS['beryliumroot']."/files/$site->name$this->name";
			berror("folder->insertObject(): new directory is $newdir",1);

			umask(000);
			$success= @mkdir($newdir,0770);
			if (!$success) {
				berror("folder->insertObject(): mkdir() failed to create a directory at $newdir. (But the folder has been inserted in the db, so things might work right.)",1);
				return 0;
				}
			}

		return $success;
		}


	function updateObject() {
		berror("folder->updateObject() called by $this->objtype id#$this->id ($this->name).",1);

		// get the current name...
		$temp= new Folder;
		$query= "SELECT * FROM folder WHERE id='$this->id' ";
		$temp->selectObject($query);

		if ($temp->name!=$this->name) $rename=1;

		// update the object...
		$success= BeryliumObject::updateObject();
		berror("folder->updateObject(): successfully updated object? ($success)",1);

		// does the folder exist?
		$site= $GLOBALS['site'];
		$newdir= $GLOBALS['beryliumroot']."/files/$site->name/$this->name";
		$exists= is_dir($newdir);

		// create the folder
		if ($success AND !$exists AND !$rename) {
			berror("folder->updateObject(): creating new directory at $newdir",1);

			umask(000);
			$success= @mkdir($newdir,0755);
			if (!$success) {
				$blah= mkdir($newdir,0755);
				berror("folder->updateObject(): mkdir() failed to create a directory at $newdir. (But the folder has been inserted in the db, so things might work right.)",0);
				return 0;
				}
			}
		elseif ($success AND !$exists AND $rename) {
			$olddir= $GLOBALS['beryliumroot']."/files/$site->name$temp->name";			
			berror("folder->updateObject(): renaming directory at $olddir to $newdir.",1);

			$success= @rename($olddir,$newdir);
			if (!$success) {
				$blah= rename($olddir,$newdir);
				berror("folder->updateObject(): rename() failed to rename $olddir to $newdir. (But the folder has been updated in the db, bummer. Something is quite wrong.)",0);
				return 0;
				}
				
			// update foldernames of contained folders... kinda hairy!
			$namestart= strlen($temp->name);
			$child= new Folder;
			$query= "SELECT obj.* FROM folder AS obj WHERE obj.siteid='$site->id' AND obj.name LIKE '$temp->name/%' ";
			$folderlist= $child->selectObject($query);
			foreach ( $folderlist AS $key=>$childfolder ) {
				if ($childfolder[id]=="") continue;
				// update $childfolder[id] with an updated name
				$childname= substr($childfolder['name'],$namestart);
				$newname= $this->name.$childname;
				berror("[color:#559922;folder-rename:] found child folder ".$childfolder['name']." (#".$childfolder['id']."). Renaming to $newname.",1);
				$query= "UPDATE folder SET name='$newname' WHERE id='$childfolder[id]' ";
				$result= mysql_query($query);
				if (!$result) {
					berror("folder-rename could not update child folder ".$childfolder['name']." (#".$childfolder['id'].") (".mysql_error().")",1);
					return 0;
					}
				}
			}
		else {
			berror("folder->updateObject(): folder already exists.",1);
			}

		return $success;
		}
	}

class Document extends ContentObject {
	// document object

	// constructor
	function Document () {
		$this->objtype= "document";
		$this->columns= "";
		}

	}
        
class Comment extends ContentObject {
	// comment object

	// constructor
	function Comment () {
		$this->objtype= "comment";
		$this->columns= "";
		}

	}


class Image extends ContentObject {
	// image object

	// constructor
	function Image () {
		$this->objtype= "image";
		$this->columns= "format=varchar(255)^path=varchar(255)^uri=varchar(255)^width=INT^height=INT";
		}

	function upload () {
		$postvars= $_POST;
		//$this->name= str_replace("/","",$postvars['name']);
		$filevars= $_FILES[imagefile];
		$tempfile= $filevars[tmp_name];
		$type= $filevars[type];
		$size= $filevars[size];
		
		// if this has no name yet, give it the posted name
		if ($this->name=="") $this->name=$postvars['name'];
		
		// if this has a new name, give it the new name
		if ($this->name!= $postvars['name'] && $postvars['name']!="") $this->name=$postvars['name'];
		
		if ($this->name=="") berror("image->upload() could not determine filename. something is wrong.",0);
		berror("image->upload() called by $this->objtype #$this->id ($this->name). [color:#6666FF;tempfile:$tempfile originalname:".$postfiles['name']." type:$type size:$size]", 1);
		
		// make sure this is an image
		$imagesize= getimagesize($tempfile);
		if (!$imagesize) {
			berror("image->upload(): file uploaded was not a valid image. Please go back and try again.",0);
			return 0;
			}
		$this->width= $imagesize[0];
		$this->height= $imagesize[1];

		// build filename extension
		switch ($imagesize[2]) {
			case 1: $extension=".gif"; break;
			case 2: $extension=".jpg"; break;
			case 3: $extension=".gif"; break;
			case 4: $extension=".swf"; break;
			}

		// build path, uri, and format
		$this->format= $extension;
		$this->getBaseUrl();
		
		// save it where it needs to go
		berror("image->upload: saving new '$type' image at [link:$this->uri;$this->path].",1);
		$success= @move_uploaded_file("$tempfile", "$this->path");
		if (!$success) {
			$blah= move_uploaded_file("$tempfile", "$this->path");
			berror("image->upload(): Couldn't move uploaded image from $tempfile to $this->path.",0);
			return 0;
			}
		
		// make sure ya can't execute it
		chmod("$this->path", 0660);

		return $success;
		}

	function import () {
		$imageurl= $_POST['imageurl'];
		$postvars= $_POST;
		
		// if this has no name yet, give it the posted name
		if ($this->name=="") $this->name=$postvars['name'];
		
		// if this has a new name, give it the new name
		if ($this->name!= $postvars['name'] && $postvars['name']!="") $this->name=$postvars['name'];
		
		if ($this->name=="") berror("image->import() could not determine filename. something is wrong.",0);
		berror("image->import() called by $this->objtype #$this->id ($this->name). [color:#6666FF;imageurl:$imageurl]", 1);
		
		// make sure this is an image
		$imagesize= getimagesize($imageurl);
		if (!$imagesize) {
			berror("image->import(): file imported was not a valid image. Please go back and try again.",0);
			return 0;
			}
		$this->width= $imagesize[0];
		$this->height= $imagesize[1];

		// build filename extension
		switch ($imagesize[2]) {
			case 1: $extension=".gif"; break;
			case 2: $extension=".jpg"; break;
			case 3: $extension=".gif"; break;
			case 4: $extension=".swf"; break;
			}

		// build path, uri, and format
		$this->format= $extension;
		$this->getBaseUrl();

		// save it where it needs to go
		berror("image->import: importing new '$extension' image from $imageurl to [link:$this->uri;$this->path].",1);
		
		if ($fp= fopen ($imageurl, "r")) {
			// open the local file for writing
			if ($fp2= fopen ($this->path, "w")) {
				$imagefile= fread($fp, 1048576); // a 1Mb limit on imported images!
				$success= fwrite($fp2, $imagefile);
				$this->defaultsource= "[link:$imageurl]";
				// make sure ya can't execute it
				chmod("$this->path", 0660);
				berror("image->import: <b>Success</b> wrote $success bytes at $this->path. Source=$this->source.",1);
				}
			else berror("image->import: <b>unable to open local file</b> at $this->path.",1);		
			}
		else berror("image->import: <b>unable to open image</b> at $imageurl.",1);

		return $success;
		}

	function save () {
		// check for upload and determine type
		$posto= $_FILES['imagefile'];
		if ($posto['size']!="") $this->useupload= "[bold:Uploading file] ($posto[size] bytes).";
		else $this->useupload=0;
		
		$postp= $_POST['imageurl'];
		if ($postp) $this->useimport= "[bold:Importing file] ($postp).";
		else $this->useimport=0;
		
		$this->id= $_POST['id'];
		berror("Image->save() called by '$this->objtype' object id#$this->id ($this->name). ($useupload)",1);

		// has the name changed?
		if ($this->id!="") {
			$temp= new Image;
			$query= "SELECT * FROM image WHERE id='$this->id' ";
			$temp->selectObject($query);
			$temp->getBaseUrl();
			$newname= $_POST['name'];
			if ($temp->name != $newname) {
				// change filename (even if a new image will be uploaded on top)
				berror("Image->save(): [bold:renaming image file] on disk ($temp->path) because name has changed from $temp->name to $newname",1);
				
				if (!file_exists($temp->path)) {
					berror("Image->save(): cancelled file rename: $temp->path does not exist.",1);
					}
				else {
					$dir= dirname($temp->path);
					$base= basename($temp->path);
					$dotpos= strrpos($base, ".");
					if ($dotpos) {
						$ext= substr($base,$dotpos);
						}
					$renamepath= "$dir/$newname$ext";
					berror("Image->save(): set to rename file $temp->path to $renamepath.",1);
					if (rename($temp->path, $renamepath)) {
						berror("Image->save(): rename successful.",1);
						}
					else {
						berror("Image->save(): unable to rename image file: from $temp->path to $renamepath. Not updated.",0);
						}
					}
				
				// get new path and uri information
				if ($renamepath) {
					$this->path= $renamepath;
					$this->uri= dirname($temp->uri)."/image-$newname$ext";
					}
				else {
					$base= basename($temp->path);
					$dotpos= strrpos($base, ".");
					if ($dotpos) {
						$ext= substr($base,$dotpos);
						}
					$this->path= dirname($temp->path)."/$newname$ext";
					$this->uri= dirname($temp->uri)."/image-$newname$ext";
					}
				berror("Image->save(): rename finishing. New path is ($this->path), new uri is ($this->uri).",1);
				}
			}

		BeryliumObject::save();
		}

	function proportion($width="*", $height="*") {
		berror("Image->proportion() called by '$this->objtype' object id#$this->id ($this->name). ($this->width X $this->height) going to ($width X $height)",1);

		$this->origHeight= $this->height;
		$this->origWidth= $this->width;

		if ($width != "*" && $this->width > $width) {
			$proportion= $width/$this->width;
			$this->width= round($this->width*$proportion);
			$this->height= round($this->height*$proportion);
			$this->isProportioned= 1;
			}

		if ($height != "*" && $this->height > $height) {
			$proportion= $height/$this->height;
			$this->width= round($this->width*$proportion);
			$this->height= round($this->height*$proportion);
			$this->isProportioned= 1;
			}

		return 1;
		}

	function getFileSize () {
		if ($this->path=="") $this->getBaseUrl();
		if (file_exists($this->path)) {
			$size= filesize($this->path);
			$this->bytesize= $size;
			if ($size<1024) {
				$this->filesize= "$size Bytes";
				}
			elseif ($size < 1048576) {
				$size= $size/1024;
				$size= round($size,2);
				$this->filesize= "$size KB";
				}
			else	{
				$size= $size/1048576;
				$size= round($size,2);
				$this->filesize= "$size MB";
				}
			}
		else {
			$this->bytesize= 0;
			$this->filesize= "file not found!";
			}
		return $this->filesize;
		}
	}
     

class Sequence extends ContentObject {
	// sequence object

	// constructor
	function Sequence () {
		$this->objtype= "sequence";
		$this->columns= "";
		}

	}
	
class Event extends PublishableObject {
	// event object (for sequences / server events)
	/*
	from BeryliumObject:
		$this->id
		$this->flavor
		$this->created
		$this->updated
		$this->sitememberid
		$this->siteid
		$this->folderid
		$this->status
		$this->properties		"p-keys"

	from PublishableObject:
		$this->name
		$this->originalid
		$this->parentobjtype
		$this->parentid
		$this->public
		$this->locked (dep.)
		$this->rank
		*/
	/*
	object reference is contained in parentobjtype/parentid
	order within sequence $sequenceid is determined by rank
	folderid seems immaterial here...
	*/
	var $sequenceid;
	var $starttime;
	var $duration;


	// constructor
	function Event () {
		$this->objtype= "event";
		$this->columns= "sequenceid=INT UNSIGNED^starttime=VARCHAR(255)^duration=VARCHAR(255)^INDEX index_sequenceid=(sequenceid)";
		}
		
	}


