<?php
// Main Berylium Object Class
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*  CONTENTS (roughly)

	context-related methods, about line 1000
	
*/

class BeryliumObject {
// master class for all objects stored in the database
	
	// all database objects have these attributes
	var $id;		// unique id
	var $flavor;		// subtype of the object; indexed
	var $created;		// creation timestamp
	var $updated;		// last update timestamp
	var $sessionid;		// last session to modify this object
	var $sitememberid;	// Sitemember id of owner/creator or 0 for Anonymous; indexed
	var $siteid;		// id of containing Site or 0 for Ubiquitous; indexed
	var $folderid;		// id of containing Folder or 0 for root (/); indexed
	var $status;		// new | posted | hidden | deleted; indexed
	var $properties;		// ^-delimited list of key=value pairs for extra properties (become $this->p_key=value)
	// operational attributes not stored in db
	var $columns;		// mySQL column_definition for this object, to be inherited by user objects
	var $queryExtras;	// extra WHERE clauses (beginning with AND) and/or OFFSET, LIMIT, and ORDERBY clauses
	var $listsize;		// number of objects returned by selectObject() (number of objects in $objectarray[])

// constructor method
	function BeryliumObject() {
		$this->columns= "id=INT UNSIGNED AUTO_INCREMENT PRIMARY KEY^flavor=VARCHAR (255)^INDEX index_flavor=(flavor(32))^created=DATETIME^updated=DATETIME^sessionid=INT UNSIGNED^sitememberid=INT UNSIGNED^INDEX index_sitememberid=(sitememberid)^siteid=INT UNSIGNED^INDEX index_siteid=(siteid)^folderid=INT UNSIGNED^INDEX index_folderid=(folderid)^status=VARCHAR(255)^INDEX index_status=(status(16))^properties=TEXT";
		}

// table backup
	function backupDB() {
		$now= date("U");
		$filename= "/home/berylium/berylium/backups/$this->objtype-$now.sql";
		$command= "/usr/local/mysql/bin/mysqldump --opt -u $GLOBALS[dbuser] -p$GLOBALS[dbpassword] beryliumdb $this->objtype > $filename";
		berror("backupDB() will attempt to perform backup of $this->objtype table.",1);

		$error= exec("$command");

		if (file_exists("$filename")) {
			$filesize= filesize("$filename");
			if ($filesize >= 1073741824) {
				$filesize = round($filesize / 1073741824 * 100) / 100 . "g";
				} 
			elseif ($filesize >= 1048576) {
				$filesize = round($filesize / 1048576 * 100) / 100 . "m";
				} 
			elseif ($filesize >= 1024) {
				$filesize = round($filesize / 1024 * 100) / 100 . "k";
				} 
			else {
				$filesize = $filesize . "b";
				}

			$this->backupsize= $filesize;
			$this->backupname= $filename;
			$error= "Created $filesize backup file at $filename.";
			$success= 1;			
			}

		berror("backupDB() success=$success, $error",1);

		return $success;
		}


// policies
	function applyPolicy() {
		// only call once per object, k?
		if ($this->publicwhere!="" && $this->statuswhere!="") {
			berror("[bold:applyPolicy():] called but publicwhere=$this->publicwhere and/or statuswhere=$this->statuswhere, so skipping lookup.",1);
			return 1;
			}
		$dbpolicies=0;
		
                $session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$sitemember= $GLOBALS['sitemember'];
		$member= $GLOBALS['member'];
		$postvars= $_POST;
		$getvars= $_GET;

		$policy= new Policy;
		$policy->flavor= $sitemember->role;
		if ($sitemember->role=="admin") $policy->flavor="editor";
		if ($sitemember->role=="anonymous" && ( $member->id=="" || !$site->public || $sitemember->truerole!="anonymous") ) {	
			berror("applyPolicy(): has membership, but not sitemembership and site is private (or has dropped role), policy role is anonymous.",1);
			$policy->flavor="anonymous";
			}
		elseif ($sitemember->role=="anonymous" && $member->id!="" ) {
			berror("applyPolicy(): has membership, but not sitemembership, policy role is member.",1);
			$policy->flavor="member";
			// we should create a sitemember here for future use? or make some other distinction...
			// but for now we just insert some default values in the sitemember object
			$sitemember->role= "member";
			$sitemember->name= $member->email;
			$GLOBALS['sitemember']= $sitemember;
			}
			
		$policy->folderid= $sitemember->folderid;
		$policy->siteid= $GLOBALS['site']->id;
		$policy->sitefolderid= $GLOBALS['site']->folderid;

		berror("Looking up policies now.<blockquote>",1);

		if ($dbpolicies) {
			// lookup policy in this folder first
			$query= "SELECT * FROM policy WHERE flavor='$policy->flavor' AND folderid='".$GLOBALS['folder']->id."' AND siteid='$policy->siteid' AND status='posted' ORDER BY created ASC";
			$policy->selectObject($query);
		
			if ($policy->id=="") {
		
				// lookup policy in sitemember->folderid
				$query= "SELECT * FROM policy WHERE flavor='$policy->flavor' AND folderid='".$GLOBALS['sitemember']->folderid."' AND siteid='$policy->siteid' AND status='posted' ORDER BY created ASC";
				$policy->selectObject($query);
		
				// lookup policy in root folder
				if ($policy->id=="") {
					$query= "SELECT * FROM policy WHERE flavor='$policy->flavor' AND folderid='$policy->sitefolderid' AND status='posted' ORDER BY id ASC";
					$policy->selectObject($query);
		
					if ($policy->id=="") {
						// turn errorLevel back up
						berror("</blockquote>",1);	
						berror("applyPolicy(): No policy found to match your role ($policy->flavor) in this area. [bold:Server can not continue].",0);
						return 0;
						} 
					}
				}
			}
		else {
			// lookup and load hard policy file
			$success=0;

                        if (!$success) {
                                // site policy
                                $policypath= $GLOBALS['beryliumroot']."/files/".$site->name."/policies/";
                                $policy->name= $policy->flavor;
                                berror("getpolicy(): Going to look for root policy file at $policypath$policy->name.",1);
                                $path= $policypath.$policy->name;
                                if (file_exists($path)) {
                                        $policy->uploadPolicy($path);
                                        $success=1;
                                        }
                                }
			
                        if (!$success) {
                                // root policy
                                $policypath= $GLOBALS['beryliumroot']."/code/policies/";
                                $policy->name= $policy->flavor;
                                berror("getpolicy(): Going to look for root policy file at $policypath$policy->name.",1);
                                $path= $policypath.$policy->name;
                                if (file_exists($path)) {
                                        $policy->uploadPolicy($path);
                                        $success=1;
                                        }
                                else {
                                        // turn errorLevel back up
                                        berror("</blockquote>",1);	
                                        berror("applyPolicy(): No policy found to match your role ($policy->flavor) in this area. [bold:Server can not continue].",0);
                                        return 0;
                                        }
                                }
			}

		// turn errorLevel back up
		berror("Done with policies</blockquote>",1);

		berror("applyPolicy() called by $this->objtype id#$this->id ($this->name). [bold:Found policy $policy->flavor.]",1);

		// generate addins for select queries
		if ($policy->prequery!="") {
			berror("applyPolicy() processing preselect: ".$policy->prequery,2);
			eval($policy->prequery);
			}

		// default to very restrictive extras just in case
		if ($this->statuswhere=="") $this->statuswhere= " AND obj.status='posted' ";
		if ($this->publicwhere=="") $this->publicwhere= " AND obj.public=1 ";
		if ($this->statusfolder=="") $this->statusfolder= " AND folder.status='posted' ";
		if ($this->publicfolder=="") $this->publicfolder= " AND folder.public=1 ";
		if ($this->orderby=="") $this->orderby= "ORDER BY obj.id ASC";
		if ($this->insertstatus=="") $this->insertstatus= "new";
		if ($this->insertpublic=="") $this->insertpublic= "1";
		if ($this->insertrank=="") $this->insertrank= "100";
		//if ($this->updatestatus=="") $this->updatestatus= "changed";
		//if ($this->updatepublic=="") $this->updatepublic= "";
		//if ($this->updaterank=="") $this->updaterank= "";

		// OWNERSHIP CHECK
		berror("<b>Ownership Check</b> does $this->sitememberid == $sitemember->id?",1);
		if ($this->sitememberid==$sitemember->id) {
			$this->itemOwner= "1";
			berror("<b>Sitemember owns the object named $this->name...</b>",1);
			}
			
		// EDITORSHIP CHECK
		berror("<b>Editorship Check</b> does $policy->flavor==editor?",1);
		if ($policy->flavor=="editor") {
			$this->itemEditor= "1";
			berror("<b>Sitemember can edit.</b>",1);
			}

		// generate object addons
		if ($policy->addons!="") {
			berror("applyPolicy() processing default: ".$policy->addons,2);
			eval($policy->addons);
			}

		berror("applyPolicy() statuswhere=($this->statuswhere) and publicwhere=($this->publicwhere).",1);
		return 1;
		}


// database interface - insert, update, select, etc.
	function insertObject() {
		// insertObject inserts $this as a new database record
		berror("insertObject() called by ".get_class($this)." id#$this->id ($this->name). objtype=$this->objtype, siteid=".$GLOBALS['site']->id.", this->siteid=$this->siteid.",1);
		$success=0;

		// connect to database
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();

		// apply policy
		if ($this->objtype!="session" AND !$session->setup) {
			if (!($session->canSavenew[$this->objtype]  OR $session->canSave[$this->objtype] OR $session->canSave[all])) {
				berror("insertObject(): Failed to find a policy that allows you to save new $this->objtype objects. Server must halt.",0);
				exit;
				}
			// insertstatus-rank--public are all maximum values...
			if ($session->insertstatus!="posted") $this->status= "new";
			if ($session->insertpublic!="0") $this->public= 1;
			if ($this->rank > $session->insertrank) $this->rank= $session->insertrank;
			}

		// make sure some important fields are set
		if ($this->siteid=="") $this->siteid=$GLOBALS['site']->id;
		if ($this->folderid=="") $this->folderid=$GLOBALS['folder']->id;
		if ($this->sitememberid=="") $this->sitememberid=$GLOBALS['sitemember']->id;
		$this->sessionid= $session->id;

		// check for duplicate name in this folder
		if ($this->name!="") {
			$found= $this->checkDuplicate("name");
			if ($found) {
				// if this is owned or operated, prompt for overwrite -- NOT IMPLEMENTED!
				if (0 AND ($this->sitememberid==$GLOBALS['sitemember']->id OR $GLOBALS['sitemember']->role=="editor")) {
					$found=0;
					berror("insertObject() disallowing overwrite by owned and operated.",1);
					}
				
				// if this is in a different site, forget it unless this bit is set.
				elseif ($GLOBALS[allowoverwrite] AND $GLOBALS['sitemember']->rank=="admin") {
					berror("insertObject() allowing overwrite by admin.",1);
					$this->id= $found;
					$overwrite= $this->updateObject;
		
					return $overwrite;
					}

				else {
					berror("checkDuplicate(): A $this->objtype with the same $field already exists here. It is $this->objtype id#$found[id] with status=$found[status]. Please use the back button to change the name of the object you are trying to create or edit.",0);
					return 0;
					}
				}
			}

		// addslashes to all fields
		$this->beryliumToMySQL();



		// get columns from table description so we know what bits of this object to save
		$query= "DESCRIBE $this->objtype ";
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through the columns to build the insert query... created and updated are exceptional
		$queryvalues= "''";
		while (list($key,$val)= each($tablecolumn)) {
			if ($key=="id") {
				continue;
				}
			elseif ($key=="created" OR $key=="updated") {
				$queryvalues= $queryvalues.", now()";
				continue;
				}
			else {
				$newobject[$key]= $this->{$key};
				$queryvalues= $queryvalues.", '$newobject[$key]'";
				}
			}		

		// process insert query
		$query= "INSERT INTO $this->objtype VALUES ($queryvalues) ";
		$result= mysql_query($query);
		if (!$result) {
			berror("insertObject(): insert query failed to get a result. $query",1);
			}
		else {
			berror("insertObject(): [bold:Insert successful.] $query",1);
			$success= 1;
			}

		// update object with new id and unencode
		$this->id= mysql_insert_id();
		$this->mySQLToBerylium();

		return $success;
		}

	function updateObject() {
		// updateObject updates the database record for $this
		berror("updateObject() called by ".get_class($this)." id#$this->id ($this->name) (path=$this->path) (status=$this->status)",1);
		$success=0;
		$postvars= $_POST;

		// connect to database
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();
		$this->sessionid= $session->id;

		// apply policy
		if ($this->objtype!="session") {
			if (!($session->canSave[$this->objtype] OR $session->canSave[all])) {
				berror("updateObject(): Failed to find a policy that allows you to save $this->objtype objects. Server must halt.",0);
				exit;
				}
			if ($session->updatestatus!="") $this->status= $session->updatestatus;
			if ($session->updatepublic!="") $this->public= $session->updatepublic;
			if ($session->updaterank!="") $this->rank= $session->updaterank;
			}

		// check for duplicate name in this folder
		if ($this->siteid=="") $this->siteid=$GLOBALS['site']->id;
		if ($this->name!="") {
			$found= $this->checkDuplicate("name");
			if ($found) {
				return 0;
				}
			}
                        
                // load comparison object to check for lock and unpassed p_keys
                $command= "\$temp= new ".ucfirst($this->objtype).";";
                eval($command);
                $query= "SELECT obj.* FROM $this->objtype AS obj WHERE obj.id='$this->id' ";
                $temp->selectObject($query);
                berror("updateObject(): loaded temp $this->objtype with id=$temp->id.",1);
                if ($temp->locked) {
                    berror("updateObject(): $temp->objtype:$temp->id ($temp->title) is locked by the database administrator. Cannot continue at this time.",0);
                    exit;
                    }
                  
                
                // check for unpassed p_keys that we shouldn't overwrite...
                if (is_array($temp->propertiesarray)) {
			foreach ($temp->propertiesarray AS $pkey=>$pvalue) {
                                if (trim($pkey)=="") {
                                      berror("updateObject(): empty pkey.",1);
                                      continue;
                                      }
				$p_pkey= "p_$pkey";
				if ($this->{$p_pkey}=="" AND $postvars[$p_pkey]=="") {
                                      $this->{$p_pkey}= stripslashes($pvalue);
                                      berror("updateObject(): From db, this->$p_pkey=".$this->{$p_pkey},1);
                                      }
                                else berror("updateObject(): this->$p_pkey is being updated, skipping.",1);
				}
			}
                    
                    
                    
                    
		// addslashes to all fields, merge p_keys into $this->properties
		$this->beryliumToMySQL();

		// get columns from table description so we know what bits of this object we can save
		$query= "DESCRIBE $this->objtype ";
		berror("updateObject inspecting table with query=$query; ",1);
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {
			berror("updateObject() extracting column ".$columnarray['Field'],2);
			$thisfield= $columnarray["Field"];
			$tablecolumn[$thisfield]= $a;
			$a++;
			}

		// run through columns to build the update query
		$queryvalues= "updated= now()";
		foreach ($tablecolumn AS $key=>$val) {
			if ($key=="id" OR $key=="created" OR $key=="updated") {
				berror("updateObject() continuing because of $key being created or updated.",2);
				continue;
				}

			if ($this->objtype!="session" AND ($key=="siteid" OR $key=="sitememberid")) {
				berror("updateObject() continuing on siteid or sitememberid (objtype!=session). ($key)",2);
				continue;
				}

			if ( $this->{$key}=="" ) {
				berror("updateObject() continuing for this->$key='' (".$this->{$key}.") and postvars[$key] is '' also. (<b>".$postvars[$key]."</b>)",2);
				continue;
				}
			else {
				berror("updateObject() setting newobject[$key]=".$this->{$key}.".",2);
				$newobject[$key]= $this->{$key};
				$queryvalues= $queryvalues.", $key= '$newobject[$key]'";
				}
			}		

		// process the update query
		$query= "UPDATE $this->objtype SET $queryvalues WHERE id='$this->id' ";
		$result= mysql_query($query);
		if (!$result) {
			berror("updateObject(): update query failed to get a result. $query; (".mysql_error().")",1);
			}
		else $success=1;

		// unencode object
		$this->mySQLToBerylium();
                
                // get the date and time in case we need it.
                $this->updated= date("Y-m-d H:i:s");

		berror("updateObject(): [bold:update successful]. $query;",1);
		return $success;
		}

	function selectObject($query) {
		// selectObject runs a query on the database and returns an $objectarray of results
		//    as well as loading the first object into $this
		berror("selectObject() called by ".get_class($this)." id#$this->id ($this->name) with query=$query;",1);
		$success=0;

		// connect to database
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();
		

		// get the result set
		$result= mysql_query($query);
		if (!$result) {
			berror("selectObject(): query failed to get a result: (".mysql_error().")",1);
			return 0;
			}

		// take first result and load it into $this object
		$objectarray[0]= mysql_fetch_array($result);
		if (is_array($objectarray[0])) {
			foreach($objectarray[0] as $key=>$value) {
				if (is_int($key)) continue;
				if ($key=="properties" AND trim($value)!="") {
					berror("selectObject() found properties ($value), unpacking...",1);
					// unpack properties into propertiesarray
					$this->propertiesarray= bunpack($value);
					
					// unpack properties array into p_keys
					if (is_array($this->propertiesarray)) {
						foreach ($this->propertiesarray AS $pkey=>$pvalue) {
                                                        if (trim($pkey)=="") {
                                                            berror("selectObject(): empty pkey.",1);
                                                            continue;
                                                            }
							$p_pkey= "p_$pkey";
							$this->{$p_pkey}= $pvalue;
							berror("selectObject(): this->$p_pkey=".$this->{$p_pkey},1);
							}
						}
					continue;
					}
				$this->{$key}= $value;
				}
			$success= 1;
			$n=1;

			while ($objectarray[$n]= mysql_fetch_array($result)) {
				$n= $n+1;
				$success= $n;
				}
			}

		else {
			berror("selectObject(): Empty result found at $result. ",1);
			$success= 0;
			}
		
		$this->listsize= $success;
		return $objectarray;
		}

	function getMySQLColumns($objtype="BeryliumObject") {
		// gets the mySQL column_definition from a BeryliumObject of type $objtype for makeTable()
		//   allows objects to define their own SQL tables
		berror("getMySQLColumns() called by ".get_class($this)." id#$this->id ($this->name).",1);

		//create a temporary object
		$command= "\$temp= new $objtype;";
		berror("getMySQLColumns(): Command=$command",2);
		eval("$command");

		//unpack the ^ delimited columns, then use that array to build the column_definition 
		$columns= bunpack($temp->columns);
		while (list ($key, $val)= each($columns)) {
			$column_definition= $column_definition.", $key $val";
			}
		$column_definition= substr($column_definition,2);

		// recurse back through parent classes
		if ($parentclass= get_parent_class($temp)) {
			$prepend= $temp->getMySQLColumns($parentclass);
			if ($prepend!="" AND $column_definition!=" ") $column_definition= $prepend.", ".$column_definition;
			elseif ($prepend!="") $column_definition= $prepend;
			}

		// return the column definition
		berror("getMySQLColumns(): Returning column definition: $column_definition",2);
		return $column_definition;
		}

	function makeTable() {
		// initializes a table to hold this type of object
		berror("makeTable() called by ".get_class($this)." id#$this->id ($this->name).",1);

		if (!$this->classname= get_class($this)) {
			berror("makeTable(): can't figure out classname of this '$this->objtype' object. Sad face.",0);
			}

		// connect to database
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();

		// use getMySQLColumns() to build the Create Table query		
		$query="CREATE TABLE ".$this->objtype." (".$this->getMySQLColumns($this->classname).") ";
		$result= mysql_query($query);

		if (!$result) {
			berror("makeTable(): Error on Create Table query= '$query'; (".mysql_error().")",1);
			$success=0;
			}
		else $success=1;

		return $success;
		}

	function checkDuplicate($field="name") {
		// checks the database for a similar object with the same name (or some other field)
		berror("checkDuplicate() called on '$field' by $this->objtype id#$this->id ($this->name) in site=$this->siteid and folder=$this->folderid.",1);

		// sites must have unique names, period
		if ($this->objtype=="site" and $field=="name") $nonfolder="";

		// folders, must be named uniquely sitewide
		if ($this->objtype=="folder" AND $field=="name") $nonfolder= "AND siteid='$this->siteid' ";

		// otherwise name must be unique to containing folder only
		else $nonfolder= "AND folderid='$this->folderid' ";
		
		// its okay for some things to have duplicate names as long as the older ones are deleted first...
		if ($this->objtype=="event") $deletedokay= "AND status!='deleted' ";

		// build query -- it's okay if $this->id=="" because then it won't be equal to any other ids, will it?
		$query= "SELECT id,name,status FROM $this->objtype WHERE id!='$this->id' AND $field='".$this->{$field}."' $nonfolder $deletedokay";
		$result= mysql_query($query);

		berror("checkDuplicate() is checking for duplicate $this->objtype using query=$query",1);

		if ($duplicate= @mysql_fetch_array($result)) {
			berror("checkDuplicate(): A $this->objtype with the same $field already exists here. It is $this->objtype id#$duplicate[id] with status=$duplicate[status]. Please use the back button to change the name of the object you are trying to create or edit.",1);
			$found=$duplicate;
			}
		else $found=0;

		return $found;
		}


// encode/decode, translation, etc.
	function beryliumToHtml() {
		// processes text fields for html display with bml parsed -- not reversible!
		// theory: removes all html tags, curly brackets "{}" and doublequotes from user input, converts newlines to <br>, and parses bml
                // should also replace single quotes with some entity
		// warning: only works with text in ISO-Latin-1 charset!!!
		berror("beryliumToHtml() called by ".get_class($this)." id#$this->id ($this->name).",1);

                if ($this->currentFormat!="text/html") {
                  $objectproperties= get_object_vars($this);
                  foreach ($objectproperties as $key=>$value) {
                          if (!is_string($value)) continue;
                          $this->{$key}= bHtml($value);
                          }
                  $this->currentFormat= "text/html";
                  }
                else berror("beryliumToHtml() redundant call, format is already $this->currentFormat.",1);

		return 1;
		}

	function beryliumToForm() {
		// processes text fields for html display -- reversible
		// theory: removes all html tags and doublequotes from user input (" becomes &quot;)
		// warning: only works with text in ISO-Latin-1 charset!!!	
		berror("beryliumToForm() called by ".get_class($this)." id#$this->id ($this->name).",1);

		if ($this->currentFormat!="text/bml" && $this->currentFormat!="text/html") {
                  $objectproperties= get_object_vars($this);
                  foreach ($objectproperties as $key=>$value) {
                          if (!is_string($value)) continue;
                          $this->{$key}= htmlentities($value);
                          }
                  $this->currentFormat= "text/bml";
                  }
                elseif ($this->currentFormat!="text/html") {
                  berror("beryliumToForm() can't process, format is already $this->currentFormat.",1);
                  }
                else berror("beryliumToForm() redundant call, format is already $this->currentFormat.",1);

		return 1;
		}

	function formToBerylium() {
		// reverts html-encoded text back to regular chars (&quot; becomes ")
		// warning: only works with text in ISO-Latin-1 charset!!!	
		berror("formToBerylium() called by ".get_class($this)." id#$this->id ($this->name).",1);

		// reverse the htmlentities translation table...
		$trans = get_html_translation_table(HTMLENTITIES);
		$trans = array_flip ($trans);

		$objectproperties= get_object_vars($this);
		foreach ($objectproperties as $key=>$value) {
			if (!is_string($value)) continue;
			$this->{$key}= strtr($value, $trans);
			}
                $this->currentFormat= "text/plain";

		return 1;
		}

	function beryliumToMySQL() {
		// processes all fields for insertion into database -- reversible
		// theory: escapes quotes and doublequotes in user input so they don't break query strings (" becomes \")
		berror("beryliumToMySQL() called by ".get_class($this)." id#$this->id ($this->name) (path=$this->path).",1);

		$objectproperties= get_object_vars($this);
		unset($this->propertiesarray);
		foreach ($objectproperties as $key=>$value) {
			if (!is_string($value) &&!is_numeric($value)) continue;
			if (substr($key,0,2)=="p_" && trim($value)!="") {
				// create properties array
				$propname= substr($key,2);
				$this->propertiesarray[$propname]= addslashes($value);
				berror("beryliumToMySQL() adding $propname to the properties array.",1);
				continue;
				}
			$this->{$key}= addslashes($value);
			}
		if (is_array($this->propertiesarray)) {
			// packup properties
			$this->properties= bpack($this->propertiesarray);
			berror("beryliumToMySQL() properties array packed as: $this->properties",1);
			}
		else $this->properties= " ";

                $this->currentFormat= "text/php";
		return 1;
		}

	function mySQLToBerylium() {
		// removes quoting
		// theory: unescapes quotes and doublequotes in user input (\" becomes ")
		berror("mySQLToBerylium() called by ".get_class($this)." id#$this->id ($this->name).",1);

		$objectproperties= get_object_vars($this);
		foreach ($objectproperties as $key=>$value) {
			if (!is_string($value)) continue;
			if ($key=="properties" AND trim($value)!="") {
				berror("mySQLToBerylium() found properties, unpacking...",1);
				// unpack properties into propertiesarray
				$this->propertiesarray= bunpack($value);
				
				// unpack properties array into p_keys
				if (is_array($this->propertiesarray)) {
					foreach ($this->propertiesarray AS $pkey=>$pvalue) {
						$p_pkey= "p_$pkey";
						$this->{$p_pkey}= stripslashes($pvalue);
						berror("mySQLToBerylium(): this->$p_pkey=".$this->{$p_pkey},1);
						}
					}
				continue;
				}
			$this->{$key}= stripslashes($value);
			}

                $this->currentFormat= "text/plain";
		return 1;
		}

	function timeFormat($format='D M j, Y, \a\t H:i:s') {
		// mysqltimestamp()s $this->created and $this->modified to UNIX timestamps
                //     $this->createdStamp $this->modifiedStamp, then translates 
                //      by $format, replacing $this->created and $this->modified 
                //      with nice dates
		berror("timeFormat() called with '$format' by ".get_class($this)." id#$this->id ($this->name).",1);

                if ($this->timeFormatted=="") {
                    $this->updatedSql= $this->updated;
                    $this->updatedStamp= mysql_timestamp($this->updatedSql);
                    $this->createdSql= $this->created;
                    $this->createdStamp= mysql_timestamp($this->createdSql);
                    }
                    
                $this->created= date($format, $this->createdStamp);
                berror("timeFormat(): $this->createdSql was translated as $this->created.",2);
    

                $this->updated= date($format, $this->updatedStamp);
                berror("timeFormat(): $this->upatedSql was translated as $this->updated.",2);
    
                $this->timeFormatted= $format;
		return 1;
		}
                
        function getRuntimeVars() {
                // call this *after* $this->beryliumToHtml in preprocess to enable runtimevars
                // see docs/runtimevars.txt for a list of them
                // if you add something here, update that document. Thanks.
                if (1) {
                  // format time and get path info
                  $this->timeFormat("F j, Y \a\\t g:ia");
                  $this->getBaseUrl();
                  
                  // dateTag: created or p_originaldate
                  if ($this->p_originaldate) {
                          $origdate= mysql_timestamp($this->p_originaldate);
                          $this->originaldate= date("l, F j, Y", $origdate);
                          $this->dateTag= $this->originaldate;
                          }
                  else $this->dateTag= $this->created;
                  
                  // publishStatus, glow, iconpvt: compile publishStatus ( like: public-posted-100 ), iconpvt, and glow
                  switch (true) {
                          case ($this->rank < 100) : 
                                  $this->lightrank= 50;
                                  break;	
                          case ($this->rank < 500) :
                                  $this->lightrank= 100;
                                  break;
                          case ($this->rank < 1000) :
                                  $this->lightrank= 500;
                                  break;
                          case ($this->rank >= 1000) :
                                  $this->lightrank= 1000;
                                  break;
                          }
                  if ($this->public) {
                          $this->publishStatus= "public-$this->status-$this->rank";
                          $this->glow= "public-$this->status-$this->lightrank";
                          }
                  else {
                          $this->publishStatus= "private-$this->status-$this->rank";
                          $this->glow= "private-$this->status-$this->lightrank";
                          $this->iconpvt= "-pvt";
                          }
                  if ($this->status=="deleted") $this->glow= "deleted";
                  
                  // iconTag: show default icon or alt icon from imageid
                  if ($this->imageid!="0") {
                          $this->iconTag= bparsebml("[icon:$this->imageid;$this->objtype:$this->id]");
                          }
                  else $this->iconTag= "<a href='$this->baseUrl'><img src='/bicons/$this->objtype$this->iconpvt.gif' border=0 alt='icon' title='$this->objtype:$this->id'></a>";
                  
                  // authorTag: show sitemember if no author defined
		  $this->authorName= bparsebml("[sitemember:$this->sitememberid]");
                  if (trim($this->author)== "") {
		  	$this->authorTag= $this->authorName;
			}
                  else $this->authorTag= $this->author;
                  
                  }
                }
		
	function getParent () {
		$command= "\$parentobject= new ".ucfirst($this->parentobjtype).";";
		eval($command);
		$parentobject->id= $this->parentid;

		$query= "SELECT * FROM $this->parentobjtype WHERE id='$this->parentid' AND siteid='$this->siteid' ";
		$parentobject->selectObject($query);
		$parentobject->getBaseURL();
		berror("object->getParent(): Parent [link:$parentobject->baseUrl;$parentobject->name] (#$parentobject->id) has been constructed as the parent of $this->objtype $this->id.",1);

		return $parentobject;
		}

	function parseCBML($field){
		// finds and translates commands written in curly-bracket markup language {cbml} within contexts
		// see cbml-engine.php
		// note that field is $this->context->field, not $this->field -- why? not quite sure yet.
		berror("[color:#ff6600;parseCBML() called with '$field' by $this->objtype id#$this->id ($this->name).]",1);

		$site= $GLOBALS['site'];
		$folder= $GLOBALS['folder'];
		$session= $GLOBALS['session'];
		$containers= $GLOBALS['containers'];
                $object= $GLOBALS['object'];
                

		$code= $this->context->{$field};
		berror("[color:#ff6600;parseCBML() code=".htmlentities($code).".]",1);
		berror("parseCBML(): policy report: this->publicwhere= $session->publicwhere.",2);

		// assume markup will be found
		$found=1;
		$end=0;
	
		//begin parsing loop
		while ($found) {
			// sanity time
			if ($end>=strlen($code)) {
				berror("parseCBML(end ($end) is greater than the string length of code, exiting loop.)",1);
				$found=0;
				continue;
				}

			// find command start
			$start= strpos($code, "{", $end);
			if ($start===false) {
				berror("parseCBML( No more { found after $end. )",1);
				$found=0;
				continue;
				}
			else berror("parseCBML( First { after $end is at $start. )",1);
			
			// look for at least one right bracket, otherwise this is madness!
			$endmost= strrpos($code, "}");
			if ($endmost===false) {
				berror("parseCBML( no endmost }, unclosed brackets, aborting.)",1);
				$found=0;
				continue;
				}
			else berror("parseCBML( The last }  is at $endmost. )",1);
	
			// check for command
			$commandend= strpos($code, ":", $start);
			if ($commandend===false) {
				$end= $start+1;
				berror("parseCBML( No command found after $start. end=$end now. strlen(code)=".strlen($code).")",1);
				continue;
				}
			else berror("parseCBML( A : was found at $commandend. )",1);
	
			// if the alleged "command" ends after the last right bracket, it isn't one.
			if ($commandend>$endmost) {
				berror("parseCBML( But that : at $commandend is further out than the endmost } at $endmost, aborting. )",1);
				$found=0;
				continue;
				}
	
			// find a likely endpoint for this tag
			$anend= strpos($code, "}", $start);
			berror("parseCBML( Next } after $start found at $anend. )",1);

			// is there lunacy here? something like "[bold=boldme] blah blah [ital:italic]"???
			if ($commandend>$anend) {
				berror("parseCBML( Lunacy here, command end (:) at $commandend is greater than } found at $anend, so trying another loop.)",1);
				$end= $start+1;
				continue;
				}
	
	
			// nested markup is not allowed in cbml!
			/*
			$next= strpos($code, "{", $start+1);
			berror("parseCBML(Next { at $next)",1);
	
			if ($next<$anend AND !($next===false)) {
				$nestlen= $endmost-$start;
				$nest= substr($code, $start+1, $nestlen);
				$code= substr($code, 0, $start+1).bparsebml($nest).substr($code, $endmost+1);
				}
			// nested markup was not allowed in cbml!
			*/
	
	
			// okay, now we can find the one living and true end
			$end= strpos($code, "}", $start);
			if ($end===false) {
				$found=0;
				continue;
				}
			berror("parseCBML( The } found $end is declared to be the true end of this statement. )",1);

	
			// check for command again
			$commandend= strpos($code, ":", $start);
			if ($commandend===false) continue;
			berror("parseCBML(The : found at $commandend is declared to be the true end of this command.)",1);

	
			// and again, if the : is outside the end bracket, forget it.
			if ($commandend>$end) {
				berror("parseCBML(The : at $commandend is outside of the } at $end, so forget it.)",1);
				continue;
				}
			
			// get command
			$commandlen= $commandend-$start-1;
			$command= substr($code, $start+1, $commandlen);
			if (trim($command)=="") {
				berror("parseCBML( No command found! )",1);
				continue;
				}
	
			// define tag
			$taglen= $end-$commandend-1;
			$tag= substr($code, $commandend+1, $taglen);

		//parse the tag for variables.
		$commandv= "\$tag= \"$tag\";";
		//$this->applyPolicy();
		berror("parseCBML() parsing $tag for variables: $commandv. ($this->imageid)<blockquote>",1);
		eval($commandv);
	
			// with $command and $tag in hand, run the bmlengine
			include("$GLOBALS[beryliumroot]/code/cbml-engine.php");
	
			// make the substitution
			$code= substr($code, 0, $start).$tag.substr($code, $end+1);
			berror("</blockquote>parseCBML( Substitution made, <b>continuing.</b> )",1);
			
			// adjust the endpoint-- $start + strlen($tag)
			$taglength= strlen($tag);
			berror("parseCBML( Cleaning up, the end is really at $start+$taglength, or ".($start+$taglength).", but we'll go ahead and start looking at ".($start+1).". )",1);
			//$end= $start+$taglength;
			$end= $start+1;
			} //end while
	
		$this->context->{$field}= $code;
		}
		


// requestable methods (lookup, view, save, list, etc.)

        function lookup() {
		// get object from the database
		// requires an object with objtype and name, and a folder with id from $containers[0] and $session->request->(method,format)
		berror("lookup() called by '$this->objtype' object id#$this->id ($this->name).",1);
		
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$folder= $GLOBALS['folder'];
		$request= $GLOBALS['session']->request;
                
		// impose a folderid requirement if this isn't a site or folder...
		if ($this->objtype!="folder" AND $this->objtype!="site") $notafolder= "AND obj.folderid='$folder->id' ";

		// apply policy
		if ($this->objtype!="policy") $query= "SELECT * FROM $this->objtype AS obj WHERE obj.name='$this->name' AND obj.siteid='$site->id' $notafolder $session->statuswhere $session->publicwhere $session->orderby $session->limit";
		else $query= "SELECT * FROM $this->objtype AS obj WHERE obj.name='$this->name' AND obj.siteid='$site->id' $notafolder $session->statuswhere $session->orderby $session->limit";
		if ($this->objtype=="context") {
			$this->parseName();
			$this->selectContext();
			}
		else $this->selectObject($query); 
                
                if ($this->listsize) {
                        berror("lookup() found primary '$this->objtype' object: (#$this->id)/($this->name).",1);
                        return 1;
                        }
                else {
                        berror("lookup() found no primary object, will look for list later with id=0.",1);
                        return 0;
                        }
                }

	function view() {
		// get context, render -- works for edit, too!
		// requires this->lookup to be performed first.
		berror("view() called by '$this->objtype' object id#$this->id ($this->name).",1);
		
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$folder= $GLOBALS['folder'];
		$request= $GLOBALS['session']->request;

		// get object context
		$this->getContext($request->method, $request->format);

// primary lookup code has moved into this->lookup() above

		if ($this->listsize) {
			berror("view() found '$this->objtype' object id#$this->id ($this->name), now rendering.",1);
			$this->preProcess();
			$this->css($GLOBALS['session']);
			if ($this->objtype!="site" AND $this->objtype!="folder") $this->header($GLOBALS['session']);
			if ($this->showNull) $this->nullObject($GLOBALS['session']);
			else $this->template($GLOBALS['session']);
			if ($this->objtype!="site" AND $this->objtype!="folder") $this->footer($GLOBALS['session']);
			$this->postProcess();
			}
		elseif ($this->name=="0") {
			$query= "SELECT * FROM $this->objtype AS obj WHERE 1 $notafolder $session->whereposted $session->wherepublic $session->orderby $session->limit";
			$this->selectObject($query);
			if ($this->listsize) {
				$output= blist($query,"list");
				boutput($output, $GLOBALS['session']);
				}
			else {
				berror("view() didn't find any (using id=0) '$this->objtype' object id#$this->id, null object.",1);
				$this->preProcess();
				$this->css($GLOBALS['session']);
				if ($this->objtype!="site" AND $this->objtype!="folder") $this->header($GLOBALS['session']);
				$this->nullObject($GLOBALS['session']);
				if ($this->objtype!="site" AND $this->objtype!="folder") $this->footer($GLOBALS['session']);
				$this->postProcess();
				}

			}
		elseif (is_numeric($this->name) && $this->name > 0) {
			$this->id= $this->name;
			$query= "SELECT * FROM $this->objtype AS obj WHERE obj.id='$this->id' $notafolder $session->whereposted $session->wherepublic $session->orderby $session->limit";
			$this->selectObject($query);
			if ($this->listsize) {
				berror("view() found (using id) '$this->objtype' object id#$this->id ($this->name), now rendering.",1);
				$this->preProcess();
				$this->css($GLOBALS['session']);
				if ($this->objtype!="site" AND $this->objtype!="folder") $this->header($GLOBALS['session']);
				if ($this->showNull) $this->nullObject($GLOBALS['session']);
				else $this->template($GLOBALS['session']);
				if ($this->objtype!="site" AND $this->objtype!="folder") $this->footer($GLOBALS['session']);
				$this->postProcess();
				}
			else {
				berror("view() didn't find (using id) '$this->objtype' object id#$this->id, null object.",1);
				$this->preProcess();
				$this->css($GLOBALS['session']);
				if ($this->objtype!="site" AND $this->objtype!="folder") $this->header($GLOBALS['session']);
				$this->nullObject($GLOBALS['session']);
				if ($this->objtype!="site" AND $this->objtype!="folder") $this->footer($GLOBALS['session']);
				$this->postProcess();
				}
			}
		else {
			berror("view() didn't find '$this->objtype' object id#$this->id ($this->name), null object.",1);
			$this->preProcess();
			$this->css($GLOBALS['session']);
			if ($this->objtype!="site" AND $this->objtype!="folder") $this->header($GLOBALS['session']);
			$this->nullObject($GLOBALS['session']);
			if ($this->objtype!="site" AND $this->objtype!="folder") $this->footer($GLOBALS['session']);
			$this->postProcess();
			}
		
		return 1;
		}

	function save() {
		// build object from HTTP_POST_VARS, get context, process, save, postprocess
		// requires $this->objtype, POST_VARS with optional id, and $session->request->(method,format)
		berror("save() called by '$this->objtype' object id#$this->id ($this->name) (path=$this->path).",1);
		
		$posto= $_POST;
		$request= $GLOBALS['session']->request;

		if ($this->objtype!="folder") {
			// load POST data into object (folders are special)
			foreach ($posto as $key=>$value) {
				$this->{$key}= $value;
				}
			}

		// has the "Create New" button been pressed? 
		if ($this->Submit2=="create new") {
			$this->id= "";
			}

		// get context for pre- and post-processing and role control
		$this->getContext($request->method, $request->format);

		$this->preProcess();
		if ($this->objtype!="site" AND $this->objtype!="folder") $this->header($GLOBALS['session']);
		$this->template($GLOBALS['session']);
		if ($this->objtype!="site" AND $this->objtype!="folder") $this->footer($GLOBALS['session']);
		if ($this->id!="") $this->updateObject();
		else $this->insertObject();
		
		// is there an attachement?
		if ($this->useupload) {
			$uploaded= $this->upload();
			if ($uploaded) {
				berror("Image->save(): file uploaded and saved at $this->path ($this->uri), continuing with db update.",1);
				$this->updateObject();
				}
			}
		elseif ($this->useimport) {
			$imported= $this->import();
			if ($imported) {
				berror("Image->save(): file imported and saved at $this->path ($this->uri), continuing with db update.",1);
				$this->updateObject();
				}
			}
		$this->postProcess();
		
		return 1;
		}


// object-fu: makeAlias, copy, move

	function move($newfolder, $newparent="") {
		berror("move(): called by $this->objtype $this->name (#$this->id), moving into $newfolder->name.",1);

		// must be called with at least object $newfolder
		if (!is_object($newfolder) || $newfolder->id=="") {
			berror("move(): called with missing or unloaded newfolder object.",1);
			return 0;
			}
		if (is_object($newparent) && $newparent->id=="") {
			berror("move(): called with newparent ($newparent->objtype $newparent->name) but it has no id.",1);
			return 0;
			}
		elseif (is_object($newparent)) {
			$withparent= 1;
			}
			
		// change folderid (and parentid and parentobjtype)
		$this->oldfolderid= $this->folderid;
		$this->folderid= $newfolder->id;
		if ($withparent) {
			$this->parentid= $newparent->id;
			$this->parentobjtype= $newparent->objtype;
			}
			
		// move any associated files
		if ($this->objtype=="folder") {
			// folders are special, you gotta rename them AND move the files...
			$this->oldname= $this->name;
			$localname= basename($this->oldname);
			if ($newfolder->name=="/") $this->name= "/$localname";
			else $this->name= "$newfolder->name/$localname";
			$oldpath= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name.$this->oldname;
			$newpath= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name.$this->name;
			
			$currentfolder= bparsebml("[folder:$this->oldfolderid]");
			berror("move(): called on a folder object $this->oldname, which is currently in $currentfolder (#$this->oldfolderid). Going to move it to $this->name in $newfolder->title (#$this->folderid).",1);
			berror("move():  (And files from $oldpath to $newpath.)",1);
			
			if (rename($oldpath, $newpath)) {
				berror("move(): file move successful.",1);
				$this->updateObject();
				}
			else {
				berror("move(): unable to rename image file: from $this->path to $renamepath. Not updated.",0);
				return 0;
				}
			
			return 1;
			}
			
		// if image, update path and uri
		elseif ($this->objtype=="image") {
			if (!file_exists($this->path)) {
				berror("move(): not moving any files: $this->path does not exist.",1);
				$this->updateObject();
				}
			else {
				$dir= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name.$newfolder->name;
				$base= basename($this->path);
				$dotpos= strrpos($base, ".");
				if ($dotpos) {
					$newname= substr($base,0,$dotpos);
					$ext= substr($base,$dotpos);
					}
				$renamepath= "$dir/$newname$ext";
				berror("move(): set to move image file $this->path to $renamepath.",1);
				if (rename($this->path, $renamepath)) {
					berror("move(): file move successful. Updating object:",1);
					$this->updateObject();

					// get new path and uri information
					$this->getBaseUrl();
					berror("Image->save(): rename finishing. New path is ($this->path), new uri is ($this->uri).",1);
					$this->updateObject();
					return 1;
					}
				else {
					berror("move(): unable to rename image file: from $this->path to $renamepath. Not updated.",0);
					return 0;
					}
				}
			return 1;
			}
		else {
			berror("move(): not moving any files for this $this->objtype, just updating the folderid ($this->oldfolderid becomes $this->folderid) ",1);
			if ($withparent) berror("move():  and parentid (to $this->parentobjtype:$this->parentid)",1);
			$this->updateObject();
			return 1;
			}
			
		return 0;
		}
		
	function getOriginal() {
		// merges original object with current
		if ($this->originalid!="" && $this->originalid!="0") {
			berror("getOriginal() will now load the original object at $this->objtype:$this->originalid.",1);
			$command= "\$original= new ".ucfirst($this->objtype).";";
			$void= eval($command);
			$session= $GLOBALS['session'];

			//load original
			$query= "SELECT obj.* FROM $this->objtype AS obj WHERE id='$this->originalid' $session->statuswhere $session->publicwhere";
			if (!$original->selectObject($query)) {
				berror("getOriginal() <b>original object is not available!</b>",1);
				return 0;
				}
				
			// set up alias vars on this object
			$this->aliasid= $this->id;

			// break it out into bits
			foreach(get_object_vars($original) as $key=>$value) {
					if ($key=="id" || $key=="originalid") continue;
					if ($key=="properties") $key= "inherited";
					berror("getOriginal() found $key.",1);
					if ($this->{$key}!="") {
						berror("getOriginal() but child object aleady has $key=".$this->{$key}.".",1);
						continue;
						}
					$this->{$key}= $value;
					}

			$this->originalObject= $original;
			return 1;
			}

		return 0;
		}


// context-related methods

	function getContext($method="", $format="") {
		// getContext() looks back through the containers array for just the right context to use: the first one it finds.
		// If context is not found in any of these places, the object cannot be rendered.
		berror("[color:#0033CC;getContext() called by $this->objtype id $this->id ($this->name).] (local method='$method', local format='$format')",1);
		
		// use the following to turn db lookup of contexts on(1)/off(0)
		$dbcontexts=1;
                //$GLOBALS['session']->standardContext= $_GET['standardContext'];

		$success= 0;
		$session= $GLOBALS['session'];
		$sitemember= $GLOBALS['sitemember'];
		$containers= $GLOBALS['containers'];
		$folder= $GLOBALS['folder'];
		$context= new Context;	// dbcontext, if any
		$fcontext= new Context;  // filesystem context

		if ($method=="") $method= $session->request->method;
		if ($format=="") $format= $session->request->format;

		// turn down the errorLevel for all these queries
		$olderror= $session->errorLevel;
		//$GLOBALS['session']->setErrorLevel(0);
		berror("<blockquote>",1);

		if ($dbcontexts AND !$session->p_standardContext) {
			// note that contexts coming from the database do not (may not?) include pre- and post-process fields...
			// also, only specific classes (no generic) may be found in the db

			// 1) class-specific, role-editor, up through folders
			if (!$success AND ($sitemember->role=="editor" OR $sitemember->role=="admin")) {
				foreach ($containers as $key=>$value) {
					if (!is_numeric($key)) continue;
					berror("[bold:getContext():] db lookup class-specific for editor in container: $value->name.",1);
					if ($success) continue;
					$folderid= $value->id;
					$query= "SELECT * FROM context WHERE method='$method' AND format='$format' AND role='editor' AND classname='$this->objtype' AND folderid='$folderid' AND status='posted' ";
					$context->selectObject($query);
					if ($context->id!="") {
						$success=1;
						}
					}	
				}
                                
			// 1) class-specific, role-writer, up through folders
			if (!$success AND ($sitemember->role=="writer" OR $sitemember->role=="editor" OR $sitemember->role=="admin")) {
				foreach ($containers as $key=>$value) {
					if (!is_numeric($key)) continue;
					berror("[bold:getContext():] db lookup class-specific for writer in container: $value->name.",1);
					if ($success) continue;
					$folderid= $value->id;
					$query= "SELECT * FROM context WHERE method='$method' AND format='$format' AND role='writer' AND classname='$this->objtype' AND folderid='$folderid' AND status='posted' ";
					$context->selectObject($query);
					if ($context->id!="") {
						$success=1;
						}
					}	
				}
                      
			// 1) class-specific, role-member, up through folders
			if (!$success AND ($sitemember->role=="member" OR $sitemember->role=="writer" OR $sitemember->role=="editor" OR $sitemember->role=="admin")) {
				foreach ($containers as $key=>$value) {
					if (!is_numeric($key)) continue;
					berror("[bold:getContext():] db lookup class-specific for member in container: $value->name.",1);
					if ($success) continue;
					$folderid= $value->id;
					$query= "SELECT * FROM context WHERE method='$method' AND format='$format' AND role='member' AND classname='$this->objtype' AND folderid='$folderid' AND status='posted' ";
					$context->selectObject($query);
					if ($context->id!="") {
						$success=1;
						}
					}	
				}
	
			// 2) class-specific, role-anonymous, up through folders
			if (!$success) {
				foreach ($containers as $key=>$value) {
					if ($success) continue;
					if (!is_numeric($key)) continue;
					berror("[bold:getContext():] db lookup class-specific, for anonymous in container: $value->name.",1);
					$folderid= $value->id;
					$query= "SELECT * FROM context WHERE method='$method' AND format='$format' AND role='anonymous' AND classname='$this->objtype' AND folderid='$folderid' AND status='posted' ";
					$context->selectObject($query);
					if ($context->id!="") {
						$success=1;
						}
					}
				}
	
			} // end if ($dbcontexts)

		// NOW look for contexts (or maybe just pre- and post-process...) in filesystem...
		$fsuccess= 0;
		if ($folder->flavor!="folder") $fcontext->flavorpath= "$folder->flavor/";
                
                
		// first pass site contexts with folder->flavor...
                if (!$fsuccess AND !$session->p_standardContext ) {
                        $fcontextpath= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name."/contexts/$fcontext->flavorpath";
                        
                        // class-specific, role specific
                        $fcontext->name= "$this->objtype-$method-$sitemember->role-$format";
                        berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                        $path= $fcontextpath.$fcontext->name;
                        if (file_exists($path)) {
                                $fcontext->uploadContext($path);
                                $fsuccess=1;
                                }
                                
                        // class-specific, role editor
                        if (!$fsuccess && $sitemember->role=="admin") {
                                $fcontext->name= "$this->objtype-$method-editor-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-specific, role writer
                        if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "$this->objtype-$method-writer-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                        
                        // class-specific, role member
                        if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "$this->objtype-$method-member-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                                        
                        // class-specific, role anonymous
                        if (!$fsuccess && $sitemember->role!="anonymous") {
                                $fcontext->name= "$this->objtype-$method-anonymous-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role specific
                        if (!$fsuccess) {
                                $fcontext->name= "generic-$method-$sitemember->role-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role editor
                        if (!$fsuccess && $sitemember->role=="admin") {
                                $fcontext->name= "generic-$method-editor-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role writer
                        if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "generic->objtype-$method-writer-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                        
                        // class-generic, role member
                        if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "generic-$method-member-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role anonymous
                        if (!$fsuccess) {
                                // try generic objtype 
                                $fcontext->name= "generic-$method-anonymous-$format";
                                berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
			}	
				
		// second pass site contexts without folder->flavor
		if (!$fsuccess && $fcontext->flavorpath && !$session->p_standardContext ) {
			$fcontextpath= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name."/contexts/";

			// class-specific, role specific
			$fcontext->name= "$this->objtype-$method-$sitemember->role-$format";
			berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
			$path= $fcontextpath.$fcontext->name;
			if (file_exists($path)) {
				$fcontext->uploadContext($path);
				$fsuccess=1;
				}
				
			// class-specific, role editor
			if (!$fsuccess && $sitemember->role=="admin") {
				$fcontext->name= "$this->objtype-$method-editor-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-specific, role writer
			if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "$this->objtype-$method-writer-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
			
			// class-specific, role member
			if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "$this->objtype-$method-member-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
							
			// class-specific, role anonymous
			if (!$fsuccess && $sitemember->role!="anonymous") {
				$fcontext->name= "$this->objtype-$method-anonymous-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role specific
			if (!$fsuccess) {
				$fcontext->name= "generic-$method-$sitemember->role-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role editor
			if (!$fsuccess && $sitemember->role=="admin") {
				$fcontext->name= "generic-$method-editor-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role writer
			if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "generic-$method-writer-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
			
			// class-generic, role member
			if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "generic-$method-member-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role anonymous
			if (!$fsuccess) {
				// try generic objtype 
				$fcontext->name= "generic-$method-anonymous-$format";
				berror("getContext(): Going to look for site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// last ditch context: 
			if (!$fsuccess) {
				$fcontext->name= "generic-view-anonymous-$format";
				berror("getContext(): Going to look for ultra-generic site context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}

			}
                
                
		
		//second pass root contexts with folder->flavor...
                if (!$fsuccess ) {
                        $fcontextpath= $GLOBALS['beryliumroot']."/code/contexts/$fcontext->flavorpath";
                        
                        // class-specific, role specific
                        $fcontext->name= "$this->objtype-$method-$sitemember->role-$format";
                        berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                        $path= $fcontextpath.$fcontext->name;
                        if (file_exists($path)) {
                                $fcontext->uploadContext($path);
                                $fsuccess=1;
                                }
                                
                        // class-specific, role editor
                        if (!$fsuccess && $sitemember->role=="admin") {
                                $fcontext->name= "$this->objtype-$method-editor-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-specific, role writer
                        if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "$this->objtype-$method-writer-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                        
                        // class-specific, role member
                        if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "$this->objtype-$method-member-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                                        
                        // class-specific, role anonymous
                        if (!$fsuccess && $sitemember->role!="anonymous") {
                                $fcontext->name= "$this->objtype-$method-anonymous-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role specific
                        if (!$fsuccess) {
                                $fcontext->name= "generic-$method-$sitemember->role-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role editor
                        if (!$fsuccess && $sitemember->role=="admin") {
                                $fcontext->name= "generic-$method-editor-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role writer
                        if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "generic->objtype-$method-writer-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                        
                        // class-generic, role member
                        if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
                                $fcontext->name= "generic-$method-member-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
                                
                        // class-generic, role anonymous
                        if (!$fsuccess) {
                                // try generic objtype 
                                $fcontext->name= "generic-$method-anonymous-$format";
                                berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
                                $path= $fcontextpath.$fcontext->name;
                                if (file_exists($path)) {
                                        $fcontext->uploadContext($path);
                                        $fsuccess=1;
                                        }
                                }
			}	
				
		// fourth pass root contexts without folder->flavor
		if (!$fsuccess && $fcontext->flavorpath) {
			$fcontextpath= $GLOBALS['beryliumroot']."/code/contexts/";

			// class-specific, role specific
			$fcontext->name= "$this->objtype-$method-$sitemember->role-$format";
			berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
			$path= $fcontextpath.$fcontext->name;
			if (file_exists($path)) {
				$fcontext->uploadContext($path);
				$fsuccess=1;
				}
				
			// class-specific, role editor
			if (!$fsuccess && $sitemember->role=="admin") {
				$fcontext->name= "$this->objtype-$method-editor-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-specific, role writer
			if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "$this->objtype-$method-writer-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
			
			// class-specific, role member
			if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "$this->objtype-$method-member-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
							
			// class-specific, role anonymous
			if (!$fsuccess && $sitemember->role!="anonymous") {
				$fcontext->name= "$this->objtype-$method-anonymous-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role specific
			if (!$fsuccess) {
				$fcontext->name= "generic-$method-$sitemember->role-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role editor
			if (!$fsuccess && $sitemember->role=="admin") {
				$fcontext->name= "generic-$method-editor-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role writer
			if (!$fsuccess && ($sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "generic-$method-writer-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
			
			// class-generic, role member
			if (!$fsuccess && ($sitemember->role=="writer" || $sitemember->role=="editor" || $sitemember->role=="admin")) {
				$fcontext->name= "generic-$method-member-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// class-generic, role anonymous
			if (!$fsuccess) {
				// try generic objtype 
				$fcontext->name= "generic-$method-anonymous-$format";
				berror("getContext(): Going to look for root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}
				
			// last ditch context: 
			if (!$fsuccess) {
				$fcontext->name= "generic-view-anonymous-$format";
				berror("getContext(): Going to look for ultra-generic root context file at $fcontextpath$fcontext->name.",1);
				$path= $fcontextpath.$fcontext->name;
				if (file_exists($path)) {
					$fcontext->uploadContext($path);
					$fsuccess=1;
					}
				}

			}
			
		// NOW reconcile dbcontext and fcontext...
		if ($context->id!="") {
			$context->preprocess= $fcontext->preprocess;
			$context->postprocess= $fcontext->postprocess;
			// load missing pieces as well... header-template-listorw-nullobject-footer
			if (trim($context->header)=="") $context->header= $fcontext->header;
			if (trim($context->template)=="") $context->template= $fcontext->template;
			if (trim($context->listrow)=="") $context->listrow= $fcontext->listrow;
			if (trim($context->nullobject)=="") $context->nullobject= $fcontext->nullobject;
			if (trim($context->footer)=="") $context->footer= $fcontext->footer;
			}
		else $context= $fcontext;
			
		// turn errorLevel back up
		berror("</blockquote>",1);
		//$GLOBALS['session']->setErrorLevel($olderror);

		// if found, return the context object
		if ($success OR $fsuccess) {
			berror("getContext(): [bold: Found '".$context->classname."' context] (#$context->id) in folder #".$context->folderid." (with role='".$context->role."' and method='".$context->method."').",1);
			$this->context= $context;
			return 1;
			}
		else	{
			// nothing found, exit unsuccessfully
			berror("getContext(): [bold:No valid context] was found for the $this->objtype you are trying to access.",1);
			$this->context->nullobject= "<table width='80%' cellpadding=8 align='center'>
                        <tr>
                        <td align=right valign=top bgcolor='#ffffff'><a href='http://berylium.org/'><img src='/bicons/blogo-label-48x48.gif' border=0></a></td>
                        <td><h1>Not Found</h1>Sorry $sitemember->name, for whatever reason you may not ".$session->request->method." this $this->objtype in ".$session->request->format." format.<br><br>(No valid context found, you may need to log in...)</td>
                        </tr>
                        </table>";
			$this->context->template= $this->context->nullobject;
                        $this->nocontext= 1;
                        return 0;
			}
		}


	function preprocess() {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
		$object= $GLOBALS['object'];
		$containers= $GLOBALS['containers'];
		if ($this->originalid!="" && $this->originalid!="0") $this->getOriginal();
		berror("preprocess() called by $this->objtype #$this->id ($this->name) (for $object->objtype page ($object->id))",1);

		if ($this->context->preprocess!="") {
			if ($session->errorLevel==2) {
				$this->context->preprocesshtml= htmlentities($this->context->preprocess);
				berror("preprocess() processing <blockquote><tt>".$this->context->preprocesshtml."</tt></blockquote>",2);
				}
			eval($this->context->preprocess);
			}

		return 1;
		}

	function css(&$outobject) {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];

		berror("css() called by $this->objtype #$this->id ($this->name) to be sent to $outobject->objtype id#$outobject->id ($outobject->name).",1);
		if ($this->context->css!="") {
			$css= $this->context->css;
                        berror("css() processing this: [color:purple;".htmlentities($css)."]",1);
                        if ($sitemember->p_fontfactor!="") {
                            berror("css() p_fontfactor found: $sitemember->p_fontfactor.",1);
                            // parse $css for font-size: $Npx;, replace $N with $N + $sitemember->p_fontfactor
                            $css= preg_replace ("/(font-size:\s?)(\d\d)(p\w)/e", 
                              "'\\1'.('\\2'+$sitemember->p_fontfactor).'\\3'", $css);
                              
                            // parse $css for line-height: $Npx;, replace $N with $N + $sitemember->p_fontfactor
                            $css= preg_replace ("/(line-height:\s?)(\d\d)(p\w)/e", 
                              "'\\1'.('\\2'+$sitemember->p_fontfactor).'\\3'", $css);
                              
                            berror("<br>css() after p_fontfactor replace: [color:purple;".htmlentities($css)."]",1);
                            }
                        
                        // is this Netscape-4?
                        if ($session->netscape) {
                            // parse $css for line-height: $Npx;, replace $N with $N + $sitemember->p_fontfactor
                            //$css= preg_replace ("/padding:\s?\d\d?px;/", "", $css);
                           $css= "";
berror("<br>css() after <b>netscape4</b> replace:[color:purple;".htmlentities($css)."]",1);
                            }
			
			$command= "\$output= \"$css\";";
			eval($command);
			}

		$GLOBALS['session']->css= $session->css.$output;
		return 1;
		}

	function header(&$outobject) {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
		$object= $GLOBALS['object'];

		berror("header() called by $this->objtype #$this->id ($this->name) to be sent to $outobject->objtype id#$outobject->id ($outobject->name).",1);
		if ($this->context->header!="") {
			// site headers not CBML parsed because it wreaks havoc on Javascript. :-(
			// 2002-12-20
			if ($this->objtype!="site") $this->parseCBML("header");
			$header= str_replace('"','\"',$this->context->header);
			berror("header() processing this: ".htmlentities($header),2);
			$command= "\$output= \"$header\";";
			eval($command);
			}

		if ($this->objtype=="site" && $outobject->objtype=="session") {
			$GLOBALS['session']->output[0]= $output;
			berror("[color:#66FF00;header() inserted chunk 0 (site header) into session id#$session->id]",1);
			}
		elseif ($this->objtype=="folder" && $outobject->objtype=="session") {
			$GLOBALS['session']->output[1]= $output;
			berror("[color:#66FF00;header() inserted chunk 1 (folder header) into session id#$session->id]",1);
			}
		else {
			boutput($output,$outobject);
			}

		return 1;
		}

	function template(&$outobject) {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
		$object= $GLOBALS['object'];

		berror("template() called by $this->objtype #$this->id ($this->name) to be sent to $outobject->objtype id#$outobject->id ($outobject->name).",1);
		if ($this->context->template!="") {
			$this->parseCBML("template");
			$template= str_replace('"','\"',$this->context->template);
			berror("template() processing this: ".htmlentities($template),2);
			$command= "\$output= \"$template\";";
			eval($command);
			}

		boutput($output,$outobject);
		return 1;
		}

	function nullObject(&$outobject) {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
		$object= $GLOBALS['object'];

		berror("nullObject() called by $this->objtype #$this->id ($this->name) to be sent to $outobject->objtype id#$outobject->id ($outobject->name).",1);
		if ($this->context->nullobject!="") {
			$this->parseCBML("nullobject");
			$nullobject= str_replace('"','\"',$this->context->nullobject);
			berror("nullObject() processing this: ".htmlentities($nullobject),2);
			$command= "\$output= \"$nullobject\";";
			eval($command);
			}

		boutput($output,$outobject);
		return 1;
		}

	function listRow(&$outobject) {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
		$object= $GLOBALS['object'];

		berror("listrow() called by $this->objtype #$this->id ($this->name) to be sent to $outobject->objtype id#$outobject->id ($outobject->name).",1);
		if ($this->context->listrow!="") {
			$this->parseCBML("listrow");
			$listrow= str_replace('"','\"',$this->context->listrow);
			berror("listrow() processing this: ".htmlentities($listrow),2);
			$command= "\$output= \"$listrow\";";
			eval($command);
			}

		boutput($output,$outobject);
		return 1;
		}

	function footer(&$outobject) {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
                $object= $GLOBALS['object'];
		$context= $this->context;

		berror("footer() called by $this->objtype #$this->id ($this->name) to be sent to $outobject->objtype id#$outobject->id ($outobject->name).",1);
		if ($this->context->footer!="") {
			$this->parseCBML("footer");
			$footer= str_replace('"','\"',$this->context->footer);
			berror("footer() processing this: ".htmlentities($footer),2);
			$command= "\$output= \"$footer\";";
			eval($command);
			}

		boutput($output,$outobject);
		return 1;
		}

	function postprocess() {
		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$member= $GLOBALS['member'];
		$folder= $GLOBALS['folder'];
		$sitemember= $GLOBALS['sitemember'];
		$containers= $GLOBALS['containers'];
		$object= $GLOBALS['object'];
		berror("postprocess() called by $this->objtype #$this->id ($this->name)",1);

		if ($this->context->postprocess!="") {
			berror("postprocess() processing ".$this->context->postprocess,2);
			eval($this->context->postprocess);
			}

		return 1;
		}


// utilities methods

	function getPropertiesList() {
		// generates an html properties list for the object
		berror("getPropertiesList() called by ".get_class($this)." id $this->id ($this->name).",1);

		$array= get_object_vars($this);
		$list= "<hr><b>".get_class($this)." values:</b><blockquote>";
		while (list($key, $val)= each($array)) {
			if (is_int($key)) continue;
			$list= $list."$key => $val<br>";
			if (is_object($val) and $key!="context") $list= $list.$val->getPropertiesList();
			}
		$list= $list."---End of ".get_class($this)." #$this->id ---</blockquote>";

		return $list;
		}

	function getBaseURL() {
		// returns the urls, uri, and filesystem path that reference this object
		$session= $GLOBALS['session'];

		if ($session->request->connection=="https") $scriptname= "/berylium";
		else $scriptname= "/berylium";

		$urlbase= $session->request->connection."://".$GLOBALS['site']->name.$scriptname;
		$sslbase= "https://".$GLOBALS['site']->name.$scriptname;
		
		// get parent folder of this object
		if ($this->objtype=="site") {
			$url= $urlbase."/";
			$sslurl= $sslbase."/";
			$idurl= $urlbase."/site-$this->id.".$session->request->format;
			$path= $GLOBALS['beryliumroot']."/files/$this->name";
			$uri= $scriptname;
			}
		else {
			if ($this->originalid!="0" && $this->originalid!="") {
				berror("getBaseUrl detected <b>alias</b>, will supply all urls and paths based on original $this->objtype at $this->originalid",1);
				$query= "SELECT name FROM folder WHERE id='".$this->originalObject->folderid."' ";
				berror("getBaseUrl parentfolder query is $query.",1);
				}
			else {
				if ($this->originalid=="") $this->originalid= 0;
				$query= "SELECT name FROM folder WHERE id='$this->folderid' ";
				}
			$this->parentfolder= blookup($query);
			if ($this->parentfolder==0) {
				berror("getBaseURL couldn't find parent folder of $this->objtype #$this->id ($this->name): folder id$this->folderid.",1);
				return 0;
				}

			// kludge to allow insertion of ending slash in foldername...
			if ($this->parentfolder['name']=="/") $this->parentfolder['name']="";

			// urlencode folder and object names
			//$this->parentfolder['name']= urlencode($this->parentfolder['name']);
			if ($this->originalid!="0") {
				$this->urlname= urlencode($this->originalObject->name);
				$this->unsafename= $this->originalObject->name;
				$this->safeid= $this->originalid;
				}
			else {
				$this->urlname= urlencode($this->name);
				$this->unsafename= $this->name;
				$this->safeid= $this->id;
				}

			// baseUrl
			// named url
			// current connection protocol and request format are used
			if ($this->objtype=="folder") {
				// link-flavored folders are different! 2002-12-23
				if ($this->flavor=="link") {
					$url= $this->headline;
					$sslurl= $this->headline;
					}
				// like: http://sitename/berylium/folder/name/
				elseif ($this->name=="/") {
					$url= $urlbase.$this->unsafename;
					$sslurl= $sslbase.$this->unsafename;
					}
				else {
					$url= $urlbase.$this->unsafename."/";
					$sslurl= $sslbase.$this->unsafename."/";
					}
				$htmlurl= $url;
				}
			else {
				// like: http://sitename/berylium/folder/name/document-docname.xml
				$url= $urlbase.$this->parentfolder['name']."/".$this->objtype."-".$this->urlname.".".$session->request->format;
				$sslurl= $sslbase.$this->parentfolder['name']."/".$this->objtype."-".$this->urlname.".".$session->request->format;
				$htmlurl= $urlbase.$this->parentfolder['name']."/".$this->objtype."-".$this->urlname.".html";
				}

			// idUrl
			// idurl -- good for unnamed things or things that might not have url-friendly names
			// like: http://sitename/berylium/folder/name/document-18.html
			// updated 2002-12-19 to http://sitename/berylium/objtype-id.html
				// was: $idurl= $urlbase.$this->parentfolder['name']."/".$this->objtype."-".$this->id.".".$session->request->format;
			$idurl= $urlbase."/".$this->objtype."-".$this->safeid.".".$session->request->format;
			if ($this->originalid!="0") {
				$aliasurl= $urlbase."/".$this->objtype."-".$this->id.".".$session->request->format;
				}

			// path
			// path in filesystem
			if ($this->objtype=="folder") {
				// like: /home/berylium/files/sitename/folder/name
				$path= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name.$this->unsafename;
				}
			else {
				// like: /home/berylium/files/sitename/folder/name/imagename.jpg
				// or: // like: /home/berylium/file/folder/name/docname.html
				if ($this->format=="") $this->format= ".html";
				$path= $GLOBALS['beryliumroot']."/files/".$GLOBALS['site']->name.$this->parentfolder['name']."/".$this->urlname.$this->format;
				}

			// uri
			// uri is a reference to the object in its native format (html unless folder or otherwise indicated)
			// no connection protocol is indicated
			if ($this->objtype=="folder") {
				if ($this->name=="/") $uri= $scriptname."/index.html";
				else $uri= $scriptname.$this->unsafename."/index.html";
				}
			else {
				if ($this->format=="") $this->format= ".html";
				$uri= $scriptname.$this->parentfolder['name']."/".$this->objtype."-".$this->urlname.$this->format;
				}
			}

		berror("getBaseURL() for $this->objtype #$this->id ($this->name):<blockquote>",1);
		berror("getBaseURL() baseUrl=".$url,1);
		berror("getBaseURL() baseSSLUrl=".$sslurl,1);
		berror("getBaseURL() htmlUrl=".$htmlurl,1);
		berror("getBaseURL() idUrl=".$idurl,1);
		berror("getBaseURL() path=".$path,1);
		berror("getBaseURL() uri=".$uri,1);
		if ($this->originalid!="0") {
			berror("getBaseURL() and <b>aliasUrl</b>=".$aliasurl,1);
			$this->aliasUrl= $aliasurl;
			}
		berror("</blockquote>",1);

		$this->baseURL= $url;
		$this->baseSSLUrl= $sslurl;
		$this->baseUrl= $url;
		$this->htmlUrl= $htmlurl;
		$this->idURL= $idurl;
		$this->idUrl= $idurl;
		$this->path= $path;
		$this->uri= $uri;
		return 1;
		}



	function oldloadObject() {	// DEPRECATED!! ****************************************************
		// loadObject refreshed $this with data from the database. Requires $this->objtype and either $this->id or ($this->name and $this->folderid)
		berror("<b>DEPRECATED!</b> loadObject() called by ".get_class($this)." id#$this->id ($this->name, in folder #$this->folderid).",1);

		// connect to database if not already
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();

		// pick a query scheme
		if ($this->id!="" AND $this->objtype!="") {
			$query= "SELECT * FROM $this->objtype WHERE id=$this->id $this->queryExtras";
			}
		elseif ($this->name!="" AND $this->folderid!="" AND $this->objtype!="") {
			$query= "SELECT * FROM $this->objtype WHERE name='$this->name' AND folderid='$this->folderid' $this->queryExtras";
			}
		elseif ($this->name!="" AND $this->objtype=="folder" OR $this->objtype=="site") {
			$query= "SELECT * FROM $this->objtype WHERE name='$this->name' $this->queryExtras";
			}
		else {
			berror("<font color='#FF0000'>loadObject(): called by ".get_class($this)." without enough details.</font>",1);
			}

		$this->selectObject($query);

		return 1;
		}



	function viewObject() {	// DEPRECATED!! ****************************************************
		// default view context; to do: render to session->output...
		berror("<b>DEPRECATED!</b> viewObject() called by ".get_class($this)." id $this->id ($this->name).",1);

		$array= get_object_vars($this);
		print "<br><b>".get_class($this)." values:</b><blockquote>";
		while (list($key, $val)= each($array)) {
			if (is_int($key)) continue;
			print "$key => $val<br>";
			if (is_object($val)) $val->viewObject();
			}
		print "---End---</blockquote>";
		}



	function createObject() {	// DEPRECATED!! ****************************************************
		berror("<b>DEPRECATED!</b> createObject() called by ".get_class($this)." id $this->id ($this->name), to create a new $this->objtype.",1);

		$this->id="";
		$this->editObject();
		}

	function editObject() {	// DEPRECATED!! ****************************************************
		// generates an HTML form for the raw editing of an object
		berror("<B>DEPRECATED</B> editObject() called by ".get_class($this)." id $this->id ($this->name).",1);

		// connect to database
		$session= $GLOBALS['session'];
		if (!$session->dbconnection) $GLOBALS['session']->dbconnection= dbconnect();

		// get table description so we know what bits of this object we can save
		$query= "DESCRIBE $this->objtype ";
		$result= mysql_query($query);
		$a=1;
		while ($columnarray= mysql_fetch_array($result)) {

			// what are some things that can't change? 
			$continuelist= array("id", "created", "updated", "sessionid");
			foreach ($continuelist as $k=>$v) {
				if ($v==$columnarray['Field']) {
					$ignorefield=1;
					berror("editObject(): ignoring db field ".$columnarray['Field'],1);
					}
				}

			$thisfield= $columnarray['Field'];
			if ($ignorefield==0) $tablecolumn[$thisfield]= $a;
			$ignorefield=0;
			$a++;
			}

		// hidden form variables (objtype and id if available)
		$hiddenvars= "<input type='hidden' name='objtype' value='$this->objtype'>";
		if ($this->id) $hiddenvars= $hiddenvars."<input type='hidden' name='id' value='$this->id'>";

		// print the form
		print "<form method='post' action='?method=update'> $hiddenvars
			  <table width='400' border='0' cellspacing='0' cellpadding='5'>
				<tr><td colspan='2'><b>Edit $this->objtype id#$this->id</b></td></tr>";

		foreach ($tablecolumn as $key=>$val) {
			print "
			   <tr valign='top'> 
			      <td align='right'>$key:</td>
			      <td> 
			        <input type='text' name='$key' size='24' maxlength='255' value='".$this->{$key}."'>
			      </td>
			    </tr>
				";
			}

		print "
			    <tr> 
			      <td width='20%'>&nbsp;</td>
			      <td> 
			        <input type='submit' name='Submit' value='Submit'>
			      </td>
			    </tr>
			  </table>
			</form>";

		return 1;
		}


	}

?>
