<?php
// Berylium Objects functions
// $Date: 2003/02/06 04:52:09 $

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// get local site configuration
// $beryliumroot is set in the berylium/http/berylium script
include("$beryliumroot/code/berylium.conf");

//
// ----------------------------------------------------- Operations Functions -------
//

// Replace the username and password of the database server, and all will be right with the world here.
// Database user should have permission to INSERT, UPDATE, and SELECT -- ONLY


function berror($message, $errorLevel=0, $object="session") {
	// puts a new message onto ${$object}->error for debuging and logging
	// errorLevel in from 0 to n with 0 being general messages, n being most detailed, default=1

	$thisobject= $GLOBALS["$object"];
	if ($GLOBALS['profile']==1) {
		$timenow= bgetmicrotime() - $GLOBALS[timerStart];
		$timenow= "($timenow):";
		}

	if ($errorLevel==0) {
		print "There has been an error in ".$_SERVER['SCRIPT_FILENAME'].":\n\r<hr>$message<hr>\n\r";
		$session= $GLOBALS['session'];
		if ($GLOBALS['session']->p_debug=="1") {
			print "<table bgcolor='#ffffff'><tr><td>";
			print "<hr><b>\$session->error</b><br>";
			print nl2br($session->error);
			print "<hr>Session complete at ".date("Y-M-D H:i:s").".<br><a href='$session->refreshURL'>Refresh</a> ($session->refreshURL)";
			print "</tr></td></table>";
			}
		exit;
		}

	if (is_object($thisobject) AND $thisobject->errorLevel>=$errorLevel) {
		$GLOBALS["$object"]->error= $thisobject->error."\n\r".$timenow.$message." [".$thisobject->errorLevel."/$errorLevel]";
		return 1;
		}
/*	else {
		print "\$thisobject is not an object: \$GLOBALS[".$GLOBALS['session']->objtype."] (object=$object)";
		exit;
		}
*/

	return 1;
	}


function boutput($message,&$outobject) {
	// puts a new chunk onto $outobject->output for later output to the client and/or a file
	berror("[color:#66FF00;boutput() adding this to $outobject->objtype id#$outobject->id ($outobject->name):]".htmlentities($message),2);

	// boutput separates its chunks by 10 steps-- in theory, some other function could leven them with other content. So sort the output array before outputting!!!
	if (is_array($outobject->output)) {
		ksort($outobject->output);
		end($outobject->output);
		$n= key($outobject->output);
		$n= $n+10;
		$outobject->output[$n]= $message;
		}
	else {
		$n= 20;
		$outobject->output[$n]= $message;
		}
	berror("[color:#66FF00;boutput() inserted chunk $n into $outobject->objtype id#$outobject->id ($outobject->name)]",1);

	return 1;
	}


function dbconnect() {
	$dbuser= $GLOBALS['dbuser'];
	$dbpassword= $GLOBALS['dbpassword'];
	$dbname= $GLOBALS['dbname'];
	
	$db= mysql_connect("localhost", "$dbuser", "$dbpassword");
	if (!$db) {
		berror("Error on database connect: ".mysql_error(),0);
		return 0;
		}
	else berror("Connected to mySQL.",1);

	if (!$database= mysql_select_db("$dbname")) {
		berror("Error selecting database $dbname: ".mysql_error(),0);
		return 0;
		}

	else berror("Database selected.",1);
	return $db;
	}


function bloadfile($filename) {
	$contents=0;

	// get contents of a file into a string
	if ($fd = @fopen ($filename, "r")) {
		$contents = fread ($fd, filesize ($filename));
		fclose ($fd);
		}

	return $contents;
	}


function brandom() {
	srand((double)microtime()*1000000); 
	$random = rand(0,32000);
	return $random;
	}


function bmail($email, $subject, $message) {
	$site= $GLOBALS['site'];

	//$email= addslashes($email);
	//$message= addslashes($message);
	//$subject= addslashes($subject);

	$headers= "From: berylium@$site->name\nReply-To: $site->admin\nX-Mailer: Berylium v1 via PHP/".phpversion();

	$sent= mail($email, $subject, $message, $headers);
      	return $sent;
	}


function blookup($query) {
	$result= mysql_query($query);
	if ($result) {
		$array= mysql_fetch_array($result);
		if (is_array($array)) return $array;
		}
	return 0;
	}

function bgetmicrotime() { 
	list($usec, $sec)= explode(" ",microtime()); 
	return ((float)$usec + (float)$sec); 
	}

//
// ----------------------------------------------------- String Functions -------
//

function bunpack($list) {
	// Unpacks a ^-delimited list of $key=$value pairs into $array[$key]=$value
	berror("bunpack() called with list: $list",2);
	$pairlist= explode("^", $list);
	while (list($key,$val)= each($pairlist)) {
		$firstequal= strpos($val, "=");
		if ($firstequal === false) {
			berror("bunpack(): no equals sign found in $val",2);
			$array["$val"]= "";
			}
		else {
			$thiskey= substr($val,0,$firstequal);
			$thisval= substr($val,$firstequal+1);
			berror("bunpack(): setting array[$thiskey]=$thisval",2);
			$array["$thiskey"]= $thisval;
			}
		}

	return $array;
	}

function bpack($array) {
	if (is_array($array)) {
		foreach($array as $key=>$value) {
			if (!$list) $list="$key=$value";
			else $list= $list."^$key=$value";
			}
		return $list;
		}
	else return "";
	}



function mysql_timestamp($datetime) {
	$year= substr($datetime,0,4);
	$month= substr($datetime,5,2);
	$day= substr($datetime,8,2);
	$time= substr($datetime,11,8);
	$hour= substr($time,0,2);
	$minute= substr($time,3,2);
	$second= substr($time,6,2);
	$timestamp= mktime($hour,$minute,$second,$month,$day,$year);
	return $timestamp;
	}
        
function bHtml($value) {
	// theory: removes all html tags, curly brackets "{}" and doublequotes from user input, converts newlines to <br>, and parses bml
        // should also replace single quotes with some entity
	// warning: only works with text in ISO-Latin-1 charset!!!
        $value= preg_replace("/[{]/","&laquo;",$value);
        $value= preg_replace("/[}]/","&raquo;",$value);
        $value= htmlentities($value);
        $value= preg_replace("/[']/","&rsquo;", $value);
        $value= nl2br($value);
        $value= bparsebml($value);
        $value= bpostbml($value);
        return $value;
        }

function bparsebml($text){
	$beryliumroot= $GLOBALS['beryliumroot'];
	$session= $GLOBALS['session'];
	
	/* // add an end tag
	$text.= "[end:]"; */
	
	if ($_GET['nobml']==1) return $text;

	// assume markup will be found
	$found=1;
	$end=0;

	//begin parsing loop
	while ($found) {
		// sanity time
		if ($end>=strlen($text)) {
			$found=0;
			continue;
			}

		// find command start
		$start= strpos($text, "[", $end);
		if ($start===false) {
			$found=0;
			continue;
			}
		
		// look for at least one right bracket, otherwise this is madness!
		$endmost= strrpos($text, "]");
		if ($endmost===false) {
			$found=0;
			continue;
			}

		// check for command
		$commandend= strpos($text, ":", $start);
		if ($commandend===false) {
			$end= $start+1;
			continue;
			}

		// if the alleged "command" ends after the last right bracket, it isn't one.
		if ($commandend>$endmost) {
			$found=0;
			continue;
			}

		// find a likely endpoint for this tag
		$anend= strpos($text, "]", $start);
		// debug: print "(A ] at $anend)";

		// is there lunacy here? something like "[bold=boldme] blah blah [ital:italic]"???
		if ($commandend>$anend) {
			$end= $start+1;
			continue;
			}


		// check for nested markup!
		$next= strpos($text, "[", $start+1);
		//debug: print "(Next [ at $next)";

		if ($next<$anend AND !($next===false)) {
			$nestlen= $endmost-$start;
			$nest= substr($text, $start+1, $nestlen);
			$text= substr($text, 0, $start+1).bparsebml($nest).substr($text, $endmost+1);
			}


		// okay, now we can find the one living and true end
		$end= strpos($text, "]", $start);
		if ($end===false) {
			$found=0;
			continue;
			}

		// check for command again
		$commandend= strpos($text, ":", $start);
		if ($commandend===false) continue;

		// and again, if the : is outside the end bracket, forget it.
		if ($commandend>$end) continue;
		
		// get command
		$commandlen= $commandend-$start-1;
		$command= substr($text, $start+1, $commandlen);
		if ($command=="") continue;

		// define tag
		$taglen= $end-$commandend-1;
		$tag= substr($text, $commandend+1, $taglen);

		// with $command and $tag in hand, run the bmlengine
		include("$beryliumroot/code/bml-engine.php");
		
		// if $truncatenl, look for nl as next character and adjust end to clip it
		if ($truncatebreak==1) {
			if (substr($text, $end+1, 4)=="<br>") {
				$end= $end+4;
				}
			elseif (substr($text, $end+1, 6)=="<br />") {
				$end= $end+6;
				}
			}

		// make the substitution
		$text= substr($text, 0, $start).$tag.substr($text, $end+1);
		
		} //end while

	return $text;
	}
		
function bpostbml ($text) {
	// run a substitution on &obrack; and &cbrack;
	$text= str_replace("&obrack;", "[", $text);
	$text= str_replace("&cbrack;", "]", $text);
	
	return $text;
	}
	
function escapebml ($text) {
	// run a substitution on [ and ]
	$text= str_replace("[","&obrack;", $text);
	$text= str_replace("]","&cbrack;", $text);
	
	return $text;
	}

function bisemail ($email) {
	// match against regex
	//see http://www.php.net/manual/en/function.eregi.php for discussion about how to do this
	$emailmatch= '^[a-z\'0-9]+([._-][a-z\'0-9]+)*@([a-z0-9]+([._-][a-z0-9]+))+$';
	if (eregi($emailmatch, $email)) {
		return 1;
		}
	else return 0;
	}

//
// ----------------------------------------------------- Password and Cookie Functions -------
//


//password suite inspired by lexzeus@mifinca.com via php.net
function keyED($txt,$encrypt_key) { 
	$encrypt_key = md5($encrypt_key); 
	$ctr=0; 
	$tmp = ""; 
	for ($i=0;$i<strlen($txt);$i++) { 
		if ($ctr==strlen($encrypt_key)) $ctr=0; 
		$tmp.= substr($txt,$i,1) ^ substr($encrypt_key,$ctr,1); 
		$ctr++; 
		} 
	return $tmp; 
	} 

function hex2bin($data) { 
	// by josh@superfork.com via php.net
	$len = strlen($data); 
	for($i=0;$i<$len;$i+=2) { 
		$newdata .= pack("C",hexdec(substr($data,$i,2))); 
		} 
	return $newdata; 
	} 

function bgetword($text) {
	$bin= hex2bin($text);
	$key = $GLOBALS['wordkey'];
	$txt = keyED($bin,$key); 
	$tmp = ""; 
	for ($i=0;$i<strlen($txt);$i++) { 
		$md5 = substr($txt,$i,1); 
		$i++; 
		$tmp.= (substr($txt,$i,1) ^ $md5); 
		} 
	return $tmp; 
	} 

function bpassword($txt) {
	$key = $GLOBALS['wordkey'];
	srand((double)microtime()*1000000); 
	$encrypt_key = md5(rand(0,32000)); 
	$ctr=0; 
	$tmp = ""; 
	for ($i=0;$i<strlen($txt);$i++) { 
		if ($ctr==strlen($encrypt_key)) $ctr=0; 
		$tmp.= substr($encrypt_key,$ctr,1) . (substr($txt,$i,1) ^ substr($encrypt_key,$ctr,1)); 
		$ctr++; 
		} 
	return bin2hex(keyED($tmp,$key)); 
	} 

function bpasswordcompare($password, $enc_text) {
	$dec_text= bgetword($enc_text);
	if ($password==$dec_text) $comp=1;
	else $comp=0;
	return $comp;
	}


function bsetcookie($key, $val, $sitename) {
	$cookie= "Set-Cookie: $key=$val; path=/;";
	header("$cookie");

	$success= "bsetcookie tried the following: $cookie";
	return $success;
	}

function bclearcookie($key) {
	header("Set-Cookie: $key=; path=/; ");
	}


//
// ----------------------------------------------------- Blist Functions -------
//
function blist($query,$method) {
	// lists stuff

	// take apart query to find objtype
	$frompos= strpos($query, "FROM")+4;
	$commapos= strpos($query, "AS", $frompos);
	$wherepos= strpos($query, "WHERE");
	if ($commapos!==FALSE AND $commapos<$wherepos) {
		$objtype= trim(substr($query, $frompos, ($commapos-$frompos)));
		}
	else $objtype= trim(substr($query, $frompos, ($wherepos-$frompos)));
	berror("[color:#6600cc;blist() called with method=$method on objtype=$objtype. Will use query= $query;]",1);

	// construct a placeholder object of class or error...
	$classname= ucfirst($objtype);
	if (class_exists($classname)) {
		$command= "\$child= new $classname;";
		eval($command);
		}
	else {
		berror("blist() called on an undefined class. Exiting.",1);
		return 0;
		}

	// apply the query to $child
	if ($childarray= $child->selectObject($query)) {
		berror("[color:#6600cc;blist() found a child list with $child->listsize items.]",1);
                // tracking var
                $GLOBALS[session]->currentListSize= $child->listsize;
		}
	else berror("[color:#6600cc;blist() found no children, will runder nullobject.]",1);

	// get the context for the $child
	$request= $GLOBALS['session']->request;
	$child->getContext($method, $request->format);
	
	// apply policy
	$child->applyPolicy();

	// render the header
	$child->preProcess();
	$child->header($child);
	$child->css($session);
	
	if (is_array($childarray) && $child->listsize > 0) {
                // set up tracking vars
                $GLOBALS[session]->currentListIndex= 0;
                
                // go through the child array rendering children
		berror("<blockquote>",1);
		foreach ($childarray as $key=>$array) {
			if (is_array($array)) {
                                $childkey= "child".$key;
				$command= "\${\$childkey}= new $classname;";
				eval($command);
                                
                                // tracking vars
                                $session= $GLOBALS['session'];
                                $session->currentListIndex= $session->currentListIndex + 1;
                                if ($session->currentListIndex > 1) {
                                        $prevkey= $key-1;
                                        $session->previousID= $childarray[$prevkey][id];
                                        }
                                $nextkey= $key+1;
                                $session->nextID= $childarray[$nextkey][id];
                                if (is_numeric($session->row)) {
                                        if ($session->row=="2") $session->row= "even";
                                        else $session->row="odd";
                                        }
                                if ($session->row=="" || $session->row=="even") {
                                        $session->row= "odd";
                                        }
                                else $session->row= "even";
                                $GLOBALS['session']= $session;
                                

				foreach($array as $property=>$value) {
					if (is_int($property)) continue;
					if ($property=="properties" AND $value!="") {
						berror("blist() found properties, unpacking...",1);
						// unpack properties into propertiesarray
						$this->propertiesarray= bunpack($value);
						
						// unpack properties array into p_keys
						if (is_array($this->propertiesarray)) {
							foreach ($this->propertiesarray AS $pkey=>$pvalue) {
								$p_pkey= "p_$pkey";
								${$childkey}->{$p_pkey}= $pvalue;
								berror("blist(): $childkey -> $p_pkey=".${$childkey}->{$p_pkey},1);
								}
							}
						continue;
						}
					${$childkey}->{$property}= $value;
					}

				// preprocess - template - listrow - postprocess
				berror("[color:#6600cc;blist() outputting $classname $childkey id#".${$childkey}->id." (".${$childkey}->name.").]",1);
				
				${$childkey}->context= $child->context;
				// apply policy
				${$childkey}->applyPolicy();
				${$childkey}->preProcess();
				${$childkey}->template($child);
				${$childkey}->listRow($child);
				${$childkey}->postprocess();
				}
			}
		berror("</blockquote>",1);
		}
	else {
		$child->nullObject($child);
		}
		
	// footer now
	$child->footer($child);

	// feed child->output into $output
	if (is_array($child->output)) {
		foreach($child->output as $key=>$value) {
			berror("blist(): Outputting child chunk $key now.",2);
			$output= $output.$value;
			}
		}
	
	return $output; //?
	}

?>
