<?php
// Code-friendly Berylium Markup Language engine
//2002-07-12 01:16

/* Copyright 2001, 2002 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// passed a command and (optionally) a tag. Builds a processed tag according to the command.
berror("[color:#ff6600;CBML Engine executing '$command' with tag=$tag]",1);


switch ($command) {

	case "list":
		// usage: {list:"SELECT * FROM objtype WHERE 1 ORDER BY field LIMIT 1,2"[;method]} -- list will add appropriate wherepublic and wherestatus
		$session= $GLOBALS['session'];
		$sitemember= $GLOBALS[sitemember];
		berror("[color:#ff6600;CBML list called with tag=$tag]",1);
		$semicolon= "";

		// new style
		$argarray= explode(";", $tag);
		if (!is_array($argarray)) {
			berror("<font color=red><b>Cannot parse list args in $tag</font>",1);
			break;
			}
		$query= $argarray[0];
		if ($argarray[1]=="") $method= "list";
		else $method= $argarray[1];
		berror("CBML list: (new style) query=$query and method=$method (tag=$tag)",1);

		// add wherestatus and wherepublic at the end of the WHERE clause...
		if ($sitemember->role!="admin") { // || ($object->objtype!="context" && $session->request->method!="listall")) {
			$query= bmakeSqlSafe($query);
			}

		eval("\$query=\"$query\";");
		berror("[color:#ff6600;CBML list will use query=$query; to [bold:list] objects using $method.]",1);

		$output= blist($query,$method);

		$tag= $output;
		//berror("[color:#ff6600;CBML list cbmloutput=".htmlentities($output).".]",0);
		break;


	case "index":
		// 2002-07-18 10:50
		// usage: {index:objtype[;method][;querytail]}

		$session= $GLOBALS['session'];
		$site= $GLOBALS['site'];
		$folder= $GLOBALS['folder'];
                
                //initialize folder...
                $folder->getRuntimeVars();
		
		// get arguments
		$arguments= explode(";", $tag);
		$objtype= $arguments[0];
		$method= $arguments[1];
		$querytail= $arguments[2];

		// defaults for optional values		
		if (!$method) $method= "list";
		if (!$querytail) $querytail= "ORDER BY obj.rank DESC, obj.created ASC";
                

		// index query looks for all posted item.rank>=100 in the current folder, as well as any posted item.rank>=$folder->rank in subfolders, subject to policy controls and optional $querytail (ORDER BY field [ ASC | DESC ] [ LIMIT limit [ ,offset ] ])
		$query= "SELECT obj.* FROM $objtype AS obj, folder WHERE obj.siteid='$site->id' AND ((folder.id=obj.folderid AND obj.folderid=$folder->id AND obj.rank>='100') OR (folder.id=obj.folderid AND folder.name LIKE '$folder->name%' AND obj.rank>='$folder->lightrank')) AND obj.status='posted' AND folder.status='posted' $session->sqlSafe $querytail";
		berror("[color:#ff6600;CBML list will use query=$query; to list $objtype"."s using $method.]",1);

		$output= blist($query,$method);

		$tag= $output;
		//berror("[color:#ff6600;CBML index cbmloutput=".htmlentities($output).".]",1);
		break;

	case "random":
		// usage: {random:SELECT;method;number=1}
		global $session, $sitemember;
		berror("CBML random: called with $tag.",1);

		// new style
		$argarray= explode(";", $tag);
		if (!is_array($argarray)) {
			berror("<font color=red><b>Cannot parse list args in $tag</font>",1);
			break;
			}
		$query= $argarray[0];
		$method= $argarray[1];
		if (is_numeric($argarray[2])) $number= $argarray[2];
		else $number= 1;
		berror("CBML random: split $tag into query, method=$method, number=$number.",1);

		// add wherestatus and wherepublic at the end of the WHERE clause...
		if ($sitemember->role!="admin") {
			$query= bmakeSqlSafe($query);
			}

		// process query
		eval("\$query=\"$query\";");
		$objtype= ucfirst(bfindSqlObjtype($query));
		berror("CBML random: found objtype=$objtype. final query is $query",1);

		// get a lit of objects matching the query
		eval("\$objlist= new \$objtype;");
		$objarray= $objlist->selectObject($query);
		$max= $objlist->listsize - 1;
		if ($number >= ($max / 2)) {
			berror("Insufficient number of matching entries ($max) to get $number unique randoms.",1);
			$number = round(($max / 2)) -1;
			if ($number < 1) $number =1;
			berror("... new number=$number.",1);
			}
		if ($max>$number) {
			berror("CBML random: found $objlist->listsize qualified results.",1);

			// find $number unique ids from $objarray
			$unique= array();
			$random= brandom($max);
			berror("CBML random: getting values:<blockquote>",1);
			for ($i = 0; $i < $number; $i++) {
				$mydebug= "$i:";
				while(in_array ( $random, $unique)){
					$random= brandom($max);
					$mydebug.= " $random? ";
					}
				$unique[$i]= $random;
				berror($mydebug."<b>$unique[$i]</b><br />",1);
				}
			berror("</blockquote>",1);

			// set up new query
			foreach($unique AS $record) {
				$id= $objarray[$record]['id'];
				$idwhere.= " OR obj.id='$id' ";
				}
			berror("CBML random: idwhere= $idwhere",1);
			$sqlobjtype= strtolower($objtype);
			$newquery= "SELECT obj.* FROM $sqlobjtype AS obj WHERE 0 $idwhere $session->sqlSafe";
			berror("CBML random: newquery= $newquery ",1);
			
			$output= blist($newquery,$method);
			$tag= $output;
			}
		else $tag="";
		//berror("CBML random output=".htmlentities($output),0);
		break;

	case "image":
		$output= bparsebml("[image:$tag]");
		$tag= $output;
		break;
		
	case "document":
		$output= bparsebml("[document:$tag]");
		$tag= $output;
		break;
                
        case "percents":
                $tag= "%%";
                break;
		
	case "rdf":
		// get arguments  0 is rdf url, 1 is a ^-delimited list of key=value pairs
		// currently supported:  refresh=seconds, channel=hidden, descriptionSize=size, maxItems=count
		// {rdf:http://galactron/berylium/index.rdf;refresh=5^maxItems=5^descriptionSize=40}
		$arguments= explode(";", $tag);
		if ($arguments[1]!="") $optargs= bunpack($arguments[1]);

		berror("CBML will parse rdf/rss from $arguments[0] now...",1);
		if ($arguments[0]!="") {
			// load fase4 rdf class
			// See http//www.fase4.com/rdf/
			require_once("$GLOBALS[beryliumroot]/external/fase4_rdf/berylium-rdf.class.php");
			$rdf = new fase4_rdf;
			
			// modify settings based on optargs
			if ($optargs['channel']) $channelstate= $optargs['channel'];
			else $channelstate= "shown";
			$rdf->set_Options( array("channel"=>"$channelstate","build"=>"hidden","cache_update"=>"hidden") );
			if ($optargs['refresh']) $refresh= $optargs['refresh'];
			else $refresh= 3600;
			$rdf->set_refresh($refresh);
			if (is_numeric($optargs['maxItems'])) $rdf->set_max_item($optargs['maxItems']);
			if (is_numeric($optargs['descriptionSize'])) $rdf->set_description_size($optargs['descriptionSize']);
			
			// set cache and rdf file settings
			$rdf->set_CacheDir("$GLOBALS[beryliumroot]/external/fase4_rdf/cache");
			$rdf->_remote_file= $arguments[0];
			
			// generate the newsfeed
			$output= "<table class='rdfTable'>".$rdf->cache()."</table>";
			$rdf->finish();
			$tag= $output;
			}
		break;

	// switch ends here
	}

// escape any $vars which might be in tag
$tag= str_replace('$','\$',$tag);

?>