<?php
//  Berylium XML-RPC server engine
//  $Date: 2003/03/19 21:10:47 $

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
$xmlrpc_server = xmlrpc_server_create();

function hello($method_name, $params, $app_data) {
	$name = $params[0];
	return "Hello, $name. How are you today?";
	}
xmlrpc_server_register_method($xmlrpc_server, "hello", "hello");

// BLOGGER API
function blogger_newPost($method_name, $params, $app_data) {
	//  blogger.newPost + properties
	$appkey= $params[0];
	$blogid= $params[1];	// maps to folderid
	$username= $params[2];
	$password= $params[3];
	$content= $params[4]; // parsed into title, description, and body
	$publish= $params[5];
	$properties= $params[6]; // optional additional $document->properties, carat-delimited key=value pairs

	if ( $blogid=="" || $username=="" || $password=="" || $content=="" ) {
		$code= 11;
		$string= "Missing some required params. See http://plant.blogger.com/api/xmlrpc_newPost.html";
		return array('faultCode' => $code, 'faultString' => $string);
		}

	// get Berylium context...
	global $site, $folder, $sitemember, $session;

	// first log-in with username and password
	$authenticated= xmlrpcLogin($username,$password);
	if (!$authenticated) {
		$string= "That username/password combination is not valid for this site.";
		$code= 11;
		return array('faultCode' => $code, 'faultString' => $string);
		}

	// then create new document
	$document= new Document;
	$props= bunpack($properties);
	foreach ($props AS $key=>$value) {
		$document->{$key}= $value;
		}
	if (trim($document->name=="")) $document->name= uniqid("rpc");
	if (trim($document->flavor=="")) $document->flavor= "log";
	$document->folderid= $blogid;
	$document->description= $content;
	if ($publish) $document->status= "posted";
	else $document->status= "new";
	if (trim($document->rank=="")) $document->rank= 100;
	if (trim($document->public=="")) $document->public= 1;

	// then insert document
	$document->applyPolicy(1);
	if (!($document->canSave['document'] OR $document->canSave['all'])) {
		$string= "xml-rpc applyPolicy(): Failed to find a policy that allows $sitemember->name to save document objects. $document->policyReport";
		$code= 11;
		return array('faultCode' => $code, 'faultString' => $string);
		}
	$document->insertObject();

	return "$document->id";
	}
xmlrpc_server_register_method($xmlrpc_server, "blogger.newPost", "blogger_newPost");

function blogger_editPost($method_name, $params, $app_data) {
	//  blogger.newPost + properties
	$appkey= $params[0];
	$postid= $params[1];	// maps to folderid
	$username= $params[2];
	$password= $params[3];
	$content= $params[4]; // parsed into title, description, and body
	$publish= $params[5];
	$properties= $params[6]; // optional additional $document->properties, carat-delimited key=value pairs

	if ( $postid=="" || $username=="" || $password==""  ) {
		$code= 11;
		$string= "Missing some required params. See http://plant.blogger.com/api/xmlrpc_newPost.html";
		return array('faultCode' => $code, 'faultString' => $string);
		}

	// get Berylium context...
	global $site, $folder, $sitemember, $session;

	// first log-in with username and password
	$authenticated= xmlrpcLogin($username,$password);
	if (!$authenticated) {
		$string= "That username/password combination is not valid for this site.";
		$code= 11;
		return array('faultCode' => $code, 'faultString' => $string);
		}

	// then load document:$postid
	$document= new Document;
	$result= $document->selectObjectById($postid);
	if ($result!=1) {
		$string= "Unable to find document:$postid for editing. ";
		$code= 11;
		return array('faultCode' => $code, 'faultString' => $string);
		}
		
	// edit the document, overwriting existing fields.
	$props= bunpack($properties);
	foreach ($props AS $key=>$value) {
		$document->{$key}= $value;
		}
	if (trim($content)!="") $document->description= $content;
	if ($publish) $document->status= "posted";  // if publish is 0, make no change to document->status

	// then update document
	$document->applyPolicy(1);
	if (!($document->canSave['document'] OR $document->canSave['all'])) {
		$string= "updateObject(): Failed to find a policy that allows $sitemember->name to save document objects.";
		$code= 11;
		return array('faultCode' => $code, 'faultString' => $string);
		}
	$document->updateObject();

	return "$document->id";
	}
xmlrpc_server_register_method($xmlrpc_server, "blogger.editPost", "blogger_editPost");


// UTILITY FUNCTIONS
function xmlrpcLogin($username,$password) {
	global $site, $folder, $sitemember, $session;
	$authenticated= 0;

	// find sitemember from username
	$sitemember = new Sitemember;
	$safeusername= addslashes($username);
	$query= "SELECT * FROM sitemember WHERE name='$safeusername' AND siteid='$site->id' AND status!='deleted' ";
	$sitemember->selectObject($query);
	if (!$sitemember->id) {
		$authenticated= 0;
		$string= "No membership was found with that username/password.";
		$sitemember->role= "anonymous";
		}
	else {
		// create a temporary sitemember object for comparison
		$temp= new Member;
		$query= "SELECT * FROM member WHERE id='$sitemember->memberid' AND status!='deleted' ";
		$temp->selectObject($query);
		if ($temp->id=="") {
			$string= "No membership was found with that username/password.";
			$authenticated= 0;
			$sitemember->role= "anonymous";
			}
		else {
			$passcompare=0;
			$passcompare= bpasswordcompare($password, $temp->password);
			if (!$passcompare) {
				$string= "No membership was found with that username/password.";
				$authenticated= 0;
				$sitemember->role= "anonymous";
				}
			else {
				$authenticated= 1;
				}
			}
		}

	$session->applyPolicy(1);
	return $authenticated;
	}

?>
