#!/usr/local/bin/php
<?php
// adds a new site your current berylium2 installation
//

// to be run at beyliumroot
$beryliumroot= ".";
$version= '$Id: addsite.php,v 1.2 2003/08/06 21:15:17 csnyder Exp $';
print "\nAdd a New Site!  ($version)\n";

// script either needs readline enabled, or the following vars: dbadminuser dbadminpass sitename siteadminemail siteadminpassword siteadminhint
if (count($argv)<7 && !function_exists("readline")) {
	print "
Usage (if PHP not compiled with GNU Readline support):
   $argv[0] <db adminusername> <db adminpasswd> <sitename> <siteadminemail> <siteadminpassword> <siteadminhint>

";
	exit();
	}

// check beryliumroot
if(!is_readable("$beryliumroot/code")) {
	print "
Cannot read $beryliumroot/code. Make sure you are running
this from your berylium root.\n";
	exit();
	}
	
// check for berylium.conf
if(!is_readable("$beryliumroot/code/berylium.conf") || !is_readable("$beryliumroot/http/be2")) {
	print "
Cannot read $beryliumroot/code/berylium.conf and/or
$beryliumroot/http/be2... this appears to be a fresh
install.

You need to run the install script, not upgrade.\n";
	exit();
	}
	
// include berylium codebase
include_once("$beryliumroot/code/berylium.conf");
include_once("$beryliumroot/code/berylium-functions.php");
include_once("$beryliumroot/code/berylium-classes.php");

$be_dbuser= "";
$be_dbpassword= "";

// setup vars
if ($argv[1]!="") $be_dbuser= $argv[1];
else $be_dbuser= readline("dbadminuser: ");
if ($argv[2]!="") $be_dbpassword= $argv[2];
else $be_dbpassword= readline("dbadminpassword: ");
if ($argv[3]!="") $sitename= $argv[3];
else $sitename= readline("site name (like example.com): ");
if ($argv[4]!="") $siteadmin= $argv[4];
else $siteadmin= readline("siteadmin email: ");
if ($argv[5]!="") $siteadminpass= $argv[5];
else $siteadminpass= readline("siteadmin password: ");
if ($argv[6]!="") $siteadminhint= $argv[6];
else $siteadminhint= readline("siteadmin password hint: ");

// build session and policy
$session= new Session;
$sitemember= new Sitemember;
$sitemember->role= "admin";
$policy= new Policy;
$policy->loadPolicy();
$session->applyPolicy();

// create site, folder, member, sitemember
$site= new Site;
$site->name= $sitename;
$site->title= ucwords(str_replace(".", " dot ", $sitename));
$site->id= "";
$site->flavor= "standard";
$site->status= "posted";
$site->public= 1;
$site->rank= 100;
if ($site->insertObject("addsite.php")) print "\nSuccessfully inserted site:$site->id ($site->name).";
else exit("\nUnable to insert site into database.\n\n");

$member= new Member;
$member->email= $siteadmin;
$member->id= "";
$member->flavor= "standard";
$member->siteid= $site->id;
$member->status= "posted";
$member->role= "admin";
$member->hint= $siteadminhint;
$member->password= bpassword($siteadminpass);
if ($member->insertObject("addsite.php")) print "\nSuccessfully inserted member:$member->id ($member->email).";
else exit("\nUnable to insert member into database.\n\n");

$sitemember->name= substr($siteadmin,0, strpos($siteadmin, "@"));
$sitemember->id= "";
$sitemember->flavor= "standard";
$sitemember->memberid= $member->id;
$sitemember->siteid= $site->id;
$sitemember->status= "posted";
$sitemember->public= 1;
$sitemember->rank= 5000;
$sitemember->role= "admin";
if ($sitemember->insertObject("addsite.php")) print "\nSuccessfully inserted sitemember:$sitemember->id ($sitemember->name).";
else exit("\nUnable to insert sitemember into database.\n\n");

$folder= new Folder;
$folder->name= "/";
$folder->id= "";
$folder->title= "Home";
$folder->description= "This site is under construction.";
$folder->flavor= "root";
$folder->sitememberid= $sitemember->id;
$folder->siteid= $site->id;
$folder->status= "posted";
$folder->public= 1;
$folder->rank= 1000;
if ($folder->insertObject("addsite.php")) print "\nSuccessfully inserted folder:$folder->id ($folder->name).";
else exit("\nUnable to insert folder into database.\n\n");

// now go back and clean everything up...
$query= "UPDATE site SET siteid='$site->id', sitememberid='$sitemember->id', folderid='$folder->id' WHERE id='$site->id' ";
if ($result= mysql_query($query)) print "\nUpdated site with siteid, sitememberid and folderid";
else print "\nUnable to update site: $query :".mysql_error()."\n";

$query= "UPDATE member SET sitememberid='$sitemember->id', folderid='$folder->id' WHERE id='$member->id' ";
if ($result= mysql_query($query)) print "\nUpdated member with sitememberid and folderid";
else print "\nUnable to update member: $query :".mysql_error()."\n";

$query= "UPDATE sitemember SET  folderid='$folder->id' WHERE id='$sitemember->id' ";
if ($result= mysql_query($query)) print "\nUpdated sitemember with folderid";
else print "\nUnable to update sitemember: $query :".mysql_error()."\n";

$query= "UPDATE folder SET folderid='$folder->id' WHERE id='$folder->id' ";
if ($result= mysql_query($query)) print "\nUpdated folder with its own folderid";
else print "\nUnable to update folder: $query :".mysql_error()."\n";

// set ownership of file
print "\nUpdating ownership of attachment storage: ";
shell_exec("chown $be_beryliumuser:$be_webgroup $beryliumroot/files/$site->name");

print "\n\nYES: $site->name is now a Berylium site! \\(^_^)/


".getcwd()."/files/$site->name has
been created to store attached files and per-site contexts 
and policies.

Login at http://$site->name/be2/?method=login  (siteid=$site->id)
";

?>

