<?php
// Code-friendly Berylium Markup Language engine
//2002-07-12 01:16

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// passed a command and (optionally) a tag. Builds a processed tag according to the command.
berror("CBML Engine executing '$command' with tag=$tag (".strlen($tag).")",1);


switch ($command) {

	case "list":
		// usage: {list:SELECT obj.* FROM objtype AS obj WHERE conditions ORDER BY field LIMIT offset, rows [;method]}
		//	default method is list
		//	$session->sqlSafe WILL be added to conditions
		global $session, $site, $folder, $sitemember, $objecttree;
		berror("CBML list",2);

		// find method
		$arguments= explode(";", $tag);
		$query= $arguments[0];
		$method= $arguments[1];
		$autolist= $arguments[2];
		if ($method=="") $method= "list";
		if (!is_numeric($autolist)) $autolist= 0;
		berror("CBML list: query=$query  |||  method=$method | autolist id=$autolist ",1);

		// add wherestatus and wherepublic at the end of the WHERE clause...
		if ($sitemember->role!="admin") { // || ($object->objtype!="context" && $session->request->method!="listall")) {
			$query= bmakeSqlSafe($query);
			}

		eval("\$query=\"$query\";");
		berror("CBML list will use query=$query; to list objects using $method. <blockquote>",1);

		// so do it already!
		$objtype= bfindSqlObjtype($query);

		// construct a placeholder object of class or error...
		$classname= ucfirst($objtype);
		if (class_exists($classname)) {
			$command= "\$child= new $classname;";
			eval($command);
			}
		else {
			berror("blist() called on an undefined class. Exiting.",1);
			return $tag;
			}
		$child->getContext($method);

		// selectObject to generate a list, then render it to $output
		$list= $child->selectObject($query);
		if ($autolist) {
			$sessional= "autolist$autolist";
			$child->autolist=  $session->{$sessional};
			$list->autolist= $session->{$sessional};
			}
		if (is_array($list->list)) {
			foreach ($list->list AS $item) {
				$list->perRow();
				$item->context= $child->context;
				$item->applyPolicy();
				$item->process();
				$item->listprocess($list);
				if ($item->showGroup=="same") {
					// render a group of items
					$grouprender.= $item->listrender("item");
					$previtem= $item;
					}
				elseif ($item->showGroup=="new") {
					if (isset($previtem)) $listRender.= $previtem->listrender("group", $grouprender);
					$grouprender= $item->listrender("item");
					$previtem= $item;
					}
				else {
					$listRender.= $item->listrender("item");
					}
				}
			if ($grouprender!="") {
				if (isset($previtem)) $listRender.= $previtem->listrender("group", $grouprender);
				}
			$child->process();
			$output= $child->listrender("container", $listRender);
			$list->perRow("reset");
			}
		else {
			$list->showNull= 1;
			$child->process();
			$listRender= $child->listrender("item");
			$output= $child->listrender("container", $listRender);
			}

		$tag= $output;
		berror("</blockquote>",1);
		unset($list, $child, $item, $previtem, $grouprender, $listRender);
		break;


	case "index":
		// 2002-07-18 10:50
		// usage: {index:objtype:method;size of index;age in days of oldest object;sort order}
		// default method is index
		// size=0 means infinite; default is $site->p_indexsize or 30
		// age=0 means no restriction; default is $site->p_indexage or 0
		// sort order = alpha | rchrono | chrono

		global $session, $site, $folder, $sitemember, $objecttree;
		berror("CBML index",2);
		berror("<blockquote>",1);
                
		// get arguments
		$arguments= explode(";", $tag);
		$methodargs= explode(":", $arguments[0]);
		$objtype= $methodargs[0];
		$method= $methodargs[1];
		$size= $arguments[1];
		$age= $arguments[2];
		$sortorder= $arguments[3];

		// defaults for optional values
		if (!$method) $method= "index";
		if (!$objtype) $objtype= "document";
		if ($size=="") {
			if ($site->p_indexsize) $size= $site->p_indexsize;
			else $size= 30;
			}
		if ($age=="") {
			if ($site->p_indexage) $age= $site->p_indexage;
			else $age= "0";
			}

		// act on options
		if ($size>0) {
			$sqllimit= "LIMIT ".($size+1)." ";
			}
		else $sqllimit= "LIMIT -1 ";
		if ($age>0) {
			$agethreshold= date("Y-m-d h:i:s",time() - (86400 * $age));
			}
		berror("CBML index: after parsing, found objtype=$objtype | method=$method | size=$size | age=$age | folder->rank is $folder->rank",3);

		// sort options
		switch ($sortorder) {
			// default is rchrono
			case "alpha": $orderby= "obj.rank DESC, obj.title ASC"; $listsort= "rank=-1^title=1"; break;
			case "chrono": $orderby= "obj.rank DESC, obj.created ASC"; $listsort= "rank=-1^created=1"; break;
			default: $orderby= "obj.rank DESC, obj.created DESC"; $listsort= "lightrank=-1^created=-1"; break;
			}

		// which objtypes to look for?
		$classarray= array("folder","document","image","audio");
		$command= '$master= new '.ucfirst($objtype).";";
		eval($command);
		$master->getContext($method);
		$list= new bList;

		// FETCH MATCHING OBJECTS from each class
		foreach ($classarray AS $class) {
			berror("<blockquote>",1);
			if (isset($_GET["$class"])) {
				$master->offset["$class"]= addslashes($_GET["$class"]);
				}
			else $master->offset["$class"]= 0;
			// index query looks for all posted item.rank>=100 in the current folder, as well as any posted item.rank>=$folder->rank in subfolders, subject to policy controls of course.
			if ($class=="folder") $sameclass= " AND obj.id!='$object->id'  ";
			else $sameclass= "";
			$query= "SELECT obj.* FROM $class AS obj, folder WHERE obj.siteid='$site->id' $sameclass AND ((folder.id=obj.folderid AND obj.folderid='$object->id' AND obj.rank>'50') OR (folder.id=obj.folderid AND folder.name LIKE '$object->name%' AND obj.rank>='$object->rank' AND obj.rank>=500)) AND obj.created > '$agethreshold'  $session->sqlSafe $session->sqlSafeFolder ORDER BY $orderby $sqllimit OFFSET ".$master->offset["$class"];
			berror("CBML index: $class query=$query",1);
			$subclass= "sub$class";
			$command= '${$subclass}= new '.ucfirst($class).";";
			eval ($command);
			$sublist= ${$subclass}->selectObject($query);
			${$subclass}->getContext($method);
			$list->merge($sublist);
			unset ($sublist);
			berror("</blockquote>",1);
			}
		berror("CBML index: ultimate list size is $list->size. Now sorting...",1);
		$list->sort($listsort);

		// RENDERING
		$master->offset['more']= 0;
		if ($list->size>0) {
			foreach ($list->list AS $item) {
				$i++;
				if ($size > 0 && $i > $size) {
					$master->offset['more']=1;
					break;
					}
				$list->perRow();
				$itemclass= "sub$item->objtype";
				$item->context= ${$itemclass}->context;
				$item->applyPolicy();
				$item->process();
				$item->listprocess($list);
				if ($item->showGroup=="same") {
					// render a group of items
					$grouprender.= $item->listrender("item");
					$previtem= $item;
					}
				elseif ($item->showGroup=="new") {
					if (isset($previtem)) $listRender.= $previtem->listrender("group", $grouprender);
					$grouprender= $item->listrender("item");
					$previtem= $item;
					}
				else {
					$listRender.= $item->listrender("item");
					}
				// page tracking
				$master->offset["$item->objtype"]++;
				}
			if ($grouprender!="") {
				if (isset($previtem)) $listRender.= $previtem->listrender("group", $grouprender);
				}
			}
		else {
			$master->showNull= 1;
			$listRender= $master->listrender("item");
			}
		$master->process();
		$output= $master->listrender("container", $listRender);
		$list->perRow("reset");
		$tag= $output;
		berror("</blockquote>",1);
		unset($master, $list, $item, $previtem, $grouprender, $listRender, $i);
		break;

	case "random":
		// usage: {random:SELECT;method;number=1}
		global $session, $sitemember;
		berror("CBML random: called with $tag.",1);

		// new style
		$argarray= explode(";", $tag);
		if (!is_array($argarray)) {
			berror("<font color=red><b>Cannot parse list args in $tag</font>",1);
			break;
			}
		$query= $argarray[0];
		$method= $argarray[1];
		if (is_numeric($argarray[2])) $number= $argarray[2];
		else $number= 1;
		berror("CBML random: split $tag into query, method=$method, number=$number.",1);

		// add wherestatus and wherepublic at the end of the WHERE clause...
		if ($sitemember->role!="admin") {
			$query= bmakeSqlSafe($query);
			}

		// process query
		eval("\$query=\"$query\";");
		$objtype= ucfirst(bfindSqlObjtype($query));
		berror("CBML random: found objtype=$objtype. final query is $query",1);

		// get a lit of objects matching the query
		eval("\$objlist= new \$objtype;");
		$objarray= $objlist->selectObject($query);
		$max= $objlist->listsize - 1;
		if ($number >= ($max / 2)) {
			berror("Insufficient number of matching entries ($max) to get $number unique randoms.",1);
			$number = round(($max / 2)) -1;
			if ($number < 1) $number =1;
			berror("... new number=$number.",1);
			}
		if ($max>$number) {
			berror("CBML random: found $objlist->listsize qualified results.",1);

			// find $number unique ids from $objarray
			$unique= array();
			$random= brandom($max);
			berror("CBML random: getting values:<blockquote>",1);
			for ($i = 0; $i < $number; $i++) {
				$mydebug= "$i:";
				while(in_array ( $random, $unique)){
					$random= brandom($max);
					$mydebug.= " $random? ";
					}
				$unique[$i]= $random;
				berror($mydebug."<b>$unique[$i]</b><br />",1);
				}
			berror("</blockquote>",1);

			// set up new query
			foreach($unique AS $record) {
				$id= $objarray->list["$record"]->id;
				$idwhere.= " OR obj.id='$id' ";
				}
			berror("CBML random: idwhere= $idwhere",1);
			$sqlobjtype= strtolower($objtype);
			$newquery= "SELECT obj.* FROM $sqlobjtype AS obj WHERE 0 $idwhere $session->sqlSafe";
			berror("CBML random: newquery= $newquery ",1);
			
			$output= $objlist->bparseCBML("{list:$newquery;$method}");
			$tag= $output;
			}
		else $tag="";
		//berror("CBML random output=".htmlentities($output),0);
		break;
		
	case "autolist":
		// autolist produces a list of a fixed size, with previous and next links
		// {autolist:SELECT obj.* FROM classname AS obj WHERE conditions;method;pagesize;sortcode}
		// method defaults to list
		// pagesize defaults to 20
		global $session, $site, $folder, $sitemember, $objecttree;
		berror("CBML autolist",2);

		// find method
		$arguments= explode(";", $tag);
		$query= $arguments[0];
		$method= $arguments[1];
		$pagesize= $arguments[2];
		$sortcode= $arguments[3];
		if ($method=="") $method="list";
		if (!is_numeric($pagesize)) $pagesize= 20;
		berror("CBML list: query=$query  |||  method=$method | pagesize=$pagesize",2);
		
		// add $session->sqlSafe at the end of the WHERE clause...
		if ($sitemember->role!="admin") {
			$query= bmakeSqlSafe($query);
			}
		eval("\$query=\"$query\";");
		berror("CBML autolist will use query=$query; to list $pagesize objects per page using $method.",1);
		
		// get total from db
		$frompos= strpos($query, "FROM");
		$totalquery= "SELECT count(obj.id) ".substr($query, $frompos);
		if ($result= mysql_query($totalquery)) {
			if ($tarray= mysql_fetch_row($result)) {
				$total= $tarray[0];
				}
			}
		berror("CBML autolist: found $total matching results.",1);
		if ($total==0) {
			// render null bit
			$alist= new Document;
			$tag= $alist->bparseCBML("{list:$query;$method}");
			break;
			}

		// which autolist is this?
		$session->autolist++;
		$autolist= $session->autolist;
		$algetvar= "offset$autolist";
		$alsortvar= "sort$autolist";
		$alsession= "autolist$autolist";
		berror("CBML autolist: this is autolist #$autolist on this page.",3);

		// get list offset from $request
		if (isset($_GET["$algetvar"])) $offset= addslashes($_GET["$algetvar"]);
		else $offset= 0;
		
		// get list sort order from request
		if (isset($_GET["$alsortvar"])) {
			$sortstring= addslashes($_GET["$alsortvar"]);
			$sortdirection= substr($sortstring, -1);
			if ($sortdirection!=1 && $sortdirection!=0) $sortdirection= 1;
			$sortcol= addslashes(substr($sortstring,0,-1));
			}
		elseif (isset($sortcode)) {
			$sortstring= $sortcode;
			$sortdirection= substr($sortstring, -1);
			if ($sortdirection!=1 && $sortdirection!=0) $sortdirection= 1;
			$sortcol= addslashes(substr($sortstring,0,-1));
			}
		else {
			$sortcol= created;
			$sortdirection= 1;
			$sortstring= "created1";
			}
		if ($sortdirection==1) $sqldirection= "ASC";
		else $sqldirection= "DESC";
		$al['sortcol']= $sortcol;
		$al['sortdirection']= $sortdirection;
		$urlsortstring= "&amp;sort$autolist=".urlencode($sortstring);
		if ($sortcol=="creator") $sqlsortcol= "creator";
		else $sqlsortcol= "obj.$sortcol";

		// set up prev, next, start, end, and total...
		if ($offset < $pagesize) {
			// previous offset is 0
			$al['previous']= 0;
			if ($offset=="0") {
				$al['start']= 1;
				}
			}
		else {
			// previous offset is $offset - $pagesize
			$al['previous']= $offset - $pagesize;
			}
		if ( ($offset + $pagesize) >= $total ) {
			// next offset is $offset
			$al['next']= $offset;
			$al['end']= 1;
			$actualsize= $total - $offset;
			}
		else {
			// next offset is $offset + $pagesize
			$al['next']= $offset + $pagesize;
			$actualsize= $pagesize;
			}
		$al['offset']= $offset;
		$al['total']= $total;
		$al['pagesize']= $pagesize;
		$al['actualsize']= $actualsize;
		$al['first']= $offset + 1;
		$al['last']= $offset + $actualsize;
		$al['id']= $autolist;
		$al['previousUrl']= "$session->refreshUrl&amp;offset$al[id]=$al[previous]$urlsortstring";
		$al['nextUrl']= "$session->refreshUrl&amp;offset$al[id]=$al[next]$urlsortstring";
		if ($al['first']==$al['last']) $al['showing']= "$al[first] of $al[total]";
		else $al['showing']= "$al[first] to $al[last] of $al[total]";

		// pagelist logic
		$totalpages= ceil($al['total'] / $al['pagesize']);
		if ($totalpages > 14 ) {
			$usetens= floor($totalpages / 10);
			$currentpage= ( $al['offset'] / $al['pagesize'] ) + 1;
			$singlestart= floor ( $currentpage / 10 ) * 10;
			$singleend= 9 + $singlestart;
			if ($singlestart==0) $singlestart= 1;
			if ($singleend > $totalpages) $singleend= $totalpages;
			//$pages= "$currentpage ($singlestart - $singleend)";
			}
		else {
			$singlestart= 1;
			$singleend= $totalpages;
			}

		// pagelist render
		if ($usetens && $singlestart > 9) {
			$pages.= "<a href='$session->refreshUrl&amp;offset$al[id]=0$urlsortstring'>1</a> - ";
			for ($i = 10; $i < $singlestart; $i=$i+10 ) {
				$pagei= ($i-1) * $al['pagesize'];
				$pages.= "<a href='$session->refreshUrl&amp;offset$al[id]=$pagei$urlsortstring'>$i</a> - ";
				}
			}
		for ($i = $singlestart; $i <= $singleend; $i++ ) {
			$pagei= ($i-1) * $al['pagesize'];
			if ($pagei==$al['offset']) $pages.= "$i ";
			else $pages.= "<a href='$session->refreshUrl&amp;offset$al[id]=$pagei$urlsortstring'>$i</a> ";
			}
		if ($usetens && $i < $totalpages) {
			for ($i; $i <= ($usetens * 10); $i=$i+10 ) {
				$pagei= ($i-1) * $al['pagesize'];
				$pages.= "<a href='$session->refreshUrl&amp;offset$al[id]=$pagei$urlsortstring'>$i</a> - ";
				}
			$lastpage= ($totalpages - 1);
			if ($lastpage!=$i) {
				$lastoffset= $lastpage * $al['pagesize'];
				if ($al['end']==1) $pages.= "$totalpages";
				else $pages.= "<a href='$session->refreshUrl&amp;offset$al[id]=$lastoffset$urlsortstring'>$totalpages</a>";
				}
			}
		$al['pages']= $pages;

		// transfer the whole autolist array to $session so it can be given to the list in a minute
		$session->{$alsession}= $al;
		$alist= new ContentObject;
		$tag= $alist->bparseCBML("{list:$query ORDER BY $sqlsortcol $sqldirection LIMIT $offset, $pagesize;$method;$autolist}");
		unset ($al, $offset, $pagesize, $actualsize, $total, $alist, $query, $method, $pages, $usetens);
		break;

	case "image":
		$output= bparsebml("[image:$tag]");
		$tag= $output;
		break;
		
	case "document":
		$output= bparsebml("[document:$tag]");
		$tag= $output;
		break;
                
        case "percents":
                $tag= "%%";
                break;
		
	case "rdf":
		// get arguments  0 is rdf url, 1 is a ^-delimited list of key=value pairs
		// currently supported:  refresh=seconds, channel=hidden, descriptionSize=size, maxItems=count
		// {rdf:http://galactron/berylium/index.rdf;refresh=5^maxItems=5^descriptionSize=40}
		$arguments= explode(";", $tag);
		if ($arguments[1]!="") $optargs= bunpack($arguments[1]);

		berror("CBML will parse rdf/rss from $arguments[0] now...",1);
		if ($arguments[0]!="") {
			// load fase4 rdf class
			// See http//www.fase4.com/rdf/
			require_once("$GLOBALS[beryliumroot]/external/fase4_rdf/berylium-rdf.class.php");
			$rdf = new fase4_rdf;
			
			// modify settings based on optargs
			if ($optargs['channel']) $channelstate= $optargs['channel'];
			else $channelstate= "shown";
			$rdf->set_Options( array("channel"=>"$channelstate","build"=>"hidden","cache_update"=>"hidden") );
			if ($optargs['refresh']) $refresh= $optargs['refresh'];
			else $refresh= 3600;
			$rdf->set_refresh($refresh);
			if (is_numeric($optargs['maxItems'])) $rdf->set_max_item($optargs['maxItems']);
			if (is_numeric($optargs['descriptionSize'])) $rdf->set_description_size($optargs['descriptionSize']);
			
			// set cache and rdf file settings
			$rdf->set_CacheDir("$GLOBALS[beryliumroot]/external/fase4_rdf/cache");
			$rdf->_remote_file= $arguments[0];
			
			// generate the newsfeed
			$output= "<table class='rdfTable'>".$rdf->cache()."</table>";
			$rdf->finish();
			$tag= $output;
			}
		break;

	// switch ends here
	}

// escape any $vars which might be in tag
$tag= str_replace('$','\$',$tag);

// EOF
