<?php

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

class e99oServer {
	var $recipe;
	var $object;
	var $cachepath;
	var $path;
	var $content;

	function e99oServer($recipe, $object) {
		$this->getPath($object);
		if (!is_readable($this->path)) {
			berror("e99o: Path $this->path not readable, cannot use e99oServer.",1);
			return;
			}
		$this->recipe =& $recipe;
		$recipe->loadRecipe();
		$recipe->evalCode($this->path);
		$debug= $GLOBALS['debug'];
		if ($this->hitCache($object) && !$debug) {
			header("Content-type: $recipe->mimetype");
			$this->content= file_get_contents($this->cachepath);
			header("Content-length: ".strlen($this->content));
			print $this->content;
			exit;
			}
		elseif (!$debug) {
			// split off into background here if necessary...
			
			$this->content= shell_exec($recipe->command);
			header("Content-type: $recipe->mimetype");
			header("Content-length: ".strlen($this->content));
			print $this->content;
			ob_start();
			$this->makeCache();
			ob_end_clean();
			exit;
			}
		else berror("e99o debug.",0);
		}
		
	function getPath($object) {
		if ($object->path!="") $this->path= $object->path;
		else {
			$object->getBaseUrl();
			$this->path= $object->path;
			}
		}
		
	function hitCache($object) {
		global $site;
		if ($object->createdStamp!="") $timestamp= $object->createdStamp;
		else {
			$timestamp= mysql_timestamp($object->created);
			}
		$this->cachepath= $GLOBALS['beryliumroot']."/cache/".date("Y", $timestamp)."/".date("m",$timestamp)."/".$site->name."_".$object->objtype."-".$object->id."@".$this->recipe->method.".".$this->recipe->format;
		berror("e99o: cachepath is $this->cachepath",1);

		// check for existance of cache
		if (!file_exists($this->cachepath)) return 0;

		// check against mod time of original
		$originalmtime= filemtime($this->path);
		$cachemtime= filemtime($this->cachepath);
		berror("e99o: cache timestamp is $cachemtime",1);
		if ($originalmtime > $cachemtime) {
			berror("e99o: cache is older than original.",1);
			return 0;
			}
		
		// check against mod time of recipe!
		if ($this->recipe->timestamp > $cachemtime) {
			berror("e99o: cache is older than recipe.",1);
			return 0;
			}
		
		// got it!
		return 1;
		}
		
	function makeCache() {
		$modir= dirname($this->cachepath);
		if (!is_dir($modir)) {
			$yeardir= dirname($modir);
			if (!is_dir($yeardir)) {
				if (!mkdir($yeardir,0770)) berror("e99o: cache error, cannot make $yeardir",-1);
				}
			if (!mkdir($modir,0770)) berror("e99o: cache error, cannot make $modir",-1);
			}
		$fp= fopen($this->cachepath, "w");
		fwrite($fp, $this->content);
		fclose($fp);
		return 1;
		}
	
	// end e99oServer class
	}
	
class e99oRecipe {
	var $objectname;
	var $name;
	var $classname;
	var $method;
	var $role;
	var $fileformat;
	var $recipecode;
	var $version;
	var $command;
	var $mimetype;

	function e99oRecipe($objectname) {
		// constructor, takes $objectname="objname@method"
		berror("e99o: recipe constructor called with $objectname.",1);
		$array= explode("@",$objectname,2);
		$this->objectname= $array[0];
		$this->method= $array[1];
		}
		
	function loadRecipe() {
		// loads recipe file into $this->recipe
		berror("e99o: loadRecipe called.",1);
		global $session, $sitemember;

		// setup
		$recipepath= $GLOBALS['beryliumroot']."/code/recipes";
		$this->format= $session->request->format;
		$classnamearray= array( $session->request->objtype, "generic" );
		switch($sitemember->role) {
			case "admin": $rolearray= array("admin","editor","writer","member","anonymous"); break;
			case "editor": $rolearray= array("editor","writer","member","anonymous"); break;
			case "writer": $rolearray= array("writer","member","anonymous"); break;
			case "member": $rolearray= array("member","anonymous"); break;
			default: $rolearray= array($sitemember->role);
			}
			
		// find the right recipe
		$success= 0;
		foreach ( $classnamearray AS $classname ) {
			if ($success) continue;
			foreach ( $rolearray AS $role ) {
				if ($success) continue;
				$filename= "$classname-$this->method-$role-$this->format.php";
				berror("e99o: loadRecipe looking for $recipepath/$filename.",1);
				$this->path= "$recipepath/$filename";
				if ( file_exists($this->path) ) {
					$this->recipecode= substr(file_get_contents($this->path), 6);
					$this->name= "$classname-$this->method-$role-$this->format";
					$this->classname= $classname;
					$this->role= $role;
					$success= 1;
					$this->timestamp= filemtime($this->path);
					berror("e99o: loadRecipe found <em>".$this->classname."-".$this->method."-".$this->role."-".$this->format."</em> ($this->timestamp).",1);
					}
				}
			}
		if (!$success) berror("e99o: loadRecipe found no recipes.",1);
		return $success;
		}
		
	function evalCode($path) {
		// evals $this->recipecode
		eval($this->recipecode);
		berror("e99o: command is $this->command",1);
		}

	// end e99oRecipe class
	}
