<?php
// Berylium2 http-engine
// $Date: 2003/08/18 04:37:42 $

// Loads, processes, and renders Berylium objects for HTTP server

/* Copyright 2003 by Chris Snyder

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// turn off notice reporting, dagnabbit!
//ini_set("error_reporting", "E_ALL & ~E_NOTICE");

//set-up debug
$debug= $_GET['debug'];
$profile= $_GET['profile'];

// $beryliumroot is set in the ~/http/be2 script
require("$beryliumroot/code/berylium.conf");
require("$beryliumroot/code/berylium-functions.php");
require("$beryliumroot/code/berylium-classes.php");

// announce thyself!
header("X-Berylium-2: ".'$Id: http-engine.php,v 1.12 2003/08/18 04:37:42 csnyder Exp $');

// init timer
$timerStart= bgetmicrotime();

//init objecttree
$objecttree= array();

// start a new Session
// the session loads from the db (or creates and saves new...), creates a session->request, a session->member (authenticated if not anonymous), and starts a new error channel
$session= new Session;
$session->buildSession();
$timenow= bgetmicrotime() - $timerStart;

// debug prefs
if ($debug>=1) {
	$session->p_debug=$debug;
	berror("Setting session->p_debug=$session->p_debug.",1);
	}
elseif ($debug=="off") {
	$debug= "";
	$session->p_debug= "";
	berror("Resetting session->p_debug ($session->p_debug)",1);
	}
$session->setErrorLevel($session->p_debug);

// role prefs
$role= $_GET['role'];
if ($role!="" && $role!="0") {
	$session->p_role= $role;
	berror("Setting session->p_role=$session->p_role.",1);
	}
elseif ($role=="0") {
	$session->p_role= "";
	berror("Resetting session->p_role ($session->p_role)",1);
	}

// standardContext prefs
$standardContext= $_GET['standardContext'];
if ($standardContext!="" && $standardContext!="0") {
	$session->p_standardContext= 1;
	berror("Setting session->p_standardContext=$session->p_standardContext.",1);
	}
elseif ($standardContext=="0") {
	$session->p_standardContext= "";
	berror("Resetting session->p_standardContext ($session->p_standardContext)",1);
	}
  
//showDeleted prefs (only for editors or admins, really...)
$showDel= $_GET['showDeleted'];
if ($showDel!="" && $showDel!="0") {
	$session->p_showDeleted= 1;
	berror("Setting session->p_showDeleted ($session->p_showDeleted).",1);
	}
elseif ($showDel=="0") {
	$session->p_showDeleted= "";
	berror("Resetting session->p_showDeleted ($session->p_showDeleted)",1);
	}

// write session prefs
$session->updateObject();

// read from session prefs...
if ($session->p_debug>=1) {
	$debug= $session->p_debug;
	}
else $debug= "";
if ($session->p_role!="") {
	$role= $session->p_role;
	}
else $role= "";
berror("Debug=$debug and Role=$session->p_role and standardContext=$session->standardContext for this request. session->p_debug=$session->p_debug.",1);
berror("<hr />Session construction complete at $timenow. Loading site next.<hr />",1);


// get the site
$site= new Site;
$site->loadSite();
$session->siteid= $site->id;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />Site construction complete at $timenow. Loading sitemember next.<hr />",1);

// get the sitemember
$sitemember= new Sitemember;
$sitemember->loadSitemember();

//allow some sitemembers to drop rank dynamically
switch ($sitemember->role) {
	case "admin":
		if ($role) {
			$sitemember->role= $role;
			$sitemember->truerole= "admin";
			}
		break;
	case "editor":
		if ($role=="writer" || $role=="member" || $role=="anonymous") {
			$sitemember->role= $role;
			$sitemember->truerole= "editor";
			}
		break;
	case "writer":
		if ($role=="member" || $role=="anonymous") {
			$sitemember->role= $role;
			$sitemember->truerole= "writer";
			}
		break;
	}
if ($sitemember->truerole=="") {
	$sitemember->truerole= $sitemember->role;
	berror("Sitemember did not drop role.",1);
	}
else {
	berror("Sitemember dropped role from $sitemember->truerole to $sitemember->role.",1);
	}
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />sitemember construction complete at $timenow. Loading member next, unless anonymous, then loading policy.<hr />",1);

// load member if not anonymous
if ($sitemember->truerole!="anonymous") {
	$member= new Member;
	$member->loadMember();
	$timenow= bgetmicrotime() - $timerStart;
	berror("<hr />member construction complete ($member->email) at $timenow. Loading policy next.<hr />",1);
	}
	
// this is the breakaway point for switching protocol if SSL is enabled...
berror("site->p_nossl=$site->p_nossl and be_nossl=$be_nossl and session->request->connection=".$session->request->connection,1);
if ($be_nossl!=1 && $site->p_nossl!=1) {
	// force http for anonymous (unless login or register or rpc)
	if ($session->request->connection!="http" && ( $sitemember->role=="anonymous" && $session->request->method!="login" && $session->request->method!="createmember" && $session->request->method!="logout" && $session->request->method!="rpc")) {
		$newlocation= "http://$site->name$session->refreshUrl";
		bredirect($newlocation, "anonymous connects via http");
		exit;
		}
	// otherwise https
	elseif ($session->request->connection!="https" && ( $sitemember->role!="anonymous" || $session->request->method=="login" || $session->request->method=="createmember" || $session->request->method=="logout")) {
		$newlocation= "https://$site->name$session->refreshUrl";
		bredirect($newlocation, "non-anonymous and/or login connects via ssl");
		}
	}
elseif ($session->request->connection!="http") {
	$newlocation= "http://$site->name$session->refreshUrl";
	bredirect($newlocation, "ssl is turned off for this site");
	}

// get session->policy here
$policy= new Policy;
$policy->loadPolicy();
$session->applyPolicy();
$site->applyPolicy();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />Policy discovery complete at $timenow. Loading folder next.<hr />",1);

// get the folder for folderid
$folder= new Folder;
if (!$folder->loadFolder()) {
	berror("Folder ".$session->request->folderpath." not found.",1);
	$folder->showNull= 1;
	}
$folder->applyPolicy();
$session->folderid= $folder->id;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />Folder construction complete at $timenow. Loading containers next.<hr />",1);

// get the containers
$containers= $folder->loadParents($folder);
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />Containers construction complete at $timenow. Loading primary object next.<hr />",1);

// load primary object
$command= "\$object= new ".ucfirst($session->request->objtype).";";
eval($command);

// is this an e99o call?
$be_e99o= 0;
if (is_readable("$beryliumroot/code/e99o-class.php")) {
$be_e99o= 1;
	if ( strpos( $session->request->objectname,"@") ) {
		include_once( "$beryliumroot/code/e99o-class.php" );
		$recipe= new e99oRecipe( $session->request->objectname);
		$session->request->objectname= $recipe->objectname;
		}
	}

// set-up the name
$object->name= $session->request->objectname;
if ($object->objtype=="folder" && $object->name!="/") $object->folderid= $containers[1]->id;
else $object->folderid= $folder->id;
$query= "SELECT obj.* FROM $object->objtype AS obj WHERE obj.name='".addslashes( stripslashes($object->name) )."' AND obj.folderid='$object->folderid' $session->sqlSafe ";
if (!$object->selectObject($query)) {
	berror("Sorry, $object->objtype $object->name not found in <a href='$folder->baseUrl'>$folder->name</a>.",1);
	if ($folder->name=="/" && is_numeric($object->name)) {
		// this could be a permalink...
		if ($object->selectObjectById($object->name)) {
			$object->getBaseUrl();
			bredirect("$object->baseUrl?method=".$session->request->method.$session->cgi, "Found permalinked object.");
			}
		else $object->showNull= 1;
		}
	elseif ( is_object($recipe) ) {
		// e99o kludge-- what if the object name realy HAS an @ in it?
		$object->name= $recipe->objectname."@".$recipe->method;
		$query= "SELECT obj.* FROM $object->objtype AS obj WHERE obj.name='".addslashes( stripslashes($object->name) )."' AND obj.folderid='$object->folderid' $session->sqlSafe ";
		if (!$object->selectObject($query)) {
			$object->showNull= 1;
			}
		else {
			$session->request->objectname= $recipe->objectname."@".$recipe->method;
			unset($recipe);
			}
		}
	else $object->showNull= 1;
	}
$object->applyPolicy();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr /> Loaded primary '$object->objtype' object (#$object->id)/($object->name) here, from folderid #$object->folderid. Getting contexts. Time is $timenow.<hr />",1);

// e99o server here...
if (is_object($recipe)) {
	$e99o= new e99oServer($recipe, $object);
	// the above takes over processing from http-engine, procs the recipe, creates and/or serves the object cache, and exits
	}

// get object contexts
if (!$object->getContext($session->request->method)) {
	berror("Sorry, the server does not know how to ".$session->request->method." this $object->objtype in ".$session->request->format." format.",0);
	}
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Object context found at $timenow. <hr>",1);

//get site and folder contexts
$site->getContext("view");
$folder->getContext("view");
$timenow= bgetmicrotime() - $timerStart;
berror("<hr>Site and folder contexts found at $timenow. <hr>",1);

// preprocess object, site and folder
if ($object->id!="" || $object->name=="" || $session->request->method!="view") $object->process();
$site->process();
$folder->process();

// render the object and maybe the folder container
$object->render();
if ($object->objtype!="folder" || $session->request->method!="view") $folder->render("container");

// render site container
$timerEnd= bgetmicrotime();
$timer= $timerEnd - $timerStart;
if ($site->serverNotes=="") $site->serverNotes= "A <a href='http://berylium.org/'>Berylium2</a> Server.<br />Rendered in ".round($timer,2)." seconds for $session->clientip.";
$output= $site->render("container");
$output= bunescapeTemplate($output);
$outputsize= strlen($output);
$session->xfer+= $outputsize;
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />Object rendering finished at $timenow. <hr />",1);

// sort and print $session->output
print $output;
flush();
$timenow= bgetmicrotime() - $timerStart;
berror("<hr />Output done at $timenow. Cleaning up.<hr />",1);

// ping $object counter and log session time
if ($session->request->method=="view") {
	$session->counter->ping($object->objtype, $object->id);
	$timenow= bgetmicrotime() - $timerStart;
	berror("<hr>Session and counter updated at $timenow.<hr>",1);
	}
else {
	$timenow= bgetmicrotime() - $timerStart;
	berror("<hr>Session updated at $timenow.<hr>",1);
	}
$session->cpu+= $timenow;
$session->updateObject();

// print session->error then exit
if ($session->p_debug>=1) {
	print "<div id='Debug'>";
	print "<hr /><h3>\$session->error for berylium2 server at $_SERVER[SCRIPT_FILENAME].</h3><a href='$session->refreshURL&debug=off'>Turn off debug</a>";
	print "<blockquote>";
	print nl2br($session->error);

	if ($_REQUEST['dump']) {
		$dump= $_REQUEST['dump'];
		if ($dump=="containers") {
			$output= "<hr /><b>$dump:</b><br />".nl2br(str_replace(" ","&nbsp;", print_r($containers,1)));
			print $output;
			}
		else {
			if ($dump=="request") $request= $session->request;
			print "<hr />";
			$dumparray= get_object_vars(${$dump});
			print "<blockquote><b>$dump:</b>";
			foreach ($dumparray as $key => $val) {
				if ($key=="error" || $key=="output" ) continue;
				print "<br />$key=>$val";
				}
			print "</blockquote>";
			}
		}

	print "</blockquote>";
	print "<hr />Session complete at ".date("Y-M-d H:i:s").".<br /><a href='$session->refreshURL'>Refresh</a> ($session->refreshURL) | <a href='#top'>Top</a>";
	print "</div>";

	// timer function
	$timerEnd= bgetmicrotime();
	$timer= $timerEnd - $timerStart;
	$outputsize= bhumansize($outputsize);
	if (($session->request->format=="html") || $profile) {
		print "<p>A <a href='http://berylium.org/'>Berylium2</a> Server.
				<br />$outputsize Rendered in ".round($timer,2)." seconds for $session->clientip.</p>";
		}
	}

// EOF

