#!/usr/local/bin/php
<?php
// upgrades your current berylium2 installation
//
ini_set("output_buffering", "0");
ini_set("implicit_flush", "1");

// to be run at beyliumroot
$beryliumroot= getcwd();
$version= '$Id: install.php,v 1.2 2003/08/12 05:19:25 csnyder Exp $';
print "\nBerylium Install $version\n\n";

// check beryliumroot
if(!is_readable("$beryliumroot/code")) {
	print "
Cannot read $beryliumroot/code. Make sure you are running
this from your berylium root.\n";
	exit();
	}
	
// check for berylium.conf
$notnew= 0;
if(is_readable("$beryliumroot/code/berylium.conf") ) {
	print "You already have a berylium.conf file. Please use the upgrade.php script instead.\n";
	exit;
	}

// set-up berylium.conf
$be_scriptname= "/be2";
$be_nossl= 0;
$be_logintime= 7776000;
$currenturser= trim(`whoami`);
$be_webuser= "nobody";

// script either needs readline enabled, or the following vars: dbadminuser dbadminpass sitename siteadminemail siteadminpassword siteadminhint
if ((!is_readable("$beryliumroot/code/berylium.conf.dist") || count($argv)<2) && !function_exists("readline")) {
	print "
Usage (if PHP not compiled with GNU Readline support):
   $argv[0] <dbadmin username> <dbadmin password>

NOTE! You must edit code/berylium.conf.dist with your configuration. 
Do not save it as berylium.conf-- this script will do that.
";
	exit();
	}

if (function_exists("readline")) {
	// collect unknowables
	$output= "\n------------configuration:
	Your answers will be used to build a fresh code/berylium.conf file,
	which you may edit later as necessary.\n";

	$be_wordkey= readline("$output
	Passphrase for encrypting passwords (8 chars min): ");
	while(strlen($be_wordkey)<8) {
		$be_wordkey= readline("Error: not long enough. \nPassphrase for encrypting passwords (8 chars min): ");
		}

	$be_dbname= readline("Database name [beryliumdb]: ");
	if (trim($be_dbname)=="") $be_dbname= "beryliumdb";
	$be_dbuser= readline("Database webserver username [beryliumweb]: ");
	if (trim($be_dbuser)=="") $be_dbuser= "beryliumweb";
	$be_dbpassword= readline("Database webserver password: ");
	}
else {
	include("$beryliumroot/code/berylium.conf.dist");
	}

// load other code now
include_once("$beryliumroot/code/berylium-functions.php");
include_once("$beryliumroot/code/berylium-classes.php");

// try connecting
$testconnection= dbconnect();
if ($testconnection==0) {
	print "Error, unable to connect to database as $be_dbuser";
	exit;
	}
mysql_close($testconnection);

if (function_exists("readline")) {
	$be_webgroup= readline("What group does Apache run as? [nobody]: ");
	if (trim($be_webgroup)=="") $be_webgroup= "nobody";
	$be_beryliumuser= readline("Who should own $beryliumroot? [$currentuser]: ");
	if (trim($be_beryliumuser)=="") $be_beryliumuser= $currentuser;
	$be_adminemail= readline("Database connection okay. \nAdministrator's email address: ");
	}

// build the new berylium.conf file
$beryliumconf= <<<EOD
<?php
// Berylium serverwide configuration
// \$Date: 2003/08/12 05:19:25 $

// force a sitename...
// \$be_sitename= "example.org";

// scriptname for dynamic interface
\$be_scriptname= "$be_scriptname";

\$be_wordkey= "$be_wordkey";
\$be_dbuser= "$be_dbuser";
\$be_dbpassword= "$be_dbpassword";
\$be_dbname= "$be_dbname";
\$be_adminemail= "$be_adminemail";

// change \$nossl to 1 if you DON'T have an SSL-enabled server for login or private objects
\$be_nossl= $be_nossl;

// max time between logins when using permanent cookie ("remember me")
\$be_logintime= $be_logintime; // 90 days

// username of berylium owner (root is fine, this is for file ownership, not program execution)
\$be_beryliumuser= "$be_beryliumuser";

// user and group of the webserver
\$be_webuser= "$be_webuser";
\$be_webgroup= "$be_webgroup";

// EOF
EOD;
$fp= fopen("$beryliumroot/code/berylium.conf","w");
fwrite($fp, $beryliumconf);
fclose($fp);
print "Wrote $beryliumroot/code/berylium.conf, which you should check and edit if necessary.\n";

// build the http/be2 file
$be2file= <<<EOD
<?php
\$version= '\$Id: install.php,v 1.2 2003/08/12 05:19:25 csnyder Exp $';
\$beryliumroot= "$beryliumroot";
require("\$beryliumroot/code/http-engine.php");
// EOF
EOD;
$fp= fopen("$beryliumroot/http/be2","w");
fwrite($fp, $be2file);
fclose($fp);
print "Created $beryliumroot/http/be2 script.\n";

// set $beryliumroot in cron scripts
$changefiles= array("cron/daily.php", "cron/site-daily.php", "cron/sendbot.php", "cron/berylbot.php","cron/botpound.php");
$be2file= file_get_contents("$beryliumroot/http/be2");
$lines= explode("\n",$be2file);
foreach ($lines AS $line) {
	if (substr($line,0,13)== '$beryliumroot') break;
	}
$firstquotepos= strpos($line, '"');
$lastquotepos= strrpos($line, '"');
$replace= substr($line, $firstquotepos+1, ($lastquotepos - ( $firstquotepos + 1 ) ) );
print "Changing cron scripts to match current beryliumroot: $replace\n";
$search= "/home/csnyder/files/berylium2";
foreach ($changefiles AS $file) {
	$path= $beryliumroot."/".$file;
	$contents= file_get_contents($path);
	$contents= str_replace($search, $replace, $contents);
	$fp= fopen($path, "w");
	fwrite($fp, $contents);
	fclose($fp);
	print "Done with $path\n";
	}
	
// create files directory
mkdir("files");
$command= "chown -R $be_beryliumuser:$be_webgroup files";
passthru($command);
$command= "chmod -R 770 files";
passthru($command);
print "Created files/ tree.\n";

// create cache directory
mkdir("cache");
$command= "chown -R $be_webuser:$be_webgroup cache";
passthru($command);
$command= "chmod -R 700 cache";
passthru($command);
print "Created cache/ tree.\n";

// set ownerships -- don't touch /files directory
$adminfiles= "cron reference upgrade.php dbupgrade.php addsite.php filesupgrade.php";
$webfiles= "code external http reference COPYING.txt";
$commands[0]= "chown -R $be_beryliumuser $adminfiles";
$commands[1]= "chown -R $be_beryliumuser:$be_webgroup $webfiles";
$commands[2]= "chmod -R 700 $adminfiles";
$commands[3]= "chmod -R 750 $webfiles";
foreach($commands AS $command) {
	print "$command\n";
	passthru($command);
	}

// install database structure
$be_dbuser= "";
$be_dbpassword= "";
if ( function_exists("readline") ) {
	$output= "\n------------database structure installation:\n";
	$be_dbuser= readline("Database administrator username [berylium]: ");
	if (trim($be_dbuser)=="") $be_dbuser= "berylium";
	$be_dbpassword= readline("Database administrator password: ");
	}
else {
	$be_dbuser= $argv[2];
	$be_dbpassword= $argv[3];
	}

// try connecting
$testconnection2= dbconnect();
if ($testconnection2==0) {
	print "Error, unable to connect to database as $be_dbuser";
	exit;
	}
mysql_close($testconnection2);
// make tables, then
$newtables= array("session",
				"context2",
				"policy",
				"site",
				"member",
				"sitemember",
				"folder",
				"document",
				"image",
				"comment",
				"sequence",
				"event",
				"counter",
				"uplink",
				"subscription",
				"message",
				"audio");
foreach($newtables AS $class) {
	$command= "\$$class= new ".ucfirst($class).";";
	eval($command);
	if (${$class}->makeTable()) {
		print "\nSuccessfully created $class table.";
		}
	else print "\n$class table exists, skipping.";
	}

// print Apache directives
$apache= <<<EOD
#############################
## Berylium Alias Directives
#
<Location /be2 >
    ForceType application/x-httpd-php
</Location>

Alias /be2 $beryliumroot/http/be2
Alias /be2css/ $beryliumroot/http/be2css/
Alias /be2js/ $beryliumroot/http/be2js/
Alias /be2icons/ $beryliumroot/http/be2icons/
Alias /htmlarea/ $beryliumroot/http/htmlarea/

<Directory "$beryliumroot/">
	AllowOverride None
	Order allow,deny
	Deny from all
</Directory>

<Directory "$beryliumroot/http/">
	AllowOverride None
	Order allow,deny
	Allow from all
</Directory>
#############################
EOD;

$fp= fopen("apache.txt","w");
fwrite($fp, $apache);
fclose($fp);
print "The Apache directives necessary for adding Berylium to your site are in apache.txt
These can either be added per <VirtualHost> container by hand, or appended to
the global configuration for Berylium support on all sites.

To apply globally, try:
     cat apache.txt >> /usr/local/apache/conf/httpd.conf
     apachectl restart

";

print "All done with basic installation. Update your httpd.conf, restart Apache, and connect
to http://yoursite.com/be2 to test.\n";
?>
